/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.test;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.aws.traits.protocols.RestJson1Trait;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilder;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingProtocolGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpProtocolClientGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpTraitResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolContentTypes;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.StructuredDataParserGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.StructuredDataSerializerGenerator;
import software.amazon.smithy.kotlin.codegen.test.TestProtocolClientGenerator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.utils.StringUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/test/MockHttpProtocolGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingProtocolGenerator;", "()V", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "getDefaultTimestampFormat", "()Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "protocol", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "getProtocol", "()Lsoftware/amazon/smithy/model/shapes/ShapeId;", "generateProtocolUnitTests", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "getHttpProtocolClientGenerator", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator;", "getProtocolHttpBindingResolver", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "model", "Lsoftware/amazon/smithy/model/Model;", "serviceShape", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "operationErrorHandler", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "structuredDataParser", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/StructuredDataParserGenerator;", "structuredDataSerializer", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/StructuredDataSerializerGenerator;", "smithy-kotlin-codegen"})
public final class MockHttpProtocolGenerator
extends HttpBindingProtocolGenerator {
    @NotNull
    private final TimestampFormatTrait.Format defaultTimestampFormat = TimestampFormatTrait.Format.EPOCH_SECONDS;
    @NotNull
    private final ShapeId protocol;

    public MockHttpProtocolGenerator() {
        ShapeId shapeId = RestJson1Trait.ID;
        Intrinsics.checkNotNullExpressionValue((Object)shapeId, (String)"ID");
        this.protocol = shapeId;
    }

    @Override
    @NotNull
    public TimestampFormatTrait.Format getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    @Override
    @NotNull
    public HttpBindingResolver getProtocolHttpBindingResolver(@NotNull Model model, @NotNull ServiceShape serviceShape2) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)serviceShape2, (String)"serviceShape");
        return new HttpTraitResolver(model, serviceShape2, ProtocolContentTypes.Companion.consistent("application/json"));
    }

    @Override
    @NotNull
    public ShapeId getProtocol() {
        return this.protocol;
    }

    @Override
    public void generateProtocolUnitTests(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
    }

    @Override
    @NotNull
    public HttpProtocolClientGenerator getHttpProtocolClientGenerator(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return new TestProtocolClientGenerator(ctx, this.getHttpMiddleware(ctx), this.getProtocolHttpBindingResolver(ctx.getModel(), ctx.getService()));
    }

    @Override
    @NotNull
    public StructuredDataParserGenerator structuredDataParser(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return new StructuredDataParserGenerator(){

            @NotNull
            public Symbol operationDeserializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull List<MemberShape> members) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)op, (String)"op");
                Intrinsics.checkNotNullParameter(members, (String)"members");
                return SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)new Function1<SymbolBuilder, Unit>(op){
                    final /* synthetic */ OperationShape $op;
                    {
                        this.$op = $op;
                        super(1);
                    }

                    public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                        Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                        $this$buildSymbol.setName(SerdeExtKt.bodyDeserializerName(this.$op));
                    }
                }));
            }

            @NotNull
            public Symbol errorDeserializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull StructureShape errorShape, @NotNull List<MemberShape> members) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)errorShape, (String)"errorShape");
                Intrinsics.checkNotNullParameter(members, (String)"members");
                return SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)new Function1<SymbolBuilder, Unit>(ctx, errorShape){
                    final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
                    final /* synthetic */ StructureShape $errorShape;
                    {
                        this.$ctx = $ctx;
                        this.$errorShape = $errorShape;
                        super(1);
                    }

                    public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                        Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                        Symbol errSymbol = this.$ctx.getSymbolProvider().toSymbol((Shape)this.$errorShape);
                        Intrinsics.checkNotNullExpressionValue((Object)errSymbol, (String)"errSymbol");
                        $this$buildSymbol.setName(SerdeExtKt.errorDeserializerName(errSymbol));
                    }
                }));
            }

            @NotNull
            public Symbol payloadDeserializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull Shape shape, @Nullable Collection<MemberShape> members) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
                return SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)new Function1<SymbolBuilder, Unit>(ctx, shape){
                    final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
                    final /* synthetic */ Shape $shape;
                    {
                        this.$ctx = $ctx;
                        this.$shape = $shape;
                        super(1);
                    }

                    public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                        Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                        Symbol symbol = this.$ctx.getSymbolProvider().toSymbol(this.$shape);
                        $this$buildSymbol.setName("deserialize" + StringUtils.capitalize((String)symbol.getName()) + "Payload");
                    }
                }));
            }
        };
    }

    @Override
    @NotNull
    public StructuredDataSerializerGenerator structuredDataSerializer(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return new StructuredDataSerializerGenerator(){

            @NotNull
            public Symbol operationSerializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull List<MemberShape> members) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)op, (String)"op");
                Intrinsics.checkNotNullParameter(members, (String)"members");
                return SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)new Function1<SymbolBuilder, Unit>(op){
                    final /* synthetic */ OperationShape $op;
                    {
                        this.$op = $op;
                        super(1);
                    }

                    public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                        Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                        $this$buildSymbol.setName(SerdeExtKt.bodySerializerName(this.$op));
                    }
                }));
            }

            @NotNull
            public Symbol payloadSerializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull Shape shape, @Nullable Collection<MemberShape> members) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
                return SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)new Function1<SymbolBuilder, Unit>(ctx, shape){
                    final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
                    final /* synthetic */ Shape $shape;
                    {
                        this.$ctx = $ctx;
                        this.$shape = $shape;
                        super(1);
                    }

                    public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                        Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                        Symbol symbol = this.$ctx.getSymbolProvider().toSymbol(this.$shape);
                        $this$buildSymbol.setName("serialize" + StringUtils.capitalize((String)symbol.getName()) + "Payload");
                    }
                }));
            }
        };
    }

    @Override
    @NotNull
    public Symbol operationErrorHandler(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)new Function1<SymbolBuilder, Unit>(op){
            final /* synthetic */ OperationShape $op;
            {
                this.$op = $op;
                super(1);
            }

            public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                $this$buildSymbol.setName(HttpBindingProtocolGeneratorKt.errorHandlerName(this.$op));
            }
        }));
    }
}

