/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.CodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.CodegenContext;
import software.amazon.smithy.kotlin.codegen.core.ExternalTypes;
import software.amazon.smithy.kotlin.codegen.core.KotlinDelegator;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.integration.KotlinIntegration;
import software.amazon.smithy.kotlin.codegen.integration.SectionWriterBinding;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.rendering.ClientConfigProperty;
import software.amazon.smithy.kotlin.codegen.rendering.ItemDescriptor;
import software.amazon.smithy.kotlin.codegen.rendering.PaginatorGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.PaginatorGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolMiddleware;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.PaginatedIndex;
import software.amazon.smithy.model.knowledge.PaginationInfo;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.PaginatedTrait;
import software.amazon.smithy.utils.CodeWriter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J:\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J@\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0014H\u0002J\u0018\u0010 \u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0016\u00a8\u0006#"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/PaginatorGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/KotlinIntegration;", "()V", "enabledForService", "", "model", "Lsoftware/amazon/smithy/model/Model;", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "renderItemPaginator", "", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "serviceShape", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "operationShape", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "itemDesc", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/ItemDescriptor;", "outputSymbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "renderPaginatorForOperation", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/CodegenContext;", "service", "paginatedOperation", "paginationInfo", "Lsoftware/amazon/smithy/model/knowledge/PaginationInfo;", "renderResponsePaginator", "serviceSymbol", "inputSymbol", "cursorSymbol", "writeAdditionalFiles", "delegator", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinDelegator;", "smithy-kotlin-codegen"})
public final class PaginatorGenerator
implements KotlinIntegration {
    @Override
    public boolean enabledForService(@NotNull Model model, @NotNull KotlinSettings settings) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Set set = model.getOperationShapes();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"model.operationShapes");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    OperationShape it = (OperationShape)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    Shape $this$hasTrait$iv = (Shape)it;
                    boolean $i$f$hasTrait = false;
                    if (!$this$hasTrait$iv.hasTrait(PaginatedTrait.class)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeAdditionalFiles(@NotNull CodegenContext ctx, @NotNull KotlinDelegator delegator) {
        void $this$expectShape$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)delegator, (String)"delegator");
        Model model = ctx.getModel();
        ShapeId shapeId$iv = ctx.getSettings().getService();
        boolean $i$f$expectShape = false;
        Shape shape = $this$expectShape$iv.expectShape(shapeId$iv, ServiceShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(shapeId, T::class.java)");
        ServiceShape service2 = (ServiceShape)shape;
        PaginatedIndex paginatedIndex = PaginatedIndex.of((Model)ctx.getModel());
        delegator.useFileWriter("Paginators.kt", Intrinsics.stringPlus((String)ctx.getSettings().getPkg().getName(), (Object)".paginators"), (Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(service2, ctx, paginatedIndex, this){
            final /* synthetic */ ServiceShape $service;
            final /* synthetic */ CodegenContext $ctx;
            final /* synthetic */ PaginatedIndex $paginatedIndex;
            final /* synthetic */ PaginatorGenerator this$0;
            {
                this.$service = $service;
                this.$ctx = $ctx;
                this.$paginatedIndex = $paginatedIndex;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull KotlinWriter writer) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                PaginationInfo shapeId$iv;
                Object object;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
                Iterable<E> iterable = this.$service.getAllOperations();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"service.allOperations");
                iterable = iterable;
                CodegenContext codegenContext = this.$ctx;
                boolean $i$f$map22 = false;
                CodegenContext codegenContext2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$expectShape$iv;
                    void it;
                    ShapeId shapeId = (ShapeId)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    object = codegenContext.getModel();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    shapeId$iv = it;
                    boolean $i$f$expectShape = false;
                    Shape shape = $this$expectShape$iv.expectShape((ShapeId)shapeId$iv, OperationShape.class);
                    Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(shapeId, T::class.java)");
                    collection.add((OperationShape)shape);
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                Iterable $i$f$map22 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    OperationShape operationShape2 = (OperationShape)element$iv$iv;
                    boolean bl = false;
                    if (!operationShape2.hasTrait(PaginatedTrait.ID)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List paginatedOperations = (List)destination$iv$iv2;
                $this$filter$iv = paginatedOperations;
                PaginatedIndex paginatedIndex = this.$paginatedIndex;
                ServiceShape serviceShape2 = this.$service;
                codegenContext2 = this.$ctx;
                PaginatorGenerator paginatorGenerator = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    OperationShape paginatedOperation = (OperationShape)element$iv;
                    boolean bl = false;
                    object = paginatedIndex.getPaginationInfo((ToShapeId)serviceShape2, (ToShapeId)paginatedOperation);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"paginatedIndex.getPagina\u2026vice, paginatedOperation)");
                    shapeId$iv = (PaginationInfo)OptionalExtKt.getOrNull(object);
                    if (shapeId$iv == null) {
                        throw new CodegenException("Unexpectedly unable to get PaginationInfo from " + serviceShape2 + ' ' + paginatedOperation);
                    }
                    PaginationInfo paginationInfo = shapeId$iv;
                    ItemDescriptor paginationItemInfo = PaginatorGeneratorKt.access$getItemDescriptorOrNull(paginationInfo, codegenContext2);
                    PaginatorGenerator.access$renderPaginatorForOperation(paginatorGenerator, writer, codegenContext2, serviceShape2, paginatedOperation, paginationInfo, paginationItemInfo);
                }
            }
        }));
    }

    private final void renderPaginatorForOperation(KotlinWriter writer, CodegenContext ctx, ServiceShape service2, OperationShape paginatedOperation, PaginationInfo paginationInfo, ItemDescriptor itemDesc) {
        Symbol serviceSymbol = ctx.getSymbolProvider().toSymbol((Shape)service2);
        Symbol outputSymbol = ctx.getSymbolProvider().toSymbol((Shape)paginationInfo.getOutput());
        Symbol inputSymbol = ctx.getSymbolProvider().toSymbol((Shape)paginationInfo.getInput());
        Object t = ctx.getModel().getShape(paginationInfo.getInputTokenMember().getTarget()).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"ctx.model.getShape(pagin\u2026TokenMember.target).get()");
        Shape cursorMember = (Shape)t;
        Symbol cursorSymbol = ctx.getSymbolProvider().toSymbol(cursorMember);
        Intrinsics.checkNotNullExpressionValue((Object)serviceSymbol, (String)"serviceSymbol");
        Intrinsics.checkNotNullExpressionValue((Object)inputSymbol, (String)"inputSymbol");
        Intrinsics.checkNotNullExpressionValue((Object)outputSymbol, (String)"outputSymbol");
        Intrinsics.checkNotNullExpressionValue((Object)cursorSymbol, (String)"cursorSymbol");
        this.renderResponsePaginator(writer, serviceSymbol, paginatedOperation, inputSymbol, outputSymbol, paginationInfo, cursorSymbol);
        if (itemDesc != null) {
            this.renderItemPaginator(writer, service2, paginatedOperation, itemDesc, outputSymbol);
        }
    }

    private final void renderResponsePaginator(KotlinWriter writer, Symbol serviceSymbol, OperationShape operationShape2, Symbol inputSymbol, Symbol outputSymbol, PaginationInfo paginationInfo, Symbol cursorSymbol) {
        List list = paginationInfo.getOutputTokenMemberPath();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"paginationInfo.outputTokenMemberPath");
        String nextMarkerLiteral2 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"?.", null, null, (int)0, null, (Function1)renderResponsePaginator.nextMarkerLiteral.1.INSTANCE, (int)30, null);
        MemberShape memberShape2 = paginationInfo.getInputTokenMember();
        Intrinsics.checkNotNullExpressionValue((Object)memberShape2, (String)"paginationInfo.inputTokenMember");
        String markerLiteral = NamingKt.defaultName(memberShape2);
        String docBody = StringsKt.trimIndent((String)("\n            Paginate over [" + outputSymbol.getName() + "] results.\n            \n            When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service\n            calls are made until the flow is collected. This also means there is no guarantee that the request is valid\n            until then. Once you start collecting the flow, the SDK will lazily load response pages by making service\n            calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will\n            see the failures only after you start collection.\n        "));
        String docReturn = "@return A [kotlinx.coroutines.flow.Flow] that can collect [" + outputSymbol.getName() + ']';
        writer.write("", new Object[0]);
        Object[] objectArray = new SymbolReference.ContextOption[]{SymbolReference.ContextOption.DECLARE};
        CodeWriter codeWriter = writer.dokka(StringsKt.trimMargin$default((String)("\n                    |" + docBody + "\n                    |@param initialRequest A [" + inputSymbol.getName() + "] to start pagination\n                    |" + docReturn + "\n                "), null, (int)1, null)).addImportReferences(cursorSymbol, (SymbolReference.ContextOption[])objectArray);
        objectArray = new Object[]{serviceSymbol, NamingKt.defaultName(operationShape2), inputSymbol, ExternalTypes.KotlinxCoroutines.INSTANCE.getFlow(), outputSymbol};
        CodeWriterExtKt.withBlock(codeWriter, "fun #T.#LPaginated(initialRequest: #T): #T<#T> =", "", objectArray, (Function1)new Function1<KotlinWriter, Unit>(cursorSymbol, operationShape2, nextMarkerLiteral2, markerLiteral){
            final /* synthetic */ Symbol $cursorSymbol;
            final /* synthetic */ OperationShape $operationShape;
            final /* synthetic */ String $nextMarkerLiteral;
            final /* synthetic */ String $markerLiteral;
            {
                this.$cursorSymbol = $cursorSymbol;
                this.$operationShape = $operationShape;
                this.$nextMarkerLiteral = $nextMarkerLiteral;
                this.$markerLiteral = $markerLiteral;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                Object[] objectArray = new Object[]{ExternalTypes.KotlinxCoroutines.INSTANCE.getFlowGenerator()};
                CodeWriterExtKt.withBlock((CodeWriter)$this$withBlock, "#T {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(this.$cursorSymbol, this.$operationShape, this.$nextMarkerLiteral, this.$markerLiteral){
                    final /* synthetic */ Symbol $cursorSymbol;
                    final /* synthetic */ OperationShape $operationShape;
                    final /* synthetic */ String $nextMarkerLiteral;
                    final /* synthetic */ String $markerLiteral;
                    {
                        this.$cursorSymbol = $cursorSymbol;
                        this.$operationShape = $operationShape;
                        this.$nextMarkerLiteral = $nextMarkerLiteral;
                        this.$markerLiteral = $markerLiteral;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        Object[] objectArray = new Object[]{this.$cursorSymbol};
                        $this$withBlock.write("var cursor: #F = null", objectArray);
                        $this$withBlock.write("var isFirstPage: Boolean = true", new Object[0]);
                        $this$withBlock.write("", new Object[0]);
                        CodeWriterExtKt.withBlock((CodeWriter)$this$withBlock, "while (isFirstPage || (cursor?.isNotEmpty() == true)) {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.$operationShape, this.$nextMarkerLiteral, this.$markerLiteral){
                            final /* synthetic */ OperationShape $operationShape;
                            final /* synthetic */ String $nextMarkerLiteral;
                            final /* synthetic */ String $markerLiteral;
                            {
                                this.$operationShape = $operationShape;
                                this.$nextMarkerLiteral = $nextMarkerLiteral;
                                this.$markerLiteral = $markerLiteral;
                                super(1);
                            }

                            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                                CodeWriterExtKt.withBlock((CodeWriter)$this$withBlock, "val req = initialRequest.copy {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.$markerLiteral){
                                    final /* synthetic */ String $markerLiteral;
                                    {
                                        this.$markerLiteral = $markerLiteral;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                                        $this$withBlock.write("this." + this.$markerLiteral + " = cursor", new Object[0]);
                                    }
                                });
                                Object[] objectArray = new Object[]{NamingKt.defaultName(this.$operationShape)};
                                $this$withBlock.write("val result = this@#1LPaginated.#1L(req)", objectArray);
                                $this$withBlock.write("isFirstPage = false", new Object[0]);
                                $this$withBlock.write(Intrinsics.stringPlus((String)"cursor = result.", (Object)this.$nextMarkerLiteral), new Object[0]);
                                $this$withBlock.write("emit(result)", new Object[0]);
                            }
                        });
                    }
                });
            }
        });
        writer.write("", new Object[0]);
        objectArray = new Object[]{serviceSymbol, NamingKt.defaultName(operationShape2), inputSymbol, KotlinTypes.INSTANCE.getUnit(), ExternalTypes.KotlinxCoroutines.INSTANCE.getFlow(), outputSymbol};
        CodeWriterExtKt.withBlock((CodeWriter)writer.dokka(StringsKt.trimMargin$default((String)("\n                    |" + docBody + "\n                    |@param block A builder block used for DSL-style invocation of the operation\n                    |" + docReturn + "\n                "), null, (int)1, null)), "fun #T.#LPaginated(block: #T.Builder.() -> #T): #T<#T> =", "", objectArray, (Function1)new Function1<KotlinWriter, Unit>(operationShape2, inputSymbol){
            final /* synthetic */ OperationShape $operationShape;
            final /* synthetic */ Symbol $inputSymbol;
            {
                this.$operationShape = $operationShape;
                this.$inputSymbol = $inputSymbol;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                Object[] objectArray = new Object[]{NamingKt.defaultName(this.$operationShape), this.$inputSymbol};
                $this$withBlock.write("#LPaginated(#T.Builder().apply(block).build())", objectArray);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void renderItemPaginator(KotlinWriter writer, ServiceShape serviceShape2, OperationShape operationShape2, ItemDescriptor itemDesc, Symbol outputSymbol) {
        String string;
        writer.write("", new Object[0]);
        writer.dokka(StringsKt.trimIndent((String)("\n                This paginator transforms the flow returned by [" + NamingKt.defaultName(operationShape2) + "Paginated] \n                to access the nested member [" + NamingKt.defaultName(itemDesc.getTargetMember(), serviceShape2) + "]\n                @return A [kotlinx.coroutines.flow.Flow] that can collect [" + NamingKt.defaultName(itemDesc.getTargetMember(), serviceShape2) + "]\n            ")));
        Object[] objectArray = new SymbolReference.ContextOption[]{SymbolReference.ContextOption.USE};
        KotlinWriter kotlinWriter = KotlinWriter.addImport$default(KotlinWriter.addImport$default(writer, ExternalTypes.KotlinxCoroutines.INSTANCE.getFlowTransform(), null, 2, null), itemDesc.getItemSymbol(), null, 2, null).addImportReferences(itemDesc.getItemSymbol(), (SymbolReference.ContextOption[])objectArray);
        String string2 = "@JvmName(\"#L#L\")";
        Object[] objectArray2 = objectArray = new Object[2];
        int n = 0;
        String string3 = outputSymbol.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"outputSymbol.name");
        if (((CharSequence)string3).length() > 0) {
            void p0;
            char c = string3.charAt(0);
            int n2 = n;
            Object[] objectArray3 = objectArray2;
            String string4 = string2;
            KotlinWriter kotlinWriter2 = kotlinWriter;
            boolean bl = false;
            char c2 = Character.toLowerCase((char)p0);
            kotlinWriter = kotlinWriter2;
            string2 = string4;
            objectArray2 = objectArray3;
            n = n2;
            c = c2;
            String string5 = string3;
            int n3 = 1;
            String string6 = string5.substring(n3);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
            string5 = string6;
            string = c + string5;
        } else {
            string = string3;
        }
        objectArray2[n] = string;
        objectArray[1] = NamingKt.defaultName(itemDesc.getTargetMember(), serviceShape2);
        CodeWriter codeWriter = kotlinWriter.write(string2, objectArray);
        objectArray = new Object[]{ExternalTypes.KotlinxCoroutines.INSTANCE.getFlow(), outputSymbol, itemDesc.getItemLiteral(), ExternalTypes.KotlinxCoroutines.INSTANCE.getFlow(), itemDesc.getCollectionLiteral()};
        CodeWriterExtKt.withBlock(codeWriter, "fun #T<#T>.#L(): #T<#L> =", "", objectArray, (Function1)new Function1<CodeWriter, Unit>(itemDesc){
            final /* synthetic */ ItemDescriptor $itemDesc;
            {
                this.$itemDesc = $itemDesc;
                super(1);
            }

            public final void invoke(CodeWriter $this$withBlock) {
                CodeWriterExtKt.withBlock($this$withBlock, "transform() { response -> ", "}", new Object[0], (Function1)new Function1<CodeWriter, Unit>(this.$itemDesc){
                    final /* synthetic */ ItemDescriptor $itemDesc;
                    {
                        this.$itemDesc = $itemDesc;
                        super(1);
                    }

                    public final void invoke(CodeWriter $this$withBlock) {
                        Object[] objectArray = new Object[]{this.$itemDesc.getItemPathLiteral()};
                        CodeWriterExtKt.withBlock($this$withBlock, "response.#L?.forEach {", "}", objectArray, renderItemPaginator.1.INSTANCE);
                    }
                });
            }
        });
    }

    @Override
    public byte getOrder() {
        return KotlinIntegration.DefaultImpls.getOrder(this);
    }

    @Override
    @NotNull
    public List<ProtocolGenerator> getProtocolGenerators() {
        return KotlinIntegration.DefaultImpls.getProtocolGenerators(this);
    }

    @Override
    @NotNull
    public List<SectionWriterBinding> getSectionWriters() {
        return KotlinIntegration.DefaultImpls.getSectionWriters(this);
    }

    @Override
    @NotNull
    public List<ClientConfigProperty> additionalServiceConfigProps(@NotNull CodegenContext ctx) {
        return KotlinIntegration.DefaultImpls.additionalServiceConfigProps(this, ctx);
    }

    @Override
    @NotNull
    public Model preprocessModel(@NotNull Model model, @NotNull KotlinSettings settings) {
        return KotlinIntegration.DefaultImpls.preprocessModel(this, model, settings);
    }

    @Override
    @NotNull
    public SymbolProvider decorateSymbolProvider(@NotNull KotlinSettings settings, @NotNull Model model, @NotNull SymbolProvider symbolProvider) {
        return KotlinIntegration.DefaultImpls.decorateSymbolProvider(this, settings, model, symbolProvider);
    }

    @Override
    public void onShapeWriterUse(@NotNull KotlinSettings settings, @NotNull Model model, @NotNull SymbolProvider symbolProvider, @NotNull KotlinWriter writer, @NotNull Shape definedShape) {
        KotlinIntegration.DefaultImpls.onShapeWriterUse(this, settings, model, symbolProvider, writer, definedShape);
    }

    @Override
    @NotNull
    public List<ProtocolMiddleware> customizeMiddleware(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull List<? extends ProtocolMiddleware> resolved) {
        return KotlinIntegration.DefaultImpls.customizeMiddleware(this, ctx, resolved);
    }

    public static final /* synthetic */ void access$renderPaginatorForOperation(PaginatorGenerator $this, KotlinWriter writer, CodegenContext ctx, ServiceShape service2, OperationShape paginatedOperation, PaginationInfo paginationInfo, ItemDescriptor itemDesc) {
        $this.renderPaginatorForOperation(writer, ctx, service2, paginatedOperation, paginationInfo, itemDesc);
    }
}

