/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.serde;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.core.CodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.model.knowledge.SerdeIndex;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.DeserializeStructGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.DeserializeUnionGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.JsonParserGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.JsonSerdeDescriptorGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.StructuredDataParserGenerator;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.utils.CodeWriter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J&\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J&\u0010\u001b\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u001aH\u0016J.\u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J.\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/JsonParserGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/StructuredDataParserGenerator;", "protocolGenerator", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator;", "supportsJsonNameTrait", "", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator;Z)V", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "getDefaultTimestampFormat", "()Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "addNestedDocumentDeserializers", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "documentDeserializer", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "errorDeserializer", "errorShape", "Lsoftware/amazon/smithy/model/shapes/StructureShape;", "members", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "operationDeserializer", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "payloadDeserializer", "member", "renderDeserializeOperationBody", "documentMembers", "renderDeserializerBody", "smithy-kotlin-codegen"})
public class JsonParserGenerator
implements StructuredDataParserGenerator {
    @NotNull
    private final ProtocolGenerator protocolGenerator;
    private final boolean supportsJsonNameTrait;
    @NotNull
    private final TimestampFormatTrait.Format defaultTimestampFormat;

    public JsonParserGenerator(@NotNull ProtocolGenerator protocolGenerator, boolean supportsJsonNameTrait) {
        Intrinsics.checkNotNullParameter((Object)protocolGenerator, (String)"protocolGenerator");
        this.protocolGenerator = protocolGenerator;
        this.supportsJsonNameTrait = supportsJsonNameTrait;
        this.defaultTimestampFormat = TimestampFormatTrait.Format.EPOCH_SECONDS;
    }

    public /* synthetic */ JsonParserGenerator(ProtocolGenerator protocolGenerator, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(protocolGenerator, bl);
    }

    @NotNull
    public TimestampFormatTrait.Format getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    @Override
    @NotNull
    public Symbol operationDeserializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull List<MemberShape> members) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        ShapeId it = (ShapeId)op.getOutput().get();
        boolean bl = false;
        Symbol outputSymbol = ctx.getSymbolProvider().toSymbol(ctx.getModel().expectShape(it));
        return SerdeExtKt.bodyDeserializer(op, ctx.getSettings(), (Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(this, ctx, op, outputSymbol, members){
            final /* synthetic */ JsonParserGenerator this$0;
            final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
            final /* synthetic */ OperationShape $op;
            final /* synthetic */ Symbol $outputSymbol;
            final /* synthetic */ List<MemberShape> $members;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$op = $op;
                this.$outputSymbol = $outputSymbol;
                this.$members = $members;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
                JsonParserGenerator.access$addNestedDocumentDeserializers(this.this$0, this.$ctx, (Shape)this.$op, writer);
                String fnName = SerdeExtKt.bodyDeserializerName(this.$op);
                Object[] objectArray = new Object[]{fnName, this.$outputSymbol};
                writer.openBlock("private fun #L(builder: #T.Builder, payload: ByteArray) {", objectArray).call(() -> operationDeserializer.1.invoke$lambda-0(this.this$0, this.$ctx, this.$op, this.$members, writer)).closeBlock("}", new Object[0]);
            }

            private static final void invoke$lambda-0(JsonParserGenerator this$0, ProtocolGenerator.GenerationContext $ctx, OperationShape $op, List $members, KotlinWriter $writer) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
                Intrinsics.checkNotNullParameter((Object)$members, (String)"$members");
                Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
                JsonParserGenerator.access$renderDeserializeOperationBody(this$0, $ctx, $op, $members, $writer);
            }
        }));
    }

    private final void addNestedDocumentDeserializers(ProtocolGenerator.GenerationContext ctx, Shape shape, KotlinWriter writer) {
        SerdeIndex serdeIndex = SerdeIndex.Companion.of(ctx.getModel());
        Set<Shape> shapesRequiringDocumentDeserializer = serdeIndex.requiresDocumentDeserializer(shape);
        Iterable $this$forEach$iv = shapesRequiringDocumentDeserializer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Shape it = (Shape)element$iv;
            boolean bl = false;
            Symbol nestedStructOrUnionDeserializer = this.documentDeserializer(ctx, it);
            KotlinWriter.addImport$default(writer, nestedStructOrUnionDeserializer, null, 2, null);
        }
    }

    private final void renderDeserializeOperationBody(ProtocolGenerator.GenerationContext ctx, OperationShape op, List<MemberShape> documentMembers, KotlinWriter writer) {
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.SerdeJson.INSTANCE.getJsonDeserializer()};
        writer.write("val deserializer = #T(payload)", objectArray);
        Shape shape = ctx.getModel().expectShape((ShapeId)op.getOutput().get());
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"shape");
        this.renderDeserializerBody(ctx, shape, documentMembers, writer);
    }

    private final Symbol documentDeserializer(ProtocolGenerator.GenerationContext ctx, Shape shape) {
        Symbol symbol = ctx.getSymbolProvider().toSymbol(shape);
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"symbol");
        return SerdeExtKt.documentDeserializer(symbol, ctx.getSettings(), (Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(symbol, shape, this, ctx){
            final /* synthetic */ Symbol $symbol;
            final /* synthetic */ Shape $shape;
            final /* synthetic */ JsonParserGenerator this$0;
            final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
            {
                this.$symbol = $symbol;
                this.$shape = $shape;
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
                Object[] objectArray = this.$symbol;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"symbol");
                String fnName = SerdeExtKt.documentDeserializerName((Symbol)objectArray);
                objectArray = new Object[]{fnName, RuntimeTypes.Serde.INSTANCE.getDeserializer(), this.$symbol};
                writer.openBlock("internal fun #L(deserializer: #T): #T {", objectArray).call(() -> documentDeserializer.1.invoke$lambda-0(this.$shape, writer, this.$symbol, this.this$0, this.$ctx)).closeBlock("}", new Object[0]);
            }

            private static final void invoke$lambda-0(Shape $shape, KotlinWriter $writer, Symbol $symbol, JsonParserGenerator this$0, ProtocolGenerator.GenerationContext $ctx) {
                Intrinsics.checkNotNullParameter((Object)$shape, (String)"$shape");
                Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                if ($shape.isUnionShape()) {
                    Object[] objectArray = new Object[]{$symbol};
                    $writer.write("var value: #T? = null", objectArray);
                    objectArray = $shape.members();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"shape.members()");
                    JsonParserGenerator.access$renderDeserializerBody(this$0, $ctx, $shape, CollectionsKt.toList((Iterable)((Iterable)objectArray)), $writer);
                    objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getDeserializationException(), Intrinsics.stringPlus((String)"Deserialized union value unexpectedly null: ", (Object)$symbol.getName())};
                    $writer.write("return value ?: throw #T(#S)", objectArray);
                } else {
                    Object object = new Object[]{$symbol};
                    $writer.write("val builder = #T.Builder()", (Object[])object);
                    object = $shape.members();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"shape.members()");
                    JsonParserGenerator.access$renderDeserializerBody(this$0, $ctx, $shape, CollectionsKt.toList((Iterable)((Iterable)object)), $writer);
                    $writer.write("return builder.build()", new Object[0]);
                }
            }
        }));
    }

    @Override
    @NotNull
    public Symbol errorDeserializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull StructureShape errorShape, @NotNull List<MemberShape> members) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorShape, (String)"errorShape");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Symbol symbol = ctx.getSymbolProvider().toSymbol((Shape)errorShape);
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"symbol");
        return SerdeExtKt.errorDeserializer(symbol, ctx.getSettings(), (Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(this, ctx, errorShape, symbol, members){
            final /* synthetic */ JsonParserGenerator this$0;
            final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
            final /* synthetic */ StructureShape $errorShape;
            final /* synthetic */ Symbol $symbol;
            final /* synthetic */ List<MemberShape> $members;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$errorShape = $errorShape;
                this.$symbol = $symbol;
                this.$members = $members;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
                JsonParserGenerator.access$addNestedDocumentDeserializers(this.this$0, this.$ctx, (Shape)this.$errorShape, writer);
                Object[] objectArray = this.$symbol;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"symbol");
                String fnName = SerdeExtKt.errorDeserializerName((Symbol)objectArray);
                objectArray = new Object[]{fnName, this.$symbol};
                writer.openBlock("private fun #L(builder: #T.Builder, payload: ByteArray) {", objectArray).call(() -> errorDeserializer.1.invoke$lambda-0(writer, this.this$0, this.$ctx, this.$errorShape, this.$members)).closeBlock("}", new Object[0]);
            }

            private static final void invoke$lambda-0(KotlinWriter $writer, JsonParserGenerator this$0, ProtocolGenerator.GenerationContext $ctx, StructureShape $errorShape, List $members) {
                Intrinsics.checkNotNullParameter((Object)((Object)$writer), (String)"$writer");
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)$errorShape, (String)"$errorShape");
                Intrinsics.checkNotNullParameter((Object)$members, (String)"$members");
                Object[] objectArray = new Object[]{RuntimeTypes.Serde.SerdeJson.INSTANCE.getJsonDeserializer()};
                $writer.write("val deserializer = #T(payload)", objectArray);
                JsonParserGenerator.access$renderDeserializerBody(this$0, $ctx, (Shape)$errorShape, $members, $writer);
            }
        }));
    }

    private final void renderDeserializerBody(ProtocolGenerator.GenerationContext ctx, Shape shape, List<MemberShape> members, KotlinWriter writer) {
        new JsonSerdeDescriptorGenerator(ProtocolGeneratorKt.toRenderingContext(ctx, this.protocolGenerator, shape, writer), members, this.supportsJsonNameTrait).render();
        if (shape.isUnionShape()) {
            String name = ctx.getSymbolProvider().toSymbol(shape).getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            new DeserializeUnionGenerator(ctx, name, members, writer, this.getDefaultTimestampFormat()).render();
        } else {
            new DeserializeStructGenerator(ctx, members, writer, this.getDefaultTimestampFormat()).render();
        }
    }

    @Override
    @NotNull
    public Symbol payloadDeserializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull MemberShape member) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Symbol symbol = ctx.getSymbolProvider().toSymbol((Shape)member);
        Shape target = ctx.getModel().expectShape(member.getTarget());
        Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
        Symbol deserializeFn = this.documentDeserializer(ctx, target);
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"symbol");
        String fnName = SerdeExtKt.payloadDeserializerName(symbol);
        return SerdeExtKt.payloadDeserializer(symbol, ctx.getSettings(), (Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(this, ctx, target, fnName, symbol, deserializeFn){
            final /* synthetic */ JsonParserGenerator this$0;
            final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
            final /* synthetic */ Shape $target;
            final /* synthetic */ String $fnName;
            final /* synthetic */ Symbol $symbol;
            final /* synthetic */ Symbol $deserializeFn;
            {
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                this.$target = $target;
                this.$fnName = $fnName;
                this.$symbol = $symbol;
                this.$deserializeFn = $deserializeFn;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
                Object[] objectArray = this.$target;
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"target");
                JsonParserGenerator.access$addNestedDocumentDeserializers(this.this$0, this.$ctx, (Shape)objectArray, writer);
                CodeWriter codeWriter = writer;
                objectArray = new Object[2];
                objectArray[0] = this.$fnName;
                Symbol symbol = this.$symbol;
                Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"symbol");
                objectArray[1] = symbol;
                CodeWriterExtKt.withBlock(codeWriter, "internal fun #L(payload: ByteArray): #T {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(this.$deserializeFn){
                    final /* synthetic */ Symbol $deserializeFn;
                    {
                        this.$deserializeFn = $deserializeFn;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        Object[] objectArray = new Object[]{RuntimeTypes.Serde.SerdeJson.INSTANCE.getJsonDeserializer()};
                        $this$withBlock.write("val deserializer = #T(payload)", objectArray);
                        objectArray = new Object[]{this.$deserializeFn};
                        $this$withBlock.write("return #T(deserializer)", objectArray);
                    }
                });
            }
        }));
    }

    public static final /* synthetic */ void access$addNestedDocumentDeserializers(JsonParserGenerator $this, ProtocolGenerator.GenerationContext ctx, Shape shape, KotlinWriter writer) {
        $this.addNestedDocumentDeserializers(ctx, shape, writer);
    }

    public static final /* synthetic */ void access$renderDeserializeOperationBody(JsonParserGenerator $this, ProtocolGenerator.GenerationContext ctx, OperationShape op, List documentMembers, KotlinWriter writer) {
        $this.renderDeserializeOperationBody(ctx, op, documentMembers, writer);
    }

    public static final /* synthetic */ void access$renderDeserializerBody(JsonParserGenerator $this, ProtocolGenerator.GenerationContext ctx, Shape shape, List members, KotlinWriter writer) {
        $this.renderDeserializerBody(ctx, shape, members, writer);
    }
}

