/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.core;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.kotlin.codegen.core.ImportDeclarations;
import software.amazon.smithy.kotlin.codegen.core.ImportDeclarationsKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinPropertyFormatter;
import software.amazon.smithy.kotlin.codegen.core.KotlinSymbolFormatter;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriterKt;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypesKt;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.EnumDefinition;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.CodeWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u0003J\u0018\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0013\u001a\u00020\u0003J'\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0003J\u001f\u0010\u001b\u001a\u00020\u00002\u0017\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00100\u001e\u00a2\u0006\u0002\b\u001fJ\u001e\u0010 \u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0006H\u0002J\u000e\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u0004\u0018\u00010\u00002\u0006\u0010$\u001a\u00020%J\u000e\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*J\u0018\u0010+\u001a\u0004\u0018\u00010\u00002\u0006\u0010,\u001a\u00020-2\u0006\u0010$\u001a\u00020.J\b\u0010/\u001a\u00020\u0003H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bj\u0002`\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "Lsoftware/amazon/smithy/utils/CodeWriter;", "fullPackageName", "", "(Ljava/lang/String;)V", "dependencies", "", "Lsoftware/amazon/smithy/codegen/core/SymbolDependency;", "getDependencies", "()Ljava/util/Set;", "fullyQualifiedSymbols", "Lkotlin/Pair;", "Lsoftware/amazon/smithy/kotlin/codegen/core/FullyQualifiedSymbolName;", "imports", "Lsoftware/amazon/smithy/kotlin/codegen/core/ImportDeclarations;", "addImport", "", "packageName", "symbolName", "alias", "symbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "addImportReferences", "options", "", "Lsoftware/amazon/smithy/codegen/core/SymbolReference$ContextOption;", "(Lsoftware/amazon/smithy/codegen/core/Symbol;[Lsoftware/amazon/smithy/codegen/core/SymbolReference$ContextOption;)Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "dokka", "docs", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "findAllReferences", "allRefs", "Lsoftware/amazon/smithy/codegen/core/SymbolReference;", "renderAnnotations", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "renderDeprecatedAnnotation", "renderDocumentation", "renderEnumDefinitionDocumentation", "enumDefinition", "Lsoftware/amazon/smithy/model/traits/EnumDefinition;", "renderMemberDocumentation", "model", "Lsoftware/amazon/smithy/model/Model;", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "toString", "smithy-kotlin-codegen"})
public final class KotlinWriter
extends CodeWriter {
    @NotNull
    private final String fullPackageName;
    @NotNull
    private final Set<Pair<String, String>> fullyQualifiedSymbols;
    @NotNull
    private final Set<SymbolDependency> dependencies;
    @NotNull
    private final ImportDeclarations imports;

    public KotlinWriter(@NotNull String fullPackageName) {
        Intrinsics.checkNotNullParameter((Object)fullPackageName, (String)"fullPackageName");
        this.fullPackageName = fullPackageName;
        this.fullyQualifiedSymbols = new LinkedHashSet();
        this.dependencies = new LinkedHashSet();
        this.imports = new ImportDeclarations();
        this.trimBlankLines();
        this.trimTrailingSpaces();
        this.setIndentText("    ");
        this.setExpressionStart('#');
        this.putFormatter('T', new KotlinSymbolFormatter((Function1<? super Symbol, Boolean>)((Function1)new Function1<Symbol, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull Symbol symbol) {
                Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                return fullyQualifiedSymbols.contains(ImportDeclarationsKt.toFullyQualifiedSymbolName(symbol));
            }
        })));
        this.putFormatter('Q', new KotlinSymbolFormatter((Function1<? super Symbol, Boolean>)((Function1)2.INSTANCE)));
        this.putFormatter('P', new KotlinPropertyFormatter(false, false, false, 7, null));
        this.putFormatter('F', new KotlinPropertyFormatter(false, false, true, 3, null));
        this.putFormatter('D', new KotlinPropertyFormatter(true, false, false, 6, null));
        this.putFormatter('E', new KotlinPropertyFormatter(true, false, true, 2, null));
    }

    @NotNull
    public final Set<SymbolDependency> getDependencies() {
        return this.dependencies;
    }

    @NotNull
    public final KotlinWriter addImport(@NotNull Symbol symbol, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        if (KotlinTypesKt.isBuiltIn(symbol)) {
            return this;
        }
        Object object = symbol.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"symbol.dependencies");
        this.dependencies.addAll((Collection)object);
        object = symbol.getNamespace();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"symbol.namespace");
        if (((CharSequence)object).length() > 0 && !Intrinsics.areEqual((Object)symbol.getNamespace(), (Object)this.fullPackageName)) {
            object = symbol.getNamespace();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"symbol.namespace");
            Object object2 = object;
            object = symbol.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"symbol.name");
            if (this.imports.symbolCollides((String)object2, (String)object)) {
                this.fullyQualifiedSymbols.add(ImportDeclarationsKt.toFullyQualifiedSymbolName(symbol));
            } else {
                object = symbol.getNamespace();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"symbol.namespace");
                Object object3 = object;
                object = symbol.getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"symbol.name");
                this.imports.addImport((String)object3, (String)object, alias);
            }
        }
        return this;
    }

    public static /* synthetic */ KotlinWriter addImport$default(KotlinWriter kotlinWriter, Symbol symbol, String string, int n, Object object) {
        if ((n & 2) != 0) {
            String string2 = symbol.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fun addImport(symbol: Sy\u2026        return this\n    }");
            string = string2;
        }
        return kotlinWriter.addImport(symbol, string);
    }

    @NotNull
    public final KotlinWriter addImportReferences(@NotNull Symbol symbol, SymbolReference.ContextOption ... options) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Set allRefs = new LinkedHashSet();
        this.findAllReferences(symbol, allRefs);
        Iterable $this$forEach$iv = allRefs;
        boolean $i$f$forEach = false;
        block0: for (Object element$iv : $this$forEach$iv) {
            SymbolReference reference = (SymbolReference)element$iv;
            boolean bl = false;
            for (SymbolReference.ContextOption option : options) {
                if (!reference.hasOption((SymbolReference.Option)option)) continue;
                Object object = reference.getSymbol();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reference.symbol");
                Symbol symbol2 = object;
                object = reference.getAlias();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reference.alias");
                this.addImport(symbol2, (String)object);
                continue block0;
            }
        }
        return this;
    }

    private final void findAllReferences(Symbol symbol, Set<SymbolReference> allRefs) {
        List list = symbol.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"symbol.references");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SymbolReference ref = (SymbolReference)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"ref");
            allRefs.add(ref);
            Symbol symbol2 = ref.getSymbol();
            Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"ref.symbol");
            this.findAllReferences(symbol2, allRefs);
        }
    }

    public final void addImport(@NotNull String packageName, @NotNull String symbolName, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)symbolName, (String)"symbolName");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        if (this.imports.symbolCollides(packageName, symbolName)) {
            this.fullyQualifiedSymbols.add((Pair<String, String>)TuplesKt.to((Object)packageName, (Object)symbolName));
        } else {
            this.imports.addImport(packageName, symbolName, alias);
        }
    }

    public static /* synthetic */ void addImport$default(KotlinWriter kotlinWriter, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = string2;
        }
        kotlinWriter.addImport(string, string2, string3);
    }

    @NotNull
    public String toString() {
        String string = super.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"super.toString()");
        String contents = string;
        String header = "// Code generated by smithy-kotlin-codegen. DO NOT EDIT!\n\n";
        String importStatements = this.imports + "\n\n";
        String pkgDecl = "package " + this.fullPackageName + "\n\n";
        return header + pkgDecl + importStatements + contents;
    }

    @NotNull
    public final KotlinWriter dokka(@NotNull Function1<? super KotlinWriter, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.pushState();
        this.write("/**", new Object[0]);
        this.setNewlinePrefix(" * ");
        block.invoke((Object)this);
        this.popState();
        this.write(" */", new Object[0]);
        return this;
    }

    @NotNull
    public final KotlinWriter dokka(@NotNull String docs) {
        Intrinsics.checkNotNullParameter((Object)docs, (String)"docs");
        return this.dokka((Function1<? super KotlinWriter, Unit>)((Function1)new Function1<KotlinWriter, Unit>(docs){
            final /* synthetic */ String $docs;
            {
                this.$docs = $docs;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$dokka) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$dokka), (String)"$this$dokka");
                $this$dokka.write(KotlinWriterKt.formatDocumentation$default(KotlinWriterKt.access$sanitizeDocumentation(this.$docs), null, 2, null), new Object[0]);
            }
        }));
    }

    public final void renderAnnotations(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.renderDeprecatedAnnotation(shape);
    }

    private final void renderDeprecatedAnnotation(Shape shape) {
        if (ShapeExtKt.isDeprecated(shape)) {
            this.write("@Deprecated(\"No longer recommended for use. See AWS API documentation for more details.\")", new Object[0]);
        }
    }

    @Nullable
    public final KotlinWriter renderDocumentation(@NotNull Shape shape) {
        KotlinWriter kotlinWriter;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape $this$getTrait$iv = shape;
        boolean $i$f$getTrait = false;
        Optional optional = $this$getTrait$iv.getTrait(DocumentationTrait.class);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTrait(T::class.java)");
        DocumentationTrait documentationTrait = (DocumentationTrait)((Trait)OptionalExtKt.getOrNull(optional));
        if (documentationTrait == null) {
            kotlinWriter = null;
        } else {
            DocumentationTrait it = documentationTrait;
            boolean bl = false;
            String string = it.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.value");
            kotlinWriter = this.dokka(string);
        }
        return kotlinWriter;
    }

    @Nullable
    public final KotlinWriter renderMemberDocumentation(@NotNull Model model, @NotNull MemberShape shape) {
        KotlinWriter kotlinWriter;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Optional optional = shape.getMemberTrait(model, DocumentationTrait.class);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"shape.getMemberTrait(mod\u2026ntationTrait::class.java)");
        DocumentationTrait documentationTrait = (DocumentationTrait)OptionalExtKt.getOrNull(optional);
        if (documentationTrait == null) {
            kotlinWriter = null;
        } else {
            DocumentationTrait it = documentationTrait;
            boolean bl = false;
            String string = it.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.value");
            kotlinWriter = this.dokka(string);
        }
        return kotlinWriter;
    }

    public final void renderEnumDefinitionDocumentation(@NotNull EnumDefinition enumDefinition) {
        Intrinsics.checkNotNullParameter((Object)enumDefinition, (String)"enumDefinition");
        enumDefinition.getDocumentation().ifPresent(arg_0 -> KotlinWriter.renderEnumDefinitionDocumentation$lambda-4(this, arg_0));
    }

    private static final void renderEnumDefinitionDocumentation$lambda-4(KotlinWriter this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.dokka(it);
    }
}

