/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.serde;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.NestedIdentifierType;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.utils.StringUtils;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\t\u001a\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u0001*\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0001\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\t\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0014\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0014\u001a\f\u0010\u0017\u001a\u00020\u0006*\u00020\fH\u0000\u001a\f\u0010\u0018\u001a\u00020\u0001*\u00020\u0019H\u0000\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\f\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\t\u001a\u0014\u0010\u001c\u001a\u00020\u0001*\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a8\u0006\u001f"}, d2={"formatInstant", "", "paramName", "tsFmt", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "forceString", "", "parseInstant", "bodyDeserializerName", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "bodySerializerName", "childShape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "model", "Lsoftware/amazon/smithy/model/Model;", "descriptorName", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "childName", "deserializerName", "documentDeserializerName", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "documentSerializerName", "errorDeserializerName", "isContainerShape", "nestedDescriptorName", "", "serialKind", "serializerName", "variableNameFor", "type", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/NestedIdentifierType;", "smithy-kotlin-codegen"})
public final class SerdeExtKt {
    @NotNull
    public static final String descriptorName(@NotNull MemberShape $this$descriptorName, @NotNull String childName) {
        Intrinsics.checkNotNullParameter((Object)$this$descriptorName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)childName, (String)"childName");
        String string = NamingKt.defaultName($this$descriptorName) + childName + "_DESCRIPTOR";
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
        return string3;
    }

    public static /* synthetic */ String descriptorName$default(MemberShape memberShape, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return SerdeExtKt.descriptorName(memberShape, string);
    }

    @NotNull
    public static final String serializerName(@NotNull OperationShape $this$serializerName) {
        Intrinsics.checkNotNullParameter((Object)$this$serializerName, (String)"<this>");
        return Intrinsics.stringPlus((String)StringUtils.capitalize((String)$this$serializerName.getId().getName()), (Object)"OperationSerializer");
    }

    @NotNull
    public static final String bodySerializerName(@NotNull OperationShape $this$bodySerializerName) {
        Intrinsics.checkNotNullParameter((Object)$this$bodySerializerName, (String)"<this>");
        return "serialize" + StringUtils.capitalize((String)$this$bodySerializerName.getId().getName()) + "OperationBody";
    }

    @NotNull
    public static final String deserializerName(@NotNull OperationShape $this$deserializerName) {
        Intrinsics.checkNotNullParameter((Object)$this$deserializerName, (String)"<this>");
        return Intrinsics.stringPlus((String)StringUtils.capitalize((String)$this$deserializerName.getId().getName()), (Object)"OperationDeserializer");
    }

    @NotNull
    public static final String bodyDeserializerName(@NotNull OperationShape $this$bodyDeserializerName) {
        Intrinsics.checkNotNullParameter((Object)$this$bodyDeserializerName, (String)"<this>");
        return "deserialize" + StringUtils.capitalize((String)$this$bodyDeserializerName.getId().getName()) + "OperationBody";
    }

    @NotNull
    public static final String documentSerializerName(@NotNull Symbol $this$documentSerializerName) {
        Intrinsics.checkNotNullParameter((Object)$this$documentSerializerName, (String)"<this>");
        return "serialize" + StringUtils.capitalize((String)$this$documentSerializerName.getName()) + "Document";
    }

    @NotNull
    public static final String documentDeserializerName(@NotNull Symbol $this$documentDeserializerName) {
        Intrinsics.checkNotNullParameter((Object)$this$documentDeserializerName, (String)"<this>");
        return "deserialize" + StringUtils.capitalize((String)$this$documentDeserializerName.getName()) + "Document";
    }

    @NotNull
    public static final String errorDeserializerName(@NotNull Symbol $this$errorDeserializerName) {
        Intrinsics.checkNotNullParameter((Object)$this$errorDeserializerName, (String)"<this>");
        return "deserialize" + StringUtils.capitalize((String)$this$errorDeserializerName.getName()) + "Error";
    }

    @NotNull
    public static final String formatInstant(@NotNull String paramName, @NotNull TimestampFormatTrait.Format tsFmt, boolean forceString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
        Intrinsics.checkNotNullParameter((Object)tsFmt, (String)"tsFmt");
        TimestampFormatTrait.Format format = tsFmt;
        int n = WhenMappings.$EnumSwitchMapping$0[format.ordinal()];
        switch (n) {
            case 1: {
                if (forceString) {
                    string = Intrinsics.stringPlus((String)paramName, (Object)".format(TimestampFormat.EPOCH_SECONDS)");
                    break;
                }
                string = Intrinsics.stringPlus((String)paramName, (Object)".toEpochDouble()");
                break;
            }
            case 2: {
                string = Intrinsics.stringPlus((String)paramName, (Object)".format(TimestampFormat.ISO_8601)");
                break;
            }
            case 3: {
                string = Intrinsics.stringPlus((String)paramName, (Object)".format(TimestampFormat.RFC_5322)");
                break;
            }
            default: {
                throw new CodegenException(Intrinsics.stringPlus((String)"unknown timestamp format: ", (Object)tsFmt));
            }
        }
        return string;
    }

    public static /* synthetic */ String formatInstant$default(String string, TimestampFormatTrait.Format format, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return SerdeExtKt.formatInstant(string, format, bl);
    }

    @NotNull
    public static final String parseInstant(@NotNull String paramName, @NotNull TimestampFormatTrait.Format tsFmt) {
        String string;
        Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
        Intrinsics.checkNotNullParameter((Object)tsFmt, (String)"tsFmt");
        TimestampFormatTrait.Format format = tsFmt;
        int n = WhenMappings.$EnumSwitchMapping$0[format.ordinal()];
        switch (n) {
            case 1: {
                string = "Instant.fromEpochSeconds(" + paramName + ')';
                break;
            }
            case 2: {
                string = "Instant.fromIso8601(" + paramName + ')';
                break;
            }
            case 3: {
                string = "Instant.fromRfc5322(" + paramName + ')';
                break;
            }
            default: {
                throw new CodegenException(Intrinsics.stringPlus((String)"unknown timestamp format: ", (Object)tsFmt));
            }
        }
        return string;
    }

    @NotNull
    public static final String serialKind(@NotNull Shape $this$serialKind) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$serialKind, (String)"<this>");
        ShapeType shapeType = $this$serialKind.getType();
        int n = shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[shapeType.ordinal()];
        switch (n) {
            case 1: {
                string = "SerialKind.Boolean";
                break;
            }
            case 2: {
                string = "SerialKind.Byte";
                break;
            }
            case 3: {
                string = "SerialKind.Short";
                break;
            }
            case 4: {
                string = "SerialKind.Integer";
                break;
            }
            case 5: {
                string = "SerialKind.Long";
                break;
            }
            case 6: {
                string = "SerialKind.Float";
                break;
            }
            case 7: {
                string = "SerialKind.Double";
                break;
            }
            case 8: {
                string = "SerialKind.String";
                break;
            }
            case 9: {
                string = "SerialKind.Blob";
                break;
            }
            case 10: {
                string = "SerialKind.Timestamp";
                break;
            }
            case 11: {
                string = "SerialKind.Document";
                break;
            }
            case 12: 
            case 13: {
                string = "SerialKind.BigNumber";
                break;
            }
            case 14: {
                string = "SerialKind.List";
                break;
            }
            case 15: {
                string = "SerialKind.List";
                break;
            }
            case 16: {
                string = "SerialKind.Map";
                break;
            }
            case 17: {
                string = "SerialKind.Struct";
                break;
            }
            case 18: {
                string = "SerialKind.Struct";
                break;
            }
            default: {
                throw new CodegenException("unknown SerialKind for " + $this$serialKind.getType() + " (" + $this$serialKind + ')');
            }
        }
        return string;
    }

    @NotNull
    public static final String variableNameFor(int $this$variableNameFor, @NotNull NestedIdentifierType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return Intrinsics.stringPlus((String)type.getPrefix(), (Object)$this$variableNameFor);
    }

    @NotNull
    public static final String nestedDescriptorName(int $this$nestedDescriptorName) {
        return Intrinsics.stringPlus((String)"_C", (Object)$this$nestedDescriptorName);
    }

    public static final boolean isContainerShape(@NotNull Shape $this$isContainerShape) {
        Intrinsics.checkNotNullParameter((Object)$this$isContainerShape, (String)"<this>");
        Shape shape = $this$isContainerShape;
        return shape instanceof CollectionShape ? true : shape instanceof MapShape;
    }

    @Nullable
    public static final Shape childShape(@NotNull Shape $this$childShape, @NotNull Model model) {
        Intrinsics.checkNotNullParameter((Object)$this$childShape, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Shape shape = $this$childShape;
        return shape instanceof CollectionShape ? model.expectShape(((CollectionShape)$this$childShape).getMember().getTarget()) : (shape instanceof MapShape ? model.expectShape(((MapShape)$this$childShape).getValue().getTarget()) : null);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TimestampFormatTrait.Format.values().length];
            nArray[TimestampFormatTrait.Format.EPOCH_SECONDS.ordinal()] = 1;
            nArray[TimestampFormatTrait.Format.DATE_TIME.ordinal()] = 2;
            nArray[TimestampFormatTrait.Format.HTTP_DATE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ShapeType.values().length];
            nArray[ShapeType.BOOLEAN.ordinal()] = 1;
            nArray[ShapeType.BYTE.ordinal()] = 2;
            nArray[ShapeType.SHORT.ordinal()] = 3;
            nArray[ShapeType.INTEGER.ordinal()] = 4;
            nArray[ShapeType.LONG.ordinal()] = 5;
            nArray[ShapeType.FLOAT.ordinal()] = 6;
            nArray[ShapeType.DOUBLE.ordinal()] = 7;
            nArray[ShapeType.STRING.ordinal()] = 8;
            nArray[ShapeType.BLOB.ordinal()] = 9;
            nArray[ShapeType.TIMESTAMP.ordinal()] = 10;
            nArray[ShapeType.DOCUMENT.ordinal()] = 11;
            nArray[ShapeType.BIG_INTEGER.ordinal()] = 12;
            nArray[ShapeType.BIG_DECIMAL.ordinal()] = 13;
            nArray[ShapeType.LIST.ordinal()] = 14;
            nArray[ShapeType.SET.ordinal()] = 15;
            nArray[ShapeType.MAP.ordinal()] = 16;
            nArray[ShapeType.STRUCTURE.ordinal()] = 17;
            nArray[ShapeType.UNION.ordinal()] = 18;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

