/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.serde;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.knowledge.SerdeIndex;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.JsonSerdeDescriptorGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerializeStructGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerializeUnionGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.StructuredDataSerializerGenerator;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bH\u0002J.\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bH\u0002J.\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/JsonSerializerGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/StructuredDataSerializerGenerator;", "protocolGenerator", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator;", "supportsJsonNameTrait", "", "<init>", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator;Z)V", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "getDefaultTimestampFormat", "()Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "operationSerializer", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "members", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "addNestedDocumentSerializers", "", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "", "renderSerializeOperationBody", "documentMembers", "documentSerializer", "renderSerializerBody", "payloadSerializer", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nJsonSerializerGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSerializerGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/serde/JsonSerializerGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1869#2,2:123\n*S KotlinDebug\n*F\n+ 1 JsonSerializerGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/serde/JsonSerializerGenerator\n*L\n52#1:123,2\n*E\n"})
public class JsonSerializerGenerator
implements StructuredDataSerializerGenerator {
    @NotNull
    private final ProtocolGenerator protocolGenerator;
    private final boolean supportsJsonNameTrait;
    @NotNull
    private final TimestampFormatTrait.Format defaultTimestampFormat;

    public JsonSerializerGenerator(@NotNull ProtocolGenerator protocolGenerator, boolean supportsJsonNameTrait) {
        Intrinsics.checkNotNullParameter((Object)protocolGenerator, (String)"protocolGenerator");
        this.protocolGenerator = protocolGenerator;
        this.supportsJsonNameTrait = supportsJsonNameTrait;
        this.defaultTimestampFormat = TimestampFormatTrait.Format.EPOCH_SECONDS;
    }

    public /* synthetic */ JsonSerializerGenerator(ProtocolGenerator protocolGenerator, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(protocolGenerator, bl);
    }

    @NotNull
    public TimestampFormatTrait.Format getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    @Override
    @NotNull
    public Symbol operationSerializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull List<MemberShape> members) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Shape input = ctx.getModel().expectShape((ShapeId)op.getInput().get());
        Symbol symbol = ctx.getSymbolProvider().toSymbol(input);
        return SerdeExtKt.bodySerializer(op, ctx.getSettings(), (Function1<? super KotlinWriter, Unit>)((Function1)arg_0 -> JsonSerializerGenerator.operationSerializer$lambda$1(this, ctx, op, symbol, members, arg_0)));
    }

    private final void addNestedDocumentSerializers(ProtocolGenerator.GenerationContext ctx, Shape shape, KotlinWriter writer, Collection<MemberShape> members) {
        SerdeIndex serdeIndex = SerdeIndex.Companion.of(ctx.getModel());
        Set<Shape> shapesRequiringDocumentSerializer = serdeIndex.requiresDocumentSerializer(shape, members);
        Iterable $this$forEach$iv = shapesRequiringDocumentSerializer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Shape it = (Shape)element$iv;
            boolean bl = false;
            Symbol nestedStructOrUnionSerializer = JsonSerializerGenerator.documentSerializer$default(this, ctx, it, null, 4, null);
            KotlinWriter.addImport$default(writer, nestedStructOrUnionSerializer, null, 2, null);
        }
    }

    static /* synthetic */ void addNestedDocumentSerializers$default(JsonSerializerGenerator jsonSerializerGenerator, ProtocolGenerator.GenerationContext generationContext, Shape shape, KotlinWriter kotlinWriter, Collection collection, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addNestedDocumentSerializers");
        }
        if ((n & 8) != 0) {
            Collection collection2 = shape.members();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"members(...)");
            collection = collection2;
        }
        jsonSerializerGenerator.addNestedDocumentSerializers(generationContext, shape, kotlinWriter, collection);
    }

    private final void renderSerializeOperationBody(ProtocolGenerator.GenerationContext ctx, OperationShape op, List<MemberShape> documentMembers, KotlinWriter writer) {
        Shape shape = ctx.getModel().expectShape((ShapeId)op.getInput().get());
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.SerdeJson.INSTANCE.getJsonSerializer()};
        writer.write("val serializer = #T()", objectArray);
        Intrinsics.checkNotNull((Object)shape);
        this.renderSerializerBody(ctx, shape, documentMembers, writer);
        writer.write("return serializer.toByteArray()", new Object[0]);
    }

    private final Symbol documentSerializer(ProtocolGenerator.GenerationContext ctx, Shape shape, Collection<MemberShape> members) {
        Symbol symbol = ctx.getSymbolProvider().toSymbol(shape);
        KotlinSettings kotlinSettings = ctx.getSettings();
        Intrinsics.checkNotNull((Object)symbol);
        return SerdeExtKt.documentSerializer(shape, kotlinSettings, symbol, members, (Function1<? super KotlinWriter, Unit>)((Function1)arg_0 -> JsonSerializerGenerator.documentSerializer$lambda$4(symbol, this, ctx, shape, members, arg_0)));
    }

    static /* synthetic */ Symbol documentSerializer$default(JsonSerializerGenerator jsonSerializerGenerator, ProtocolGenerator.GenerationContext generationContext, Shape shape, Collection collection, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: documentSerializer");
        }
        if ((n & 4) != 0) {
            Collection collection2 = shape.members();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"members(...)");
            collection = collection2;
        }
        return jsonSerializerGenerator.documentSerializer(generationContext, shape, collection);
    }

    private final void renderSerializerBody(ProtocolGenerator.GenerationContext ctx, Shape shape, List<MemberShape> members, KotlinWriter writer) {
        new JsonSerdeDescriptorGenerator(ProtocolGeneratorKt.toRenderingContext(ctx, this.protocolGenerator, shape, writer), members, this.supportsJsonNameTrait).render();
        Shape shape2 = shape;
        if (shape2 instanceof DocumentShape) {
            writer.write("serializer.serializeDocument(input)", new Object[0]);
        } else if (shape2 instanceof UnionShape) {
            new SerializeUnionGenerator(ctx, (UnionShape)shape, members, writer, this.getDefaultTimestampFormat()).render();
        } else {
            new SerializeStructGenerator(ctx, members, writer, this.getDefaultTimestampFormat()).render();
        }
    }

    @Override
    @NotNull
    public Symbol payloadSerializer(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull Shape shape, @Nullable Collection<MemberShape> members) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape target = ShapeExtKt.targetOrSelf(shape, ctx.getModel());
        Symbol symbol = ctx.getSymbolProvider().toSymbol(shape);
        Collection collection = members;
        if (collection == null) {
            collection = target.members();
        }
        Collection forMembers = collection;
        Intrinsics.checkNotNull((Object)forMembers);
        Symbol serializeFn = this.documentSerializer(ctx, target, forMembers);
        KotlinSettings kotlinSettings = ctx.getSettings();
        Intrinsics.checkNotNull((Object)symbol);
        return SerdeExtKt.payloadSerializer(target, kotlinSettings, symbol, forMembers, (Function1<? super KotlinWriter, Unit>)((Function1)arg_0 -> JsonSerializerGenerator.payloadSerializer$lambda$6(this, ctx, target, forMembers, symbol, serializeFn, arg_0)));
    }

    private static final void operationSerializer$lambda$1$lambda$0(JsonSerializerGenerator this$0, ProtocolGenerator.GenerationContext $ctx, OperationShape $op, List $members, KotlinWriter $writer) {
        this$0.renderSerializeOperationBody($ctx, $op, $members, $writer);
    }

    private static final Unit operationSerializer$lambda$1(JsonSerializerGenerator this$0, ProtocolGenerator.GenerationContext $ctx, OperationShape $op, Symbol $symbol, List $members, KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        JsonSerializerGenerator.addNestedDocumentSerializers$default(this$0, $ctx, (Shape)$op, writer, null, 8, null);
        String fnName = SerdeExtKt.bodySerializerName($op);
        Object[] objectArray = new Object[]{fnName, RuntimeTypes.Core.INSTANCE.getExecutionContext(), $symbol};
        ((KotlinWriter)((KotlinWriter)writer.openBlock("private fun #L(context: #T, input: #T): ByteArray {", objectArray)).call(() -> JsonSerializerGenerator.operationSerializer$lambda$1$lambda$0(this$0, $ctx, $op, $members, writer))).closeBlock("}", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final void documentSerializer$lambda$4$lambda$3(JsonSerializerGenerator this$0, ProtocolGenerator.GenerationContext $ctx, Shape $shape, Collection $members, KotlinWriter $writer) {
        this$0.renderSerializerBody($ctx, $shape, CollectionsKt.toList((Iterable)$members), $writer);
    }

    private static final Unit documentSerializer$lambda$4(Symbol $symbol, JsonSerializerGenerator this$0, ProtocolGenerator.GenerationContext $ctx, Shape $shape, Collection $members, KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getSerializer(), $symbol};
        ((KotlinWriter)((KotlinWriter)writer.openBlock("internal fun #identifier.name:L(serializer: #T, input: #T) {", objectArray)).call(() -> JsonSerializerGenerator.documentSerializer$lambda$4$lambda$3(this$0, $ctx, $shape, $members, writer))).closeBlock("}", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit payloadSerializer$lambda$6$lambda$5(Symbol $serializeFn, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.SerdeJson.INSTANCE.getJsonSerializer()};
        $this$withBlock.write("val serializer = #T()", objectArray);
        objectArray = new Object[]{$serializeFn};
        $this$withBlock.write("#T(serializer, input)", objectArray);
        $this$withBlock.write("return serializer.toByteArray()", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit payloadSerializer$lambda$6(JsonSerializerGenerator this$0, ProtocolGenerator.GenerationContext $ctx, Shape $target, Collection $forMembers, Symbol $symbol, Symbol $serializeFn, KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNull((Object)$forMembers);
        this$0.addNestedDocumentSerializers($ctx, $target, writer, $forMembers);
        Intrinsics.checkNotNull((Object)$symbol);
        Object[] objectArray = new SymbolReference.ContextOption[]{SymbolReference.ContextOption.USE};
        writer.addImportReferences($symbol, (SymbolReference.ContextOption[])objectArray);
        objectArray = new Object[]{$symbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "internal fun #identifier.name:L(input: #T): ByteArray {", "}", objectArray, arg_0 -> JsonSerializerGenerator.payloadSerializer$lambda$6$lambda$5($serializeFn, arg_0));
        return Unit.INSTANCE;
    }
}

