/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.protocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinDependency;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriterKt;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.integration.AuthSchemeHandler;
import software.amazon.smithy.kotlin.codegen.integration.SectionId;
import software.amazon.smithy.kotlin.codegen.integration.SectionKey;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.knowledge.AuthIndex;
import software.amazon.smithy.kotlin.codegen.rendering.auth.AuthSchemeProviderAdapterGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.auth.IdentityProviderConfigGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.endpoints.EndpointResolverAdapterGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpProtocolClientGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolMiddleware;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.pattern.SmithyPattern;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.EndpointTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001:\u0004'()*B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J \u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J \u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J \u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010%\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006+"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator;", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "middleware", "", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolMiddleware;", "httpBindingResolver", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "<init>", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;Ljava/util/List;Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;)V", "getCtx", "()Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "getMiddleware", "()Ljava/util/List;", "getHttpBindingResolver", "()Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "render", "", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "renderProperties", "importSymbols", "renderInit", "renderOperationBody", "opIndex", "Lsoftware/amazon/smithy/model/knowledge/OperationIndex;", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "renderOperationSetup", "renderFinalizeBeforeExecute", "renderOperationExecute", "ioSymbolNames", "Lkotlin/Pair;", "", "renderOperationMiddleware", "renderClose", "renderAdditionalMethods", "renderMergeServiceDefaults", "EndpointResolverAdapterBinding", "OperationTelemetryBuilder", "ClientInitializer", "MergeServiceDefaults", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nHttpProtocolClientGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpProtocolClientGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,369:1\n1053#2:370\n774#2:371\n865#2,2:372\n1053#2:374\n1863#2,2:375\n1863#2:377\n865#2,2:378\n1864#2:380\n1863#2,2:381\n1863#2,2:383\n1863#2,2:385\n230#2,2:387\n83#3:389\n*S KotlinDebug\n*F\n+ 1 HttpProtocolClientGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator\n*L\n56#1:370\n314#1:371\n314#1:372,2\n315#1:374\n316#1:375,2\n69#1:377\n70#1:378,2\n69#1:380\n74#1:381,2\n77#1:383,2\n111#1:385,2\n231#1:387,2\n225#1:389\n*E\n"})
public class HttpProtocolClientGenerator {
    @NotNull
    private final ProtocolGenerator.GenerationContext ctx;
    @NotNull
    private final List<ProtocolMiddleware> middleware;
    @NotNull
    private final HttpBindingResolver httpBindingResolver;

    public HttpProtocolClientGenerator(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull List<? extends ProtocolMiddleware> middleware, @NotNull HttpBindingResolver httpBindingResolver) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(middleware, (String)"middleware");
        Intrinsics.checkNotNullParameter((Object)httpBindingResolver, (String)"httpBindingResolver");
        this.ctx = ctx;
        this.middleware = middleware;
        this.httpBindingResolver = httpBindingResolver;
    }

    @NotNull
    protected final ProtocolGenerator.GenerationContext getCtx() {
        return this.ctx;
    }

    @NotNull
    protected final List<ProtocolMiddleware> getMiddleware() {
        return this.middleware;
    }

    @NotNull
    protected final HttpBindingResolver getHttpBindingResolver() {
        return this.httpBindingResolver;
    }

    public void render(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Symbol symbol = this.ctx.getSymbolProvider().toSymbol((Shape)this.ctx.getService());
        TopDownIndex topDownIndex = TopDownIndex.of((Model)this.ctx.getModel());
        Set set = topDownIndex.getContainedOperations((ToShapeId)this.ctx.getService());
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getContainedOperations(...)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        List operations = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                OperationShape it = (OperationShape)a;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Comparable comparable = (Comparable)((Object)NamingKt.defaultName(it));
                it = (OperationShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                Intrinsics.checkNotNull((Object)it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)NamingKt.defaultName(it))));
            }
        });
        OperationIndex operationsIndex = OperationIndex.of((Model)this.ctx.getModel());
        this.importSymbols(writer);
        ((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)writer.openBlock("internal class Default" + symbol.getName() + "(override val config: " + symbol.getName() + ".Config) : " + symbol.getName() + " {", new Object[0])).call(() -> HttpProtocolClientGenerator.render$lambda$1(this, writer))).write("", new Object[0])).call(() -> HttpProtocolClientGenerator.render$lambda$2(this, writer))).write("", new Object[0])).call(() -> HttpProtocolClientGenerator.render$lambda$6(operations, this, writer))).call(() -> HttpProtocolClientGenerator.render$lambda$8(operations, this, writer, operationsIndex))).write("", new Object[0])).call(() -> HttpProtocolClientGenerator.render$lambda$9(this, writer))).write("", new Object[0])).call(() -> HttpProtocolClientGenerator.render$lambda$10(this, writer))).write("", new Object[0])).call(() -> HttpProtocolClientGenerator.render$lambda$11(this, writer))).closeBlock("}", new Object[0])).write("", new Object[0]);
    }

    protected void renderProperties(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Object[] objectArray = new Object[]{RuntimeTypes.Core.IO.INSTANCE.getSdkManagedGroup()};
        writer.write("private val managedResources = #T()", objectArray);
        objectArray = new Object[]{RuntimeTypes.HttpClient.INSTANCE.getSdkHttpClient()};
        writer.write("private val client = #T(config.httpClient)", objectArray);
        objectArray = new Object[]{IdentityProviderConfigGenerator.Companion.getSymbol(this.ctx.getSettings())};
        writer.write("private val identityProviderConfig = #T(config)", objectArray);
        objectArray = new Object[]{RuntimeTypes.Auth.HttpAuth.INSTANCE.getAuthScheme()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "private val configuredAuthSchemes = with(config.authSchemes.associateBy(#T::schemeId).toMutableMap()){", "}", objectArray, arg_0 -> HttpProtocolClientGenerator.renderProperties$lambda$14(this, arg_0));
        objectArray = new Object[]{AuthSchemeProviderAdapterGenerator.Companion.getSymbol(this.ctx.getSettings())};
        writer.write("private val authSchemeAdapter = #T(config)", objectArray);
        objectArray = new Object[]{this.ctx.getSettings().getPkg().getName()};
        writer.write("private val telemetryScope = #S", objectArray);
        objectArray = new Object[]{RuntimeTypes.HttpClient.Operation.INSTANCE.getOperationMetrics()};
        writer.write("private val opMetrics = #T(telemetryScope, config.telemetryProvider)", objectArray);
    }

    protected void importSymbols(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        KotlinWriter.addImport$default(writer, this.ctx.getSettings().getPkg().subpackage("model"), "*", null, 4, null);
        Set set = new TopDownIndex(this.ctx.getModel()).getContainedOperations((ToShapeId)this.ctx.getService());
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getContainedOperations(...)");
        if (!((Collection)set).isEmpty()) {
            KotlinWriter.addImport$default(writer, this.ctx.getSettings().getPkg().getSerde(), "*", null, 4, null);
        }
        Object[] objectArray = new Symbol[]{RuntimeTypes.HttpClient.Operation.INSTANCE.getSdkHttpOperation(), RuntimeTypes.HttpClient.Operation.INSTANCE.getContext()};
        Set defaultClientSymbols = SetsKt.setOf((Object[])objectArray);
        KotlinWriterKt.addImport(writer, (Iterable<Symbol>)defaultClientSymbols);
        writer.getDependencies().addAll((Collection<SymbolDependency>)KotlinDependency.Companion.getHTTP().getDependencies());
    }

    protected void renderInit(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "init {", "}", new Object[0], arg_0 -> HttpProtocolClientGenerator.renderInit$lambda$15(writer, this, arg_0));
    }

    protected void renderOperationBody(@NotNull KotlinWriter writer, @NotNull OperationIndex opIndex, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)opIndex, (String)"opIndex");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        writer.write("", new Object[0]);
        writer.renderDocumentation((Shape)op);
        writer.renderAnnotations((Shape)op);
        String signature = ShapeExtKt.operationSignature$default(opIndex, this.ctx.getModel(), this.ctx.getSymbolProvider(), op, false, 8, null);
        Object[] objectArray = new Object[]{signature};
        ((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)writer.openBlock("override #L {", objectArray)).call(() -> HttpProtocolClientGenerator.renderOperationBody$lambda$16(this, writer, opIndex, op))).call(() -> HttpProtocolClientGenerator.renderOperationBody$lambda$17(this, op, writer))).call(() -> HttpProtocolClientGenerator.renderOperationBody$lambda$18(this, writer, opIndex, op))).call(() -> HttpProtocolClientGenerator.renderOperationBody$lambda$19(this, writer, opIndex, op))).closeBlock("}", new Object[0]);
    }

    protected void renderOperationSetup(@NotNull KotlinWriter writer, @NotNull OperationIndex opIndex, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)opIndex, (String)"opIndex");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Optional inputShape = opIndex.getInput((ToShapeId)op);
        Optional outputShape = opIndex.getOutput((ToShapeId)op);
        HttpTrait httpTrait = this.httpBindingResolver.httpTrait(op);
        Pair<String, String> pair = this.ioSymbolNames(op);
        String inputSymbolName = (String)pair.component1();
        String outputSymbolName = (String)pair.component2();
        writer.openBlock("val op = SdkHttpOperation.build<#L, #L> {", "}", inputSymbolName, outputSymbolName, () -> HttpProtocolClientGenerator.renderOperationSetup$lambda$27(inputShape, writer, op, outputShape, this, httpTrait));
        writer.write("mergeServiceDefaults(op.context)", new Object[0]);
    }

    protected void renderFinalizeBeforeExecute(@NotNull KotlinWriter writer, @NotNull OperationIndex opIndex, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)opIndex, (String)"opIndex");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        writer.write("op.interceptors.addAll(config.interceptors)", new Object[0]);
    }

    protected void renderOperationExecute(@NotNull KotlinWriter writer, @NotNull OperationIndex opIndex, @NotNull OperationShape op) {
        KotlinWriter kotlinWriter;
        String inputVariableName;
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)opIndex, (String)"opIndex");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Optional inputShape = opIndex.getInput((ToShapeId)op);
        Optional outputShape = opIndex.getOutput((ToShapeId)op);
        Boolean hasOutputStream = outputShape.map(arg_0 -> HttpProtocolClientGenerator.renderOperationExecute$lambda$29(arg_0 -> HttpProtocolClientGenerator.renderOperationExecute$lambda$28(this, arg_0), arg_0)).orElse(false);
        String string = inputVariableName = inputShape.isPresent() ? "input" : KotlinTypes.INSTANCE.getUnit().getFullName();
        if (hasOutputStream.booleanValue()) {
            Object[] objectArray = new Object[]{RuntimeTypes.HttpClient.Operation.INSTANCE.getExecute(), inputVariableName};
            kotlinWriter = (KotlinWriter)writer.write("return op.#T(client, #L, block)", objectArray);
        } else {
            Object[] objectArray = new Object[]{RuntimeTypes.HttpClient.Operation.INSTANCE.getRoundTrip(), inputVariableName};
            kotlinWriter = (KotlinWriter)writer.write("return op.#T(client, #L)", objectArray);
        }
    }

    private final Pair<String, String> ioSymbolNames(OperationShape op) {
        OperationIndex opIndex = OperationIndex.of((Model)this.ctx.getModel());
        Optional inputShape = opIndex.getInput((ToShapeId)op);
        Optional outputShape = opIndex.getOutput((ToShapeId)op);
        Optional<String> optional = inputShape.map(arg_0 -> HttpProtocolClientGenerator.ioSymbolNames$lambda$31(arg_0 -> HttpProtocolClientGenerator.ioSymbolNames$lambda$30(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        String string = OptionalExtKt.getOrNull(optional);
        if (string == null) {
            string = KotlinTypes.INSTANCE.getUnit().getFullName();
        }
        String inputSymbolName = string;
        Optional<String> optional2 = outputShape.map(arg_0 -> HttpProtocolClientGenerator.ioSymbolNames$lambda$33(arg_0 -> HttpProtocolClientGenerator.ioSymbolNames$lambda$32(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(optional2, (String)"map(...)");
        String string2 = OptionalExtKt.getOrNull(optional2);
        if (string2 == null) {
            string2 = KotlinTypes.INSTANCE.getUnit().getFullName();
        }
        String outputSymbolName = string2;
        return new Pair((Object)inputSymbolName, (Object)outputSymbolName);
    }

    /*
     * WARNING - void declaration
     */
    protected void renderOperationMiddleware(@NotNull OperationShape op, @NotNull KotlinWriter writer) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Iterable $this$filter$iv = this.middleware;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProtocolMiddleware it = (ProtocolMiddleware)element$iv$iv;
            boolean bl = false;
            if (!it.isEnabledFor(this.ctx, op)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProtocolMiddleware p0 = (ProtocolMiddleware)a;
                boolean bl = false;
                Comparable comparable = Byte.valueOf(p0.getOrder());
                p0 = (ProtocolMiddleware)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Byte.valueOf(p0.getOrder()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtocolMiddleware middleware = (ProtocolMiddleware)element$iv;
            boolean bl = false;
            middleware.render(this.ctx, op, writer);
        }
    }

    protected void renderClose(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "override fun close() {", "}", new Object[0], HttpProtocolClientGenerator::renderClose$lambda$36);
    }

    protected void renderAdditionalMethods(@NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
    }

    private final void renderMergeServiceDefaults(KotlinWriter writer) {
        writer.dokka("merge the defaults configured for the service into the execution context before firing off a request");
        Object[] objectArray = new Object[]{RuntimeTypes.Core.INSTANCE.getExecutionContext()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "private fun mergeServiceDefaults(ctx: #T) {", "}", objectArray, arg_0 -> HttpProtocolClientGenerator.renderMergeServiceDefaults$lambda$37(this, writer, arg_0));
    }

    private static final void render$lambda$1(HttpProtocolClientGenerator this$0, KotlinWriter $writer) {
        this$0.renderProperties($writer);
    }

    private static final void render$lambda$2(HttpProtocolClientGenerator this$0, KotlinWriter $writer) {
        this$0.renderInit($writer);
    }

    private static final void render$lambda$6(List $operations, HttpProtocolClientGenerator this$0, KotlinWriter $writer) {
        Set appliedMiddleware = new LinkedHashSet();
        Iterable $this$forEach$iv = $operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationShape op = (OperationShape)element$iv;
            boolean bl = false;
            Iterable $this$filterTo$iv = this$0.middleware;
            boolean $i$f$filterTo = false;
            for (Object element$iv2 : $this$filterTo$iv) {
                ProtocolMiddleware it = (ProtocolMiddleware)element$iv2;
                boolean bl2 = false;
                ProtocolGenerator.GenerationContext generationContext = this$0.ctx;
                Intrinsics.checkNotNull((Object)op);
                if (!it.isEnabledFor(generationContext, op)) continue;
                ((Collection)appliedMiddleware).add(element$iv2);
            }
        }
        $this$forEach$iv = appliedMiddleware;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtocolMiddleware it = (ProtocolMiddleware)element$iv;
            boolean bl = false;
            it.renderProperties($writer);
        }
    }

    private static final void render$lambda$8(List $operations, HttpProtocolClientGenerator this$0, KotlinWriter $writer, OperationIndex $operationsIndex) {
        Iterable $this$forEach$iv = $operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OperationShape op = (OperationShape)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$operationsIndex);
            Intrinsics.checkNotNull((Object)op);
            this$0.renderOperationBody($writer, $operationsIndex, op);
        }
    }

    private static final void render$lambda$9(HttpProtocolClientGenerator this$0, KotlinWriter $writer) {
        this$0.renderClose($writer);
    }

    private static final void render$lambda$10(HttpProtocolClientGenerator this$0, KotlinWriter $writer) {
        this$0.renderMergeServiceDefaults($writer);
    }

    private static final void render$lambda$11(HttpProtocolClientGenerator this$0, KotlinWriter $writer) {
        this$0.renderAdditionalMethods($writer);
    }

    private static final Unit renderProperties$lambda$14$lambda$13$lambda$12(AuthSchemeHandler $it, HttpProtocolClientGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $it.instantiateAuthSchemeExpr(this$0.ctx, $this$withBlock);
        return Unit.INSTANCE;
    }

    private static final Unit renderProperties$lambda$14(HttpProtocolClientGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AuthIndex authIndex = new AuthIndex();
        List<AuthSchemeHandler> allAuthHandlers = authIndex.authHandlersForService(this$0.ctx);
        Iterable $this$forEach$iv = allAuthHandlers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair;
            Object[] objectArray;
            AuthSchemeHandler it = (AuthSchemeHandler)element$iv;
            boolean bl = false;
            if (it.getAuthSchemeIdSymbol() != null) {
                objectArray = new Symbol[1];
                Intrinsics.checkNotNull((Object)it.getAuthSchemeIdSymbol());
                pair = TuplesKt.to((Object)"#T", (Object)objectArray);
            } else {
                objectArray = new Object[]{RuntimeTypes.Auth.Identity.INSTANCE.getAuthSchemeId(), it.getAuthSchemeId()};
                pair = TuplesKt.to((Object)"#T(#S)", (Object)objectArray);
            }
            Pair pair2 = pair;
            String format = (String)pair2.component1();
            Object[] args = (Object[])pair2.component2();
            AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "getOrPut(" + format + "){", "}", Arrays.copyOf(args, args.length), arg_0 -> HttpProtocolClientGenerator.renderProperties$lambda$14$lambda$13$lambda$12(it, this$0, arg_0));
        }
        $this$withBlock.write("toMap()", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderInit$lambda$15(KotlinWriter $writer, HttpProtocolClientGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{RuntimeTypes.Core.IO.INSTANCE.getAddIfManaged()};
        $this$withBlock.write("managedResources.#T(config.httpClient)", objectArray);
        AbstractCodeWriterExtKt.declareSection$default($writer, ClientInitializer.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to(ClientInitializer.INSTANCE.getGenerationContext(), (Object)this$0.ctx)), null, 4, null);
        return Unit.INSTANCE;
    }

    private static final void renderOperationBody$lambda$16(HttpProtocolClientGenerator this$0, KotlinWriter $writer, OperationIndex $opIndex, OperationShape $op) {
        this$0.renderOperationSetup($writer, $opIndex, $op);
    }

    private static final void renderOperationBody$lambda$17(HttpProtocolClientGenerator this$0, OperationShape $op, KotlinWriter $writer) {
        this$0.renderOperationMiddleware($op, $writer);
    }

    private static final void renderOperationBody$lambda$18(HttpProtocolClientGenerator this$0, KotlinWriter $writer, OperationIndex $opIndex, OperationShape $op) {
        this$0.renderFinalizeBeforeExecute($writer, $opIndex, $op);
    }

    private static final void renderOperationBody$lambda$19(HttpProtocolClientGenerator this$0, KotlinWriter $writer, OperationIndex $opIndex, OperationShape $op) {
        this$0.renderOperationExecute($writer, $opIndex, $op);
    }

    private static final void renderOperationSetup$lambda$27$lambda$21$lambda$20(KotlinWriter $writer, HttpTrait $httpTrait) {
        $writer.write("val builder = HttpRequestBuilder()", new Object[0]);
        Object[] objectArray = new Object[1];
        String string = $httpTrait.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMethod(...)");
        Intrinsics.checkNotNullExpressionValue((Object)string.toUpperCase(Locale.ROOT), (String)"toUpperCase(...)");
        $writer.write("builder.method = HttpMethod.#L", objectArray);
        objectArray = new Object[]{$httpTrait.getUri().toString()};
        $writer.write("builder.url.path = #S", objectArray);
        $writer.write("return builder", new Object[0]);
    }

    private static final void renderOperationSetup$lambda$27$lambda$21(KotlinWriter $writer, HttpTrait $httpTrait) {
        $writer.openBlock("override fun serialize(context: ExecutionContext, input: #Q): HttpRequestBuilder {", "}", KotlinTypes.INSTANCE.getUnit(), () -> HttpProtocolClientGenerator.renderOperationSetup$lambda$27$lambda$21$lambda$20($writer, $httpTrait));
    }

    private static final CharSequence renderOperationSetup$lambda$27$lambda$24$lambda$23(Optional $inputShape, SmithyPattern.Segment segment) {
        CharSequence charSequence;
        if (segment.isLabel()) {
            Object element$iv2;
            block3: {
                Collection collection = ((StructureShape)$inputShape.get()).members();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"members(...)");
                Iterable $this$first$iv = collection;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    MemberShape member = (MemberShape)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)member.getMemberName(), (Object)segment.getContent())) continue;
                    break block3;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            MemberShape member = (MemberShape)element$iv2;
            StringBuilder stringBuilder = new StringBuilder().append("${input.");
            Intrinsics.checkNotNull((Object)member);
            charSequence = stringBuilder.append(NamingKt.defaultName(member)).append('}').toString();
        } else {
            String string = segment.getContent();
            Intrinsics.checkNotNull((Object)string);
            charSequence = string;
        }
        return charSequence;
    }

    private static final Unit renderOperationSetup$lambda$27$lambda$25(KotlinWriter $writer, OperationShape $op, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("provider = config.telemetryProvider", new Object[0]);
        $this$withBlock.write("scope = telemetryScope", new Object[0]);
        $this$withBlock.write("metrics = opMetrics", new Object[0]);
        AbstractCodeWriterExtKt.declareSection$default($writer, OperationTelemetryBuilder.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to(OperationTelemetryBuilder.INSTANCE.getOperation(), (Object)$op)), null, 4, null);
        return Unit.INSTANCE;
    }

    private static final Unit renderOperationSetup$lambda$27$lambda$26(HttpProtocolClientGenerator this$0, KotlinWriter $this$declareSection) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$declareSection), (String)"$this$declareSection");
        Object[] objectArray = new Object[]{EndpointResolverAdapterGenerator.Companion.getSymbol(this$0.ctx.getSettings())};
        $this$declareSection.write("execution.endpointResolver = #T(config)", objectArray);
        return Unit.INSTANCE;
    }

    private static final void renderOperationSetup$lambda$27(Optional $inputShape, KotlinWriter $writer, OperationShape $op, Optional $outputShape, HttpProtocolClientGenerator this$0, HttpTrait $httpTrait) {
        KotlinWriter kotlinWriter;
        if ($inputShape.isPresent()) {
            kotlinWriter = (KotlinWriter)$writer.write("serializeWith = " + SerdeExtKt.serializerName($op) + "()", new Object[0]);
        } else {
            KotlinWriter.addImport$default($writer, RuntimeTypes.Http.Request.INSTANCE.getHttpRequestBuilder(), null, 2, null);
            KotlinWriter.addImport$default($writer, RuntimeTypes.Core.INSTANCE.getExecutionContext(), null, 2, null);
            kotlinWriter = (KotlinWriter)$writer.openBlock("serializer = object : #T.NonStreaming<#Q> {", "}", RuntimeTypes.HttpClient.Operation.INSTANCE.getHttpSerializer(), KotlinTypes.INSTANCE.getUnit(), () -> HttpProtocolClientGenerator.renderOperationSetup$lambda$27$lambda$21($writer, $httpTrait));
        }
        KotlinWriter kotlinWriter2 = $outputShape.isPresent() ? (KotlinWriter)$writer.write("deserializeWith = " + SerdeExtKt.deserializerName($op) + "()", new Object[0]) : (KotlinWriter)$writer.write("deserializer = UnitDeserializer", new Object[0]);
        Object[] objectArray = new Object[]{$op.getId().getName()};
        $writer.write("operationName = #S", objectArray);
        objectArray = new Object[]{"ServiceId"};
        $writer.write("serviceName = #L", objectArray);
        Shape $this$getTrait$iv = (Shape)$op;
        boolean $i$f$getTrait = false;
        Optional optional = $this$getTrait$iv.getTrait(EndpointTrait.class);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTrait(...)");
        EndpointTrait endpointTrait = (EndpointTrait)((Trait)OptionalExtKt.getOrNull(optional));
        if (endpointTrait != null) {
            EndpointTrait endpointTrait2 = endpointTrait;
            boolean bl = false;
            List list = endpointTrait2.getHostPrefix().getSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSegments(...)");
            String hostPrefix = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, arg_0 -> HttpProtocolClientGenerator.renderOperationSetup$lambda$27$lambda$24$lambda$23($inputShape, arg_0), (int)30, null);
            Object[] objectArray2 = new Object[]{hostPrefix};
            KotlinWriter cfr_ignored_0 = (KotlinWriter)$writer.write("hostPrefix = #S", objectArray2);
        }
        objectArray = new Object[]{RuntimeTypes.HttpClient.Operation.INSTANCE.getTelemetry()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$writer, "#T {", "}", objectArray, arg_0 -> HttpProtocolClientGenerator.renderOperationSetup$lambda$27$lambda$25($writer, $op, arg_0));
        objectArray = new Object[]{RuntimeTypes.HttpClient.Operation.INSTANCE.getOperationAuthConfig()};
        $writer.write("execution.auth = #T(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)", objectArray);
        objectArray = new Pair[]{TuplesKt.to(EndpointResolverAdapterBinding.INSTANCE.getGenerationContext(), (Object)this$0.ctx), TuplesKt.to(EndpointResolverAdapterBinding.INSTANCE.getOperationShape(), (Object)$op)};
        AbstractCodeWriterExtKt.declareSection((AbstractCodeWriter)$writer, EndpointResolverAdapterBinding.INSTANCE, MapsKt.mapOf((Pair[])objectArray), arg_0 -> HttpProtocolClientGenerator.renderOperationSetup$lambda$27$lambda$26(this$0, arg_0));
        $writer.write("execution.retryStrategy = config.retryStrategy", new Object[0]);
        $writer.write("execution.retryPolicy = config.retryPolicy", new Object[0]);
    }

    private static final Boolean renderOperationExecute$lambda$28(HttpProtocolClientGenerator this$0, StructureShape it) {
        Intrinsics.checkNotNull((Object)it);
        return ShapeExtKt.hasStreamingMember(it, this$0.ctx.getModel());
    }

    private static final Boolean renderOperationExecute$lambda$29(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String ioSymbolNames$lambda$30(HttpProtocolClientGenerator this$0, StructureShape it) {
        return this$0.ctx.getSymbolProvider().toSymbol((Shape)it).getName();
    }

    private static final String ioSymbolNames$lambda$31(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String ioSymbolNames$lambda$32(HttpProtocolClientGenerator this$0, StructureShape it) {
        return this$0.ctx.getSymbolProvider().toSymbol((Shape)it).getName();
    }

    private static final String ioSymbolNames$lambda$33(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit renderClose$lambda$36(KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("managedResources.unshareAll()", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderMergeServiceDefaults$lambda$37(HttpProtocolClientGenerator this$0, KotlinWriter $writer, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        HttpProtocolClientGeneratorKt.putIfAbsent$default($this$withBlock, RuntimeTypes.SmithyClient.INSTANCE.getSdkClientOption(), "ClientName", null, false, 12, null);
        HttpProtocolClientGeneratorKt.putIfAbsent$default($this$withBlock, RuntimeTypes.SmithyClient.INSTANCE.getSdkClientOption(), "LogMode", null, false, 12, null);
        if (ShapeExtKt.hasIdempotentTokenMember(this$0.ctx.getService(), this$0.ctx.getModel())) {
            HttpProtocolClientGeneratorKt.putIfAbsent$default($this$withBlock, RuntimeTypes.SmithyClient.INSTANCE.getSdkClientOption(), "IdempotencyTokenProvider", null, true, 4, null);
        }
        AbstractCodeWriterExtKt.declareSection$default($writer, MergeServiceDefaults.INSTANCE, MapsKt.mapOf((Pair)TuplesKt.to(MergeServiceDefaults.INSTANCE.getGenerationContext(), (Object)this$0.ctx)), null, 4, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator$ClientInitializer;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "<init>", "()V", "GenerationContext", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "getGenerationContext", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "smithy-kotlin-codegen"})
    public static final class ClientInitializer
    implements SectionId {
        @NotNull
        public static final ClientInitializer INSTANCE = new ClientInitializer();
        @NotNull
        private static final SectionKey<ProtocolGenerator.GenerationContext> GenerationContext = new SectionKey("GenerationContext");

        private ClientInitializer() {
        }

        @NotNull
        public final SectionKey<ProtocolGenerator.GenerationContext> getGenerationContext() {
            return GenerationContext;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator$EndpointResolverAdapterBinding;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "<init>", "()V", "GenerationContext", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "getGenerationContext", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "OperationShape", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "getOperationShape", "smithy-kotlin-codegen"})
    public static final class EndpointResolverAdapterBinding
    implements SectionId {
        @NotNull
        public static final EndpointResolverAdapterBinding INSTANCE = new EndpointResolverAdapterBinding();
        @NotNull
        private static final SectionKey<ProtocolGenerator.GenerationContext> GenerationContext = new SectionKey("GenerationContext");
        @NotNull
        private static final SectionKey<OperationShape> OperationShape = new SectionKey("OperationShape");

        private EndpointResolverAdapterBinding() {
        }

        @NotNull
        public final SectionKey<ProtocolGenerator.GenerationContext> getGenerationContext() {
            return GenerationContext;
        }

        @NotNull
        public final SectionKey<OperationShape> getOperationShape() {
            return OperationShape;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator$MergeServiceDefaults;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "<init>", "()V", "GenerationContext", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "getGenerationContext", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "smithy-kotlin-codegen"})
    public static final class MergeServiceDefaults
    implements SectionId {
        @NotNull
        public static final MergeServiceDefaults INSTANCE = new MergeServiceDefaults();
        @NotNull
        private static final SectionKey<ProtocolGenerator.GenerationContext> GenerationContext = new SectionKey("GenerationContext");

        private MergeServiceDefaults() {
        }

        @NotNull
        public final SectionKey<ProtocolGenerator.GenerationContext> getGenerationContext() {
            return GenerationContext;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpProtocolClientGenerator$OperationTelemetryBuilder;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "<init>", "()V", "Operation", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "getOperation", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "smithy-kotlin-codegen"})
    public static final class OperationTelemetryBuilder
    implements SectionId {
        @NotNull
        public static final OperationTelemetryBuilder INSTANCE = new OperationTelemetryBuilder();
        @NotNull
        private static final SectionKey<OperationShape> Operation = new SectionKey("Operation");

        private OperationTelemetryBuilder() {
        }

        @NotNull
        public final SectionKey<OperationShape> getOperation() {
            return Operation;
        }
    }
}

