/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.SensitiveTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013J.\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J.\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/UnionGenerator;", "", "model", "Lsoftware/amazon/smithy/model/Model;", "symbolProvider", "Lsoftware/amazon/smithy/codegen/core/SymbolProvider;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "shape", "Lsoftware/amazon/smithy/model/shapes/UnionShape;", "<init>", "(Lsoftware/amazon/smithy/model/Model;Lsoftware/amazon/smithy/codegen/core/SymbolProvider;Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;Lsoftware/amazon/smithy/model/shapes/UnionShape;)V", "getModel", "()Lsoftware/amazon/smithy/model/Model;", "symbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "getSymbol", "()Lsoftware/amazon/smithy/codegen/core/Symbol;", "render", "", "renderHashCode", "sortedMembers", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "selectHashFunctionForShape", "", "member", "renderEquals", "typeName", "renderToString", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nUnionGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnionGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/UnionGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,189:1\n1755#2,3:190\n1053#2:194\n1863#2,2:195\n1053#2:197\n1863#2,2:198\n1#3:193\n73#4:200\n73#4:201\n73#4:202\n*S KotlinDebug\n*F\n+ 1 UnionGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/UnionGenerator\n*L\n34#1:190,3\n44#1:194\n44#1:195,2\n65#1:197\n65#1:198,2\n139#1:200\n180#1:201\n167#1:202\n*E\n"})
public final class UnionGenerator {
    @NotNull
    private final Model model;
    @NotNull
    private final SymbolProvider symbolProvider;
    @NotNull
    private final KotlinWriter writer;
    @NotNull
    private final UnionShape shape;
    @NotNull
    private final Symbol symbol;

    public UnionGenerator(@NotNull Model model, @NotNull SymbolProvider symbolProvider, @NotNull KotlinWriter writer, @NotNull UnionShape shape) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)symbolProvider, (String)"symbolProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.model = model;
        this.symbolProvider = symbolProvider;
        this.writer = writer;
        this.shape = shape;
        Symbol symbol = this.symbolProvider.toSymbol((Shape)this.shape);
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"toSymbol(...)");
        this.symbol = symbol;
    }

    @NotNull
    public final Model getModel() {
        return this.model;
    }

    @NotNull
    public final Symbol getSymbol() {
        return this.symbol;
    }

    public final void render() {
        Object[] objectArray;
        Symbol variantSymbol;
        String variantName;
        Object element$iv;
        boolean bl;
        Object[] $this$any$iv;
        block6: {
            $this$any$iv = (Object[])this.shape.getAllMembers().values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object iterator : $this$any$iv) {
                    MemberShape memberShape = (MemberShape)iterator;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)memberShape.getMemberName(), (String)"SdkUnknown", (boolean)true)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (!(!bl)) {
            boolean $i$a$-check-UnionGenerator$render$332 = false;
            String $i$a$-check-UnionGenerator$render$332 = "generating SdkUnknown would cause duplicate variant for union shape: " + this.shape;
            throw new IllegalStateException($i$a$-check-UnionGenerator$render$332.toString());
        }
        this.writer.renderDocumentation((Shape)this.shape);
        this.writer.renderAnnotations((Shape)this.shape);
        $this$any$iv = new Object[]{this.symbol};
        this.writer.openBlock("public sealed class #T {", $this$any$iv);
        Collection<MemberShape> members = ShapeExtKt.filterEventStreamErrors(this.shape, this.model);
        Iterable $this$sortedBy$iv = members;
        boolean $i$f$sortedBy = false;
        Object $this$forEach$iv = (Object[])CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MemberShape it = (MemberShape)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getMemberName());
                it = (MemberShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMemberName())));
            }
        });
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            MemberShape it = (MemberShape)element$iv;
            boolean bl3 = false;
            this.writer.renderMemberDocumentation(this.model, it);
            this.writer.renderAnnotations((Shape)it);
            variantName = NamingKt.unionVariantName(it);
            variantSymbol = this.symbolProvider.toSymbol((Shape)it);
            objectArray = new Object[]{variantName, variantSymbol, this.symbol};
            AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "public data class #L(val value: #Q) : #Q() {", "}", objectArray, arg_0 -> UnionGenerator.render$lambda$4$lambda$3(this, it, variantName, arg_0));
            this.writer.write("", new Object[0]);
        }
        $this$forEach$iv = new Object[]{this.symbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "public object SdkUnknown : #Q() {", "}", (Object[])$this$forEach$iv, arg_0 -> UnionGenerator.render$lambda$5(this, arg_0));
        $this$sortedBy$iv = members;
        $i$f$sortedBy = false;
        $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MemberShape it = (MemberShape)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getMemberName());
                it = (MemberShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMemberName())));
            }
        });
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            MemberShape it = (MemberShape)element$iv;
            boolean bl4 = false;
            variantName = NamingKt.unionVariantName(it);
            variantSymbol = this.symbolProvider.toSymbol((Shape)it);
            this.writer.write("", new Object[0]);
            this.writer.dokka((Function1<? super KotlinWriter, Unit>)((Function1)arg_0 -> UnionGenerator.render$lambda$9$lambda$7(this, variantName, variantSymbol, arg_0)));
            objectArray = new Object[]{variantName, variantSymbol, this.symbol, variantName};
            this.writer.write("public fun as#L(): #Q = (this as #T.#L).value", objectArray);
            this.writer.write("", new Object[0]);
            this.writer.dokka((Function1<? super KotlinWriter, Unit>)((Function1)arg_0 -> UnionGenerator.render$lambda$9$lambda$8(this, variantName, variantSymbol, arg_0)));
            objectArray = new Object[]{variantName, variantSymbol, this.symbol, variantName};
            this.writer.write("public fun as#LOrNull(): #Q? = (this as? #T.#L)?.value", objectArray);
        }
        ((KotlinWriter)this.writer.closeBlock("}", new Object[0])).write("", new Object[0]);
    }

    private final void renderHashCode(Model model, List<MemberShape> sortedMembers, SymbolProvider symbolProvider, KotlinWriter writer) {
        writer.write("", new Object[0]);
        Object[] objectArray = new Object[]{KotlinTypes.INSTANCE.getInt()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "override fun hashCode(): #Q {", "}", objectArray, arg_0 -> UnionGenerator.renderHashCode$lambda$10(this, model, sortedMembers, symbolProvider, arg_0));
    }

    private final String selectHashFunctionForShape(Model model, MemberShape member, SymbolProvider symbolProvider) {
        String string;
        Shape targetShape = model.expectShape(member.getTarget());
        Symbol targetSymbol = symbolProvider.toSymbol(targetShape);
        ShapeType shapeType = targetShape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)targetSymbol);
                if (SymbolExtKt.isNullable(targetSymbol)) {
                    string = " ?: 0";
                    break;
                }
                string = "";
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)targetSymbol);
                if (SymbolExtKt.isNullable(targetSymbol)) {
                    string = ".toInt() ?: 0";
                    break;
                }
                string = ".toInt()";
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)targetShape);
                Shape $this$hasTrait$iv = targetShape;
                boolean $i$f$hasTrait = false;
                if ($this$hasTrait$iv.hasTrait(StreamingTrait.class)) {
                    string = ".hashCode() ?: 0";
                    break;
                }
                string = ".contentHashCode()";
                break;
            }
            default: {
                Intrinsics.checkNotNull((Object)targetSymbol);
                string = SymbolExtKt.isNullable(targetSymbol) ? ".hashCode() ?: 0" : ".hashCode()";
            }
        }
        return string;
    }

    private final void renderEquals(Model model, List<MemberShape> sortedMembers, String typeName, KotlinWriter writer) {
        writer.write("", new Object[0]);
        Object[] objectArray = new Object[]{KotlinTypes.INSTANCE.getAny(), KotlinTypes.INSTANCE.getBoolean()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "override fun equals(other: #Q?): #Q {", "}", objectArray, arg_0 -> UnionGenerator.renderEquals$lambda$11(typeName, sortedMembers, model, writer, arg_0));
    }

    private final void renderToString() {
        Shape $this$hasTrait$iv = (Shape)this.shape;
        boolean $i$f$hasTrait = false;
        if ($this$hasTrait$iv.hasTrait(SensitiveTrait.class)) {
            Object[] objectArray = new Object[]{KotlinTypes.INSTANCE.getString(), this.symbol};
            this.writer.write("override fun toString(): #Q = \"#T(*** Sensitive Data Redacted ***)\"", objectArray);
        }
    }

    private static final Unit render$lambda$4$lambda$3(UnionGenerator this$0, MemberShape $it, String $variantName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        if (this$0.model.expectShape($it.getTarget()).getType() == ShapeType.BLOB) {
            this$0.renderHashCode(this$0.model, CollectionsKt.listOf((Object)$it), this$0.symbolProvider, $this$withBlock);
            this$0.renderEquals(this$0.model, CollectionsKt.listOf((Object)$it), $variantName, $this$withBlock);
        }
        this$0.renderToString();
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$5(UnionGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        this$0.renderToString();
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$9$lambda$7(UnionGenerator this$0, String $variantName, Symbol $variantSymbol, KotlinWriter $this$dokka) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$dokka), (String)"$this$dokka");
        Object[] objectArray = new Object[]{this$0.symbol, $variantName, $variantSymbol, this$0.symbol, $variantName};
        $this$dokka.write("Casts this [#T] as a [#L] and retrieves its [#Q] value. Throws an exception if the [#T] is not a\n[#L].", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$9$lambda$8(UnionGenerator this$0, String $variantName, Symbol $variantSymbol, KotlinWriter $this$dokka) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$dokka), (String)"$this$dokka");
        Object[] objectArray = new Object[]{this$0.symbol, $variantName, $variantSymbol, this$0.symbol, $variantName};
        $this$dokka.write("Casts this [#T] as a [#L] and retrieves its [#Q] value. Returns null if the [#T] is not a [#L].", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderHashCode$lambda$10(UnionGenerator this$0, Model $model, List $sortedMembers, SymbolProvider $symbolProvider, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{this$0.selectHashFunctionForShape($model, (MemberShape)$sortedMembers.get(0), $symbolProvider)};
        $this$withBlock.write("return value#L", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderEquals$lambda$11(String $typeName, List $sortedMembers, Model $model, KotlinWriter $writer, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("if (this === other) return true", new Object[0]);
        $this$withBlock.write("if (other == null || this::class != other::class) return false", new Object[0]);
        $this$withBlock.write("", new Object[0]);
        $this$withBlock.write("other as " + $typeName, new Object[0]);
        $this$withBlock.write("", new Object[0]);
        for (MemberShape memberShape : $sortedMembers) {
            KotlinWriter kotlinWriter;
            Object[] objectArray;
            Shape target = $model.expectShape(memberShape.getTarget());
            String memberName = "value";
            if (target instanceof BlobShape) {
                Shape $this$hasTrait$iv = target;
                boolean $i$f$hasTrait = false;
                if (!$this$hasTrait$iv.hasTrait(StreamingTrait.class)) {
                    objectArray = new Object[]{memberName};
                    kotlinWriter = (KotlinWriter)$writer.write("if (!#1L.contentEquals(other.#1L)) return false", objectArray);
                    continue;
                }
            }
            objectArray = new Object[]{memberName};
            kotlinWriter = (KotlinWriter)$this$withBlock.write("if (#1L != other.#1L) return false", objectArray);
        }
        $this$withBlock.write("", new Object[0]);
        $this$withBlock.write("return true", new Object[0]);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShapeType.values().length];
            try {
                nArray[ShapeType.INTEGER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BLOB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

