/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.CodegenContext;
import software.amazon.smithy.kotlin.codegen.core.ExternalTypes;
import software.amazon.smithy.kotlin.codegen.core.KotlinDelegator;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.integration.AuthSchemeHandler;
import software.amazon.smithy.kotlin.codegen.integration.KotlinIntegration;
import software.amazon.smithy.kotlin.codegen.integration.SectionWriterBinding;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.traits.PaginationEndBehavior;
import software.amazon.smithy.kotlin.codegen.model.traits.PaginationEndBehaviorTrait;
import software.amazon.smithy.kotlin.codegen.rendering.ItemDescriptor;
import software.amazon.smithy.kotlin.codegen.rendering.PaginatorGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.endpoints.EndpointCustomization;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolMiddleware;
import software.amazon.smithy.kotlin.codegen.rendering.util.ConfigProperty;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.PaginatedIndex;
import software.amazon.smithy.model.knowledge.PaginationInfo;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.PaginatedTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J2\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J(\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u001c"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/PaginatorGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/KotlinIntegration;", "<init>", "()V", "enabledForService", "", "model", "Lsoftware/amazon/smithy/model/Model;", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "writeAdditionalFiles", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/CodegenContext;", "delegator", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinDelegator;", "renderPaginatorForOperation", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "paginatedOperation", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "paginationInfo", "Lsoftware/amazon/smithy/model/knowledge/PaginationInfo;", "itemDesc", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/ItemDescriptor;", "renderResponsePaginator", "operationShape", "renderItemPaginator", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nPaginatorGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaginatorGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/PaginatorGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,299:1\n1755#2,2:300\n1757#2:303\n774#2:305\n865#2:306\n866#2:308\n1863#2,2:312\n73#3:302\n43#3:304\n73#3:307\n43#3:309\n43#3:310\n83#3:314\n1#4:311\n*S KotlinDebug\n*F\n+ 1 PaginatorGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/PaginatorGenerator\n*L\n37#1:300,2\n37#1:303\n46#1:305\n46#1:306\n46#1:308\n49#1:312,2\n37#1:302\n40#1:304\n46#1:307\n92#1:309\n204#1:310\n155#1:314\n*E\n"})
public final class PaginatorGenerator
implements KotlinIntegration {
    @Override
    public boolean enabledForService(@NotNull Model model, @NotNull KotlinSettings settings) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Set set = TopDownIndex.of((Model)model).getContainedOperations((ToShapeId)settings.getService());
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getContainedOperations(...)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    OperationShape it = (OperationShape)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    Shape $this$hasTrait$iv = (Shape)it;
                    boolean $i$f$hasTrait = false;
                    if (!$this$hasTrait$iv.hasTrait(PaginatedTrait.class)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeAdditionalFiles(@NotNull CodegenContext ctx, @NotNull KotlinDelegator delegator) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$expectShape$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)delegator, (String)"delegator");
        Model model = ctx.getModel();
        ShapeId shapeId$iv = ctx.getSettings().getService();
        boolean $i$f$expectShape22 = false;
        Shape shape = $this$expectShape$iv.expectShape(shapeId$iv, ServiceShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(...)");
        ServiceShape service = (ServiceShape)shape;
        PaginatedIndex paginatedIndex = PaginatedIndex.of((Model)ctx.getModel());
        Set set = TopDownIndex.of((Model)ctx.getModel()).getContainedOperations((ToShapeId)ctx.getSettings().getService());
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getContainedOperations(...)");
        Iterable $i$f$expectShape22 = set;
        boolean $i$f$filter = false;
        void var8_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            OperationShape it = (OperationShape)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Shape $this$hasTrait$iv = (Shape)it;
            boolean $i$f$hasTrait = false;
            if (!$this$hasTrait$iv.hasTrait(PaginatedTrait.class)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List paginatedOperations = (List)destination$iv$iv;
        KotlinDelegator.useFileWriter$default(delegator, "Paginators.kt", ctx.getSettings().getPkg().getName() + ".paginators", null, arg_0 -> PaginatorGenerator.writeAdditionalFiles$lambda$3(paginatedOperations, paginatedIndex, service, ctx, this, arg_0), 4, null);
    }

    private final void renderPaginatorForOperation(CodegenContext ctx, KotlinWriter writer, OperationShape paginatedOperation, PaginationInfo paginationInfo, ItemDescriptor itemDesc) {
        this.renderResponsePaginator(ctx, writer, paginatedOperation, paginationInfo);
        if (itemDesc != null) {
            this.renderItemPaginator(ctx, writer, paginatedOperation, itemDesc);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderResponsePaginator(CodegenContext ctx, KotlinWriter writer, OperationShape operationShape, PaginationInfo paginationInfo) {
        String string;
        Object[] objectArray;
        void $this$expectShape$iv;
        Model model = ctx.getModel();
        ShapeId shapeId$iv = ctx.getSettings().getService();
        boolean $i$f$expectShape = false;
        Shape shape = $this$expectShape$iv.expectShape(shapeId$iv, ServiceShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(...)");
        ServiceShape service = (ServiceShape)shape;
        Symbol serviceSymbol = ctx.getSymbolProvider().toSymbol((Shape)service);
        StructureShape outputShape = paginationInfo.getOutput();
        Symbol outputSymbol = ctx.getSymbolProvider().toSymbol((Shape)outputShape);
        Symbol inputSymbol = ctx.getSymbolProvider().toSymbol((Shape)paginationInfo.getInput());
        Symbol cursorSymbol = ctx.getSymbolProvider().toSymbol((Shape)paginationInfo.getInputTokenMember());
        List list = paginationInfo.getOutputTokenMemberPath();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOutputTokenMemberPath(...)");
        String nextMarkerLiteral = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"?.", null, null, (int)0, null, PaginatorGenerator::renderResponsePaginator$lambda$4, (int)30, null);
        MemberShape memberShape = paginationInfo.getInputTokenMember();
        Intrinsics.checkNotNullExpressionValue((Object)memberShape, (String)"getInputTokenMember(...)");
        String markerLiteral = NamingKt.defaultName(memberShape);
        String docBody = StringsKt.trimIndent((String)("\n            Paginate over [" + outputSymbol.getName() + "] results.\n            \n            When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service\n            calls are made until the flow is collected. This also means there is no guarantee that the request is valid\n            until then. Once you start collecting the flow, the SDK will lazily load response pages by making service\n            calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will\n            see the failures only after you start collection.\n        "));
        String docReturn = "@return A [kotlinx.coroutines.flow.Flow] that can collect [" + outputSymbol.getName() + ']';
        StructureShape structureShape = paginationInfo.getInput();
        Intrinsics.checkNotNullExpressionValue((Object)structureShape, (String)"getInput(...)");
        if (ShapeExtKt.getHasAllOptionalMembers((Shape)structureShape)) {
            objectArray = new Object[]{inputSymbol};
            string = writer.format("initialRequest: #1T = #1T { }", objectArray);
        } else {
            objectArray = new Object[]{inputSymbol};
            string = writer.format("initialRequest: #T", objectArray);
        }
        String inputParameter = string;
        writer.write("", new Object[0]);
        KotlinWriter kotlinWriter = writer.dokka(StringsKt.trimMargin$default((String)("\n                    |" + docBody + "\n                    |@param initialRequest A [" + inputSymbol.getName() + "] to start pagination\n                    |" + docReturn + "\n                "), null, (int)1, null));
        Intrinsics.checkNotNull((Object)cursorSymbol);
        objectArray = new SymbolReference.ContextOption[]{SymbolReference.ContextOption.DECLARE};
        AbstractCodeWriter abstractCodeWriter = kotlinWriter.addImportReferences(cursorSymbol, (SymbolReference.ContextOption[])objectArray);
        objectArray = new Object[]{ctx.getSettings().getApi().getVisibility(), serviceSymbol, NamingKt.defaultName(operationShape), inputParameter, ExternalTypes.KotlinxCoroutines.INSTANCE.getFlow(), outputSymbol};
        AbstractCodeWriterExtKt.withBlock(abstractCodeWriter, "#L fun #T.#LPaginated(#L): #T<#T> =", "", objectArray, arg_0 -> PaginatorGenerator.renderResponsePaginator$lambda$8(markerLiteral, cursorSymbol, operationShape, nextMarkerLiteral, outputShape, arg_0));
        writer.write("", new Object[0]);
        objectArray = new Object[]{ctx.getSettings().getApi().getVisibility(), serviceSymbol, NamingKt.defaultName(operationShape), inputSymbol, KotlinTypes.INSTANCE.getUnit(), ExternalTypes.KotlinxCoroutines.INSTANCE.getFlow(), outputSymbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer.dokka(StringsKt.trimMargin$default((String)("\n                    |" + docBody + "\n                    |@param block A builder block used for DSL-style invocation of the operation\n                    |" + docReturn + "\n                "), null, (int)1, null)), "#L fun #T.#LPaginated(block: #T.Builder.() -> #T): #T<#T> =", "", objectArray, arg_0 -> PaginatorGenerator.renderResponsePaginator$lambda$9(operationShape, inputSymbol, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void renderItemPaginator(CodegenContext ctx, KotlinWriter writer, OperationShape operationShape, ItemDescriptor itemDesc) {
        String string;
        void $this$expectShape$iv;
        Model model = ctx.getModel();
        ShapeId shapeId$iv = ctx.getSettings().getService();
        boolean $i$f$expectShape = false;
        Shape shape = $this$expectShape$iv.expectShape(shapeId$iv, ServiceShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(...)");
        ServiceShape serviceShape = (ServiceShape)shape;
        Shape outputShape = ctx.getModel().expectShape(operationShape.getOutputShape());
        Symbol outputSymbol = ctx.getSymbolProvider().toSymbol(outputShape);
        writer.write("", new Object[0]);
        writer.dokka(StringsKt.trimIndent((String)("\n                This paginator transforms the flow returned by [" + NamingKt.defaultName(operationShape) + "Paginated] \n                to access the nested member [" + NamingKt.defaultName(itemDesc.getTargetMember(), serviceShape) + "]\n                @return A [kotlinx.coroutines.flow.Flow] that can collect [" + NamingKt.defaultName(itemDesc.getTargetMember(), serviceShape) + "]\n            ")));
        Object[] objectArray = new SymbolReference.ContextOption[]{SymbolReference.ContextOption.USE};
        KotlinWriter kotlinWriter = KotlinWriter.addImport$default(KotlinWriter.addImport$default(writer, ExternalTypes.KotlinxCoroutines.INSTANCE.getFlowTransform(), null, 2, null), itemDesc.getItemSymbol(), null, 2, null).addImportReferences(itemDesc.getItemSymbol(), (SymbolReference.ContextOption[])objectArray);
        String string2 = "@#T(\"#L#L\")";
        objectArray = new Object[3];
        objectArray[0] = KotlinTypes.Jvm.INSTANCE.getJvmName();
        Object[] objectArray2 = objectArray;
        int n = 1;
        String string3 = outputSymbol.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        String string4 = string3;
        if (((CharSequence)string4).length() > 0) {
            void p0;
            char c = string4.charAt(0);
            int n2 = n;
            Object[] objectArray3 = objectArray2;
            String string5 = string2;
            KotlinWriter kotlinWriter2 = kotlinWriter;
            boolean bl = false;
            char c2 = Character.toLowerCase((char)p0);
            kotlinWriter = kotlinWriter2;
            string2 = string5;
            objectArray2 = objectArray3;
            n = n2;
            c = c2;
            String string6 = string4;
            int n3 = 1;
            String string7 = string6.substring(n3);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            string6 = string7;
            string = c + string6;
        } else {
            string = string4;
        }
        objectArray2[n] = string;
        objectArray[2] = NamingKt.defaultName(itemDesc.getTargetMember(), serviceShape);
        Object[] objectArray4 = kotlinWriter.write(string2, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray4, (String)"write(...)");
        Object[] objectArray5 = objectArray4;
        objectArray4 = new Object[]{ctx.getSettings().getApi().getVisibility(), ExternalTypes.KotlinxCoroutines.INSTANCE.getFlow(), outputSymbol, itemDesc.getItemLiteral(), ExternalTypes.KotlinxCoroutines.INSTANCE.getFlow(), itemDesc.getCollectionLiteral()};
        AbstractCodeWriterExtKt.withBlock(objectArray5, "#L fun #T<#T>.#L(): #T<#L> =", "", objectArray4, arg_0 -> PaginatorGenerator.renderItemPaginator$lambda$12(itemDesc, arg_0));
    }

    @Override
    public byte getOrder() {
        return KotlinIntegration.DefaultImpls.getOrder(this);
    }

    @Override
    @NotNull
    public List<ProtocolGenerator> getProtocolGenerators() {
        return KotlinIntegration.DefaultImpls.getProtocolGenerators(this);
    }

    @Override
    @NotNull
    public List<SectionWriterBinding> getSectionWriters() {
        return KotlinIntegration.DefaultImpls.getSectionWriters(this);
    }

    @Override
    @NotNull
    public List<ConfigProperty> additionalServiceConfigProps(@NotNull CodegenContext ctx) {
        return KotlinIntegration.DefaultImpls.additionalServiceConfigProps(this, ctx);
    }

    @Override
    @NotNull
    public Model preprocessModel(@NotNull Model model, @NotNull KotlinSettings settings) {
        return KotlinIntegration.DefaultImpls.preprocessModel(this, model, settings);
    }

    @Override
    @NotNull
    public SymbolProvider decorateSymbolProvider(@NotNull KotlinSettings settings, @NotNull Model model, @NotNull SymbolProvider symbolProvider) {
        return KotlinIntegration.DefaultImpls.decorateSymbolProvider(this, settings, model, symbolProvider);
    }

    @Override
    @NotNull
    public List<ProtocolMiddleware> customizeMiddleware(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull List<? extends ProtocolMiddleware> resolved) {
        return KotlinIntegration.DefaultImpls.customizeMiddleware(this, ctx, resolved);
    }

    @Override
    @NotNull
    public List<AuthSchemeHandler> authSchemes(@NotNull ProtocolGenerator.GenerationContext ctx) {
        return KotlinIntegration.DefaultImpls.authSchemes(this, ctx);
    }

    @Override
    @Nullable
    public EndpointCustomization customizeEndpointResolution(@NotNull ProtocolGenerator.GenerationContext ctx) {
        return KotlinIntegration.DefaultImpls.customizeEndpointResolution(this, ctx);
    }

    private static final Unit writeAdditionalFiles$lambda$3(List $paginatedOperations, PaginatedIndex $paginatedIndex, ServiceShape $service, CodegenContext $ctx, PaginatorGenerator this$0, KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Iterable $this$forEach$iv = $paginatedOperations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PaginationInfo paginationInfo;
            OperationShape paginatedOperation = (OperationShape)element$iv;
            boolean bl = false;
            Optional optional = $paginatedIndex.getPaginationInfo((ToShapeId)$service, (ToShapeId)paginatedOperation);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getPaginationInfo(...)");
            if ((PaginationInfo)OptionalExtKt.getOrNull(optional) == null) {
                throw new CodegenException("Unexpectedly unable to get PaginationInfo from " + $service + ' ' + paginatedOperation);
            }
            ItemDescriptor paginationItemInfo = PaginatorGeneratorKt.access$getItemDescriptorOrNull(paginationInfo, $ctx, writer);
            Intrinsics.checkNotNull((Object)paginatedOperation);
            this$0.renderPaginatorForOperation($ctx, writer, paginatedOperation, paginationInfo, paginationItemInfo);
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence renderResponsePaginator$lambda$4(MemberShape it) {
        Intrinsics.checkNotNull((Object)it);
        return NamingKt.defaultName(it);
    }

    private static final Unit renderResponsePaginator$lambda$8$lambda$7$lambda$6$lambda$5(String $markerLiteral, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("this." + $markerLiteral + " = cursor", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderResponsePaginator$lambda$8$lambda$7$lambda$6(OperationShape $operationShape, String $nextMarkerLiteral, String $markerLiteral, StructureShape $outputShape, KotlinWriter $this$withBlock) {
        String string;
        Object endBehavior;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "val req = initialRequest.copy {", "}", new Object[0], arg_0 -> PaginatorGenerator.renderResponsePaginator$lambda$8$lambda$7$lambda$6$lambda$5($markerLiteral, arg_0));
        Object[] objectArray2 = new Object[]{NamingKt.defaultName($operationShape)};
        $this$withBlock.write("val result = this@#1LPaginated.#1L(req)", objectArray2);
        $this$withBlock.write("cursor = result." + $nextMarkerLiteral, new Object[0]);
        Shape $this$getTrait$iv = (Shape)$operationShape;
        boolean $i$f$getTrait = false;
        Optional optional = $this$getTrait$iv.getTrait(PaginationEndBehaviorTrait.class);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTrait(...)");
        Object object = (PaginationEndBehaviorTrait)((Trait)OptionalExtKt.getOrNull(optional));
        if (object == null || (object = object.getValue()) == null) {
            object = PaginationEndBehavior.Companion.getDefault();
        }
        if (Intrinsics.areEqual((Object)(objectArray = (endBehavior = object)), (Object)PaginationEndBehavior.OutputTokenEmpty.INSTANCE)) {
            string = "cursor?.isNotEmpty() == true";
        } else if (Intrinsics.areEqual((Object)objectArray, (Object)PaginationEndBehavior.IdenticalToken.INSTANCE)) {
            string = "cursor != null && cursor != req." + $markerLiteral;
        } else if (objectArray instanceof PaginationEndBehavior.TruncationMember) {
            Map map = $outputShape.getAllMembers();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAllMembers(...)");
            Object object2 = MapsKt.getValue((Map)map, (Object)((PaginationEndBehavior.TruncationMember)endBehavior).getMemberName());
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getValue(...)");
            String member = NamingKt.defaultName((MemberShape)object2);
            string = "result." + member + " == true";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String hasNextPageFlag = string;
        objectArray = new Object[]{hasNextPageFlag};
        $this$withBlock.write("hasNextPage = #L", objectArray);
        $this$withBlock.write("emit(result)", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderResponsePaginator$lambda$8$lambda$7(String $markerLiteral, Symbol $cursorSymbol, OperationShape $operationShape, String $nextMarkerLiteral, StructureShape $outputShape, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{$cursorSymbol};
        $this$withBlock.write("var cursor: #F = initialRequest." + $markerLiteral, objectArray);
        $this$withBlock.write("var hasNextPage: Boolean = true", new Object[0]);
        $this$withBlock.write("", new Object[0]);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "while (hasNextPage) {", "}", new Object[0], arg_0 -> PaginatorGenerator.renderResponsePaginator$lambda$8$lambda$7$lambda$6($operationShape, $nextMarkerLiteral, $markerLiteral, $outputShape, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderResponsePaginator$lambda$8(String $markerLiteral, Symbol $cursorSymbol, OperationShape $operationShape, String $nextMarkerLiteral, StructureShape $outputShape, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{ExternalTypes.KotlinxCoroutines.INSTANCE.getFlowGenerator()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "#T {", "}", objectArray, arg_0 -> PaginatorGenerator.renderResponsePaginator$lambda$8$lambda$7($markerLiteral, $cursorSymbol, $operationShape, $nextMarkerLiteral, $outputShape, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderResponsePaginator$lambda$9(OperationShape $operationShape, Symbol $inputSymbol, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{NamingKt.defaultName($operationShape), $inputSymbol};
        $this$withBlock.write("#LPaginated(#T.Builder().apply(block).build())", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderItemPaginator$lambda$12$lambda$11$lambda$10(KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("emit(it)", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderItemPaginator$lambda$12$lambda$11(ItemDescriptor $itemDesc, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{$itemDesc.getItemPathLiteral()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "response.#L?.forEach {", "}", objectArray, PaginatorGenerator::renderItemPaginator$lambda$12$lambda$11$lambda$10);
        return Unit.INSTANCE;
    }

    private static final Unit renderItemPaginator$lambda$12(ItemDescriptor $itemDesc, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "transform() { response -> ", "}", new Object[0], arg_0 -> PaginatorGenerator.renderItemPaginator$lambda$12$lambda$11($itemDesc, arg_0));
        return Unit.INSTANCE;
    }
}

