/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.build.FileManifest;
import software.amazon.smithy.build.PluginContext;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependency;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.kotlin.codegen.CodegenVisitorKt;
import software.amazon.smithy.kotlin.codegen.KotlinCodegenPlugin;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.UnresolvableProtocolException;
import software.amazon.smithy.kotlin.codegen.core.CodegenContextKt;
import software.amazon.smithy.kotlin.codegen.core.GenerationContext;
import software.amazon.smithy.kotlin.codegen.core.KotlinDelegator;
import software.amazon.smithy.kotlin.codegen.core.KotlinDependency;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RenderingContext;
import software.amazon.smithy.kotlin.codegen.integration.KotlinIntegration;
import software.amazon.smithy.kotlin.codegen.model.OperationNormalizer;
import software.amazon.smithy.kotlin.codegen.rendering.EnumGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.ExceptionBaseClassGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.GradleGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.ServiceClientGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.StructureGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.UnionGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ApplicationProtocol;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.transform.ModelTransformer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J0\u0010 \u001a\u0004\u0018\u00010\u001b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\"\u001a\u00020\u0002J\u0012\u0010#\u001a\u00020\u00022\b\u0010$\u001a\u0004\u0018\u00010%H\u0014J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010$\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010$\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00022\u0006\u0010$\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00022\u0006\u0010$\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u0010H\u0016R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/CodegenVisitor;", "Lsoftware/amazon/smithy/model/shapes/ShapeVisitor$Default;", "", "context", "Lsoftware/amazon/smithy/build/PluginContext;", "<init>", "(Lsoftware/amazon/smithy/build/PluginContext;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "Ljava/util/logging/Logger;", "model", "Lsoftware/amazon/smithy/model/Model;", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "service", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "fileManifest", "Lsoftware/amazon/smithy/build/FileManifest;", "symbolProvider", "Lsoftware/amazon/smithy/codegen/core/SymbolProvider;", "writers", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinDelegator;", "integrations", "", "Lsoftware/amazon/smithy/kotlin/codegen/integration/KotlinIntegration;", "protocolGenerator", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator;", "applicationProtocol", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ApplicationProtocol;", "baseGenerationContext", "Lsoftware/amazon/smithy/kotlin/codegen/core/GenerationContext;", "resolveProtocolGenerator", "", "execute", "getDefault", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "structureShape", "Lsoftware/amazon/smithy/model/shapes/StructureShape;", "stringShape", "Lsoftware/amazon/smithy/model/shapes/StringShape;", "intEnumShape", "Lsoftware/amazon/smithy/model/shapes/IntEnumShape;", "unionShape", "Lsoftware/amazon/smithy/model/shapes/UnionShape;", "serviceShape", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nCodegenVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodegenVisitor.kt\nsoftware/amazon/smithy/kotlin/codegen/CodegenVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,237:1\n2642#2:238\n1053#2:240\n1797#2,3:241\n1368#2:244\n1454#2,5:245\n1202#2,2:250\n1230#2,4:252\n1863#2,2:256\n1611#2,9:258\n1863#2:267\n1864#2:269\n1620#2:270\n1863#2,2:271\n1#3:239\n1#3:268\n73#4:273\n*S KotlinDebug\n*F\n+ 1 CodegenVisitor.kt\nsoftware/amazon/smithy/kotlin/codegen/CodegenVisitor\n*L\n52#1:238\n53#1:240\n84#1:241,3\n104#1:244\n104#1:245,5\n104#1:250,2\n104#1:252,4\n122#1:256,2\n152#1:258,9\n152#1:267\n152#1:269\n152#1:270\n158#1:271,2\n52#1:239\n152#1:268\n174#1:273\n*E\n"})
public final class CodegenVisitor
extends ShapeVisitor.Default<Unit> {
    private final Logger logger;
    @NotNull
    private final Model model;
    @NotNull
    private final KotlinSettings settings;
    @NotNull
    private final ServiceShape service;
    @NotNull
    private final FileManifest fileManifest;
    @NotNull
    private final SymbolProvider symbolProvider;
    @NotNull
    private final KotlinDelegator writers;
    @NotNull
    private final List<KotlinIntegration> integrations;
    @Nullable
    private final ProtocolGenerator protocolGenerator;
    @NotNull
    private final ApplicationProtocol applicationProtocol;
    @NotNull
    private final GenerationContext baseGenerationContext;

    /*
     * WARNING - void declaration
     */
    public CodegenVisitor(@NotNull PluginContext context) {
        void $this$fold$iv;
        void initial$iv;
        KotlinIntegration integration3;
        KotlinIntegration integration2;
        void $this$onEach$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        Model model = context.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)model, (String)"getModel(...)");
        ObjectNode objectNode = context.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"getSettings(...)");
        this.settings = KotlinSettings.Companion.from(model, objectNode);
        FileManifest fileManifest = context.getFileManifest();
        Intrinsics.checkNotNullExpressionValue((Object)fileManifest, (String)"getFileManifest(...)");
        this.fileManifest = fileManifest;
        ClassLoader classLoader = context.getPluginClassLoader().orElse(((Object)((Object)this)).getClass().getClassLoader());
        this.logger.info("Discovering KotlinIntegration providers...");
        Iterable iterable = ServiceLoader.load(KotlinIntegration.class, classLoader);
        CodegenVisitor codegenVisitor = this;
        boolean $i$f$onEach22 = false;
        void var6_9 = $this$onEach$iv;
        Model $this$onEach_u24lambda_u2418$iv = var6_9;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
            integration2 = (KotlinIntegration)element$iv;
            boolean bl2 = false;
            this.logger.info("Loaded KotlinIntegration: " + integration2.getClass().getName());
        }
        void v3 = var6_9;
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"onEach(...)");
        void $this$sortedBy$iv = v3;
        boolean $i$f$sortedBy = false;
        codegenVisitor.integrations = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KotlinIntegration p0 = (KotlinIntegration)a;
                boolean bl = false;
                Comparable comparable = Byte.valueOf(p0.getOrder());
                p0 = (KotlinIntegration)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Byte.valueOf(p0.getOrder()));
            }
        }));
        Model resolvedModel = context.getModel();
        List disabledIntegrations = new ArrayList();
        this.logger.info("Preprocessing model");
        for (KotlinIntegration integration3 : this.integrations) {
            $this$onEach_u24lambda_u2418$iv = resolvedModel;
            Intrinsics.checkNotNull((Object)$this$onEach_u24lambda_u2418$iv);
            if (integration3.enabledForService($this$onEach_u24lambda_u2418$iv, this.settings)) {
                this.logger.info("Enabled KotlinIntegration: " + integration3.getClass().getName());
                $this$onEach_u24lambda_u2418$iv = resolvedModel;
                Intrinsics.checkNotNull((Object)$this$onEach_u24lambda_u2418$iv);
                resolvedModel = integration3.preprocessModel($this$onEach_u24lambda_u2418$iv, this.settings);
                continue;
            }
            disabledIntegrations.add(integration3);
        }
        this.integrations.removeAll(disabledIntegrations);
        ModelTransformer modelTransformer = ModelTransformer.create();
        Object $i$f$onEach22 = resolvedModel;
        Intrinsics.checkNotNull((Object)$i$f$onEach22);
        $i$f$onEach22 = resolvedModel = modelTransformer.copyServiceErrorsToOperations(resolvedModel, this.settings.getService((Model)$i$f$onEach22));
        Intrinsics.checkNotNull((Object)$i$f$onEach22);
        this.model = OperationNormalizer.INSTANCE.transform((Model)$i$f$onEach22, this.settings.getService());
        this.service = this.settings.getService(this.model);
        $i$f$onEach22 = this.integrations;
        integration3 = KotlinCodegenPlugin.Companion.createSymbolProvider(this.model, this.settings);
        codegenVisitor = this;
        boolean $i$f$fold = false;
        SymbolProvider accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            integration2 = (KotlinIntegration)element$iv;
            void provider = accumulator$iv;
            boolean bl3 = false;
            accumulator$iv = integration2.decorateSymbolProvider(this.settings, this.model, (SymbolProvider)provider);
        }
        codegenVisitor.symbolProvider = accumulator$iv;
        this.writers = new KotlinDelegator(this.settings, this.model, this.fileManifest, this.symbolProvider, this.integrations);
        this.protocolGenerator = this.resolveProtocolGenerator(this.integrations, this.model, this.service, this.settings);
        Object object = this.protocolGenerator;
        if (object == null || (object = object.getApplicationProtocol()) == null) {
            object = ApplicationProtocol.Companion.createDefaultHttpApplicationProtocol();
        }
        this.applicationProtocol = object;
        this.baseGenerationContext = new GenerationContext(this.model, this.symbolProvider, this.settings, this.protocolGenerator, this.integrations);
    }

    /*
     * WARNING - void declaration
     */
    private final ProtocolGenerator resolveProtocolGenerator(List<? extends KotlinIntegration> integrations, Model model, ServiceShape service, KotlinSettings settings) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = integrations;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            KotlinIntegration it = (KotlinIntegration)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getProtocolGenerators();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ProtocolGenerator bl = (ProtocolGenerator)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl2 = false;
            map.put(it.getProtocol(), element$iv$iv);
        }
        Map generators = destination$iv$iv2;
        ServiceIndex serviceIndex = ServiceIndex.of((Model)model);
        try {
            Intrinsics.checkNotNull((Object)serviceIndex);
            ShapeId protocolTrait = settings.resolveServiceProtocol(serviceIndex, service, generators.keySet());
            return (ProtocolGenerator)generators.get(protocolTrait);
        }
        catch (UnresolvableProtocolException ex) {
            this.logger.warning("Unable to find protocol generator for " + service.getId() + ": " + ex.getMessage());
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void execute() {
        Object it;
        this.logger.info("Generating Kotlin client for service " + this.settings.getService());
        this.logger.info("Walking shapes from " + this.settings.getService() + " to find shapes to generate");
        Model modelWithoutTraits = ModelTransformer.create().getModelWithoutTraitShapes(this.model);
        Set serviceShapes = new Walker(modelWithoutTraits).walkShapes((Shape)this.service);
        Intrinsics.checkNotNull((Object)serviceShapes);
        Iterable $this$forEach$iv = serviceShapes;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Shape)element$iv;
            boolean bl = false;
            it.accept((ShapeVisitor)this);
        }
        ProtocolGenerator protocolGenerator = this.protocolGenerator;
        if (protocolGenerator != null) {
            ProtocolGenerator $this$execute_u24lambda_u245 = $i$f$forEach2 = protocolGenerator;
            boolean bl = false;
            ProtocolGenerator.GenerationContext ctx = new ProtocolGenerator.GenerationContext(this.settings, this.model, this.service, this.symbolProvider, this.integrations, $this$execute_u24lambda_u245.getProtocol(), this.writers);
            this.logger.info("" + '[' + this.service.getId() + "] Generating unit tests for protocol " + $this$execute_u24lambda_u245.getProtocol());
            $this$execute_u24lambda_u245.generateProtocolUnitTests(ctx);
            this.logger.info("" + '[' + this.service.getId() + "] Generating service client for protocol " + $this$execute_u24lambda_u245.getProtocol());
            $this$execute_u24lambda_u245.generateProtocolClient(ctx);
            this.logger.info("" + '[' + this.service.getId() + "] Generating endpoint provider for protocol " + $this$execute_u24lambda_u245.getProtocol());
            CodegenVisitorKt.access$generateEndpointsSources($this$execute_u24lambda_u245, ctx);
            this.logger.info("" + '[' + this.service.getId() + "] Generating auth scheme provider for protocol " + $this$execute_u24lambda_u245.getProtocol());
            CodegenVisitorKt.access$generateAuthSchemeProvider($this$execute_u24lambda_u245, ctx);
        }
        this.writers.finalize();
        if (this.settings.getBuild().getGenerateDefaultBuildFiles()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable $i$f$forEach2 = this.writers.getDependencies();
            boolean $i$f$mapNotNull = false;
            void bl = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach3 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KotlinDependency it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                SymbolDependency it2 = (SymbolDependency)element$iv$iv;
                boolean bl3 = false;
                Object v = it2.getProperties().get("dependency");
                if ((v instanceof KotlinDependency ? (KotlinDependency)v : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List dependencies = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            GradleGeneratorKt.writeGradleBuild(this.settings, this.fileManifest, dependencies);
        }
        $this$forEach$iv = this.integrations;
        boolean $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (KotlinIntegration)element$iv;
            boolean bl = false;
            it.writeAdditionalFiles(this.baseGenerationContext, this.writers);
        }
        this.writers.flushWriters();
    }

    protected void getDefault(@Nullable Shape shape) {
    }

    public void structureShape(@NotNull StructureShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.writers.useShapeWriter((Shape)shape, (Function1<? super KotlinWriter, Unit>)((Function1)arg_0 -> CodegenVisitor.structureShape$lambda$8(this, shape, arg_0)));
    }

    public void stringShape(@NotNull StringShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape $this$hasTrait$iv = (Shape)shape;
        boolean $i$f$hasTrait = false;
        if ($this$hasTrait$iv.hasTrait(EnumTrait.class)) {
            this.writers.useShapeWriter((Shape)shape, (Function1<? super KotlinWriter, Unit>)((Function1)arg_0 -> CodegenVisitor.stringShape$lambda$9(shape, this, arg_0)));
        }
    }

    public void intEnumShape(@NotNull IntEnumShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.writers.useShapeWriter((Shape)shape, (Function1<? super KotlinWriter, Unit>)((Function1)arg_0 -> CodegenVisitor.intEnumShape$lambda$10(shape, this, arg_0)));
    }

    public void unionShape(@NotNull UnionShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.writers.useShapeWriter((Shape)shape, (Function1<? super KotlinWriter, Unit>)((Function1)arg_0 -> CodegenVisitor.unionShape$lambda$11(this, shape, arg_0)));
    }

    public void serviceShape(@NotNull ServiceShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        if (!Intrinsics.areEqual((Object)this.service, (Object)shape)) {
            this.logger.fine("Skipping `" + shape.getId() + "` because it is not `" + this.service.getId() + '`');
            return;
        }
        this.writers.useShapeWriter((Shape)shape, (Function1<? super KotlinWriter, Unit>)((Function1)arg_0 -> CodegenVisitor.serviceShape$lambda$12(this, shape, arg_0)));
        Symbol baseExceptionSymbol = ExceptionBaseClassGenerator.INSTANCE.baseExceptionSymbol(this.baseGenerationContext.getSettings());
        String string = baseExceptionSymbol.getName() + ".kt";
        String string2 = baseExceptionSymbol.getNamespace();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNamespace(...)");
        KotlinDelegator.useFileWriter$default(this.writers, string, string2, null, arg_0 -> CodegenVisitor.serviceShape$lambda$13(this, arg_0), 4, null);
    }

    private static final Unit structureShape$lambda$8(CodegenVisitor this$0, StructureShape $shape, KotlinWriter it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        RenderingContext<Shape> renderingContext = CodegenContextKt.toRenderingContext(this$0.baseGenerationContext, it, (Shape)$shape);
        new StructureGenerator(renderingContext).render();
        return Unit.INSTANCE;
    }

    private static final Unit stringShape$lambda$9(StringShape $shape, CodegenVisitor this$0, KotlinWriter it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Shape shape = (Shape)$shape;
        Symbol symbol = this$0.symbolProvider.toSymbol((Shape)$shape);
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"toSymbol(...)");
        new EnumGenerator(shape, symbol, it).render();
        return Unit.INSTANCE;
    }

    private static final Unit intEnumShape$lambda$10(IntEnumShape $shape, CodegenVisitor this$0, KotlinWriter it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        Shape shape = (Shape)$shape;
        Symbol symbol = this$0.symbolProvider.toSymbol((Shape)$shape);
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"toSymbol(...)");
        new EnumGenerator(shape, symbol, it).render();
        return Unit.INSTANCE;
    }

    private static final Unit unionShape$lambda$11(CodegenVisitor this$0, UnionShape $shape, KotlinWriter it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        new UnionGenerator(this$0.model, this$0.symbolProvider, it, $shape).render();
        return Unit.INSTANCE;
    }

    private static final Unit serviceShape$lambda$12(CodegenVisitor this$0, ServiceShape $shape, KotlinWriter it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        RenderingContext<Shape> renderingCtx = CodegenContextKt.toRenderingContext(this$0.baseGenerationContext, it, (Shape)$shape);
        new ServiceClientGenerator(renderingCtx).render();
        return Unit.INSTANCE;
    }

    private static final Unit serviceShape$lambda$13(CodegenVisitor this$0, KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        ExceptionBaseClassGenerator.INSTANCE.render(this$0.baseGenerationContext, writer);
        return Unit.INSTANCE;
    }
}

