/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.serde;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.DefaultValueSerializationMode;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.NestedIdentifierType;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.IdempotencyTokenTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001JB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0006H\u0004J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020!H\u0016J(\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0016H\u0004J(\u0010(\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010)\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0016H\u0004J(\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J0\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u00020,2\u0006\u0010+\u001a\u00020,2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J0\u00101\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0016J8\u00102\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00062\u0006\u00100\u001a\u00020,2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\u0006\u0010-\u001a\u00020.2\u0006\u0010'\u001a\u00020\u0016H\u0002J8\u00103\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00062\u0006\u00100\u001a\u00020,2\u0006\u00104\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u0010-\u001a\u00020.2\u0006\u0010'\u001a\u00020\u0016H\u0002J0\u00105\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00062\u0006\u00104\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u0006\u00106\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J0\u00107\u001a\u00020\u001a2\u0006\u00100\u001a\u00020,2\u0006\u00104\u001a\u00020,2\u0006\u0010%\u001a\u00020&2\u0006\u00108\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J8\u00109\u001a\u00020\u001a2\u0006\u00100\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020,2\u0006\u00104\u001a\u00020,2\u0006\u0010%\u001a\u00020&2\u0006\u00108\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J(\u0010:\u001a\u00020\u001a2\u0006\u00104\u001a\u00020,2\u0006\u0010%\u001a\u00020&2\u0006\u00108\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J0\u0010;\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020,2\u0006\u00104\u001a\u00020,2\u0006\u0010%\u001a\u00020&2\u0006\u00108\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010<\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u001c\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160E2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010F\u001a\u00020\u00162\u0006\u00100\u001a\u00020,2\u0006\u0010G\u001a\u00020\u0016H\u0002J\f\u0010H\u001a\u00020\u0016*\u00020IH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010@\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\u00020>X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010C\u00a8\u0006K"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/SerializeStructGenerator;", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "members", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "<init>", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;Ljava/util/List;Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;)V", "getCtx", "()Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "getMembers", "()Ljava/util/List;", "getWriter", "()Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "getDefaultTimestampFormat", "()Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "parentName", "", "defaultName", "valueToSerializeName", "render", "", "renderMemberShape", "memberShape", "renderMapMemberSerializer", "targetShape", "Lsoftware/amazon/smithy/model/shapes/MapShape;", "renderListMemberSerializer", "Lsoftware/amazon/smithy/model/shapes/CollectionShape;", "delegateMapSerialization", "rootMemberShape", "mapShape", "nestingLevel", "", "parentMemberName", "delegateListSerialization", "listShape", "renderNestedStructureElement", "structureShape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "isSparse", "", "renderNestedStructureEntry", "keyShape", "renderMapElement", "renderMapEntry", "renderListEntry", "elementShape", "renderListElement", "parentListMemberName", "renderPrimitiveEntry", "listMemberName", "renderTimestampEntry", "renderPrimitiveElement", "renderTimestampElement", "renderShapeSerializer", "serializerFn", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/SerializeStructGenerator$SerializeFunction;", "idempotencyTokenPostfix", "serializerForStructureShape", "serializerForSimpleShape", "getSerializerForSimpleShape", "()Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/SerializeStructGenerator$SerializeFunction;", "keyValueNames", "Lkotlin/Pair;", "keyValue", "keyName", "primitiveSerializerFunctionName", "Lsoftware/amazon/smithy/model/shapes/ShapeType;", "SerializeFunction", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nSerializeStructGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializeStructGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/serde/SerializeStructGenerator\n+ 2 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,707:1\n72#2:708\n72#2:709\n72#2:710\n1863#3,2:711\n1#4:713\n*S KotlinDebug\n*F\n+ 1 SerializeStructGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/serde/SerializeStructGenerator\n*L\n488#1:708\n557#1:709\n617#1:710\n85#1:711,2\n*E\n"})
public class SerializeStructGenerator {
    @NotNull
    private final ProtocolGenerator.GenerationContext ctx;
    @NotNull
    private final List<MemberShape> members;
    @NotNull
    private final KotlinWriter writer;
    @NotNull
    private final TimestampFormatTrait.Format defaultTimestampFormat;
    @NotNull
    private final SerializeFunction serializerForStructureShape;
    @NotNull
    private final SerializeFunction serializerForSimpleShape;

    public SerializeStructGenerator(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull List<MemberShape> members, @NotNull KotlinWriter writer, @NotNull TimestampFormatTrait.Format defaultTimestampFormat) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)defaultTimestampFormat, (String)"defaultTimestampFormat");
        this.ctx = ctx;
        this.members = members;
        this.writer = writer;
        this.defaultTimestampFormat = defaultTimestampFormat;
        this.serializerForStructureShape = (arg_0, arg_1) -> SerializeStructGenerator.serializerForStructureShape$lambda$32(this, arg_0, arg_1);
        this.serializerForSimpleShape = (arg_0, arg_1) -> SerializeStructGenerator.serializerForSimpleShape$lambda$38(this, arg_0, arg_1);
    }

    @NotNull
    protected final ProtocolGenerator.GenerationContext getCtx() {
        return this.ctx;
    }

    @NotNull
    protected final List<MemberShape> getMembers() {
        return this.members;
    }

    @NotNull
    protected final KotlinWriter getWriter() {
        return this.writer;
    }

    @NotNull
    protected final TimestampFormatTrait.Format getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    @NotNull
    public String parentName(@NotNull String defaultName) {
        Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
        return defaultName;
    }

    @NotNull
    public String valueToSerializeName(@NotNull String defaultName) {
        Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
        return defaultName;
    }

    public void render() {
        String string;
        if (!((Collection)this.members).isEmpty()) {
            string = "OBJ_DESCRIPTOR";
        } else {
            KotlinWriter.addImport$default(this.writer, RuntimeTypes.Serde.INSTANCE.getSdkObjectDescriptor(), null, 2, null);
            string = "SdkObjectDescriptor.build{}";
        }
        String objDescriptor = string;
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getSerializeStruct()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "serializer.#T(" + objDescriptor + ") {", "}", objectArray, arg_0 -> SerializeStructGenerator.render$lambda$1(this, arg_0));
    }

    protected final void renderMemberShape(@NotNull MemberShape memberShape) {
        Intrinsics.checkNotNullParameter((Object)memberShape, (String)"memberShape");
        Shape targetShape = this.ctx.getModel().expectShape(memberShape.getTarget());
        ShapeType shapeType = targetShape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 1: 
            case 2: {
                Intrinsics.checkNotNull((Object)targetShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.CollectionShape");
                this.renderListMemberSerializer(memberShape, (CollectionShape)targetShape);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)targetShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.MapShape");
                this.renderMapMemberSerializer(memberShape, (MapShape)targetShape);
                break;
            }
            case 4: 
            case 5: {
                this.renderShapeSerializer(memberShape, this.serializerForStructureShape);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                this.renderShapeSerializer(memberShape, this.serializerForSimpleShape);
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected shape type: " + targetShape.getType()).toString());
            }
        }
    }

    public void renderMapMemberSerializer(@NotNull MemberShape memberShape, @NotNull MapShape targetShape) {
        Intrinsics.checkNotNullParameter((Object)memberShape, (String)"memberShape");
        Intrinsics.checkNotNullParameter((Object)targetShape, (String)"targetShape");
        String memberName = this.ctx.getSymbolProvider().toMemberName(memberShape);
        String descriptorName = SerdeExtKt.descriptorName$default(memberShape, null, 1, null);
        int nestingLevel = 0;
        Symbol memberSymbol = this.ctx.getSymbolProvider().toSymbol((Shape)memberShape);
        AbstractCodeWriter abstractCodeWriter = this.writer;
        Intrinsics.checkNotNull((Object)memberSymbol);
        AbstractCodeWriterExtKt.wrapBlockIf(abstractCodeWriter, SymbolExtKt.isNullable(memberSymbol), "if (input." + memberName + " != null) {", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderMapMemberSerializer$lambda$3(this, descriptorName, memberShape, targetShape, nestingLevel, memberName, arg_0));
    }

    public void renderListMemberSerializer(@NotNull MemberShape memberShape, @NotNull CollectionShape targetShape) {
        Intrinsics.checkNotNullParameter((Object)memberShape, (String)"memberShape");
        Intrinsics.checkNotNullParameter((Object)targetShape, (String)"targetShape");
        String memberName = this.ctx.getSymbolProvider().toMemberName(memberShape);
        String descriptorName = SerdeExtKt.descriptorName$default(memberShape, null, 1, null);
        int nestingLevel = 0;
        Symbol memberSymbol = this.ctx.getSymbolProvider().toSymbol((Shape)memberShape);
        AbstractCodeWriter abstractCodeWriter = this.writer;
        Intrinsics.checkNotNull((Object)memberSymbol);
        AbstractCodeWriterExtKt.wrapBlockIf(abstractCodeWriter, SymbolExtKt.isNullable(memberSymbol), "if (input." + memberName + " != null) {", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderListMemberSerializer$lambda$5(this, descriptorName, memberShape, targetShape, nestingLevel, memberName, arg_0));
    }

    protected final void delegateMapSerialization(@NotNull MemberShape rootMemberShape, @NotNull MapShape mapShape, int nestingLevel, @NotNull String parentMemberName) {
        Intrinsics.checkNotNullParameter((Object)rootMemberShape, (String)"rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)mapShape, (String)"mapShape");
        Intrinsics.checkNotNullParameter((Object)parentMemberName, (String)"parentMemberName");
        Shape keyShape = this.ctx.getModel().expectShape(mapShape.getKey().getTarget());
        Shape elementShape = this.ctx.getModel().expectShape(mapShape.getValue().getTarget());
        boolean isSparse = ShapeExtKt.isSparse((Shape)mapShape);
        ShapeType shapeType = elementShape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                Intrinsics.checkNotNull((Object)keyShape);
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderPrimitiveEntry(keyShape, elementShape, nestingLevel, parentMemberName, isSparse);
                break;
            }
            case 17: {
                Intrinsics.checkNotNull((Object)keyShape);
                MemberShape memberShape = mapShape.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)memberShape, (String)"getValue(...)");
                Shape shape = (Shape)memberShape;
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderTimestampEntry(keyShape, shape, elementShape, nestingLevel, parentMemberName, isSparse);
                break;
            }
            case 1: 
            case 2: {
                Intrinsics.checkNotNull((Object)keyShape);
                Intrinsics.checkNotNull((Object)elementShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.CollectionShape");
                this.renderListEntry(rootMemberShape, keyShape, (CollectionShape)elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)keyShape);
                Intrinsics.checkNotNull((Object)elementShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.MapShape");
                this.renderMapEntry(rootMemberShape, keyShape, (MapShape)elementShape, nestingLevel, isSparse, parentMemberName);
                break;
            }
            case 4: 
            case 5: {
                Intrinsics.checkNotNull((Object)keyShape);
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderNestedStructureEntry(keyShape, elementShape, nestingLevel, parentMemberName, isSparse);
                break;
            }
            default: {
                throw new IllegalStateException(("Unhandled type " + elementShape.getType()).toString());
            }
        }
    }

    protected final void delegateListSerialization(@NotNull MemberShape rootMemberShape, @NotNull CollectionShape listShape, int nestingLevel, @NotNull String parentMemberName) {
        Intrinsics.checkNotNullParameter((Object)rootMemberShape, (String)"rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)listShape, (String)"listShape");
        Intrinsics.checkNotNullParameter((Object)parentMemberName, (String)"parentMemberName");
        Shape elementShape = this.ctx.getModel().expectShape(listShape.getMember().getTarget());
        boolean isSparse = ShapeExtKt.isSparse((Shape)listShape);
        ShapeType shapeType = elementShape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderPrimitiveElement(elementShape, nestingLevel, parentMemberName, isSparse);
                break;
            }
            case 17: {
                MemberShape memberShape = listShape.getMember();
                Intrinsics.checkNotNullExpressionValue((Object)memberShape, (String)"getMember(...)");
                Shape shape = (Shape)memberShape;
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderTimestampElement(shape, elementShape, nestingLevel, parentMemberName, isSparse);
                break;
            }
            case 1: 
            case 2: {
                Intrinsics.checkNotNull((Object)elementShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.CollectionShape");
                this.renderListElement(rootMemberShape, (CollectionShape)elementShape, nestingLevel, parentMemberName, isSparse);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)elementShape, (String)"null cannot be cast to non-null type software.amazon.smithy.model.shapes.MapShape");
                this.renderMapElement(rootMemberShape, (MapShape)elementShape, nestingLevel, parentMemberName, isSparse);
                break;
            }
            case 4: 
            case 5: {
                Intrinsics.checkNotNull((Object)elementShape);
                this.renderNestedStructureElement(elementShape, nestingLevel, parentMemberName, isSparse);
                break;
            }
            default: {
                throw new IllegalStateException(("Unhandled type " + elementShape.getType()).toString());
            }
        }
    }

    private final void renderNestedStructureElement(Shape structureShape, int nestingLevel, String parentMemberName, boolean isSparse) {
        ShapeType shapeType = structureShape.getType();
        Intrinsics.checkNotNullExpressionValue((Object)shapeType, (String)"getType(...)");
        String serializerFnName = this.primitiveSerializerFunctionName(shapeType);
        Symbol symbol = this.ctx.getSymbolProvider().toSymbol(structureShape);
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"toSymbol(...)");
        String serializerTypeName = SerdeExtKt.documentSerializerName(symbol);
        String elementName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.ELEMENT);
        String containerName = nestingLevel == 0 ? "input." : "";
        String valueToSerializeName = this.valueToSerializeName(elementName);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "for (" + elementName + " in " + containerName + parentMemberName + ") {", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderNestedStructureElement$lambda$7(this, isSparse, elementName, serializerFnName, valueToSerializeName, serializerTypeName, arg_0));
    }

    private final void renderNestedStructureEntry(Shape keyShape, Shape structureShape, int nestingLevel, String parentMemberName, boolean isSparse) {
        KotlinWriter kotlinWriter;
        Symbol symbol = this.ctx.getSymbolProvider().toSymbol(structureShape);
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"toSymbol(...)");
        String serializerTypeName = SerdeExtKt.documentSerializerName(symbol);
        Pair<String, String> pair = this.keyValueNames(nestingLevel);
        String keyName = (String)pair.component1();
        String valueName = (String)pair.component2();
        String keyValue = this.keyValue(keyShape, keyName);
        String containerName = nestingLevel == 0 ? "input." : "";
        String value = "asSdkSerializable(" + valueName + ", ::" + serializerTypeName + ')';
        boolean bl = isSparse;
        if (bl) {
            kotlinWriter = (KotlinWriter)this.writer.write(containerName + parentMemberName + ".forEach { (" + keyName + ", " + valueName + ") -> if (" + valueName + " != null) entry(" + keyValue + ", " + value + ") else entry(" + keyValue + ", null as String?) }", new Object[0]);
        } else if (!bl) {
            kotlinWriter = (KotlinWriter)this.writer.write(containerName + parentMemberName + ".forEach { (" + keyName + ", " + valueName + ") -> entry(" + keyValue + ", " + value + ") }", new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public void renderMapElement(@NotNull MemberShape rootMemberShape, @NotNull MapShape mapShape, int nestingLevel, @NotNull String parentMemberName, boolean isSparse) {
        Intrinsics.checkNotNullParameter((Object)rootMemberShape, (String)"rootMemberShape");
        Intrinsics.checkNotNullParameter((Object)mapShape, (String)"mapShape");
        Intrinsics.checkNotNullParameter((Object)parentMemberName, (String)"parentMemberName");
        String descriptorName = SerdeExtKt.descriptorName(rootMemberShape, SerdeExtKt.nestedDescriptorName(nestingLevel));
        String elementName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.ELEMENT);
        String containerName = nestingLevel == 0 ? "input." : "";
        String parentName = this.parentName(elementName);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "for (" + elementName + " in " + containerName + parentMemberName + ") {", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderMapElement$lambda$10(this, descriptorName, isSparse, elementName, rootMemberShape, mapShape, nestingLevel, parentName, arg_0));
    }

    private final void renderMapEntry(MemberShape rootMemberShape, Shape keyShape, MapShape mapShape, int nestingLevel, boolean isSparse, String parentMemberName) {
        String descriptorName = SerdeExtKt.descriptorName(rootMemberShape, SerdeExtKt.nestedDescriptorName(nestingLevel));
        String containerName = nestingLevel == 0 ? "input." : "";
        Pair<String, String> pair = this.keyValueNames(nestingLevel);
        String keyName = (String)pair.component1();
        String valueName = (String)pair.component2();
        String keyValue = this.keyValue(keyShape, keyName);
        String parentName = this.parentName(valueName);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, containerName + parentMemberName + ".forEach { (" + keyName + ", " + valueName + ") ->", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderMapEntry$lambda$13(this, isSparse, valueName, keyValue, descriptorName, rootMemberShape, mapShape, nestingLevel, parentName, arg_0));
    }

    private final void renderListEntry(MemberShape rootMemberShape, Shape keyShape, CollectionShape elementShape, int nestingLevel, boolean isSparse, String parentMemberName) {
        String descriptorName = SerdeExtKt.descriptorName(rootMemberShape, SerdeExtKt.nestedDescriptorName(nestingLevel));
        String containerName = nestingLevel == 0 ? "input." : "";
        Pair<String, String> pair = this.keyValueNames(nestingLevel);
        String keyName = (String)pair.component1();
        String valueName = (String)pair.component2();
        String parentName = this.parentName(valueName);
        String keyValue = this.keyValue(keyShape, keyName);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, containerName + parentMemberName + ".forEach { (" + keyName + ", " + valueName + ") ->", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderListEntry$lambda$16(this, isSparse, valueName, keyValue, descriptorName, rootMemberShape, elementShape, nestingLevel, parentName, arg_0));
    }

    private final void renderListElement(MemberShape rootMemberShape, CollectionShape elementShape, int nestingLevel, String parentListMemberName, boolean isSparse) {
        String descriptorName = SerdeExtKt.descriptorName(rootMemberShape, SerdeExtKt.nestedDescriptorName(nestingLevel));
        String elementName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.ELEMENT);
        String containerName = nestingLevel == 0 ? "input." : "";
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "for (" + elementName + " in " + containerName + parentListMemberName + ") {", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderListElement$lambda$19(this, descriptorName, isSparse, elementName, rootMemberShape, elementShape, nestingLevel, arg_0));
    }

    private final void renderPrimitiveEntry(Shape keyShape, Shape elementShape, int nestingLevel, String listMemberName, boolean isSparse) {
        String containerName = nestingLevel == 0 ? "input." : "";
        String enumPostfix = ShapeExtKt.isEnum(elementShape) ? ".value" : "";
        Pair<String, String> pair = this.keyValueNames(nestingLevel);
        String keyName = (String)pair.component1();
        String valueName = (String)pair.component2();
        String keyValue = this.keyValue(keyShape, keyName);
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, containerName + listMemberName + ".forEach { (" + keyName + ", " + valueName + ") ->", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderPrimitiveEntry$lambda$21(this, isSparse, valueName, keyValue, enumPostfix, arg_0));
    }

    private final void renderTimestampEntry(Shape keyShape, Shape memberShape, Shape elementShape, int nestingLevel, String listMemberName, boolean isSparse) {
        KotlinWriter.addImport$default(this.writer, RuntimeTypes.Core.INSTANCE.getTimestampFormat(), null, 2, null);
        Shape $this$hasTrait$iv = memberShape;
        boolean $i$f$hasTrait = false;
        Shape shape = $this$hasTrait$iv.hasTrait(TimestampFormatTrait.class) ? memberShape : elementShape;
        Pair<String, String> pair = shape.getTrait(TimestampFormatTrait.class).map(arg_0 -> SerializeStructGenerator.renderTimestampEntry$lambda$23(SerializeStructGenerator::renderTimestampEntry$lambda$22, arg_0)).orElse(this.defaultTimestampFormat);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"orElse(...)");
        String tsFormat = SerdeExtKt.toRuntimeEnum((TimestampFormatTrait.Format)pair);
        pair = this.keyValueNames(nestingLevel);
        String keyName = (String)pair.component1();
        String valueName = (String)pair.component2();
        String keyValue = this.keyValue(keyShape, keyName);
        String containerName = nestingLevel == 0 ? "input." : "";
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, containerName + listMemberName + ".forEach { (" + keyName + ", " + valueName + ") ->", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderTimestampEntry$lambda$25(this, isSparse, valueName, keyValue, tsFormat, arg_0));
    }

    private final void renderPrimitiveElement(Shape elementShape, int nestingLevel, String listMemberName, boolean isSparse) {
        String string;
        ShapeType shapeType = elementShape.getType();
        Intrinsics.checkNotNullExpressionValue((Object)shapeType, (String)"getType(...)");
        String serializerFnName = this.primitiveSerializerFunctionName(shapeType);
        String iteratorName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.ELEMENT);
        boolean bl = ShapeExtKt.isEnum(elementShape);
        if (bl) {
            string = iteratorName + ".value";
        } else if (!bl) {
            string = iteratorName;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String elementName = string;
        String containerName = nestingLevel == 0 ? "input." : "";
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "for (" + iteratorName + " in " + containerName + listMemberName + ") {", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderPrimitiveElement$lambda$26(isSparse, this, elementName, serializerFnName, arg_0));
    }

    private final void renderTimestampElement(Shape memberShape, Shape elementShape, int nestingLevel, String listMemberName, boolean isSparse) {
        KotlinWriter.addImport$default(this.writer, RuntimeTypes.Core.INSTANCE.getTimestampFormat(), null, 2, null);
        Shape $this$hasTrait$iv = memberShape;
        boolean $i$f$hasTrait22 = false;
        Shape shape = $this$hasTrait$iv.hasTrait(TimestampFormatTrait.class) ? memberShape : elementShape;
        TimestampFormatTrait.Format $i$f$hasTrait22 = shape.getTrait(TimestampFormatTrait.class).map(arg_0 -> SerializeStructGenerator.renderTimestampElement$lambda$28(SerializeStructGenerator::renderTimestampElement$lambda$27, arg_0)).orElse(this.defaultTimestampFormat);
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$hasTrait22, (String)"orElse(...)");
        String tsFormat = SerdeExtKt.toRuntimeEnum($i$f$hasTrait22);
        String elementName = SerdeExtKt.variableNameFor(nestingLevel, NestedIdentifierType.ELEMENT);
        String containerName = nestingLevel == 0 ? "input." : "";
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "for (" + elementName + " in " + containerName + listMemberName + ") {", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderTimestampElement$lambda$30(this, isSparse, elementName, tsFormat, arg_0));
    }

    public void renderShapeSerializer(@NotNull MemberShape memberShape, @NotNull SerializeFunction serializerFn) {
        KotlinWriter kotlinWriter;
        Intrinsics.checkNotNullParameter((Object)memberShape, (String)"memberShape");
        Intrinsics.checkNotNullParameter((Object)serializerFn, (String)"serializerFn");
        String postfix = this.idempotencyTokenPostfix(memberShape);
        Symbol memberSymbol = this.ctx.getSymbolProvider().toSymbol((Shape)memberShape);
        String memberName = this.ctx.getSymbolProvider().toMemberName(memberShape);
        Intrinsics.checkNotNull((Object)memberSymbol);
        if (SymbolExtKt.isNullable(memberSymbol)) {
            String identifier = this.valueToSerializeName("it");
            String fn = serializerFn.format(memberShape, identifier);
            kotlinWriter = (KotlinWriter)this.writer.write("input." + memberName + "?.let { " + fn + " }" + postfix, new Object[0]);
        } else {
            String defaultValue = SymbolExtKt.defaultValue(memberSymbol);
            boolean checkDefaults = this.ctx.getSettings().getApi().getDefaultValueSerializationMode() == DefaultValueSerializationMode.WHEN_DIFFERENT;
            String defaultCheck = checkDefaults && !memberShape.isRequired() && SymbolExtKt.isNotNullable(memberSymbol) && defaultValue != null ? "if (input." + memberName + " != " + defaultValue + ") " : "";
            String fn = serializerFn.format(memberShape, "input." + memberName);
            kotlinWriter = (KotlinWriter)this.writer.write(defaultCheck + fn + postfix, new Object[0]);
        }
    }

    private final String idempotencyTokenPostfix(MemberShape memberShape) {
        String string;
        Shape $this$hasTrait$iv = (Shape)memberShape;
        boolean $i$f$hasTrait = false;
        if ($this$hasTrait$iv.hasTrait(IdempotencyTokenTrait.class)) {
            KotlinWriter.addImport$default(this.writer, RuntimeTypes.SmithyClient.INSTANCE.getIdempotencyTokenProviderExt(), null, 2, null);
            string = " ?: field(" + SerdeExtKt.descriptorName$default(memberShape, null, 1, null) + ", context.idempotencyTokenProvider.generateToken())";
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    protected final SerializeFunction getSerializerForSimpleShape() {
        return this.serializerForSimpleShape;
    }

    private final Pair<String, String> keyValueNames(int nestingLevel) {
        String keyName = nestingLevel == 0 ? "key" : "key" + nestingLevel;
        String valueName = nestingLevel == 0 ? "value" : "value" + nestingLevel;
        return TuplesKt.to((Object)keyName, (Object)valueName);
    }

    private final String keyValue(Shape keyShape, String keyName) {
        return keyName + (ShapeExtKt.isEnum(keyShape) ? ".value" : "");
    }

    private final String primitiveSerializerFunctionName(ShapeType $this$primitiveSerializerFunctionName) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$primitiveSerializerFunctionName.ordinal()]) {
            case 7: {
                string = "Boolean";
                break;
            }
            case 8: 
            case 19: {
                string = "String";
                break;
            }
            case 9: {
                string = "Byte";
                break;
            }
            case 10: {
                string = "Short";
                break;
            }
            case 11: 
            case 20: {
                string = "Int";
                break;
            }
            case 12: {
                string = "Long";
                break;
            }
            case 13: {
                string = "Float";
                break;
            }
            case 14: {
                string = "Double";
                break;
            }
            case 18: {
                string = "Document";
                break;
            }
            case 4: 
            case 5: {
                string = "SdkSerializable";
                break;
            }
            case 6: {
                string = "ByteArray";
                break;
            }
            default: {
                throw new CodegenException($this$primitiveSerializerFunctionName + " has no primitive serialize function on the Serializer interface");
            }
        }
        String suffix = string;
        return "serialize" + suffix;
    }

    private static final Unit render$lambda$1(SerializeStructGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Iterable $this$forEach$iv = this$0.members;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MemberShape memberShape = (MemberShape)element$iv;
            boolean bl = false;
            this$0.renderMemberShape(memberShape);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderMapMemberSerializer$lambda$3$lambda$2(SerializeStructGenerator this$0, MemberShape $memberShape, MapShape $targetShape, int $nestingLevel, String $memberName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Intrinsics.checkNotNull((Object)$memberName);
        this$0.delegateMapSerialization($memberShape, $targetShape, $nestingLevel, $memberName);
        return Unit.INSTANCE;
    }

    private static final Unit renderMapMemberSerializer$lambda$3(SerializeStructGenerator this$0, String $descriptorName, MemberShape $memberShape, MapShape $targetShape, int $nestingLevel, String $memberName, KotlinWriter $this$wrapBlockIf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$wrapBlockIf), (String)"$this$wrapBlockIf");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this$0.writer, "mapField(" + $descriptorName + ") {", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderMapMemberSerializer$lambda$3$lambda$2(this$0, $memberShape, $targetShape, $nestingLevel, $memberName, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderListMemberSerializer$lambda$5$lambda$4(SerializeStructGenerator this$0, MemberShape $memberShape, CollectionShape $targetShape, int $nestingLevel, String $memberName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Intrinsics.checkNotNull((Object)$memberName);
        this$0.delegateListSerialization($memberShape, $targetShape, $nestingLevel, $memberName);
        return Unit.INSTANCE;
    }

    private static final Unit renderListMemberSerializer$lambda$5(SerializeStructGenerator this$0, String $descriptorName, MemberShape $memberShape, CollectionShape $targetShape, int $nestingLevel, String $memberName, KotlinWriter $this$wrapBlockIf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$wrapBlockIf), (String)"$this$wrapBlockIf");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this$0.writer, "listField(" + $descriptorName + ") {", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderListMemberSerializer$lambda$5$lambda$4(this$0, $memberShape, $targetShape, $nestingLevel, $memberName, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderNestedStructureElement$lambda$7$lambda$6(SerializeStructGenerator this$0, String $serializerFnName, String $valueToSerializeName, String $serializerTypeName, KotlinWriter $this$wrapBlockIf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$wrapBlockIf), (String)"$this$wrapBlockIf");
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getAsSdkSerializable()};
        this$0.writer.write($serializerFnName + "(#T(" + $valueToSerializeName + ", ::" + $serializerTypeName + "))", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderNestedStructureElement$lambda$7(SerializeStructGenerator this$0, boolean $isSparse, String $elementName, String $serializerFnName, String $valueToSerializeName, String $serializerTypeName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.wrapBlockIf((AbstractCodeWriter)this$0.writer, $isSparse, "if (" + $elementName + " != null) {", "} else serializeNull()", new Object[0], arg_0 -> SerializeStructGenerator.renderNestedStructureElement$lambda$7$lambda$6(this$0, $serializerFnName, $valueToSerializeName, $serializerTypeName, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderMapElement$lambda$10$lambda$9$lambda$8(SerializeStructGenerator this$0, MemberShape $rootMemberShape, MapShape $mapShape, int $nestingLevel, String $parentName, KotlinWriter $this$wrapBlockIf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$wrapBlockIf), (String)"$this$wrapBlockIf");
        this$0.delegateMapSerialization($rootMemberShape, $mapShape, $nestingLevel + 1, $parentName);
        return Unit.INSTANCE;
    }

    private static final Unit renderMapElement$lambda$10$lambda$9(SerializeStructGenerator this$0, boolean $isSparse, String $elementName, MemberShape $rootMemberShape, MapShape $mapShape, int $nestingLevel, String $parentName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.wrapBlockIf((AbstractCodeWriter)this$0.writer, $isSparse, "if (" + $elementName + " != null) {", "} else serializeNull()", new Object[0], arg_0 -> SerializeStructGenerator.renderMapElement$lambda$10$lambda$9$lambda$8(this$0, $rootMemberShape, $mapShape, $nestingLevel, $parentName, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderMapElement$lambda$10(SerializeStructGenerator this$0, String $descriptorName, boolean $isSparse, String $elementName, MemberShape $rootMemberShape, MapShape $mapShape, int $nestingLevel, String $parentName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getSerializeMap()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this$0.writer, "serializer.#T(" + $descriptorName + ") {", "}", objectArray, arg_0 -> SerializeStructGenerator.renderMapElement$lambda$10$lambda$9(this$0, $isSparse, $elementName, $rootMemberShape, $mapShape, $nestingLevel, $parentName, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderMapEntry$lambda$13$lambda$12$lambda$11(SerializeStructGenerator this$0, MemberShape $rootMemberShape, MapShape $mapShape, int $nestingLevel, String $parentName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        this$0.delegateMapSerialization($rootMemberShape, $mapShape, $nestingLevel + 1, $parentName);
        return Unit.INSTANCE;
    }

    private static final Unit renderMapEntry$lambda$13$lambda$12(SerializeStructGenerator this$0, String $keyValue, String $descriptorName, MemberShape $rootMemberShape, MapShape $mapShape, int $nestingLevel, String $parentName, KotlinWriter $this$wrapBlockIf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$wrapBlockIf), (String)"$this$wrapBlockIf");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this$0.writer, "mapEntry(" + $keyValue + ", " + $descriptorName + ") {", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderMapEntry$lambda$13$lambda$12$lambda$11(this$0, $rootMemberShape, $mapShape, $nestingLevel, $parentName, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderMapEntry$lambda$13(SerializeStructGenerator this$0, boolean $isSparse, String $valueName, String $keyValue, String $descriptorName, MemberShape $rootMemberShape, MapShape $mapShape, int $nestingLevel, String $parentName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.wrapBlockIf((AbstractCodeWriter)this$0.writer, $isSparse, "if (" + $valueName + " != null) {", "} else entry(" + $keyValue + ", null as String?)", new Object[0], arg_0 -> SerializeStructGenerator.renderMapEntry$lambda$13$lambda$12(this$0, $keyValue, $descriptorName, $rootMemberShape, $mapShape, $nestingLevel, $parentName, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderListEntry$lambda$16$lambda$15$lambda$14(SerializeStructGenerator this$0, MemberShape $rootMemberShape, CollectionShape $elementShape, int $nestingLevel, String $parentName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        this$0.delegateListSerialization($rootMemberShape, $elementShape, $nestingLevel + 1, $parentName);
        return Unit.INSTANCE;
    }

    private static final Unit renderListEntry$lambda$16$lambda$15(SerializeStructGenerator this$0, String $keyValue, String $descriptorName, MemberShape $rootMemberShape, CollectionShape $elementShape, int $nestingLevel, String $parentName, KotlinWriter $this$wrapBlockIf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$wrapBlockIf), (String)"$this$wrapBlockIf");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this$0.writer, "listEntry(" + $keyValue + ", " + $descriptorName + ") {", "}", new Object[0], arg_0 -> SerializeStructGenerator.renderListEntry$lambda$16$lambda$15$lambda$14(this$0, $rootMemberShape, $elementShape, $nestingLevel, $parentName, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderListEntry$lambda$16(SerializeStructGenerator this$0, boolean $isSparse, String $valueName, String $keyValue, String $descriptorName, MemberShape $rootMemberShape, CollectionShape $elementShape, int $nestingLevel, String $parentName, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.wrapBlockIf((AbstractCodeWriter)this$0.writer, $isSparse, "if (" + $valueName + " != null) {", "} else entry(" + $keyValue + ", null as String?)", new Object[0], arg_0 -> SerializeStructGenerator.renderListEntry$lambda$16$lambda$15(this$0, $keyValue, $descriptorName, $rootMemberShape, $elementShape, $nestingLevel, $parentName, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderListElement$lambda$19$lambda$18$lambda$17(SerializeStructGenerator this$0, MemberShape $rootMemberShape, CollectionShape $elementShape, int $nestingLevel, String $elementName, KotlinWriter $this$wrapBlockIf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$wrapBlockIf), (String)"$this$wrapBlockIf");
        this$0.delegateListSerialization($rootMemberShape, $elementShape, $nestingLevel + 1, $elementName);
        return Unit.INSTANCE;
    }

    private static final Unit renderListElement$lambda$19$lambda$18(SerializeStructGenerator this$0, boolean $isSparse, String $elementName, MemberShape $rootMemberShape, CollectionShape $elementShape, int $nestingLevel, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.wrapBlockIf((AbstractCodeWriter)this$0.writer, $isSparse, "if (" + $elementName + " != null) {", "} else serializeNull()", new Object[0], arg_0 -> SerializeStructGenerator.renderListElement$lambda$19$lambda$18$lambda$17(this$0, $rootMemberShape, $elementShape, $nestingLevel, $elementName, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderListElement$lambda$19(SerializeStructGenerator this$0, String $descriptorName, boolean $isSparse, String $elementName, MemberShape $rootMemberShape, CollectionShape $elementShape, int $nestingLevel, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{RuntimeTypes.Serde.INSTANCE.getSerializeList()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this$0.writer, "serializer.#T(" + $descriptorName + ") {", "}", objectArray, arg_0 -> SerializeStructGenerator.renderListElement$lambda$19$lambda$18(this$0, $isSparse, $elementName, $rootMemberShape, $elementShape, $nestingLevel, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderPrimitiveEntry$lambda$21$lambda$20(SerializeStructGenerator this$0, String $keyValue, String $valueName, String $enumPostfix, KotlinWriter $this$wrapBlockIf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$wrapBlockIf), (String)"$this$wrapBlockIf");
        this$0.writer.write("entry(" + $keyValue + ", " + $valueName + $enumPostfix + ')', new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderPrimitiveEntry$lambda$21(SerializeStructGenerator this$0, boolean $isSparse, String $valueName, String $keyValue, String $enumPostfix, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.wrapBlockIf((AbstractCodeWriter)this$0.writer, $isSparse, "if (" + $valueName + " != null) {", "} else entry(" + $keyValue + ", null as String?)", new Object[0], arg_0 -> SerializeStructGenerator.renderPrimitiveEntry$lambda$21$lambda$20(this$0, $keyValue, $valueName, $enumPostfix, arg_0));
        return Unit.INSTANCE;
    }

    private static final TimestampFormatTrait.Format renderTimestampEntry$lambda$22(TimestampFormatTrait it) {
        return it.getFormat();
    }

    private static final TimestampFormatTrait.Format renderTimestampEntry$lambda$23(Function1 $tmp0, Object p0) {
        return (TimestampFormatTrait.Format)$tmp0.invoke(p0);
    }

    private static final Unit renderTimestampEntry$lambda$25$lambda$24(SerializeStructGenerator this$0, String $keyValue, String $tsFormat, KotlinWriter $this$wrapBlockIf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$wrapBlockIf), (String)"$this$wrapBlockIf");
        this$0.writer.write("entry(" + $keyValue + ", it, " + $tsFormat + ')', new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderTimestampEntry$lambda$25(SerializeStructGenerator this$0, boolean $isSparse, String $valueName, String $keyValue, String $tsFormat, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.wrapBlockIf((AbstractCodeWriter)this$0.writer, $isSparse, "if (" + $valueName + " != null) {", "} else entry(" + $keyValue + ", null as String?)", new Object[0], arg_0 -> SerializeStructGenerator.renderTimestampEntry$lambda$25$lambda$24(this$0, $keyValue, $tsFormat, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit renderPrimitiveElement$lambda$26(boolean $isSparse, SerializeStructGenerator this$0, String $elementName, String $serializerFnName, KotlinWriter $this$withBlock) {
        KotlinWriter kotlinWriter;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        boolean bl = $isSparse;
        if (bl) {
            kotlinWriter = (KotlinWriter)this$0.writer.write("if (" + $elementName + " != null) " + $serializerFnName + '(' + $elementName + ") else serializeNull()", new Object[0]);
        } else if (!bl) {
            kotlinWriter = (KotlinWriter)this$0.writer.write($serializerFnName + '(' + $elementName + ')', new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final TimestampFormatTrait.Format renderTimestampElement$lambda$27(TimestampFormatTrait it) {
        return it.getFormat();
    }

    private static final TimestampFormatTrait.Format renderTimestampElement$lambda$28(Function1 $tmp0, Object p0) {
        return (TimestampFormatTrait.Format)$tmp0.invoke(p0);
    }

    private static final Unit renderTimestampElement$lambda$30$lambda$29(SerializeStructGenerator this$0, String $elementName, String $tsFormat, KotlinWriter $this$wrapBlockIf) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$wrapBlockIf), (String)"$this$wrapBlockIf");
        this$0.writer.write("serializeInstant(" + $elementName + ", " + $tsFormat + ')', new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderTimestampElement$lambda$30(SerializeStructGenerator this$0, boolean $isSparse, String $elementName, String $tsFormat, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.wrapBlockIf((AbstractCodeWriter)this$0.writer, $isSparse, "if (" + $elementName + " != null) {", "} else serializeNull()", new Object[0], arg_0 -> SerializeStructGenerator.renderTimestampElement$lambda$30$lambda$29(this$0, $elementName, $tsFormat, arg_0));
        return Unit.INSTANCE;
    }

    private static final String serializerForStructureShape$lambda$32(SerializeStructGenerator this$0, MemberShape member, String identifier) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Shape target = ShapeExtKt.targetOrSelf((Shape)member, this$0.ctx.getModel());
        if (!(target.getType() == ShapeType.STRUCTURE || target.getType() == ShapeType.UNION)) {
            boolean $i$a$-require-SerializeStructGenerator$serializerForStructureShape$1$22 = false;
            String $i$a$-require-SerializeStructGenerator$serializerForStructureShape$1$22 = "Unexpected serializer for member: " + member + "; target: " + target;
            throw new IllegalArgumentException($i$a$-require-SerializeStructGenerator$serializerForStructureShape$1$22.toString());
        }
        Symbol symbol = this$0.ctx.getSymbolProvider().toSymbol(target);
        Intrinsics.checkNotNull((Object)symbol);
        String memberSerializerName = SerdeExtKt.documentSerializerName(symbol);
        String descriptor = SerdeExtKt.descriptorName$default(member, null, 1, null);
        return "field(" + descriptor + ", " + identifier + ", ::" + memberSerializerName + ')';
    }

    private static final TimestampFormatTrait.Format serializerForSimpleShape$lambda$38$lambda$33(TimestampFormatTrait it) {
        return it.getFormat();
    }

    private static final TimestampFormatTrait.Format serializerForSimpleShape$lambda$38$lambda$34(Function1 $tmp0, Object p0) {
        return (TimestampFormatTrait.Format)$tmp0.invoke(p0);
    }

    private static final TimestampFormatTrait.Format serializerForSimpleShape$lambda$38$lambda$37$lambda$35(TimestampFormatTrait it) {
        return it.getFormat();
    }

    private static final TimestampFormatTrait.Format serializerForSimpleShape$lambda$38$lambda$37$lambda$36(Function1 $tmp0, Object p0) {
        return (TimestampFormatTrait.Format)$tmp0.invoke(p0);
    }

    private static final TimestampFormatTrait.Format serializerForSimpleShape$lambda$38$lambda$37(Shape $target, SerializeStructGenerator this$0) {
        return $target.getTrait(TimestampFormatTrait.class).map(arg_0 -> SerializeStructGenerator.serializerForSimpleShape$lambda$38$lambda$37$lambda$36(SerializeStructGenerator::serializerForSimpleShape$lambda$38$lambda$37$lambda$35, arg_0)).orElse(this$0.defaultTimestampFormat);
    }

    private static final String serializerForSimpleShape$lambda$38(SerializeStructGenerator this$0, MemberShape member, String identifier) {
        String string;
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Shape target = ShapeExtKt.targetOrSelf((Shape)member, this$0.ctx.getModel());
        if (target.getType() == ShapeType.TIMESTAMP) {
            KotlinWriter.addImport$default(this$0.writer, RuntimeTypes.Core.INSTANCE.getTimestampFormat(), null, 2, null);
            TimestampFormatTrait.Format format = member.getTrait(TimestampFormatTrait.class).map(arg_0 -> SerializeStructGenerator.serializerForSimpleShape$lambda$38$lambda$34(SerializeStructGenerator::serializerForSimpleShape$lambda$38$lambda$33, arg_0)).orElseGet(() -> SerializeStructGenerator.serializerForSimpleShape$lambda$38$lambda$37(target, this$0));
            Intrinsics.checkNotNullExpressionValue((Object)format, (String)"orElseGet(...)");
            String tsFormat = SerdeExtKt.toRuntimeEnum(format);
            string = identifier + ", " + tsFormat;
        } else {
            string = ShapeExtKt.isEnum(target) ? identifier + ".value" : identifier;
        }
        String encoded = string;
        String descriptor = SerdeExtKt.descriptorName$default(member, null, 1, null);
        return "field(" + descriptor + ", " + encoded + ')';
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/SerializeStructGenerator$SerializeFunction;", "", "format", "", "member", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "identifier", "smithy-kotlin-codegen"})
    public static interface SerializeFunction {
        @NotNull
        public String format(@NotNull MemberShape var1, @NotNull String var2);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShapeType.values().length];
            try {
                nArray[ShapeType.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.SET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.MAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.STRUCTURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.UNION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BLOB.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BOOLEAN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.STRING.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BYTE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.SHORT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.INTEGER.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.LONG.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.FLOAT.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.DOUBLE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BIG_INTEGER.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BIG_DECIMAL.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.TIMESTAMP.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.DOCUMENT.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.ENUM.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.INT_ENUM.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

