/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.endpoints.discovery;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.aws.traits.clientendpointdiscovery.ClientEndpointDiscoveryTrait;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.CodegenContext;
import software.amazon.smithy.kotlin.codegen.core.KotlinDelegator;
import software.amazon.smithy.kotlin.codegen.core.KotlinDelegatorKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilder;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.rendering.endpoints.EndpointResolverAdapterGenerator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\u00020\u0012*\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0012*\u00020\u0014H\u0002J\f\u0010\u0016\u001a\u00020\u0012*\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \r*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/discovery/EndpointDiscovererGenerator;", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/CodegenContext;", "delegator", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinDelegator;", "<init>", "(Lsoftware/amazon/smithy/kotlin/codegen/core/CodegenContext;Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinDelegator;)V", "symbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "service", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "clientSymbol", "kotlin.jvm.PlatformType", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "operationName", "", "render", "", "renderAsEndpointResolver", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "renderDiscoverHost", "renderInvalidate", "Companion", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nEndpointDiscovererGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndpointDiscovererGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/discovery/EndpointDiscovererGenerator\n+ 2 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,133:1\n42#2:134\n77#2:135\n42#2:136\n*S KotlinDebug\n*F\n+ 1 EndpointDiscovererGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/discovery/EndpointDiscovererGenerator\n*L\n21#1:134\n24#1:135\n25#1:136\n*E\n"})
public final class EndpointDiscovererGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodegenContext ctx;
    @NotNull
    private final KotlinDelegator delegator;
    @NotNull
    private final Symbol symbol;
    @NotNull
    private final ServiceShape service;
    private final Symbol clientSymbol;
    @NotNull
    private final String operationName;

    /*
     * WARNING - void declaration
     */
    public EndpointDiscovererGenerator(@NotNull CodegenContext ctx, @NotNull KotlinDelegator delegator) {
        void $this$expectShape$iv;
        void $this$operationName_u24lambda_u240;
        void $this$expectShape$iv2;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)delegator, (String)"delegator");
        this.ctx = ctx;
        this.delegator = delegator;
        this.symbol = Companion.symbolFor(this.ctx.getSettings());
        Model model = this.ctx.getModel();
        Object shapeId$iv = this.ctx.getSettings().getService();
        boolean $i$f$expectShape = false;
        Shape shape = $this$expectShape$iv2.expectShape(shapeId$iv, ServiceShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(...)");
        this.service = (ServiceShape)shape;
        this.clientSymbol = this.ctx.getSymbolProvider().toSymbol((Shape)this.service);
        shapeId$iv = this;
        EndpointDiscovererGenerator endpointDiscovererGenerator = this;
        boolean bl = false;
        Shape $this$expectTrait$iv = (Shape)$this$operationName_u24lambda_u240.service;
        boolean $i$f$expectTrait22 = false;
        Trait trait = $this$expectTrait$iv.expectTrait(ClientEndpointDiscoveryTrait.class);
        Intrinsics.checkNotNullExpressionValue((Object)trait, (String)"expectTrait(...)");
        ClientEndpointDiscoveryTrait epDiscoveryTrait = (ClientEndpointDiscoveryTrait)trait;
        Model $i$f$expectTrait22 = $this$operationName_u24lambda_u240.ctx.getModel();
        ShapeId shapeId = epDiscoveryTrait.getOperation();
        Intrinsics.checkNotNullExpressionValue((Object)shapeId, (String)"getOperation(...)");
        ShapeId shapeId$iv2 = shapeId;
        boolean $i$f$expectShape2 = false;
        Shape shape2 = $this$expectShape$iv.expectShape(shapeId$iv2, OperationShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape2, (String)"expectShape(...)");
        OperationShape operation = (OperationShape)shape2;
        endpointDiscovererGenerator.operationName = NamingKt.defaultName(operation);
    }

    public final void render() {
        KotlinDelegatorKt.applyFileWriter(this.delegator, this.symbol, (Function1<? super KotlinWriter, Unit>)((Function1)arg_0 -> EndpointDiscovererGenerator.render$lambda$2(this, arg_0)));
    }

    private final void renderAsEndpointResolver(KotlinWriter $this$renderAsEndpointResolver) {
        Object[] objectArray = new Object[]{this.clientSymbol, EndpointResolverAdapterGenerator.Companion.getSymbol(this.ctx.getSettings()), RuntimeTypes.HttpClient.Operation.INSTANCE.getEndpointResolver()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$renderAsEndpointResolver, "internal fun asEndpointResolver(client: #T, delegate: #T) = #T { request ->", "}", objectArray, EndpointDiscovererGenerator::renderAsEndpointResolver$lambda$4);
    }

    private final void renderDiscoverHost(KotlinWriter $this$renderDiscoverHost) {
        Object[] objectArray = new Object[]{this.clientSymbol, RuntimeTypes.Core.Utils.INSTANCE.getExpiringValue(), RuntimeTypes.Core.Net.INSTANCE.getHost()};
        $this$renderDiscoverHost.openBlock("private suspend fun discoverHost(client: #T): #T<#T> =", objectArray);
        objectArray = new Object[]{this.operationName};
        $this$renderDiscoverHost.write("client.#L()", objectArray);
        $this$renderDiscoverHost.indent();
        $this$renderDiscoverHost.write(".endpoints", new Object[0]);
        objectArray = new Object[]{RuntimeTypes.Core.Utils.INSTANCE.getExpiringValue()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$renderDiscoverHost, "?.map { ep -> #T(", ")}", objectArray, EndpointDiscovererGenerator::renderDiscoverHost$lambda$5);
        $this$renderDiscoverHost.write("?.firstOrNull()", new Object[0]);
        objectArray = new Object[]{RuntimeTypes.SmithyClient.Endpoints.INSTANCE.getEndpointProviderException(), this.operationName};
        $this$renderDiscoverHost.write("?: throw #T(\"Unable to discover any endpoints when invoking #L!\")", objectArray);
        $this$renderDiscoverHost.dedent(2);
    }

    private final void renderInvalidate(KotlinWriter $this$renderInvalidate) {
        Object[] objectArray = new Object[]{RuntimeTypes.Core.INSTANCE.getExecutionContext()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$renderInvalidate, "internal suspend fun invalidate(context: #T) {", "}", objectArray, EndpointDiscovererGenerator::renderInvalidate$lambda$6);
    }

    private static final Unit render$lambda$2$lambda$1(EndpointDiscovererGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{RuntimeTypes.Core.Collections.INSTANCE.getReadThroughCache(), RuntimeTypes.Core.Net.INSTANCE.getHost(), KotlinTypes.Time.INSTANCE.getMinutes(), RuntimeTypes.Core.INSTANCE.getClock()};
        $this$withBlock.write("private val cache = #T<DiscoveryParams, #T>(10.#T, #T.System)", objectArray);
        $this$withBlock.write("", new Object[0]);
        this$0.renderAsEndpointResolver($this$withBlock);
        $this$withBlock.write("", new Object[0]);
        this$0.renderDiscoverHost($this$withBlock);
        $this$withBlock.write("", new Object[0]);
        this$0.renderInvalidate($this$withBlock);
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$2(EndpointDiscovererGenerator this$0, KotlinWriter $this$applyFileWriter) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applyFileWriter), (String)"$this$applyFileWriter");
        $this$applyFileWriter.dokka(StringsKt.trimIndent((String)("\n                    A class which looks up specific endpoints for " + this$0.ctx.getSettings().getSdkId() + " calls via the `" + this$0.operationName + "`\n                    API. These unique endpoints are cached as appropriate to avoid unnecessary latency in subsequent\n                    calls.\n                ")));
        Object[] objectArray = new Object[]{this$0.ctx.getSettings().getApi().getVisibility(), this$0.symbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$applyFileWriter, "#L class #T {", "}", objectArray, arg_0 -> EndpointDiscovererGenerator.render$lambda$2$lambda$1(this$0, arg_0));
        $this$applyFileWriter.write("", new Object[0]);
        objectArray = new Object[]{RuntimeTypes.Core.Collections.INSTANCE.getAttributeKey()};
        $this$applyFileWriter.write("private val discoveryParamsKey = #T<DiscoveryParams>(\"DiscoveryParams\")", objectArray);
        $this$applyFileWriter.write("private data class DiscoveryParams(private val region: String?, private val identity: String)", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderAsEndpointResolver$lambda$4$lambda$3(KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("originalEndpoint.uri.copy { host = discoveredHost },", new Object[0]);
        $this$withBlock.write("originalEndpoint.headers,", new Object[0]);
        $this$withBlock.write("originalEndpoint.attributes,", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderAsEndpointResolver$lambda$4(KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("val identity = request.identity", new Object[0]);
        Object[] objectArray = new Object[]{RuntimeTypes.Auth.Credentials.AwsCredentials.INSTANCE.getCredentials()};
        $this$withBlock.write("require(identity is #T) { \"Endpoint discovery requires AWS credentials\" }", objectArray);
        $this$withBlock.write("", new Object[0]);
        $this$withBlock.write("val cacheKey = DiscoveryParams(client.config.region, identity.accessKeyId)", new Object[0]);
        $this$withBlock.write("request.context[discoveryParamsKey] = cacheKey", new Object[0]);
        $this$withBlock.write("val discoveredHost = cache.get(cacheKey) { discoverHost(client) }", new Object[0]);
        $this$withBlock.write("", new Object[0]);
        $this$withBlock.write("val originalEndpoint = delegate.resolve(request)", new Object[0]);
        objectArray = new Object[]{RuntimeTypes.SmithyClient.Endpoints.INSTANCE.getEndpoint()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "#T(", ")", objectArray, EndpointDiscovererGenerator::renderAsEndpointResolver$lambda$4$lambda$3);
        return Unit.INSTANCE;
    }

    private static final Unit renderDiscoverHost$lambda$5(KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{RuntimeTypes.Core.Net.INSTANCE.getHost()};
        $this$withBlock.write("#T.parse(ep.address!!),", objectArray);
        objectArray = new Object[]{RuntimeTypes.Core.INSTANCE.getInstant(), KotlinTypes.Time.INSTANCE.getMinutes()};
        $this$withBlock.write("#T.now() + ep.cachePeriodInMinutes.#T,", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderInvalidate$lambda$6(KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.write("context.getOrNull(discoveryParamsKey)?.let { cache.invalidate(it) }", new Object[0]);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/endpoints/discovery/EndpointDiscovererGenerator$Companion;", "", "<init>", "()V", "symbolFor", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "smithy-kotlin-codegen"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Symbol symbolFor(@NotNull KotlinSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            return SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)arg_0 -> Companion.symbolFor$lambda$0(settings, arg_0)));
        }

        private static final Unit symbolFor$lambda$0(KotlinSettings $settings, SymbolBuilder $this$buildSymbol) {
            Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
            String clientName = NamingKt.clientName($settings.getSdkId());
            $this$buildSymbol.setName(clientName + "EndpointDiscoverer");
            $this$buildSymbol.setNamespace($settings.getPkg().getName() + ".endpoints");
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

