/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.serde;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.DeserializeStructGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerializeUnionGeneratorKt;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\bH\u0014J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/DeserializeUnionGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/DeserializeStructGenerator;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "unionName", "", "members", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "<init>", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;Ljava/lang/String;Ljava/util/List;Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;)V", "render", "", "renderMemberShape", "memberShape", "renderShapeDeserializer", "deserializationResultName", "defaultName", "collectionReturnExpression", "defaultCollectionName", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nDeserializeUnionGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeserializeUnionGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/serde/DeserializeUnionGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1053#2:96\n1863#2,2:97\n*S KotlinDebug\n*F\n+ 1 DeserializeUnionGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/serde/DeserializeUnionGenerator\n*L\n35#1:96\n36#1:97,2\n*E\n"})
public final class DeserializeUnionGenerator
extends DeserializeStructGenerator {
    @NotNull
    private final String unionName;

    public DeserializeUnionGenerator(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull String unionName, @NotNull List<MemberShape> members, @NotNull KotlinWriter writer, @NotNull TimestampFormatTrait.Format defaultTimestampFormat) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)unionName, (String)"unionName");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)defaultTimestampFormat, (String)"defaultTimestampFormat");
        super(ctx, members, writer, defaultTimestampFormat);
        this.unionName = unionName;
    }

    @Override
    public void render() {
        String objDescriptor = !((Collection)this.getMembers()).isEmpty() ? "OBJ_DESCRIPTOR" : "SdkObjectDescriptor.build {}";
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.getWriter(), "deserializer.deserializeStruct(" + objDescriptor + ") {", "}", new Object[0], arg_0 -> DeserializeUnionGenerator.render$lambda$4(this, arg_0));
    }

    @Override
    protected void renderMemberShape(@NotNull MemberShape memberShape) {
        Intrinsics.checkNotNullParameter((Object)memberShape, (String)"memberShape");
        Shape targetShape = this.getCtx().getModel().expectShape(memberShape.getTarget());
        if (targetShape instanceof ListShape) {
            this.renderListMemberDeserializer(memberShape, (CollectionShape)targetShape);
        } else if (targetShape instanceof MapShape) {
            this.renderMapMemberDeserializer(memberShape, (MapShape)targetShape);
        } else if (targetShape instanceof StructureShape || targetShape instanceof UnionShape) {
            this.renderShapeDeserializer(memberShape);
        } else if (targetShape instanceof BlobShape || targetShape instanceof BooleanShape || targetShape instanceof StringShape || targetShape instanceof TimestampShape || targetShape instanceof ByteShape || targetShape instanceof ShortShape || targetShape instanceof IntegerShape || targetShape instanceof LongShape || targetShape instanceof FloatShape || targetShape instanceof DoubleShape || targetShape instanceof BigDecimalShape || targetShape instanceof DocumentShape || targetShape instanceof BigIntegerShape) {
            this.renderShapeDeserializer(memberShape);
        } else {
            throw new IllegalStateException(("Unexpected shape type: " + targetShape.getType()).toString());
        }
    }

    @Override
    public void renderShapeDeserializer(@NotNull MemberShape memberShape) {
        Intrinsics.checkNotNullParameter((Object)memberShape, (String)"memberShape");
        String unionTypeName = SerializeUnionGeneratorKt.unionTypeName(memberShape, this.getCtx());
        String descriptorName = SerdeExtKt.descriptorName$default(memberShape, null, 1, null);
        String deserialize = this.deserializerForShape((Shape)memberShape);
        this.getWriter().write(descriptorName + ".index -> value = " + unionTypeName + '(' + deserialize + ')', new Object[0]);
    }

    @Override
    @NotNull
    public String deserializationResultName(@NotNull String defaultName) {
        Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
        return "value";
    }

    @Override
    @NotNull
    public String collectionReturnExpression(@NotNull MemberShape memberShape, @NotNull String defaultCollectionName) {
        Intrinsics.checkNotNullParameter((Object)memberShape, (String)"memberShape");
        Intrinsics.checkNotNullParameter((Object)defaultCollectionName, (String)"defaultCollectionName");
        String unionTypeName = SerializeUnionGeneratorKt.unionTypeName(memberShape, this.getCtx());
        return unionTypeName + '(' + defaultCollectionName + ')';
    }

    private static final Unit render$lambda$4$lambda$3$lambda$2(DeserializeUnionGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Iterable $this$sortedBy$iv = this$0.getMembers();
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MemberShape it = (MemberShape)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getMemberName());
                it = (MemberShape)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMemberName())));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MemberShape memberShape = (MemberShape)element$iv;
            boolean bl = false;
            this$0.renderMemberShape(memberShape);
        }
        $this$withBlock.write("null -> break@loop", new Object[0]);
        $this$withBlock.write("else -> value = " + this$0.unionName + ".SdkUnknown.also { skipValue() }", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$4$lambda$3(DeserializeUnionGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "when(findNextFieldIndex()) {", "}", new Object[0], arg_0 -> DeserializeUnionGenerator.render$lambda$4$lambda$3$lambda$2(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit render$lambda$4(DeserializeUnionGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "loop@while(true) {", "}", new Object[0], arg_0 -> DeserializeUnionGenerator.render$lambda$4$lambda$3(this$0, arg_0));
        return Unit.INSTANCE;
    }
}

