/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.rendering.EnumGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.KotlinEnum;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/EnumGenerator;", "", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "symbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "<init>", "(Lsoftware/amazon/smithy/model/shapes/Shape;Lsoftware/amazon/smithy/codegen/core/Symbol;Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;)V", "getShape", "()Lsoftware/amazon/smithy/model/shapes/Shape;", "getSymbol", "()Lsoftware/amazon/smithy/codegen/core/Symbol;", "getWriter", "()Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "ktEnum", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/KotlinEnum;", "generatedNames", "", "", "render", "", "renderVariant", "variant", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/KotlinEnum$Variant;", "renderSdkUnknown", "renderCompanionObject", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nEnumGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/EnumGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n1#2:232\n1863#3,2:233\n1863#3,2:235\n1863#3,2:237\n*S KotlinDebug\n*F\n+ 1 EnumGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/EnumGenerator\n*L\n114#1:233,2\n152#1:235,2\n162#1:237,2\n*E\n"})
public final class EnumGenerator {
    @NotNull
    private final Shape shape;
    @NotNull
    private final Symbol symbol;
    @NotNull
    private final KotlinWriter writer;
    @NotNull
    private final KotlinEnum ktEnum;
    @NotNull
    private final Set<String> generatedNames;

    public EnumGenerator(@NotNull Shape shape, @NotNull Symbol symbol, @NotNull KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        this.shape = shape;
        this.symbol = symbol;
        this.writer = writer;
        this.ktEnum = EnumGeneratorKt.access$asKotlinEnum(this.shape);
        this.generatedNames = new LinkedHashSet();
    }

    @NotNull
    public final Shape getShape() {
        return this.shape;
    }

    @NotNull
    public final Symbol getSymbol() {
        return this.symbol;
    }

    @NotNull
    public final KotlinWriter getWriter() {
        return this.writer;
    }

    public final void render() {
        this.writer.renderDocumentation(this.shape);
        this.writer.renderAnnotations(this.shape);
        Object[] objectArray = new Object[]{this.symbol.getName()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "public sealed class #L {", "}", objectArray, arg_0 -> EnumGenerator.render$lambda$1(this, arg_0));
    }

    private final void renderVariant(KotlinEnum.Variant variant) {
        String string = variant.getDocumentation();
        if (string != null) {
            String it = string;
            boolean bl = false;
            this.writer.dokka(it);
        }
        if (!this.generatedNames.add(variant.getName())) {
            throw new CodegenException("prefixing invalid enum value to form a valid Kotlin identifier causes generated sealed class names to not be unique: " + variant.getName() + "; shape=" + this.shape);
        }
        Object[] objectArray = new Object[]{variant.getName(), this.symbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "public object #L : #Q() {", "}", objectArray, arg_0 -> EnumGenerator.renderVariant$lambda$3(this, variant, arg_0));
    }

    private final void renderSdkUnknown() {
        if (this.generatedNames.contains("SdkUnknown")) {
            throw new CodegenException("generating SdkUnknown would cause duplicate variant for enum shape: " + this.shape);
        }
        Object[] objectArray = new Object[]{this.ktEnum.getSymbol(), this.symbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "public data class SdkUnknown(override val value: #Q) : #Q() {", "}", objectArray, arg_0 -> EnumGenerator.renderSdkUnknown$lambda$4(this, arg_0));
    }

    private final void renderCompanionObject() {
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)this.writer, "public companion object {", "}", new Object[0], arg_0 -> EnumGenerator.renderCompanionObject$lambda$9(this, arg_0));
    }

    private static final Unit render$lambda$1(EnumGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{this$0.ktEnum.getSymbol()};
        $this$withBlock.write("public abstract val value: #Q", objectArray);
        $this$withBlock.write("", new Object[0]);
        Iterable $this$forEach$iv = this$0.ktEnum.getVariants();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinEnum.Variant it = (KotlinEnum.Variant)element$iv;
            boolean bl = false;
            this$0.renderVariant(it);
            $this$withBlock.write("", new Object[0]);
        }
        this$0.renderSdkUnknown();
        $this$withBlock.write("", new Object[0]);
        this$0.renderCompanionObject();
        return Unit.INSTANCE;
    }

    private static final Unit renderVariant$lambda$3(EnumGenerator this$0, KotlinEnum.Variant $variant, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{this$0.ktEnum.getSymbol(), $variant.getValueLiteral()};
        $this$withBlock.write("override val value: #Q = #L", objectArray);
        objectArray = new Object[]{KotlinTypes.INSTANCE.getString(), $variant.getName()};
        this$0.writer.write("override fun toString(): #Q = #S", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderSdkUnknown$lambda$4(EnumGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Object[] objectArray = new Object[]{KotlinTypes.INSTANCE.getString()};
        this$0.writer.write("override fun toString(): #Q = \"SdkUnknown($value)\"", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderCompanionObject$lambda$9$lambda$6(EnumGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Iterable $this$forEach$iv = this$0.ktEnum.getVariants();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinEnum.Variant it = (KotlinEnum.Variant)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getValueLiteral(), it.getName()};
            $this$withBlock.write("#L -> #L", objectArray);
        }
        $this$withBlock.write("else -> SdkUnknown(value)", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderCompanionObject$lambda$9$lambda$8(EnumGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        Iterable $this$forEach$iv = this$0.ktEnum.getVariants();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinEnum.Variant it = (KotlinEnum.Variant)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getName()};
            $this$withBlock.write("#L,", objectArray);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderCompanionObject$lambda$9(EnumGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
        $this$withBlock.dokka("Convert a raw value to one of the sealed variants or [SdkUnknown]");
        Object[] objectArray = new Object[]{this$0.ktEnum.getSymbol(), this$0.symbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "public fun fromValue(value: #Q): #Q = when (value) {", "}", objectArray, arg_0 -> EnumGenerator.renderCompanionObject$lambda$9$lambda$6(this$0, arg_0));
        $this$withBlock.write("", new Object[0]);
        $this$withBlock.dokka("Get a list of all possible variants");
        objectArray = new Object[]{KotlinTypes.Collections.INSTANCE.getList(), this$0.symbol};
        $this$withBlock.write("public fun values(): #Q<#Q> = values", objectArray);
        $this$withBlock.write("", new Object[0]);
        objectArray = new Object[]{KotlinTypes.Collections.INSTANCE.getList(), this$0.symbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)$this$withBlock, "private val values: #Q<#Q> = listOf(", ")", objectArray, arg_0 -> EnumGenerator.renderCompanionObject$lambda$9$lambda$8(this$0, arg_0));
        return Unit.INSTANCE;
    }
}

