/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.model;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.SymbolExtKt;
import software.amazon.smithy.kotlin.codegen.utils.CaseUtilsKt;
import software.amazon.smithy.kotlin.codegen.utils.StringsKt;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.rulesengine.language.evaluation.value.ArrayValue;
import software.amazon.smithy.rulesengine.language.evaluation.value.BooleanValue;
import software.amazon.smithy.rulesengine.language.evaluation.value.StringValue;
import software.amazon.smithy.rulesengine.language.evaluation.value.Value;
import software.amazon.smithy.rulesengine.language.syntax.Identifier;
import software.amazon.smithy.rulesengine.language.syntax.parameters.Parameter;
import software.amazon.smithy.rulesengine.language.syntax.parameters.ParameterType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\b\u001a\u0010\u0010\t\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\f"}, d2={"defaultName", "", "Lsoftware/amazon/smithy/rulesengine/language/syntax/Identifier;", "Lsoftware/amazon/smithy/rulesengine/language/syntax/parameters/Parameter;", "toSymbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "Lsoftware/amazon/smithy/rulesengine/language/syntax/parameters/ParameterType;", "toLiteral", "Lsoftware/amazon/smithy/rulesengine/language/evaluation/value/Value;", "format", "", "Lsoftware/amazon/smithy/model/node/Node;", "smithy-kotlin-codegen"})
public final class RulesEngineExtKt {
    @NotNull
    public static final String defaultName(@NotNull Identifier $this$defaultName) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultName, (String)"<this>");
        String string = $this$defaultName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return CaseUtilsKt.toCamelCase(string);
    }

    @NotNull
    public static final String defaultName(@NotNull Parameter $this$defaultName) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultName, (String)"<this>");
        Identifier identifier = $this$defaultName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)identifier, (String)"getName(...)");
        return RulesEngineExtKt.defaultName(identifier);
    }

    @NotNull
    public static final Symbol toSymbol(@NotNull ParameterType $this$toSymbol) {
        Symbol symbol;
        Intrinsics.checkNotNullParameter((Object)$this$toSymbol, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toSymbol.ordinal()]) {
            case 1: {
                symbol = KotlinTypes.INSTANCE.getString();
                break;
            }
            case 2: {
                symbol = KotlinTypes.INSTANCE.getBoolean();
                break;
            }
            case 3: {
                symbol = KotlinTypes.Collections.list$default(KotlinTypes.Collections.INSTANCE, KotlinTypes.INSTANCE.getString(), false, null, 6, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return SymbolExtKt.asNullable(symbol);
    }

    @NotNull
    public static final String toLiteral(@NotNull Value $this$toLiteral) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toLiteral, (String)"<this>");
        Value value = $this$toLiteral;
        if (value instanceof StringValue) {
            String string2 = ((StringValue)$this$toLiteral).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValue(...)");
            string = StringsKt.doubleQuote(string2);
        } else if (value instanceof BooleanValue) {
            string = String.valueOf(((BooleanValue)$this$toLiteral).getValue());
        } else if (value instanceof ArrayValue) {
            List list = ((ArrayValue)$this$toLiteral).getValues();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
            string = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", (CharSequence)"listOf(", (CharSequence)")", (int)0, null, RulesEngineExtKt::toLiteral$lambda$0, (int)24, null);
        } else {
            throw new IllegalArgumentException("unrecognized parameter value type " + $this$toLiteral.getType());
        }
        return string;
    }

    @NotNull
    public static final String format(@NotNull List<? extends Node> $this$format) {
        Intrinsics.checkNotNullParameter($this$format, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$format, (CharSequence)", ", (CharSequence)"listOf(", (CharSequence)")", (int)0, null, RulesEngineExtKt::format$lambda$1, (int)24, null);
    }

    private static final CharSequence toLiteral$lambda$0(Value value) {
        String string = value.expectStringValue().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        return StringsKt.doubleQuote(string);
    }

    private static final CharSequence format$lambda$1(Node element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.expectStringNode().getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        return StringsKt.doubleQuote(string);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ParameterType.values().length];
            try {
                nArray[ParameterType.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParameterType.BOOLEAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParameterType.STRING_ARRAY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

