/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.model.knowledge;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.aws.traits.auth.SigV4Trait;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.OptionalAuthTrait;
import software.amazon.smithy.model.traits.Trait;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/model/knowledge/AwsSignatureVersion4;", "", "<init>", "()V", "isSupportedAuthentication", "", "model", "Lsoftware/amazon/smithy/model/Model;", "serviceShape", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "signingServiceName", "", "hasSigV4AuthScheme", "service", "operation", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nAwsSignatureVersion4.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsSignatureVersion4.kt\nsoftware/amazon/smithy/kotlin/codegen/model/knowledge/AwsSignatureVersion4\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,58:1\n1755#2,3:59\n77#3:62\n72#3:63\n*S KotlinDebug\n*F\n+ 1 AwsSignatureVersion4.kt\nsoftware/amazon/smithy/kotlin/codegen/model/knowledge/AwsSignatureVersion4\n*L\n32#1:59,3\n41#1:62\n55#1:63\n*E\n"})
public final class AwsSignatureVersion4 {
    @NotNull
    public static final AwsSignatureVersion4 INSTANCE = new AwsSignatureVersion4();

    private AwsSignatureVersion4() {
    }

    public final boolean isSupportedAuthentication(@NotNull Model model, @NotNull ServiceShape serviceShape) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)serviceShape, (String)"serviceShape");
            Iterable $this$any$iv = ServiceIndex.of((Model)model).getAuthSchemes((ToShapeId)serviceShape).values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Trait it = (Trait)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getClass(), SigV4Trait.class)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final String signingServiceName(@NotNull ServiceShape serviceShape) {
        Intrinsics.checkNotNullParameter((Object)serviceShape, (String)"serviceShape");
        Shape $this$expectTrait$iv = (Shape)serviceShape;
        boolean $i$f$expectTrait = false;
        Trait trait = $this$expectTrait$iv.expectTrait(SigV4Trait.class);
        Intrinsics.checkNotNullExpressionValue((Object)trait, (String)"expectTrait(...)");
        SigV4Trait sigv4Trait = (SigV4Trait)trait;
        String string = sigv4Trait.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasSigV4AuthScheme(@NotNull Model model, @NotNull ServiceShape service, @NotNull OperationShape operation) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Map auth = ServiceIndex.of((Model)model).getEffectiveAuthSchemes((ToShapeId)service.getId(), (ToShapeId)operation.getId());
        if (!auth.containsKey(SigV4Trait.ID)) return false;
        Shape $this$hasTrait$iv = (Shape)operation;
        boolean $i$f$hasTrait = false;
        if ($this$hasTrait$iv.hasTrait(OptionalAuthTrait.class)) return false;
        return true;
    }
}

