/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.lang;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeVisitor;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.CodegenContext;
import software.amazon.smithy.kotlin.codegen.core.KotlinDelegator;
import software.amazon.smithy.kotlin.codegen.integration.AuthSchemeHandler;
import software.amazon.smithy.kotlin.codegen.integration.KotlinIntegration;
import software.amazon.smithy.kotlin.codegen.integration.SectionWriterBinding;
import software.amazon.smithy.kotlin.codegen.lang.DocumentationPreprocessor;
import software.amazon.smithy.kotlin.codegen.lang.DocumentationPreprocessorKt;
import software.amazon.smithy.kotlin.codegen.rendering.endpoints.EndpointCustomization;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolMiddleware;
import software.amazon.smithy.kotlin.codegen.rendering.util.ConfigProperty;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.ModelTransformer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/lang/DocumentationPreprocessor;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/KotlinIntegration;", "<init>", "()V", "preprocessModel", "Lsoftware/amazon/smithy/model/Model;", "model", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "toKdoc", "", "doc", "parseClean", "Lorg/jsoup/nodes/Document;", "rawDoc", "MarkdownRenderer", "smithy-kotlin-codegen"})
public final class DocumentationPreprocessor
implements KotlinIntegration {
    @Override
    @NotNull
    public Model preprocessModel(@NotNull Model model, @NotNull KotlinSettings settings) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        ModelTransformer transformer = ModelTransformer.create();
        Model model2 = transformer.mapTraits(model, (arg_0, arg_1) -> DocumentationPreprocessor.preprocessModel$lambda$0(this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)model2, (String)"mapTraits(...)");
        return model2;
    }

    private final String toKdoc(String doc) {
        Document parsed = this.parseClean(doc);
        MarkdownRenderer renderer = new MarkdownRenderer();
        parsed.body().traverse((NodeVisitor)renderer);
        return renderer.text();
    }

    private final Document parseClean(String rawDoc) {
        String sanitized2 = DocumentationPreprocessorKt.access$applyWithin(DocumentationPreprocessorKt.access$applyWithin(rawDoc, "<code>", "</code>", parseClean.sanitized.1.INSTANCE), "<pre>", "</pre>", parseClean.sanitized.2.INSTANCE);
        Document parsed = Jsoup.parse((String)sanitized2);
        Element element = parsed.body();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"body(...)");
        Function1[] function1Array = new Function1[]{DocumentationPreprocessor::parseClean$lambda$1, DocumentationPreprocessor::parseClean$lambda$2};
        DocumentationPreprocessorKt.access$filterDescendants((Node)element, function1Array);
        Intrinsics.checkNotNull((Object)parsed);
        return parsed;
    }

    @Override
    public byte getOrder() {
        return KotlinIntegration.DefaultImpls.getOrder(this);
    }

    @Override
    @NotNull
    public List<ProtocolGenerator> getProtocolGenerators() {
        return KotlinIntegration.DefaultImpls.getProtocolGenerators(this);
    }

    @Override
    @NotNull
    public List<SectionWriterBinding> getSectionWriters() {
        return KotlinIntegration.DefaultImpls.getSectionWriters(this);
    }

    @Override
    public boolean enabledForService(@NotNull Model model, @NotNull KotlinSettings settings) {
        return KotlinIntegration.DefaultImpls.enabledForService(this, model, settings);
    }

    @Override
    @NotNull
    public List<ConfigProperty> additionalServiceConfigProps(@NotNull CodegenContext ctx) {
        return KotlinIntegration.DefaultImpls.additionalServiceConfigProps(this, ctx);
    }

    @Override
    @NotNull
    public SymbolProvider decorateSymbolProvider(@NotNull KotlinSettings settings, @NotNull Model model, @NotNull SymbolProvider symbolProvider) {
        return KotlinIntegration.DefaultImpls.decorateSymbolProvider(this, settings, model, symbolProvider);
    }

    @Override
    public void writeAdditionalFiles(@NotNull CodegenContext ctx, @NotNull KotlinDelegator delegator) {
        KotlinIntegration.DefaultImpls.writeAdditionalFiles(this, ctx, delegator);
    }

    @Override
    @NotNull
    public List<ProtocolMiddleware> customizeMiddleware(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull List<? extends ProtocolMiddleware> resolved) {
        return KotlinIntegration.DefaultImpls.customizeMiddleware(this, ctx, resolved);
    }

    @Override
    @NotNull
    public List<AuthSchemeHandler> authSchemes(@NotNull ProtocolGenerator.GenerationContext ctx) {
        return KotlinIntegration.DefaultImpls.authSchemes(this, ctx);
    }

    @Override
    @Nullable
    public EndpointCustomization customizeEndpointResolution(@NotNull ProtocolGenerator.GenerationContext ctx) {
        return KotlinIntegration.DefaultImpls.customizeEndpointResolution(this, ctx);
    }

    private static final Trait preprocessModel$lambda$0(DocumentationPreprocessor this$0, Shape shape, Trait trait) {
        Trait trait2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (trait instanceof DocumentationTrait) {
            String string = ((DocumentationTrait)trait).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            String docs = this$0.toKdoc(string);
            trait2 = (Trait)new DocumentationTrait(docs, ((DocumentationTrait)trait).getSourceLocation());
        } else {
            trait2 = trait;
        }
        return trait2;
    }

    private static final boolean parseClean$lambda$1(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof TextNode && ((TextNode)it).isBlank();
    }

    private static final boolean parseClean$lambda$2(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.nodeName(), (Object)"dt") && it.childNodes().isEmpty();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\b\u0010\u0015\u001a\u00020\u000eH\u0002J\b\u0010\u0016\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\u00060\u0006j\u0002`\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/lang/DocumentationPreprocessor$MarkdownRenderer;", "Lorg/jsoup/select/NodeVisitor;", "<init>", "()V", "builder", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "Ljava/lang/StringBuilder;", "bufferedAnchorHref", "", "bufferedAnchorText", "listPrefix", "text", "head", "", "node", "Lorg/jsoup/nodes/Node;", "depth", "", "tail", "writeBufferedAnchor", "sublistIndent", "sublistDedent", "Companion", "smithy-kotlin-codegen"})
    private static final class MarkdownRenderer
    implements NodeVisitor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private StringBuilder builder = new StringBuilder();
        @NotNull
        private String bufferedAnchorHref = "";
        @NotNull
        private String bufferedAnchorText = "";
        @NotNull
        private String listPrefix = "";
        @NotNull
        public static final String SUBLIST_INDENT = "   ";
        @NotNull
        public static final String PREFORMAT_MARKER = "`";
        @NotNull
        public static final String BOLD_MARKER = "**";
        @NotNull
        public static final String ITALIC_MARKER = "*";

        @NotNull
        public final String text() {
            String string = this.builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return ((Object)StringsKt.trim((CharSequence)string)).toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        public void head(@NotNull Node node, int depth) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node instanceof TextNode) {
                Node node2 = node.parentNode();
                if (Intrinsics.areEqual((Object)(node2 != null ? node2.nodeName() : null), (Object)"a")) {
                    this.bufferedAnchorText = DocumentationPreprocessorKt.access$markdownText((TextNode)node);
                    return;
                }
                this.builder.append(DocumentationPreprocessorKt.access$markdownText((TextNode)node));
                return;
            }
            String string = node.nodeName();
            if (string != null) {
                int n = -1;
                switch (string.hashCode()) {
                    case 3200: {
                        if (!string.equals("dd")) break;
                        n = 1;
                        break;
                    }
                    case 97: {
                        if (!string.equals("a")) break;
                        n = 2;
                        break;
                    }
                    case 3387378: {
                        if (!string.equals("note")) break;
                        n = 1;
                        break;
                    }
                    case 111267: {
                        if (!string.equals("pre")) break;
                        n = 3;
                        break;
                    }
                    case 98: {
                        if (!string.equals("b")) break;
                        n = 4;
                        break;
                    }
                    case -891980137: {
                        if (!string.equals("strong")) break;
                        n = 4;
                        break;
                    }
                    case 3059181: {
                        if (!string.equals("code")) break;
                        n = 3;
                        break;
                    }
                    case 3240: {
                        if (!string.equals("em")) break;
                        n = 5;
                        break;
                    }
                    case 3208: {
                        if (!string.equals("dl")) break;
                        n = 1;
                        break;
                    }
                    case 105: {
                        if (!string.equals("i")) break;
                        n = 5;
                        break;
                    }
                    case 3029410: {
                        if (!string.equals("body")) break;
                        n = 1;
                        break;
                    }
                    case 3152: {
                        if (!string.equals("br")) break;
                        n = 6;
                        break;
                    }
                    case 3216: {
                        if (!string.equals("dt")) break;
                        n = 7;
                        break;
                    }
                    case 112: {
                        if (!string.equals("p")) break;
                        n = 1;
                        break;
                    }
                    case -208525278: {
                        if (!string.equals("important")) break;
                        n = 1;
                        break;
                    }
                    case 99473: {
                        if (!string.equals("div")) break;
                        n = 1;
                        break;
                    }
                    case 3735: {
                        if (!string.equals("ul")) break;
                        n = 8;
                        break;
                    }
                    case 1331805594: {
                        if (!string.equals("fullname")) break;
                        n = 9;
                        break;
                    }
                    case 3453: {
                        if (!string.equals("li")) break;
                        n = 10;
                        break;
                    }
                    case 3549: {
                        if (!string.equals("ol")) break;
                        n = 8;
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        if (node.hasAttr("href")) {
                            this.bufferedAnchorHref = node.attr("href");
                        }
                        object = Unit.INSTANCE;
                        return;
                    }
                    case 10: {
                        String prefix = Intrinsics.areEqual((Object)node.childNode(0).nodeName(), (Object)"ul") ? "\n" : "";
                        object = this.builder.append(this.listPrefix + "+ " + prefix);
                        return;
                    }
                    case 8: {
                        if (DocumentationPreprocessorKt.access$hasAncestor(node, head.1.INSTANCE)) {
                            this.sublistIndent();
                        }
                        object = Unit.INSTANCE;
                        return;
                    }
                    case 3: {
                        object = this.builder.append(PREFORMAT_MARKER);
                        return;
                    }
                    case 4: {
                        object = this.builder.append(BOLD_MARKER);
                        return;
                    }
                    case 5: {
                        object = this.builder.append(ITALIC_MARKER);
                        return;
                    }
                    case 6: {
                        DocumentationPreprocessorKt.access$ensureLineBreak(this.builder);
                        object = Unit.INSTANCE;
                        return;
                    }
                    case 7: {
                        object = this.builder.append("## ");
                        return;
                    }
                    case 9: {
                        object = this.builder.append("# ");
                        return;
                    }
                    case 1: {
                        object = Unit.INSTANCE;
                        return;
                    }
                }
            }
            object = this.builder.append('<' + node.nodeName() + '>');
        }

        public void tail(@NotNull Node node, int depth) {
            block43: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                String string = node.nodeName();
                if (string == null) break block43;
                int n = -1;
                switch (string.hashCode()) {
                    case 3200: {
                        if (string.equals("dd")) {
                            n = 1;
                        }
                        break;
                    }
                    case 97: {
                        if (string.equals("a")) {
                            n = 2;
                        }
                        break;
                    }
                    case 111267: {
                        if (string.equals("pre")) {
                            n = 3;
                        }
                        break;
                    }
                    case 98: {
                        if (string.equals("b")) {
                            n = 4;
                        }
                        break;
                    }
                    case -891980137: {
                        if (string.equals("strong")) {
                            n = 4;
                        }
                        break;
                    }
                    case 3059181: {
                        if (string.equals("code")) {
                            n = 3;
                        }
                        break;
                    }
                    case 3240: {
                        if (string.equals("em")) {
                            n = 5;
                        }
                        break;
                    }
                    case 105: {
                        if (string.equals("i")) {
                            n = 5;
                        }
                        break;
                    }
                    case 112: {
                        if (string.equals("p")) {
                            n = 1;
                        }
                        break;
                    }
                    case 99473: {
                        if (string.equals("div")) {
                            n = 1;
                        }
                        break;
                    }
                    case 3216: {
                        if (string.equals("dt")) {
                            n = 6;
                        }
                        break;
                    }
                    case 3735: {
                        if (string.equals("ul")) {
                            n = 7;
                        }
                        break;
                    }
                    case 1331805594: {
                        if (string.equals("fullname")) {
                            n = 6;
                        }
                        break;
                    }
                    case 3549: {
                        if (string.equals("ol")) {
                            n = 7;
                        }
                        break;
                    }
                    case 3453: {
                        if (string.equals("li")) {
                            n = 6;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        Node nextSibling = node.nextSibling();
                        if (nextSibling != null && DocumentationPreprocessorKt.access$isList(nextSibling)) {
                            DocumentationPreprocessorKt.access$ensureLineBreak(this.builder);
                            break;
                        }
                        if (DocumentationPreprocessorKt.access$hasAncestor(node, tail.1.INSTANCE)) {
                            return;
                        }
                        DocumentationPreprocessorKt.access$ensureSectionBreak(this.builder);
                        break;
                    }
                    case 2: {
                        this.writeBufferedAnchor();
                        break;
                    }
                    case 7: {
                        this.sublistDedent();
                        Node node2 = node.parent();
                        if (!Intrinsics.areEqual((Object)(node2 != null ? node2.nodeName() : null), (Object)"body")) break;
                        DocumentationPreprocessorKt.access$ensureSectionBreak(this.builder);
                        break;
                    }
                    case 3: {
                        this.builder.append(PREFORMAT_MARKER);
                        break;
                    }
                    case 4: {
                        this.builder.append(BOLD_MARKER);
                        break;
                    }
                    case 5: {
                        this.builder.append(ITALIC_MARKER);
                        break;
                    }
                    case 6: {
                        DocumentationPreprocessorKt.access$ensureLineBreak(this.builder);
                    }
                }
            }
        }

        private final void writeBufferedAnchor() {
            this.builder.append(!Intrinsics.areEqual((Object)this.bufferedAnchorHref, (Object)"") ? '[' + this.bufferedAnchorText + "](" + this.bufferedAnchorHref + ')' : this.bufferedAnchorText);
            this.bufferedAnchorHref = "";
            this.bufferedAnchorText = "";
        }

        private final void sublistIndent() {
            this.listPrefix = this.listPrefix + SUBLIST_INDENT;
        }

        private final void sublistDedent() {
            this.listPrefix = StringsKt.dropLast((String)this.listPrefix, (int)3);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/lang/DocumentationPreprocessor$MarkdownRenderer$Companion;", "", "<init>", "()V", "SUBLIST_INDENT", "", "PREFORMAT_MARKER", "BOLD_MARKER", "ITALIC_MARKER", "smithy-kotlin-codegen"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

