/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.core;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.ReservedWordSymbolProvider;
import software.amazon.smithy.codegen.core.ReservedWords;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependencyContainer;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.KotlinDependency;
import software.amazon.smithy.kotlin.codegen.core.KotlinSymbolProvider;
import software.amazon.smithy.kotlin.codegen.core.KotlinSymbolProviderKt;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.lang.ReservedWordsKt;
import software.amazon.smithy.kotlin.codegen.model.DefaultValueType;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilder;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolExtKt;
import software.amazon.smithy.kotlin.codegen.utils.OptionalExtKt;
import software.amazon.smithy.kotlin.codegen.utils.StringsKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NullableIndex;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.ClientOptionalTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.SparseTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.traits.Trait;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00fe\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ]2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001]B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u0012\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0012\u0010#\u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010!\u001a\u00020&H\u0016J\u0012\u0010'\u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010!\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010!\u001a\u00020,H\u0002J$\u0010-\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010,2\u0006\u0010.\u001a\u00020\u00132\b\b\u0002\u0010/\u001a\u000200H\u0002J,\u0010-\u001a\u00020\u00192\b\u0010!\u001a\u0004\u0018\u00010,2\u0006\u0010.\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u00132\b\b\u0002\u0010/\u001a\u000200H\u0002J\u0012\u00102\u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u000103H\u0016J\u0010\u00104\u001a\u00020\u00032\u0006\u0010!\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u00032\u0006\u0010!\u001a\u000207H\u0016J\u0018\u00108\u001a\u00020\u00132\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0013H\u0002J\u0010\u0010<\u001a\u00020\u00032\u0006\u0010!\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00032\u0006\u0010!\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u00032\u0006\u0010!\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020\u00032\u0006\u0010!\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020\u00032\u0006\u0010!\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u001cH\u0016J \u0010G\u001a\u00020\u00032\u0006\u0010!\u001a\u00020,2\u0006\u0010.\u001a\u00020\u00132\u0006\u0010H\u001a\u00020\u0013H\u0002J\u0012\u0010I\u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010JH\u0016J\u0012\u0010K\u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010LH\u0016J\u0010\u0010M\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0015H\u0016J\u0010\u0010N\u001a\u00020\u00032\u0006\u0010!\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020\u00032\u0006\u0010!\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020\u00032\u0006\u0010!\u001a\u00020SH\u0016J\u0012\u0010T\u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010UH\u0016J\u0010\u0010V\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0010\u0010W\u001a\u00020\u00032\u0006\u0010!\u001a\u00020,H\u0016J\u0010\u0010X\u001a\u00020\u00032\u0006\u0010!\u001a\u00020YH\u0016J\u0016\u0010Z\u001a\u0004\u0018\u00010\u0013*\u00020[2\u0006\u0010\\\u001a\u00020,H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinSymbolProvider;", "Lsoftware/amazon/smithy/codegen/core/SymbolProvider;", "Lsoftware/amazon/smithy/model/shapes/ShapeVisitor;", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "model", "Lsoftware/amazon/smithy/model/Model;", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "(Lsoftware/amazon/smithy/model/Model;Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;)V", "depth", "", "escaper", "Lsoftware/amazon/smithy/codegen/core/ReservedWordSymbolProvider$Escaper;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "nullableIndex", "Lsoftware/amazon/smithy/model/knowledge/NullableIndex;", "rootNamespace", "", "service", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "addDeclareMemberReferences", "", "builder", "Lsoftware/amazon/smithy/codegen/core/Symbol$Builder;", "members", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "addSymbolReferences", "from", "to", "bigDecimalShape", "shape", "Lsoftware/amazon/smithy/model/shapes/BigDecimalShape;", "bigIntegerShape", "Lsoftware/amazon/smithy/model/shapes/BigIntegerShape;", "blobShape", "Lsoftware/amazon/smithy/model/shapes/BlobShape;", "booleanShape", "Lsoftware/amazon/smithy/model/shapes/BooleanShape;", "byteShape", "Lsoftware/amazon/smithy/model/shapes/ByteShape;", "createEnumSymbol", "Lsoftware/amazon/smithy/model/shapes/Shape;", "createSymbolBuilder", "typeName", "nullable", "", "namespace", "documentShape", "Lsoftware/amazon/smithy/model/shapes/DocumentShape;", "doubleShape", "Lsoftware/amazon/smithy/model/shapes/DoubleShape;", "floatShape", "Lsoftware/amazon/smithy/model/shapes/FloatShape;", "getDefaultValueForNumber", "type", "Lsoftware/amazon/smithy/model/shapes/ShapeType;", "value", "intEnumShape", "Lsoftware/amazon/smithy/model/shapes/IntEnumShape;", "integerShape", "Lsoftware/amazon/smithy/model/shapes/IntegerShape;", "listShape", "Lsoftware/amazon/smithy/model/shapes/ListShape;", "longShape", "Lsoftware/amazon/smithy/model/shapes/LongShape;", "mapShape", "Lsoftware/amazon/smithy/model/shapes/MapShape;", "memberShape", "numberShape", "defaultValue", "operationShape", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "resourceShape", "Lsoftware/amazon/smithy/model/shapes/ResourceShape;", "serviceShape", "shortShape", "Lsoftware/amazon/smithy/model/shapes/ShortShape;", "stringShape", "Lsoftware/amazon/smithy/model/shapes/StringShape;", "structureShape", "Lsoftware/amazon/smithy/model/shapes/StructureShape;", "timestampShape", "Lsoftware/amazon/smithy/model/shapes/TimestampShape;", "toMemberName", "toSymbol", "unionShape", "Lsoftware/amazon/smithy/model/shapes/UnionShape;", "getDefaultValue", "Lsoftware/amazon/smithy/model/traits/DefaultTrait;", "targetShape", "Companion", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nKotlinSymbolProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSymbolProvider.kt\nsoftware/amazon/smithy/kotlin/codegen/core/KotlinSymbolProvider\n+ 2 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,323:1\n43#2:324\n73#2:329\n73#2:330\n73#2:331\n83#2:332\n73#2:333\n1855#3,2:325\n1855#3,2:327\n*S KotlinDebug\n*F\n+ 1 KotlinSymbolProvider.kt\nsoftware/amazon/smithy/kotlin/codegen/core/KotlinSymbolProvider\n*L\n31#1:324\n150#1:329\n163#1:330\n187#1:331\n188#1:332\n247#1:333\n129#1:325,2\n142#1:327,2\n*E\n"})
public final class KotlinSymbolProvider
implements SymbolProvider,
ShapeVisitor<Symbol> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Model model;
    @NotNull
    private final KotlinSettings settings;
    @NotNull
    private final String rootNamespace;
    @NotNull
    private final ServiceShape service;
    private final Logger logger;
    @NotNull
    private final ReservedWordSymbolProvider.Escaper escaper;
    @NotNull
    private final NullableIndex nullableIndex;
    private int depth;

    /*
     * WARNING - void declaration
     */
    public KotlinSymbolProvider(@NotNull Model model, @NotNull KotlinSettings settings) {
        void $this$expectShape$iv;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.model = model;
        this.settings = settings;
        this.rootNamespace = this.settings.getPkg().getName();
        Model model2 = this.model;
        ShapeId shapeId$iv = this.settings.getService();
        boolean $i$f$expectShape = false;
        Shape shape = $this$expectShape$iv.expectShape(shapeId$iv, ServiceShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(shapeId, T::class.java)");
        this.service = (ServiceShape)shape;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.nullableIndex = new NullableIndex(this.model);
        ReservedWords reservedWords = ReservedWordsKt.kotlinReservedWords();
        ReservedWordSymbolProvider.Escaper escaper = ReservedWordSymbolProvider.builder().nameReservedWords(reservedWords).memberReservedWords(reservedWords).escapePredicate(KotlinSymbolProvider::_init_$lambda$0).buildEscaper();
        Intrinsics.checkNotNullExpressionValue((Object)escaper, (String)"builder()\n            .n\u2026          .buildEscaper()");
        this.escaper = escaper;
    }

    @NotNull
    public Symbol toSymbol(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        int n = this.depth;
        this.depth = n + 1;
        Object object = shape.accept((ShapeVisitor)this);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"shape.accept(this)");
        Symbol symbol2 = (Symbol)object;
        int n2 = this.depth;
        this.depth = n2 + -1;
        this.logger.fine("creating symbol from " + shape + ": " + symbol2);
        Symbol symbol3 = this.escaper.escapeSymbol(shape, symbol2);
        Intrinsics.checkNotNullExpressionValue((Object)symbol3, (String)"escaper.escapeSymbol(shape, symbol)");
        return symbol3;
    }

    @NotNull
    public String toMemberName(@NotNull MemberShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        String string = this.escaper.escapeMemberName(NamingKt.defaultName(shape));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escaper.escapeMemberName(shape.defaultName())");
        return string;
    }

    @NotNull
    public Symbol byteShape(@NotNull ByteShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return this.numberShape((Shape)shape, "Byte", "0.toByte()");
    }

    @NotNull
    public Symbol integerShape(@NotNull IntegerShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return this.numberShape((Shape)shape, "Int", "0");
    }

    @NotNull
    public Symbol intEnumShape(@NotNull IntEnumShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return this.createEnumSymbol((Shape)shape);
    }

    @NotNull
    public Symbol shortShape(@NotNull ShortShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return this.numberShape((Shape)shape, "Short", "0.toShort()");
    }

    @NotNull
    public Symbol longShape(@NotNull LongShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return this.numberShape((Shape)shape, "Long", "0L");
    }

    @NotNull
    public Symbol floatShape(@NotNull FloatShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return this.numberShape((Shape)shape, "Float", "0f");
    }

    @NotNull
    public Symbol doubleShape(@NotNull DoubleShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return this.numberShape((Shape)shape, "Double", "0.0");
    }

    private final Symbol numberShape(Shape shape, String typeName, String defaultValue) {
        Symbol symbol2 = SymbolExtKt.defaultValue$default(KotlinSymbolProvider.createSymbolBuilder$default(this, shape, typeName, "kotlin", false, 8, null), defaultValue, null, 2, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"createSymbolBuilder(shap\u2026lue(defaultValue).build()");
        return symbol2;
    }

    @NotNull
    public Symbol bigIntegerShape(@Nullable BigIntegerShape shape) {
        return RuntimeTypes.Core.Content.INSTANCE.getBigInteger();
    }

    @NotNull
    public Symbol bigDecimalShape(@Nullable BigDecimalShape shape) {
        return RuntimeTypes.Core.Content.INSTANCE.getBigDecimal();
    }

    @NotNull
    public Symbol stringShape(@NotNull StringShape shape) {
        Symbol symbol2;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        if (ShapeExtKt.isEnum((Shape)shape)) {
            symbol2 = this.createEnumSymbol((Shape)shape);
        } else {
            Symbol symbol3 = this.createSymbolBuilder((Shape)shape, "String", "kotlin", true).build();
            symbol2 = symbol3;
            Intrinsics.checkNotNullExpressionValue((Object)symbol3, (String)"{\n        createSymbolBu\u2026= \"kotlin\").build()\n    }");
        }
        return symbol2;
    }

    private final Symbol createEnumSymbol(Shape shape) {
        String namespace = this.rootNamespace + ".model";
        Symbol symbol2 = this.createSymbolBuilder(shape, NamingKt.defaultName(shape, this.service), namespace, true).definitionFile(NamingKt.defaultName(shape, this.service) + ".kt").build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"createSymbolBuilder(shap\u2026kt\")\n            .build()");
        return symbol2;
    }

    @NotNull
    public Symbol booleanShape(@Nullable BooleanShape shape) {
        Symbol symbol2 = SymbolExtKt.defaultValue$default(KotlinSymbolProvider.createSymbolBuilder$default(this, (Shape)shape, "Boolean", "kotlin", false, 8, null), "false", null, 2, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"createSymbolBuilder(shap\u2026ultValue(\"false\").build()");
        return symbol2;
    }

    @NotNull
    public Symbol structureShape(@NotNull StructureShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        String name = NamingKt.defaultName((Shape)shape, this.service);
        String namespace = this.rootNamespace + ".model";
        Symbol.Builder builder = this.createSymbolBuilder((Shape)shape, name, namespace, true).definitionFile(name + ".kt");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        this.addDeclareMemberReferences(builder, shape.getAllMembers().values());
        Symbol symbol2 = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"builder.build()");
        return symbol2;
    }

    private final void addDeclareMemberReferences(Symbol.Builder builder, Collection<MemberShape> members) {
        if (this.depth > 1) {
            return;
        }
        Iterable $this$forEach$iv = members;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MemberShape it = (MemberShape)element$iv;
            boolean bl = false;
            Symbol memberSymbol = this.toSymbol((Shape)it);
            SymbolExtKt.addReference(builder, memberSymbol, SymbolReference.ContextOption.DECLARE);
            Shape shape = this.model.expectShape(it.getTarget());
            if (!(shape instanceof CollectionShape ? true : shape instanceof MapShape)) continue;
            this.addSymbolReferences(memberSymbol, builder);
        }
    }

    private final void addSymbolReferences(Symbol from2, Symbol.Builder to) {
        if (from2.getReferences().isEmpty()) {
            return;
        }
        List list = from2.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"from.references");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SymbolReference it = (SymbolReference)element$iv;
            boolean bl = false;
            Symbol symbol2 = it.getSymbol();
            Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"it.symbol");
            this.addSymbolReferences(symbol2, to);
            to.addReference(it);
        }
    }

    @NotNull
    public Symbol listShape(@NotNull ListShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        MemberShape memberShape2 = shape.getMember();
        Intrinsics.checkNotNullExpressionValue((Object)memberShape2, (String)"shape.member");
        Symbol reference = this.toSymbol((Shape)memberShape2);
        Shape $this$hasTrait$iv = (Shape)shape;
        boolean $i$f$hasTrait = false;
        String valueSuffix = $this$hasTrait$iv.hasTrait(SparseTrait.class) ? "?" : "";
        String valueType = reference.getName() + valueSuffix;
        String fullyQualifiedValueType = reference.getFullName() + valueSuffix;
        Symbol symbol2 = ((Symbol.Builder)((Symbol.Builder)((Symbol.Builder)KotlinSymbolProviderKt.access$addReferences(this.createSymbolBuilder((Shape)shape, "List<" + valueType + '>', true), reference).putProperty("fullyQualifiedNameHint", (Object)("List<" + fullyQualifiedValueType + '>'))).putProperty("mutableCollectionType", (Object)("mutableListOf<" + valueType + '>'))).putProperty("immutableCollectionType", (Object)("listOf<" + valueType + '>'))).build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"createSymbolBuilder(shap\u2026e>\")\n            .build()");
        return symbol2;
    }

    @NotNull
    public Symbol mapShape(@NotNull MapShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        MemberShape memberShape2 = shape.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)memberShape2, (String)"shape.value");
        Symbol reference = this.toSymbol((Shape)memberShape2);
        Shape $this$hasTrait$iv = (Shape)shape;
        boolean $i$f$hasTrait = false;
        String valueSuffix = $this$hasTrait$iv.hasTrait(SparseTrait.class) ? "?" : "";
        String valueType = reference.getName() + valueSuffix;
        String fullyQualifiedValueType = reference.getFullName() + valueSuffix;
        String keyType = KotlinTypes.INSTANCE.getString().getName();
        String fullyQualifiedKeyType = KotlinTypes.INSTANCE.getString().getFullName();
        Symbol symbol2 = ((Symbol.Builder)((Symbol.Builder)((Symbol.Builder)((Symbol.Builder)KotlinSymbolProviderKt.access$addReferences(this.createSymbolBuilder((Shape)shape, "Map<" + keyType + ", " + valueType + '>', true), reference).putProperty("fullyQualifiedNameHint", (Object)("Map<" + fullyQualifiedKeyType + ", " + fullyQualifiedValueType + '>'))).putProperty("mutableCollectionType", (Object)("mutableMapOf<" + keyType + ", " + valueType + '>'))).putProperty("immutableCollectionType", (Object)("mapOf<" + keyType + ", " + valueType + '>'))).putProperty("entryExpression", (Object)("Map.Entry<" + keyType + ", " + valueType + '>'))).build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"createSymbolBuilder(shap\u2026e>\")\n            .build()");
        return symbol2;
    }

    @NotNull
    public Symbol memberShape(@NotNull MemberShape shape) {
        Symbol symbol2;
        boolean isEventStream;
        Symbol.Builder builder;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape targetShape = (Shape)this.model.getShape(shape.getTarget()).orElseThrow(() -> KotlinSymbolProvider.memberShape$lambda$3(shape));
        Intrinsics.checkNotNullExpressionValue((Object)targetShape, (String)"targetShape");
        Symbol.Builder $this$memberShape_u24lambda_u245 = builder = this.toSymbol(targetShape).toBuilder();
        boolean bl = false;
        if (this.nullableIndex.isMemberNullable(shape, NullableIndex.CheckMode.CLIENT_ZERO_VALUE_V1_NO_INPUT)) {
            Intrinsics.checkNotNullExpressionValue((Object)$this$memberShape_u24lambda_u245, (String)"memberShape$lambda$5");
            SymbolExtKt.nullable($this$memberShape_u24lambda_u245);
        }
        Shape $this$hasTrait$iv = (Shape)shape;
        boolean $i$f$hasTrait = false;
        if (!$this$hasTrait$iv.hasTrait(ClientOptionalTrait.class)) {
            Shape $this$getTrait$iv = (Shape)shape;
            boolean $i$f$getTrait = false;
            Optional optional = $this$getTrait$iv.getTrait(DefaultTrait.class);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getTrait(T::class.java)");
            DefaultTrait defaultTrait = (DefaultTrait)((Trait)OptionalExtKt.getOrNull(optional));
            if (defaultTrait != null) {
                DefaultTrait it = defaultTrait;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$memberShape_u24lambda_u245, (String)"memberShape$lambda$5$lambda$4");
                SymbolExtKt.defaultValue($this$memberShape_u24lambda_u245, this.getDefaultValue(it, targetShape), DefaultValueType.MODELED);
            }
        }
        Symbol targetSymbol = builder.build();
        $this$memberShape_u24lambda_u245 = this.model.expectShape(shape.getContainer());
        StructureShape container = $this$memberShape_u24lambda_u245 instanceof StructureShape ? (StructureShape)$this$memberShape_u24lambda_u245 : null;
        boolean isOperationInputOrOutput = container != null && (ShapeExtKt.isOperationInput(container) || ShapeExtKt.isOperationOutput(container));
        boolean bl3 = isEventStream = ShapeExtKt.isStreaming(targetShape) && targetShape.isUnionShape();
        if (isOperationInputOrOutput && isEventStream) {
            symbol2 = SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)new Function1<SymbolBuilder, Unit>(targetSymbol){
                final /* synthetic */ Symbol $targetSymbol;
                {
                    this.$targetSymbol = $targetSymbol;
                    super(1);
                }

                public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                    Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                    $this$buildSymbol.setName("Flow<" + this.$targetSymbol.getFullName() + '>');
                    $this$buildSymbol.setNullable(true);
                    Symbol symbol2 = this.$targetSymbol;
                    Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"targetSymbol");
                    SymbolReference.ContextOption[] contextOptionArray = new SymbolReference.ContextOption[]{SymbolReference.ContextOption.DECLARE};
                    $this$buildSymbol.reference(symbol2, contextOptionArray);
                    contextOptionArray = new SymbolReference.ContextOption[]{SymbolReference.ContextOption.DECLARE};
                    $this$buildSymbol.reference(RuntimeTypes.KotlinxCoroutines.Flow.INSTANCE.getFlow(), contextOptionArray);
                }
            }));
        } else {
            Symbol symbol3 = targetSymbol;
            symbol2 = symbol3;
            Intrinsics.checkNotNullExpressionValue((Object)symbol3, (String)"{\n            targetSymbol\n        }");
        }
        return symbol2;
    }

    private final String getDefaultValue(DefaultTrait $this$getDefaultValue, Shape targetShape) {
        String string;
        Node node = $this$getDefaultValue.toNode();
        if (Intrinsics.areEqual((Object)node.toString(), (Object)"null") || targetShape instanceof BlobShape && Intrinsics.areEqual((Object)node.toString(), (Object)"")) {
            string = null;
        } else if (ShapeExtKt.isEnum(targetShape)) {
            String string2;
            Symbol enumSymbol = this.toSymbol(targetShape);
            if (targetShape.isStringShape()) {
                string2 = StringsKt.dq(node.toString());
            } else if (targetShape.isIntEnumShape()) {
                string2 = this.getDefaultValueForNumber(ShapeType.INTEGER, node.toString());
            } else {
                throw new CodegenException("Unknown enum type for " + targetShape);
            }
            String arg = string2;
            string = enumSymbol.getFullName() + ".fromValue(" + arg + ')';
        } else if (node.isNumberNode()) {
            ShapeType shapeType = targetShape.getType();
            Intrinsics.checkNotNullExpressionValue((Object)shapeType, (String)"targetShape.type");
            string = this.getDefaultValueForNumber(shapeType, node.toString());
        } else {
            string = node.isArrayNode() ? "listOf()" : (node.isObjectNode() ? "mapOf()" : (node.isStringNode() ? StringsKt.dq(node.toString()) : node.toString()));
        }
        return string;
    }

    @NotNull
    public Symbol timestampShape(@Nullable TimestampShape shape) {
        KotlinDependency dependency = KotlinDependency.Companion.getCORE();
        Symbol symbol2 = this.createSymbolBuilder((Shape)shape, "Instant", true).namespace(dependency.getNamespace() + ".time", ".").addDependency((SymbolDependencyContainer)dependency).build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"createSymbolBuilder(shap\u2026ncy)\n            .build()");
        return symbol2;
    }

    @NotNull
    public Symbol blobShape(@NotNull BlobShape shape) {
        Symbol symbol2;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape $this$hasTrait$iv = (Shape)shape;
        boolean $i$f$hasTrait = false;
        if ($this$hasTrait$iv.hasTrait(StreamingTrait.class)) {
            symbol2 = SymbolExtKt.asNullable(RuntimeTypes.Core.Content.INSTANCE.getByteStream());
        } else {
            Symbol symbol3 = this.createSymbolBuilder((Shape)shape, "ByteArray", "kotlin", true).build();
            symbol2 = symbol3;
            Intrinsics.checkNotNullExpressionValue((Object)symbol3, (String)"{\n        createSymbolBu\u2026= \"kotlin\").build()\n    }");
        }
        return symbol2;
    }

    @NotNull
    public Symbol documentShape(@Nullable DocumentShape shape) {
        return SymbolExtKt.asNullable(RuntimeTypes.Core.Content.INSTANCE.getDocument());
    }

    @NotNull
    public Symbol unionShape(@NotNull UnionShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        String name = NamingKt.defaultName((Shape)shape, this.service);
        String namespace = this.rootNamespace + ".model";
        Symbol.Builder builder = this.createSymbolBuilder((Shape)shape, name, namespace, true).definitionFile(name + ".kt");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        this.addDeclareMemberReferences(builder, shape.getAllMembers().values());
        Symbol symbol2 = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"builder.build()");
        return symbol2;
    }

    @NotNull
    public Symbol resourceShape(@Nullable ResourceShape shape) {
        Symbol symbol2 = KotlinSymbolProvider.createSymbolBuilder$default(this, (Shape)shape, "Resource", false, 4, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"createSymbolBuilder(shape, \"Resource\").build()");
        return symbol2;
    }

    @NotNull
    public Symbol operationShape(@Nullable OperationShape shape) {
        throw new IllegalStateException(((Object)((Object)operationShape.1.INSTANCE)).toString());
    }

    @NotNull
    public Symbol serviceShape(@NotNull ServiceShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        String serviceName = NamingKt.clientName(this.settings.getSdkId());
        Symbol symbol2 = KotlinSymbolProvider.createSymbolBuilder$default(this, (Shape)shape, serviceName + "Client", false, 4, null).namespace(this.rootNamespace, ".").definitionFile(serviceName + "Client.kt").build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"createSymbolBuilder(shap\u2026eName}Client.kt\").build()");
        return symbol2;
    }

    private final Symbol.Builder createSymbolBuilder(Shape shape, String typeName, boolean nullable) {
        Symbol.Builder builder = ((Symbol.Builder)Symbol.builder().putProperty("shape", (Object)shape)).name(typeName);
        if (nullable) {
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
            SymbolExtKt.nullable(builder);
        }
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        return builder;
    }

    static /* synthetic */ Symbol.Builder createSymbolBuilder$default(KotlinSymbolProvider kotlinSymbolProvider, Shape shape, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return kotlinSymbolProvider.createSymbolBuilder(shape, string, bl);
    }

    private final String getDefaultValueForNumber(ShapeType type, String value) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                string = value + 'L';
                break;
            }
            case 2: {
                string = value + 'f';
                break;
            }
            case 3: {
                CharSequence charSequence = value;
                if (new Regex("[0-9]*\\.[0-9]+").matches(charSequence)) {
                    string = value;
                    break;
                }
                string = value + ".0";
                break;
            }
            case 4: {
                string = value + ".toShort()";
                break;
            }
            case 5: {
                string = value + ".toByte()";
                break;
            }
            default: {
                string = value;
            }
        }
        return string;
    }

    private final Symbol.Builder createSymbolBuilder(Shape shape, String typeName, String namespace, boolean nullable) {
        Symbol.Builder builder = this.createSymbolBuilder(shape, typeName, nullable).namespace(namespace, ".");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"createSymbolBuilder(shap\u2026namespace(namespace, \".\")");
        return builder;
    }

    static /* synthetic */ Symbol.Builder createSymbolBuilder$default(KotlinSymbolProvider kotlinSymbolProvider, Shape shape, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return kotlinSymbolProvider.createSymbolBuilder(shape, string, string2, bl);
    }

    private static final boolean _init_$lambda$0(Shape shape, Symbol symbol2) {
        String string = symbol2.getDefinitionFile();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"symbol.definitionFile");
        return ((CharSequence)string).length() > 0;
    }

    private static final CodegenException memberShape$lambda$3(MemberShape $shape) {
        Intrinsics.checkNotNullParameter((Object)$shape, (String)"$shape");
        return new CodegenException("Shape not found: " + $shape.getTarget());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinSymbolProvider$Companion;", "", "()V", "isTypeGeneratedForShape", "", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "smithy-kotlin-codegen"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isTypeGeneratedForShape(@NotNull Shape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return ShapeExtKt.isEnum(shape) || shape.isStructureShape() || shape.isUnionShape();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShapeType.values().length];
            try {
                nArray[ShapeType.LONG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.FLOAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.DOUBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.BYTE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

