/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilder;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingDescriptor;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.NumberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ShapeType;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a*\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u0002`\r\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0006\u001a\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\b\u0012\u0004\u0012\u00020\u00120\u0010\u00a8\u0006\u0013"}, d2={"stringToNumber", "", "shape", "Lsoftware/amazon/smithy/model/shapes/NumberShape;", "errorHandler", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "block", "Lkotlin/Function1;", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "", "Lsoftware/amazon/smithy/kotlin/codegen/core/SymbolRenderer;", "errorHandlerName", "filterDocumentBoundMembers", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingDescriptor;", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nHttpBindingProtocolGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpBindingProtocolGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingProtocolGeneratorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,984:1\n766#2:985\n857#2,2:986\n1045#2:988\n1549#2:989\n1620#2,3:990\n*S KotlinDebug\n*F\n+ 1 HttpBindingProtocolGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingProtocolGeneratorKt\n*L\n965#1:985\n965#1:986,2\n966#1:988\n967#1:989\n967#1:990,3\n*E\n"})
public final class HttpBindingProtocolGeneratorKt {
    @NotNull
    public static final String stringToNumber(@NotNull NumberShape shape) {
        String string;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        ShapeType shapeType = shape.getType();
        switch (shapeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[shapeType.ordinal()]) {
            case 1: {
                string = "toByte()";
                break;
            }
            case 2: {
                string = "toShort()";
                break;
            }
            case 3: {
                string = "toInt()";
                break;
            }
            case 4: {
                string = "toLong()";
                break;
            }
            case 5: {
                string = "toFloat()";
                break;
            }
            case 6: {
                string = "toDouble()";
                break;
            }
            default: {
                throw new CodegenException("unknown number shape: " + shape);
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<MemberShape> filterDocumentBoundMembers(@NotNull List<HttpBindingDescriptor> $this$filterDocumentBoundMembers) {
        void $this$mapTo$iv$iv;
        HttpBindingDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterDocumentBoundMembers, (String)"<this>");
        Iterable $this$filter$iv = $this$filterDocumentBoundMembers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (HttpBindingDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it.getLocation() == HttpBinding.Location.DOCUMENT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                HttpBindingDescriptor it = (HttpBindingDescriptor)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getMemberName());
                it = (HttpBindingDescriptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMemberName())));
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (HttpBindingDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMember());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String errorHandlerName(@NotNull OperationShape $this$errorHandlerName) {
        Intrinsics.checkNotNullParameter((Object)$this$errorHandlerName, (String)"<this>");
        return "throw" + NamingKt.capitalizedDefaultName($this$errorHandlerName) + "Error";
    }

    @NotNull
    public static final Symbol errorHandler(@NotNull OperationShape $this$errorHandler, @NotNull KotlinSettings settings, @NotNull Function1<? super KotlinWriter, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$errorHandler, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)new Function1<SymbolBuilder, Unit>($this$errorHandler, settings, block){
            final /* synthetic */ OperationShape $this_errorHandler;
            final /* synthetic */ KotlinSettings $settings;
            final /* synthetic */ Function1<KotlinWriter, Unit> $block;
            {
                this.$this_errorHandler = $receiver;
                this.$settings = $settings;
                this.$block = $block;
                super(1);
            }

            public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                $this$buildSymbol.setName(HttpBindingProtocolGeneratorKt.errorHandlerName(this.$this_errorHandler));
                $this$buildSymbol.setNamespace(this.$settings.getPkg().getName() + ".transform");
                $this$buildSymbol.setDefinitionFile(SerdeExtKt.deserializerName(this.$this_errorHandler) + ".kt");
                $this$buildSymbol.setRenderBy(this.$block);
            }
        }));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShapeType.values().length];
            try {
                nArray[ShapeType.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.SHORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.INTEGER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.LONG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.FLOAT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.DOUBLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

