/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.CodegenContext;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.integration.SectionId;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilder;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ExceptionBaseClassGenerator;", "", "()V", "baseExceptionSymbol", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "checkForCollision", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/core/CodegenContext;", "exceptionSymbol", "render", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "ExceptionBaseClassSection", "smithy-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nExceptionBaseClassGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionBaseClassGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/ExceptionBaseClassGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1#2:75\n1855#3:76\n1194#3,2:77\n1222#3,4:79\n1856#3:83\n*S KotlinDebug\n*F\n+ 1 ExceptionBaseClassGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/rendering/ExceptionBaseClassGenerator\n*L\n66#1:76\n67#1:77,2\n67#1:79,4\n66#1:83\n*E\n"})
public final class ExceptionBaseClassGenerator {
    @NotNull
    public static final ExceptionBaseClassGenerator INSTANCE = new ExceptionBaseClassGenerator();

    private ExceptionBaseClassGenerator() {
    }

    public final void render(@NotNull CodegenContext ctx, @NotNull KotlinWriter writer) {
        Symbol symbol2;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        ProtocolGenerator protocolGenerator = ctx.getProtocolGenerator();
        if (protocolGenerator == null || (protocolGenerator = protocolGenerator.getExceptionBaseClassSymbol()) == null) {
            protocolGenerator = ProtocolGenerator.Companion.getDefaultServiceExceptionSymbol();
        }
        ProtocolGenerator baseException = protocolGenerator;
        KotlinWriter.addImport$default(writer, (Symbol)baseException, null, 2, null);
        Symbol it = symbol2 = this.baseExceptionSymbol(ctx.getSettings());
        boolean bl = false;
        INSTANCE.checkForCollision(ctx, it);
        Symbol serviceException = symbol2;
        String name = NamingKt.clientName(ctx.getSettings().getSdkId());
        writer.dokka("Base class for all service related exceptions thrown by the " + name + " client");
        Object[] objectArray = new Object[]{serviceException, baseException};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)writer, "public open class #T : #T {", "}", objectArray, (Function1)new Function1<KotlinWriter, Unit>(writer){
            final /* synthetic */ KotlinWriter $writer;
            {
                this.$writer = $writer;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                $this$withBlock.write("public constructor() : super()", new Object[0]);
                $this$withBlock.write("public constructor(message: String?) : super(message)", new Object[0]);
                $this$withBlock.write("public constructor(message: String?, cause: Throwable?) : super(message, cause)", new Object[0]);
                $this$withBlock.write("public constructor(cause: Throwable?) : super(cause)", new Object[0]);
                AbstractCodeWriterExtKt.declareSection$default(this.$writer, ExceptionBaseClassSection.INSTANCE, null, null, 6, null);
            }
        });
    }

    @NotNull
    public final Symbol baseExceptionSymbol(@NotNull KotlinSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)new Function1<SymbolBuilder, Unit>(settings){
            final /* synthetic */ KotlinSettings $settings;
            {
                this.$settings = $settings;
                super(1);
            }

            public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                String serviceName = NamingKt.clientName(this.$settings.getSdkId());
                $this$buildSymbol.setName(serviceName + "Exception");
                $this$buildSymbol.setNamespace(this.$settings.getPkg().getName() + ".model");
                $this$buildSymbol.setDefinitionFile($this$buildSymbol.getName() + ".kt");
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void checkForCollision(CodegenContext ctx, Symbol exceptionSymbol) {
        TopDownIndex topDownIndex = TopDownIndex.of((Model)ctx.getModel());
        Set operations = topDownIndex.getContainedOperations((ToShapeId)ctx.getSettings().getService());
        Intrinsics.checkNotNullExpressionValue((Object)operations, (String)"operations");
        Iterable $this$forEach$iv = operations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$associateByTo$iv$iv;
            OperationShape operationShape2 = (OperationShape)element$iv;
            boolean bl = false;
            List list = operationShape2.getErrors();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"operationShape.errors");
            Iterable $this$associateBy$iv = list;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void shapeId;
                ShapeId shapeId2 = (ShapeId)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl2 = false;
                map.put(shapeId.getName(), element$iv$iv);
            }
            Map errorNameToShapeIndex = destination$iv$iv;
            if (!errorNameToShapeIndex.containsKey(exceptionSymbol.getName())) continue;
            throw new CodegenException("Generated base error type '" + exceptionSymbol.getName() + "' collides with " + errorNameToShapeIndex.get(exceptionSymbol.getName()) + '.');
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/ExceptionBaseClassGenerator$ExceptionBaseClassSection;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "()V", "smithy-kotlin-codegen"})
    public static final class ExceptionBaseClassSection
    implements SectionId {
        @NotNull
        public static final ExceptionBaseClassSection INSTANCE = new ExceptionBaseClassSection();

        private ExceptionBaseClassSection() {
        }
    }
}

