/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\u001f\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\rH\u0002\u00a2\u0006\u0002\u0010\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"BUILD_SETTINGS", "", "PACKAGE_DESCRIPTION", "PACKAGE_NAME", "PACKAGE_SETTINGS", "PACKAGE_VERSION", "SDK_ID", "SERVICE", "inferService", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "Lsoftware/amazon/smithy/model/Model;", "orNull", "T", "Ljava/util/Optional;", "(Ljava/util/Optional;)Ljava/lang/Object;", "smithy-kotlin-codegen"})
public final class KotlinSettingsKt {
    @NotNull
    private static final String SERVICE = "service";
    @NotNull
    private static final String PACKAGE_SETTINGS = "package";
    @NotNull
    private static final String PACKAGE_NAME = "name";
    @NotNull
    private static final String PACKAGE_VERSION = "version";
    @NotNull
    private static final String PACKAGE_DESCRIPTION = "description";
    @NotNull
    private static final String BUILD_SETTINGS = "build";
    @NotNull
    private static final String SDK_ID = "sdkId";

    @NotNull
    public static final ShapeId inferService(@NotNull Model $this$inferService) {
        Intrinsics.checkNotNullParameter((Object)$this$inferService, (String)"<this>");
        Stream<ShapeId> stream = $this$inferService.shapes(ServiceShape.class).map(Shape::getId).sorted();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"shapes(ServiceShape::cla\u2026:getId)\n        .sorted()");
        List services = StreamsKt.toList(stream);
        if (services.isEmpty()) {
            throw new CodegenException("Cannot infer a service to generate because the model does not contain any service shapes");
        }
        if (services.size() > 1) {
            throw new CodegenException("Cannot infer service to generate because the model contains multiple service shapes: " + services);
        }
        Object object = CollectionsKt.single((List)services);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"services.single()");
        return (ShapeId)object;
    }

    private static final <T> T orNull(Optional<T> $this$orNull) {
        return $this$orNull.isPresent() ? (T)$this$orNull.get() : null;
    }

    public static final /* synthetic */ Object access$orNull(Optional $receiver) {
        return KotlinSettingsKt.orNull($receiver);
    }
}

