/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.core;

import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.smithy.codegen.core.CodegenException;
import software.amazon.smithy.codegen.core.ReservedWordSymbolProvider;
import software.amazon.smithy.codegen.core.ReservedWords;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.codegen.core.SymbolDependencyContainer;
import software.amazon.smithy.codegen.core.SymbolProvider;
import software.amazon.smithy.codegen.core.SymbolReference;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.core.KotlinDependency;
import software.amazon.smithy.kotlin.codegen.core.KotlinSymbolProvider;
import software.amazon.smithy.kotlin.codegen.core.KotlinSymbolProviderKt;
import software.amazon.smithy.kotlin.codegen.core.NamingKt;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.lang.ReservedWordsKt;
import software.amazon.smithy.kotlin.codegen.model.ShapeExtKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilder;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.model.SymbolExtKt;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.SparseTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.traits.UniqueItemsTrait;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 T2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001TB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\u0012\u0010\u001e\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0012\u0010!\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010&H\u0016J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020(H\u0016J\u001a\u0010)\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u0011H\u0002J\u0010\u0010,\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020-H\u0002J$\u0010.\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010*2\u0006\u0010/\u001a\u00020\u00112\b\b\u0002\u00100\u001a\u000201H\u0002J,\u0010.\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010*2\u0006\u0010/\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u00112\b\b\u0002\u00100\u001a\u000201H\u0002J\u0012\u00103\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u000104H\u0016J\u0010\u00105\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u001aH\u0016J\"\u0010B\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020*2\u0006\u0010/\u001a\u00020\u00112\b\b\u0002\u0010C\u001a\u00020\u0011H\u0002J\u0012\u0010D\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010EH\u0016J\u0012\u0010F\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010GH\u0016J\u0010\u0010H\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\u0010\u0010I\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020JH\u0016J\u0010\u0010K\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020-H\u0016J\u0010\u0010L\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020MH\u0016J\u0012\u0010N\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010OH\u0016J\u0010\u0010P\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u001aH\u0016J\u0010\u0010Q\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020*H\u0016J\u0010\u0010R\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020SH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinSymbolProvider;", "Lsoftware/amazon/smithy/codegen/core/SymbolProvider;", "Lsoftware/amazon/smithy/model/shapes/ShapeVisitor;", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "model", "Lsoftware/amazon/smithy/model/Model;", "settings", "Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;", "(Lsoftware/amazon/smithy/model/Model;Lsoftware/amazon/smithy/kotlin/codegen/KotlinSettings;)V", "depth", "", "escaper", "Lsoftware/amazon/smithy/codegen/core/ReservedWordSymbolProvider$Escaper;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "rootNamespace", "", "service", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "addDeclareMemberReferences", "", "builder", "Lsoftware/amazon/smithy/codegen/core/Symbol$Builder;", "members", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "addSymbolReferences", "from", "to", "bigDecimalShape", "shape", "Lsoftware/amazon/smithy/model/shapes/BigDecimalShape;", "bigIntegerShape", "Lsoftware/amazon/smithy/model/shapes/BigIntegerShape;", "blobShape", "Lsoftware/amazon/smithy/model/shapes/BlobShape;", "booleanShape", "Lsoftware/amazon/smithy/model/shapes/BooleanShape;", "byteShape", "Lsoftware/amazon/smithy/model/shapes/ByteShape;", "createBigSymbol", "Lsoftware/amazon/smithy/model/shapes/Shape;", "symbolName", "createEnumSymbol", "Lsoftware/amazon/smithy/model/shapes/StringShape;", "createSymbolBuilder", "typeName", "boxed", "", "namespace", "documentShape", "Lsoftware/amazon/smithy/model/shapes/DocumentShape;", "doubleShape", "Lsoftware/amazon/smithy/model/shapes/DoubleShape;", "floatShape", "Lsoftware/amazon/smithy/model/shapes/FloatShape;", "integerShape", "Lsoftware/amazon/smithy/model/shapes/IntegerShape;", "listShape", "Lsoftware/amazon/smithy/model/shapes/ListShape;", "longShape", "Lsoftware/amazon/smithy/model/shapes/LongShape;", "mapShape", "Lsoftware/amazon/smithy/model/shapes/MapShape;", "memberShape", "numberShape", "defaultValue", "operationShape", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "resourceShape", "Lsoftware/amazon/smithy/model/shapes/ResourceShape;", "serviceShape", "shortShape", "Lsoftware/amazon/smithy/model/shapes/ShortShape;", "stringShape", "structureShape", "Lsoftware/amazon/smithy/model/shapes/StructureShape;", "timestampShape", "Lsoftware/amazon/smithy/model/shapes/TimestampShape;", "toMemberName", "toSymbol", "unionShape", "Lsoftware/amazon/smithy/model/shapes/UnionShape;", "Companion", "smithy-kotlin-codegen"})
public final class KotlinSymbolProvider
implements SymbolProvider,
ShapeVisitor<Symbol> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Model model;
    @NotNull
    private final KotlinSettings settings;
    @NotNull
    private final String rootNamespace;
    @NotNull
    private final ServiceShape service;
    private final Logger logger;
    @NotNull
    private final ReservedWordSymbolProvider.Escaper escaper;
    private int depth;

    /*
     * WARNING - void declaration
     */
    public KotlinSymbolProvider(@NotNull Model model, @NotNull KotlinSettings settings) {
        void $this$expectShape$iv;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.model = model;
        this.settings = settings;
        this.rootNamespace = this.settings.getPkg().getName();
        Model model2 = this.model;
        ShapeId shapeId$iv = this.settings.getService();
        boolean $i$f$expectShape = false;
        Shape shape = $this$expectShape$iv.expectShape(shapeId$iv, ServiceShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(shapeId, T::class.java)");
        this.service = (ServiceShape)shape;
        this.logger = Logger.getLogger(this.getClass().getName());
        ReservedWords reservedWords = ReservedWordsKt.kotlinReservedWords();
        ReservedWordSymbolProvider.Escaper escaper = ReservedWordSymbolProvider.builder().nameReservedWords(reservedWords).memberReservedWords(reservedWords).escapePredicate(KotlinSymbolProvider::_init_$lambda-0).buildEscaper();
        Intrinsics.checkNotNullExpressionValue((Object)escaper, (String)"builder()\n            .n\u2026          .buildEscaper()");
        this.escaper = escaper;
    }

    @NotNull
    public Symbol toSymbol(@NotNull Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        int n = this.depth;
        this.depth = n + 1;
        Object object = shape.accept((ShapeVisitor)this);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"shape.accept(this)");
        Symbol symbol = (Symbol)object;
        int n2 = this.depth;
        this.depth = n2 + -1;
        this.logger.fine("creating symbol from " + shape + ": " + symbol);
        Symbol symbol2 = this.escaper.escapeSymbol(shape, symbol);
        Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"escaper.escapeSymbol(shape, symbol)");
        return symbol2;
    }

    @NotNull
    public String toMemberName(@NotNull MemberShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        String string = this.escaper.escapeMemberName(NamingKt.defaultName(shape));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escaper.escapeMemberName(shape.defaultName())");
        return string;
    }

    @NotNull
    public Symbol byteShape(@NotNull ByteShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return KotlinSymbolProvider.numberShape$default(this, (Shape)shape, "Byte", null, 4, null);
    }

    @NotNull
    public Symbol integerShape(@NotNull IntegerShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return KotlinSymbolProvider.numberShape$default(this, (Shape)shape, "Int", null, 4, null);
    }

    @NotNull
    public Symbol shortShape(@NotNull ShortShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return KotlinSymbolProvider.numberShape$default(this, (Shape)shape, "Short", null, 4, null);
    }

    @NotNull
    public Symbol longShape(@NotNull LongShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return this.numberShape((Shape)shape, "Long", "0L");
    }

    @NotNull
    public Symbol floatShape(@NotNull FloatShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return this.numberShape((Shape)shape, "Float", "0.0f");
    }

    @NotNull
    public Symbol doubleShape(@NotNull DoubleShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return this.numberShape((Shape)shape, "Double", "0.0");
    }

    private final Symbol numberShape(Shape shape, String typeName, String defaultValue) {
        Symbol symbol = SymbolExtKt.defaultValue(KotlinSymbolProvider.createSymbolBuilder$default(this, shape, typeName, "kotlin", false, 8, null), defaultValue).build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"createSymbolBuilder(shap\u2026lue)\n            .build()");
        return symbol;
    }

    static /* synthetic */ Symbol numberShape$default(KotlinSymbolProvider kotlinSymbolProvider, Shape shape, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "0";
        }
        return kotlinSymbolProvider.numberShape(shape, string, string2);
    }

    @NotNull
    public Symbol bigIntegerShape(@Nullable BigIntegerShape shape) {
        return this.createBigSymbol((Shape)shape, "BigInteger");
    }

    @NotNull
    public Symbol bigDecimalShape(@Nullable BigDecimalShape shape) {
        return this.createBigSymbol((Shape)shape, "BigDecimal");
    }

    private final Symbol createBigSymbol(Shape shape, String symbolName) {
        Symbol symbol = this.createSymbolBuilder(shape, symbolName, "java.math", true).build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"createSymbolBuilder(shap\u2026h\", boxed = true).build()");
        return symbol;
    }

    @NotNull
    public Symbol stringShape(@NotNull StringShape shape) {
        Symbol symbol;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        if (ShapeExtKt.isEnum((Shape)shape)) {
            symbol = this.createEnumSymbol(shape);
        } else {
            Symbol symbol2 = this.createSymbolBuilder((Shape)shape, "String", "kotlin", true).build();
            symbol = symbol2;
            Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"{\n        createSymbolBu\u2026= \"kotlin\").build()\n    }");
        }
        return symbol;
    }

    private final Symbol createEnumSymbol(StringShape shape) {
        String namespace = this.rootNamespace + ".model";
        Symbol symbol = this.createSymbolBuilder((Shape)shape, NamingKt.defaultName((Shape)shape, this.service), namespace, true).definitionFile(NamingKt.defaultName((Shape)shape, this.service) + ".kt").build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"createSymbolBuilder(shap\u2026kt\")\n            .build()");
        return symbol;
    }

    @NotNull
    public Symbol booleanShape(@Nullable BooleanShape shape) {
        Symbol symbol = SymbolExtKt.defaultValue(KotlinSymbolProvider.createSymbolBuilder$default(this, (Shape)shape, "Boolean", "kotlin", false, 8, null), "false").build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"createSymbolBuilder(shap\u2026ultValue(\"false\").build()");
        return symbol;
    }

    @NotNull
    public Symbol structureShape(@NotNull StructureShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        String name = NamingKt.defaultName((Shape)shape, this.service);
        String namespace = this.rootNamespace + ".model";
        Symbol.Builder builder = this.createSymbolBuilder((Shape)shape, name, namespace, true).definitionFile(name + ".kt");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        this.addDeclareMemberReferences(builder, shape.getAllMembers().values());
        Symbol symbol = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"builder.build()");
        return symbol;
    }

    private final void addDeclareMemberReferences(Symbol.Builder builder, Collection<MemberShape> members) {
        if (this.depth > 1) {
            return;
        }
        Iterable $this$forEach$iv = members;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MemberShape it = (MemberShape)element$iv;
            boolean bl = false;
            Symbol memberSymbol = this.toSymbol((Shape)it);
            SymbolExtKt.addReference(builder, memberSymbol, SymbolReference.ContextOption.DECLARE);
            Shape shape = this.model.expectShape(it.getTarget());
            if (!(shape instanceof CollectionShape ? true : shape instanceof MapShape)) continue;
            this.addSymbolReferences(memberSymbol, builder);
        }
    }

    private final void addSymbolReferences(Symbol from, Symbol.Builder to) {
        if (from.getReferences().isEmpty()) {
            return;
        }
        List list = from.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"from.references");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SymbolReference it = (SymbolReference)element$iv;
            boolean bl = false;
            Symbol symbol = it.getSymbol();
            Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"it.symbol");
            this.addSymbolReferences(symbol, to);
            to.addReference(it);
        }
    }

    @NotNull
    public Symbol listShape(@NotNull ListShape shape) {
        Symbol symbol;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        MemberShape memberShape2 = shape.getMember();
        Intrinsics.checkNotNullExpressionValue((Object)memberShape2, (String)"shape.member");
        Symbol reference = this.toSymbol((Shape)memberShape2);
        Shape $this$hasTrait$iv = (Shape)shape;
        boolean $i$f$hasTrait = false;
        String valueType = $this$hasTrait$iv.hasTrait(SparseTrait.class) ? reference.getName() + '?' : reference.getName();
        $this$hasTrait$iv = (Shape)shape;
        $i$f$hasTrait = false;
        if ($this$hasTrait$iv.hasTrait(UniqueItemsTrait.class)) {
            Symbol symbol2 = ((Symbol.Builder)((Symbol.Builder)this.createSymbolBuilder((Shape)shape, "Set<" + valueType + '>', true).addReference(reference).putProperty("mutableCollectionType", (Object)("mutableSetOf<" + valueType + '>'))).putProperty("immutableCollectionType", (Object)("setOf<" + valueType + '>'))).build();
            symbol = symbol2;
            Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"{\n            createSymb\u2026       .build()\n        }");
        } else {
            Symbol symbol3 = ((Symbol.Builder)((Symbol.Builder)KotlinSymbolProviderKt.access$addReferences(this.createSymbolBuilder((Shape)shape, "List<" + valueType + '>', true), reference).putProperty("mutableCollectionType", (Object)("mutableListOf<" + valueType + '>'))).putProperty("immutableCollectionType", (Object)("listOf<" + valueType + '>'))).build();
            symbol = symbol3;
            Intrinsics.checkNotNullExpressionValue((Object)symbol3, (String)"{\n            createSymb\u2026       .build()\n        }");
        }
        return symbol;
    }

    @NotNull
    public Symbol mapShape(@NotNull MapShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        MemberShape memberShape2 = shape.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)memberShape2, (String)"shape.value");
        Symbol reference = this.toSymbol((Shape)memberShape2);
        Shape $this$hasTrait$iv = (Shape)shape;
        boolean $i$f$hasTrait = false;
        String valueType = $this$hasTrait$iv.hasTrait(SparseTrait.class) ? reference.getName() + '?' : reference.getName();
        Symbol symbol = ((Symbol.Builder)((Symbol.Builder)((Symbol.Builder)KotlinSymbolProviderKt.access$addReferences(this.createSymbolBuilder((Shape)shape, "Map<String, " + valueType + '>', true), reference).putProperty("mutableCollectionType", (Object)("mutableMapOf<String, " + valueType + '>'))).putProperty("immutableCollectionType", (Object)("mapOf<String, " + valueType + '>'))).putProperty("entryExpression", (Object)("Map.Entry<String, " + valueType + '>'))).build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"createSymbolBuilder(shap\u2026e>\")\n            .build()");
        return symbol;
    }

    @NotNull
    public Symbol memberShape(@NotNull MemberShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape targetShape = (Shape)this.model.getShape(shape.getTarget()).orElseThrow(() -> KotlinSymbolProvider.memberShape$lambda-3(shape));
        Intrinsics.checkNotNullExpressionValue((Object)targetShape, (String)"targetShape");
        Symbol targetSymbol = this.toSymbol(targetShape);
        Shape shape2 = this.model.expectShape(shape.getContainer());
        StructureShape container = shape2 instanceof StructureShape ? (StructureShape)shape2 : null;
        boolean isOperationInputOrOutput = container != null && (ShapeExtKt.isOperationInput(container) || ShapeExtKt.isOperationOutput(container));
        boolean isEventStream = ShapeExtKt.isStreaming(targetShape) && targetShape.isUnionShape();
        return isOperationInputOrOutput && isEventStream ? SymbolBuilderKt.buildSymbol((Function1<? super SymbolBuilder, Unit>)((Function1)new Function1<SymbolBuilder, Unit>(targetSymbol){
            final /* synthetic */ Symbol $targetSymbol;
            {
                this.$targetSymbol = $targetSymbol;
                super(1);
            }

            public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                $this$buildSymbol.setName("Flow<" + this.$targetSymbol.getFullName() + '>');
                $this$buildSymbol.setNullable(true);
                SymbolReference.ContextOption[] contextOptionArray = new SymbolReference.ContextOption[]{SymbolReference.ContextOption.DECLARE};
                $this$buildSymbol.reference(this.$targetSymbol, contextOptionArray);
                contextOptionArray = new SymbolReference.ContextOption[]{SymbolReference.ContextOption.DECLARE};
                $this$buildSymbol.reference(RuntimeTypes.KotlinxCoroutines.Flow.INSTANCE.getFlow(), contextOptionArray);
            }
        })) : targetSymbol;
    }

    @NotNull
    public Symbol timestampShape(@Nullable TimestampShape shape) {
        KotlinDependency dependency = KotlinDependency.Companion.getCORE();
        Symbol symbol = this.createSymbolBuilder((Shape)shape, "Instant", true).namespace(dependency.getNamespace() + ".time", ".").addDependency((SymbolDependencyContainer)dependency).build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"createSymbolBuilder(shap\u2026ncy)\n            .build()");
        return symbol;
    }

    @NotNull
    public Symbol blobShape(@NotNull BlobShape shape) {
        Symbol symbol;
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Shape $this$hasTrait$iv = (Shape)shape;
        boolean $i$f$hasTrait = false;
        if ($this$hasTrait$iv.hasTrait(StreamingTrait.class)) {
            KotlinDependency dependency = KotlinDependency.Companion.getCORE();
            Symbol symbol2 = this.createSymbolBuilder((Shape)shape, "ByteStream", true).namespace(dependency.getNamespace() + ".content", ".").addDependency((SymbolDependencyContainer)dependency).build();
            symbol = symbol2;
            Intrinsics.checkNotNullExpressionValue((Object)symbol2, (String)"{\n        val dependency\u2026           .build()\n    }");
        } else {
            Symbol symbol3 = this.createSymbolBuilder((Shape)shape, "ByteArray", "kotlin", true).build();
            symbol = symbol3;
            Intrinsics.checkNotNullExpressionValue((Object)symbol3, (String)"{\n        createSymbolBu\u2026= \"kotlin\").build()\n    }");
        }
        return symbol;
    }

    @NotNull
    public Symbol documentShape(@Nullable DocumentShape shape) {
        KotlinDependency dependency = KotlinDependency.Companion.getCORE();
        Symbol symbol = this.createSymbolBuilder((Shape)shape, "Document", true).namespace(dependency.getNamespace() + ".smithy", ".").addDependency((SymbolDependencyContainer)dependency).build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"createSymbolBuilder(shap\u2026ncy)\n            .build()");
        return symbol;
    }

    @NotNull
    public Symbol unionShape(@NotNull UnionShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        String name = NamingKt.defaultName((Shape)shape, this.service);
        String namespace = this.rootNamespace + ".model";
        Symbol.Builder builder = this.createSymbolBuilder((Shape)shape, name, namespace, true).definitionFile(name + ".kt");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        this.addDeclareMemberReferences(builder, shape.getAllMembers().values());
        Symbol symbol = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"builder.build()");
        return symbol;
    }

    @NotNull
    public Symbol resourceShape(@Nullable ResourceShape shape) {
        Symbol symbol = KotlinSymbolProvider.createSymbolBuilder$default(this, (Shape)shape, "Resource", false, 4, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"createSymbolBuilder(shape, \"Resource\").build()");
        return symbol;
    }

    @NotNull
    public Symbol operationShape(@Nullable OperationShape shape) {
        throw new IllegalStateException(((Object)((Object)operationShape.1.INSTANCE)).toString());
    }

    @NotNull
    public Symbol serviceShape(@NotNull ServiceShape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        String serviceName = NamingKt.clientName(this.settings.getSdkId());
        Symbol symbol = KotlinSymbolProvider.createSymbolBuilder$default(this, (Shape)shape, serviceName + "Client", false, 4, null).namespace(this.rootNamespace, ".").definitionFile(serviceName + "Client.kt").build();
        Intrinsics.checkNotNullExpressionValue((Object)symbol, (String)"createSymbolBuilder(shap\u2026eName}Client.kt\").build()");
        return symbol;
    }

    private final Symbol.Builder createSymbolBuilder(Shape shape, String typeName, boolean boxed) {
        boolean explicitlyBoxed;
        boolean bl;
        Symbol.Builder builder = ((Symbol.Builder)Symbol.builder().putProperty("shape", (Object)shape)).name(typeName);
        Shape shape2 = shape;
        if (shape2 != null) {
            Shape $this$hasTrait$iv = shape2;
            boolean $i$f$hasTrait = false;
            bl = $this$hasTrait$iv.hasTrait(BoxTrait.class);
        } else {
            bl = explicitlyBoxed = false;
        }
        if (explicitlyBoxed || boxed) {
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
            SymbolExtKt.boxed(builder);
        }
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        return builder;
    }

    static /* synthetic */ Symbol.Builder createSymbolBuilder$default(KotlinSymbolProvider kotlinSymbolProvider, Shape shape, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return kotlinSymbolProvider.createSymbolBuilder(shape, string, bl);
    }

    private final Symbol.Builder createSymbolBuilder(Shape shape, String typeName, String namespace, boolean boxed) {
        Symbol.Builder builder = this.createSymbolBuilder(shape, typeName, boxed).namespace(namespace, ".");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"createSymbolBuilder(shap\u2026namespace(namespace, \".\")");
        return builder;
    }

    static /* synthetic */ Symbol.Builder createSymbolBuilder$default(KotlinSymbolProvider kotlinSymbolProvider, Shape shape, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return kotlinSymbolProvider.createSymbolBuilder(shape, string, string2, bl);
    }

    private static final boolean _init_$lambda-0(Shape shape, Symbol symbol) {
        String string = symbol.getDefinitionFile();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"symbol.definitionFile");
        return ((CharSequence)string).length() > 0;
    }

    private static final CodegenException memberShape$lambda-3(MemberShape $shape) {
        Intrinsics.checkNotNullParameter((Object)$shape, (String)"$shape");
        return new CodegenException("Shape not found: " + $shape.getTarget());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinSymbolProvider$Companion;", "", "()V", "isTypeGeneratedForShape", "", "shape", "Lsoftware/amazon/smithy/model/shapes/Shape;", "smithy-kotlin-codegen"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isTypeGeneratedForShape(@NotNull Shape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return ShapeExtKt.isEnum(shape) || shape.isStructureShape() || shape.isUnionShape();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

