/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.rendering.serde;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.kotlin.codegen.core.CodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.DeserializeStructGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerdeExtKt;
import software.amazon.smithy.kotlin.codegen.rendering.serde.SerializeUnionGeneratorKt;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.utils.CodeWriter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\bH\u0014J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/DeserializeUnionGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/serde/DeserializeStructGenerator;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "unionName", "", "members", "", "Lsoftware/amazon/smithy/model/shapes/MemberShape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "(Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;Ljava/lang/String;Ljava/util/List;Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;)V", "collectionReturnExpression", "memberShape", "defaultCollectionName", "deserializationResultName", "defaultName", "render", "", "renderMemberShape", "renderShapeDeserializer", "smithy-kotlin-codegen"})
public final class DeserializeUnionGenerator
extends DeserializeStructGenerator {
    @NotNull
    private final String unionName;

    public DeserializeUnionGenerator(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull String unionName, @NotNull List<MemberShape> members, @NotNull KotlinWriter writer, @NotNull TimestampFormatTrait.Format defaultTimestampFormat) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)unionName, (String)"unionName");
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Intrinsics.checkNotNullParameter((Object)((Object)writer), (String)"writer");
        Intrinsics.checkNotNullParameter((Object)defaultTimestampFormat, (String)"defaultTimestampFormat");
        super(ctx, members, writer, defaultTimestampFormat);
        this.unionName = unionName;
    }

    @Override
    public void render() {
        String objDescriptor = !((Collection)this.getMembers()).isEmpty() ? "OBJ_DESCRIPTOR" : "SdkObjectDescriptor.build {}";
        CodeWriterExtKt.withBlock((CodeWriter)this.getWriter(), "deserializer.deserializeStruct(" + objDescriptor + ") {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this){
            final /* synthetic */ DeserializeUnionGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                CodeWriterExtKt.withBlock((CodeWriter)$this$withBlock, "loop@while(true) {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.this$0){
                    final /* synthetic */ DeserializeUnionGenerator this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                        CodeWriterExtKt.withBlock((CodeWriter)$this$withBlock, "when(findNextFieldIndex()) {", "}", new Object[0], (Function1)new Function1<KotlinWriter, Unit>(this.this$0){
                            final /* synthetic */ DeserializeUnionGenerator this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                                void $this$forEach$iv;
                                Intrinsics.checkNotNullParameter((Object)((Object)$this$withBlock), (String)"$this$withBlock");
                                Iterable $this$sortedBy$iv = this.this$0.getMembers();
                                boolean $i$f$sortedBy = false;
                                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                                    public final int compare(T a, T b) {
                                        MemberShape it = (MemberShape)a;
                                        boolean bl = false;
                                        Comparable comparable = (Comparable)((Object)it.getMemberName());
                                        it = (MemberShape)b;
                                        Comparable comparable2 = comparable;
                                        bl = false;
                                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMemberName())));
                                    }
                                });
                                DeserializeUnionGenerator deserializeUnionGenerator = this.this$0;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    MemberShape memberShape2 = (MemberShape)element$iv;
                                    boolean bl = false;
                                    deserializeUnionGenerator.renderMemberShape(memberShape2);
                                }
                                $this$withBlock.write("null -> break@loop", new Object[0]);
                                $this$withBlock.write("else -> value = " + DeserializeUnionGenerator.access$getUnionName$p(this.this$0) + ".SdkUnknown.also { skipValue() }", new Object[0]);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    protected void renderMemberShape(@NotNull MemberShape memberShape2) {
        Intrinsics.checkNotNullParameter((Object)memberShape2, (String)"memberShape");
        Shape targetShape = this.getCtx().getModel().expectShape(memberShape2.getTarget());
        if (targetShape instanceof ListShape ? true : targetShape instanceof SetShape) {
            Shape shape = targetShape;
            if (shape == null) {
                throw new NullPointerException("null cannot be cast to non-null type software.amazon.smithy.model.shapes.CollectionShape");
            }
            this.renderListMemberDeserializer(memberShape2, (CollectionShape)shape);
        } else if (targetShape instanceof MapShape) {
            this.renderMapMemberDeserializer(memberShape2, (MapShape)targetShape);
        } else if (targetShape instanceof StructureShape ? true : targetShape instanceof UnionShape) {
            this.renderShapeDeserializer(memberShape2);
        } else if (targetShape instanceof DocumentShape) {
            this.renderDocumentShapeDeserializer(memberShape2);
        } else if (((((((((((targetShape instanceof BlobShape ? true : targetShape instanceof BooleanShape) ? true : targetShape instanceof StringShape) ? true : targetShape instanceof TimestampShape) ? true : targetShape instanceof ByteShape) ? true : targetShape instanceof ShortShape) ? true : targetShape instanceof IntegerShape) ? true : targetShape instanceof LongShape) ? true : targetShape instanceof FloatShape) ? true : targetShape instanceof DoubleShape) ? true : targetShape instanceof BigDecimalShape) ? true : targetShape instanceof BigIntegerShape) {
            this.renderShapeDeserializer(memberShape2);
        } else {
            throw new IllegalStateException(("Unexpected shape type: " + targetShape.getType()).toString());
        }
    }

    @Override
    public void renderShapeDeserializer(@NotNull MemberShape memberShape2) {
        Intrinsics.checkNotNullParameter((Object)memberShape2, (String)"memberShape");
        String unionTypeName = SerializeUnionGeneratorKt.unionTypeName(memberShape2, this.getCtx());
        String descriptorName = SerdeExtKt.descriptorName$default(memberShape2, null, 1, null);
        String deserialize = this.deserializerForShape((Shape)memberShape2);
        this.getWriter().write(descriptorName + ".index -> value = " + unionTypeName + '(' + deserialize + ')', new Object[0]);
    }

    @Override
    @NotNull
    public String deserializationResultName(@NotNull String defaultName) {
        Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
        return "value";
    }

    @Override
    @NotNull
    public String collectionReturnExpression(@NotNull MemberShape memberShape2, @NotNull String defaultCollectionName) {
        Intrinsics.checkNotNullParameter((Object)memberShape2, (String)"memberShape");
        Intrinsics.checkNotNullParameter((Object)defaultCollectionName, (String)"defaultCollectionName");
        String unionTypeName = SerializeUnionGeneratorKt.unionTypeName(memberShape2, this.getCtx());
        return unionTypeName + '(' + defaultCollectionName + ')';
    }

    public static final /* synthetic */ String access$getUnionName$p(DeserializeUnionGenerator $this) {
        return $this.unionName;
    }
}

