/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.aws.protocols.core;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.aws.traits.protocols.AwsQueryCompatibleTrait;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.aws.protocols.eventstream.EventStreamParserGenerator;
import software.amazon.smithy.kotlin.codegen.aws.protocols.eventstream.EventStreamSerializerGenerator;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.integration.SectionId;
import software.amazon.smithy.kotlin.codegen.integration.SectionKey;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilder;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.rendering.ExceptionBaseClassGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingProtocolGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpProtocolTestGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpProtocolUnitTestErrorGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpProtocolUnitTestRequestGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpProtocolUnitTestResponseGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.TestMemberDelta;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0017"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/AwsHttpBindingProtocolGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingProtocolGenerator;", "<init>", "()V", "generateProtocolUnitTests", "", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "getErrorCode", "", "errShapeId", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "renderDeserializeErrorDetails", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "eventStreamRequestHandler", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "eventStreamResponseHandler", "operationErrorHandler", "renderThrowOperationError", "Sections", "smithy-aws-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nAwsHttpBindingProtocolGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsHttpBindingProtocolGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/AwsHttpBindingProtocolGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,171:1\n1869#2,2:172\n73#3:174\n73#3:175\n*S KotlinDebug\n*F\n+ 1 AwsHttpBindingProtocolGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/AwsHttpBindingProtocolGenerator\n*L\n150#1:172,2\n135#1:174\n163#1:175\n*E\n"})
public abstract class AwsHttpBindingProtocolGenerator
extends HttpBindingProtocolGenerator {
    public void generateProtocolUnitTests(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object[] objectArray = new String[]{"RestJsonHttpEmptyPrefixHeadersRequestClient", "HttpEmptyPrefixHeadersRequestClient"};
        TestMemberDelta ignoredTests = new TestMemberDelta(SetsKt.setOf((Object[])objectArray), null, 2, null);
        HttpProtocolUnitTestRequestGenerator.Builder requestTestBuilder = new HttpProtocolUnitTestRequestGenerator.Builder();
        HttpProtocolUnitTestResponseGenerator.Builder responseTestBuilder = new HttpProtocolUnitTestResponseGenerator.Builder();
        HttpProtocolUnitTestErrorGenerator.Builder errorTestBuilder = new HttpProtocolUnitTestErrorGenerator.Builder();
        new HttpProtocolTestGenerator(ctx, requestTestBuilder, responseTestBuilder, errorTestBuilder, ignoredTests).generateProtocolTests();
    }

    @NotNull
    protected String getErrorCode(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull ShapeId errShapeId) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errShapeId, (String)"errShapeId");
        String string = errShapeId.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public abstract void renderDeserializeErrorDetails(@NotNull ProtocolGenerator.GenerationContext var1, @NotNull OperationShape var2, @NotNull KotlinWriter var3);

    @NotNull
    public Symbol eventStreamRequestHandler(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        HttpBindingResolver resolver = this.getProtocolHttpBindingResolver(ctx.getModel(), ctx.getService());
        String string = resolver.determineRequestContentType(op);
        if (string == null) {
            throw new IllegalStateException("event streams must set a content-type".toString());
        }
        String contentType = string;
        EventStreamSerializerGenerator eventStreamSerializerGenerator = new EventStreamSerializerGenerator(this.structuredDataSerializer(ctx), contentType);
        return eventStreamSerializerGenerator.requestHandler(ctx, op);
    }

    @NotNull
    public Symbol eventStreamResponseHandler(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        EventStreamParserGenerator eventStreamParserGenerator = new EventStreamParserGenerator(ctx, this.structuredDataParser(ctx));
        return eventStreamParserGenerator.responseHandler(ctx, op);
    }

    @NotNull
    public Symbol operationErrorHandler(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return HttpBindingProtocolGeneratorKt.errorHandler((OperationShape)op, (KotlinSettings)ctx.getSettings(), arg_0 -> AwsHttpBindingProtocolGenerator.operationErrorHandler$lambda$1(op, this, ctx, arg_0));
    }

    private final void renderThrowOperationError(ProtocolGenerator.GenerationContext ctx, OperationShape op, KotlinWriter writer) {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Sections.RenderThrowOperationError.INSTANCE.getContext(), (Object)ctx), TuplesKt.to(Sections.RenderThrowOperationError.INSTANCE.getOperation(), (Object)op)};
        AbstractCodeWriterExtKt.declareSection((AbstractCodeWriter)((AbstractCodeWriter)writer), (SectionId)Sections.RenderThrowOperationError.INSTANCE, (Map)MapsKt.mapOf((Pair[])pairArray), arg_0 -> AwsHttpBindingProtocolGenerator.renderThrowOperationError$lambda$10(ctx, writer, op, this, arg_0));
    }

    private static final Unit operationErrorHandler$lambda$1$lambda$0(AwsHttpBindingProtocolGenerator this$0, ProtocolGenerator.GenerationContext $ctx, OperationShape $op, KotlinWriter $writer, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
        this$0.renderThrowOperationError($ctx, $op, $writer);
        return Unit.INSTANCE;
    }

    private static final Unit operationErrorHandler$lambda$1(OperationShape $op, AwsHttpBindingProtocolGenerator this$0, ProtocolGenerator.GenerationContext $ctx, KotlinWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Object[] objectArray = new Object[]{RuntimeTypes.Core.INSTANCE.getExecutionContext(), RuntimeTypes.Http.INSTANCE.getHttpCall(), KotlinTypes.INSTANCE.getByteArray(), KotlinTypes.INSTANCE.getNothing()};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)((AbstractCodeWriter)writer), (String)("private fun " + HttpBindingProtocolGeneratorKt.errorHandlerName((OperationShape)$op) + "(context: #T, call: #T, payload: #T?): #Q {"), (String)"}", (Object[])objectArray, arg_0 -> AwsHttpBindingProtocolGenerator.operationErrorHandler$lambda$1$lambda$0(this$0, $ctx, $op, writer, arg_0));
        return Unit.INSTANCE;
    }

    private static final void renderThrowOperationError$lambda$10$lambda$2(AwsHttpBindingProtocolGenerator this$0, ProtocolGenerator.GenerationContext $ctx, OperationShape $op, KotlinWriter $writer) {
        this$0.renderDeserializeErrorDetails($ctx, $op, $writer);
    }

    private static final Unit renderThrowOperationError$lambda$10$lambda$4$lambda$3(KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
        Object[] objectArray = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getSetAseErrorMetadata()};
        $this$withBlock.write((Object)"#T(it, wrappedCall.response, null)", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderThrowOperationError$lambda$10$lambda$4(ProtocolGenerator.GenerationContext $ctx, Symbol $exceptionBaseSymbol, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
        Object[] objectArray = new Object[]{$exceptionBaseSymbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)((AbstractCodeWriter)$this$withBlock), (String)("throw #T(\"Failed to parse response as '" + $ctx.getProtocol().getName() + "' error\", ex).also {"), (String)"}", (Object[])objectArray, AwsHttpBindingProtocolGenerator::renderThrowOperationError$lambda$10$lambda$4$lambda$3);
        return Unit.INSTANCE;
    }

    private static final Unit renderThrowOperationError$lambda$10$lambda$6$lambda$5(KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
        Object[] objectArray = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getSetAseErrorMetadata()};
        $this$withBlock.write((Object)"#T(it, wrappedResponse, errorDetails)", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderThrowOperationError$lambda$10$lambda$6(Symbol $exceptionBaseSymbol, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
        $this$withBlock.openBlock("queryErrorDetails = try {", new Object[0]);
        Object[] objectArray = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getAwsQueryCompatibleErrorDetails()};
        $this$withBlock.write((Object)"#T.parse(it)", objectArray);
        AbstractCodeWriterExtKt.closeAndOpenBlock((AbstractCodeWriter)((AbstractCodeWriter)$this$withBlock), (String)"} catch (ex: Exception) {", (Object[])new Object[0]);
        objectArray = new Object[]{$exceptionBaseSymbol};
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)((AbstractCodeWriter)$this$withBlock), (String)"throw #T(\"Failed to parse awsQuery-compatible error\", ex).also {", (String)"}", (Object[])objectArray, AwsHttpBindingProtocolGenerator::renderThrowOperationError$lambda$10$lambda$6$lambda$5);
        $this$withBlock.closeBlock("}", new Object[0]);
        return Unit.INSTANCE;
    }

    private static final Unit renderThrowOperationError$lambda$10$lambda$9$lambda$8$lambda$7(Symbol $errSymbol, ProtocolGenerator.GenerationContext $ctx, SymbolBuilder $this$buildSymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
        $this$buildSymbol.setName($errSymbol.getName() + "Deserializer");
        $this$buildSymbol.setNamespace($ctx.getSettings().getPkg().getSerde());
        return Unit.INSTANCE;
    }

    private static final Unit renderThrowOperationError$lambda$10$lambda$9(OperationShape $op, Symbol $exceptionBaseSymbol, ProtocolGenerator.GenerationContext $ctx, KotlinWriter $writer, AwsHttpBindingProtocolGenerator this$0, KotlinWriter $this$withBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
        List list = $op.getErrors();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getErrors(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShapeId err = (ShapeId)element$iv;
            boolean bl = false;
            Symbol errSymbol = $ctx.getSymbolProvider().toSymbol($ctx.getModel().expectShape(err));
            Symbol errDeserializerSymbol = SymbolBuilderKt.buildSymbol(arg_0 -> AwsHttpBindingProtocolGenerator.renderThrowOperationError$lambda$10$lambda$9$lambda$8$lambda$7(errSymbol, $ctx, arg_0));
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNull((Object)err);
            objectArray[0] = this$0.getErrorCode($ctx, err);
            objectArray[1] = errDeserializerSymbol;
            $writer.write((Object)"#S -> #T().deserialize(context, wrappedCall, payload)", objectArray);
        }
        Object[] objectArray = new Object[]{$exceptionBaseSymbol};
        $this$withBlock.write((Object)"else -> #T(errorDetails.message)", objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit renderThrowOperationError$lambda$10(ProtocolGenerator.GenerationContext $ctx, KotlinWriter $writer, OperationShape $op, AwsHttpBindingProtocolGenerator this$0, KotlinWriter $this$declareSection) {
        Intrinsics.checkNotNullParameter((Object)$this$declareSection, (String)"$this$declareSection");
        Symbol exceptionBaseSymbol = ExceptionBaseClassGenerator.INSTANCE.baseExceptionSymbol($ctx.getSettings());
        Object[] objectArray = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getWithPayload()};
        AbstractCodeWriter abstractCodeWriter = ((KotlinWriter)((KotlinWriter)$writer.write((Object)"val wrappedResponse = call.response.#T(payload)", objectArray)).write((Object)"val wrappedCall = call.copy(response = wrappedResponse)", new Object[0])).write((Object)"", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)abstractCodeWriter, (String)"write(...)");
        Object[] objectArray2 = ((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)AbstractCodeWriterExtKt.declareSection$default((AbstractCodeWriter)abstractCodeWriter, (SectionId)Sections.ProtocolErrorDeserialization.INSTANCE, (Map)MapsKt.mapOf((Pair)TuplesKt.to(Sections.ProtocolErrorDeserialization.INSTANCE.getOperation(), (Object)$op)), null, (int)4, null)).write((Object)"val errorDetails = try {", new Object[0])).indent()).call(() -> AwsHttpBindingProtocolGenerator.renderThrowOperationError$lambda$10$lambda$2(this$0, $ctx, $op, $writer))).dedent();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"dedent(...)");
        ((KotlinWriter)AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)objectArray2, (String)"} catch (ex: Exception) {", (String)"}", (Object[])new Object[0], arg_0 -> AwsHttpBindingProtocolGenerator.renderThrowOperationError$lambda$10$lambda$4($ctx, exceptionBaseSymbol, arg_0))).write((Object)"", new Object[0]);
        Object[] $this$hasTrait$iv = (Object[])$ctx.getService();
        boolean $i$f$hasTrait = false;
        if ($this$hasTrait$iv.hasTrait(AwsQueryCompatibleTrait.class)) {
            $this$hasTrait$iv = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getAwsQueryCompatibleErrorDetails()};
            $writer.write((Object)"var queryErrorDetails: #T? = null", $this$hasTrait$iv);
            $this$hasTrait$iv = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getXAmznQueryErrorHeader()};
            AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)((AbstractCodeWriter)$writer), (String)"call.response.headers[#T]?.let {", (String)"}", (Object[])$this$hasTrait$iv, arg_0 -> AwsHttpBindingProtocolGenerator.renderThrowOperationError$lambda$10$lambda$6(exceptionBaseSymbol, arg_0));
            $writer.write((Object)"", new Object[0]);
        }
        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)((AbstractCodeWriter)$writer), (String)"val ex = when(errorDetails.code) {", (String)"}", (Object[])new Object[0], arg_0 -> AwsHttpBindingProtocolGenerator.renderThrowOperationError$lambda$10$lambda$9($op, exceptionBaseSymbol, $ctx, $writer, this$0, arg_0));
        $writer.write((Object)"", new Object[0]);
        $this$hasTrait$iv = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getSetAseErrorMetadata()};
        $writer.write((Object)"#T(ex, wrappedResponse, errorDetails)", $this$hasTrait$iv);
        $this$hasTrait$iv = (Object[])$ctx.getService();
        $i$f$hasTrait = false;
        if ($this$hasTrait$iv.hasTrait(AwsQueryCompatibleTrait.class)) {
            objectArray2 = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getSetAwsQueryCompatibleErrorMetadata()};
            $writer.write((Object)"queryErrorDetails?.let { #T(ex, it) }", objectArray2);
        }
        $writer.write((Object)"throw ex", new Object[0]);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/AwsHttpBindingProtocolGenerator$Sections;", "", "<init>", "()V", "ProtocolErrorDeserialization", "RenderThrowOperationError", "smithy-aws-kotlin-codegen"})
    public static final class Sections {
        @NotNull
        public static final Sections INSTANCE = new Sections();

        private Sections() {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/AwsHttpBindingProtocolGenerator$Sections$ProtocolErrorDeserialization;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "<init>", "()V", "Operation", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "getOperation", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "smithy-aws-kotlin-codegen"})
        public static final class ProtocolErrorDeserialization
        implements SectionId {
            @NotNull
            public static final ProtocolErrorDeserialization INSTANCE = new ProtocolErrorDeserialization();
            @NotNull
            private static final SectionKey<OperationShape> Operation = new SectionKey("Operation");

            private ProtocolErrorDeserialization() {
            }

            @NotNull
            public final SectionKey<OperationShape> getOperation() {
                return Operation;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/AwsHttpBindingProtocolGenerator$Sections$RenderThrowOperationError;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "<init>", "()V", "Context", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "getContext", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Operation", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "getOperation", "smithy-aws-kotlin-codegen"})
        public static final class RenderThrowOperationError
        implements SectionId {
            @NotNull
            public static final RenderThrowOperationError INSTANCE = new RenderThrowOperationError();
            @NotNull
            private static final SectionKey<ProtocolGenerator.GenerationContext> Context = new SectionKey("Context");
            @NotNull
            private static final SectionKey<OperationShape> Operation = new SectionKey("Operation");

            private RenderThrowOperationError() {
            }

            @NotNull
            public final SectionKey<ProtocolGenerator.GenerationContext> getContext() {
                return Context;
            }

            @NotNull
            public final SectionKey<OperationShape> getOperation() {
                return Operation;
            }
        }
    }
}

