/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.aws.protocols.core;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.aws.traits.protocols.AwsQueryCompatibleTrait;
import software.amazon.smithy.codegen.core.Symbol;
import software.amazon.smithy.kotlin.codegen.KotlinSettings;
import software.amazon.smithy.kotlin.codegen.aws.protocols.core.AwsHttpBindingProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.aws.protocols.eventstream.EventStreamParserGenerator;
import software.amazon.smithy.kotlin.codegen.aws.protocols.eventstream.EventStreamSerializerGenerator;
import software.amazon.smithy.kotlin.codegen.core.AbstractCodeWriterExtKt;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.integration.SectionId;
import software.amazon.smithy.kotlin.codegen.integration.SectionKey;
import software.amazon.smithy.kotlin.codegen.lang.KotlinTypes;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilder;
import software.amazon.smithy.kotlin.codegen.model.SymbolBuilderKt;
import software.amazon.smithy.kotlin.codegen.rendering.ExceptionBaseClassGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingProtocolGeneratorKt;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpProtocolTestGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpProtocolUnitTestErrorGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpProtocolUnitTestRequestGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpProtocolUnitTestResponseGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.TestMemberDelta;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.AbstractCodeWriter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H&J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/AwsHttpBindingProtocolGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingProtocolGenerator;", "()V", "eventStreamRequestHandler", "Lsoftware/amazon/smithy/codegen/core/Symbol;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "eventStreamResponseHandler", "generateProtocolUnitTests", "", "getErrorCode", "", "errShapeId", "Lsoftware/amazon/smithy/model/shapes/ShapeId;", "operationErrorHandler", "renderDeserializeErrorDetails", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "renderThrowOperationError", "Sections", "smithy-aws-kotlin-codegen"})
public abstract class AwsHttpBindingProtocolGenerator
extends HttpBindingProtocolGenerator {
    public void generateProtocolUnitTests(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        TestMemberDelta ignoredTests = new TestMemberDelta(SetsKt.setOf((Object)"AwsJson10ClientPopulatesDefaultValuesInInput"), null, 2, null);
        HttpProtocolUnitTestRequestGenerator.Builder requestTestBuilder = new HttpProtocolUnitTestRequestGenerator.Builder();
        HttpProtocolUnitTestResponseGenerator.Builder responseTestBuilder = new HttpProtocolUnitTestResponseGenerator.Builder();
        HttpProtocolUnitTestErrorGenerator.Builder errorTestBuilder = new HttpProtocolUnitTestErrorGenerator.Builder();
        new HttpProtocolTestGenerator(ctx, requestTestBuilder, responseTestBuilder, errorTestBuilder, ignoredTests).generateProtocolTests();
    }

    @NotNull
    protected String getErrorCode(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull ShapeId errShapeId) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errShapeId, (String)"errShapeId");
        String string = errShapeId.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public abstract void renderDeserializeErrorDetails(@NotNull ProtocolGenerator.GenerationContext var1, @NotNull OperationShape var2, @NotNull KotlinWriter var3);

    @NotNull
    public Symbol eventStreamRequestHandler(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        HttpBindingResolver resolver = this.getProtocolHttpBindingResolver(ctx.getModel(), ctx.getService());
        String string = resolver.determineRequestContentType(op);
        if (string == null) {
            throw new IllegalStateException("event streams must set a content-type".toString());
        }
        String contentType = string;
        EventStreamSerializerGenerator eventStreamSerializerGenerator = new EventStreamSerializerGenerator(this.structuredDataSerializer(ctx), contentType);
        return eventStreamSerializerGenerator.requestHandler(ctx, op);
    }

    @NotNull
    public Symbol eventStreamResponseHandler(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        EventStreamParserGenerator eventStreamParserGenerator = new EventStreamParserGenerator(ctx, this.structuredDataParser(ctx));
        return eventStreamParserGenerator.responseHandler(ctx, op);
    }

    @NotNull
    public Symbol operationErrorHandler(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        return HttpBindingProtocolGeneratorKt.errorHandler((OperationShape)op, (KotlinSettings)ctx.getSettings(), (Function1)((Function1)new Function1<KotlinWriter, Unit>(op, this, ctx){
            final /* synthetic */ OperationShape $op;
            final /* synthetic */ AwsHttpBindingProtocolGenerator this$0;
            final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
            {
                this.$op = $op;
                this.this$0 = $receiver;
                this.$ctx = $ctx;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter writer) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                Object[] objectArray = new Object[]{RuntimeTypes.Core.INSTANCE.getExecutionContext(), RuntimeTypes.Http.INSTANCE.getHttpCall(), KotlinTypes.INSTANCE.getByteArray(), KotlinTypes.INSTANCE.getNothing()};
                AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)((AbstractCodeWriter)writer), (String)("private fun " + HttpBindingProtocolGeneratorKt.errorHandlerName((OperationShape)this.$op) + "(context: #T, call: #T, payload: #T?): #Q {"), (String)"}", (Object[])objectArray, (Function1)((Function1)new Function1<KotlinWriter, Unit>(this.this$0, this.$ctx, this.$op, writer){
                    final /* synthetic */ AwsHttpBindingProtocolGenerator this$0;
                    final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
                    final /* synthetic */ OperationShape $op;
                    final /* synthetic */ KotlinWriter $writer;
                    {
                        this.this$0 = $receiver;
                        this.$ctx = $ctx;
                        this.$op = $op;
                        this.$writer = $writer;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
                        AwsHttpBindingProtocolGenerator.access$renderThrowOperationError(this.this$0, this.$ctx, this.$op, this.$writer);
                    }
                }));
            }
        }));
    }

    private final void renderThrowOperationError(ProtocolGenerator.GenerationContext ctx, OperationShape op, KotlinWriter writer) {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Sections.RenderThrowOperationError.INSTANCE.getContext(), (Object)ctx), TuplesKt.to(Sections.RenderThrowOperationError.INSTANCE.getOperation(), (Object)op)};
        AbstractCodeWriterExtKt.declareSection((AbstractCodeWriter)((AbstractCodeWriter)writer), (SectionId)Sections.RenderThrowOperationError.INSTANCE, (Map)MapsKt.mapOf((Pair[])pairArray), (Function1)((Function1)new Function1<KotlinWriter, Unit>(ctx, writer, op, this){
            final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
            final /* synthetic */ KotlinWriter $writer;
            final /* synthetic */ OperationShape $op;
            final /* synthetic */ AwsHttpBindingProtocolGenerator this$0;
            {
                this.$ctx = $ctx;
                this.$writer = $writer;
                this.$op = $op;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KotlinWriter $this$declareSection) {
                Intrinsics.checkNotNullParameter((Object)$this$declareSection, (String)"$this$declareSection");
                Symbol exceptionBaseSymbol = ExceptionBaseClassGenerator.INSTANCE.baseExceptionSymbol(this.$ctx.getSettings());
                Object[] objectArray = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getWithPayload()};
                AbstractCodeWriter abstractCodeWriter = ((KotlinWriter)((KotlinWriter)this.$writer.write((Object)"val wrappedResponse = call.response.#T(payload)", objectArray)).write((Object)"val wrappedCall = call.copy(response = wrappedResponse)", new Object[0])).write((Object)"", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)abstractCodeWriter, (String)"write(...)");
                Object[] objectArray2 = ((KotlinWriter)((KotlinWriter)((KotlinWriter)((KotlinWriter)AbstractCodeWriterExtKt.declareSection$default((AbstractCodeWriter)abstractCodeWriter, (SectionId)Sections.ProtocolErrorDeserialization.INSTANCE, (Map)MapsKt.mapOf((Pair)TuplesKt.to(Sections.ProtocolErrorDeserialization.INSTANCE.getOperation(), (Object)this.$op)), null, (int)4, null)).write((Object)"val errorDetails = try {", new Object[0])).indent()).call(() -> renderThrowOperationError.1.invoke$lambda$0(this.this$0, this.$ctx, this.$op, this.$writer))).dedent();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"dedent(...)");
                ((KotlinWriter)AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)objectArray2, (String)"} catch (ex: Exception) {", (String)"}", (Object[])new Object[0], (Function1)((Function1)new Function1<KotlinWriter, Unit>(this.$ctx, exceptionBaseSymbol){
                    final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
                    final /* synthetic */ Symbol $exceptionBaseSymbol;
                    {
                        this.$ctx = $ctx;
                        this.$exceptionBaseSymbol = $exceptionBaseSymbol;
                        super(1);
                    }

                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
                        Object[] objectArray = new Object[]{this.$exceptionBaseSymbol};
                        AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)((AbstractCodeWriter)$this$withBlock), (String)("throw #T(\"Failed to parse response as '" + this.$ctx.getProtocol().getName() + "' error\", ex).also {"), (String)"}", (Object[])objectArray, (Function1)renderThrowOperationError.1.INSTANCE);
                    }
                }))).write((Object)"", new Object[0]);
                Object[] $this$hasTrait$iv = (Object[])this.$ctx.getService();
                boolean $i$f$hasTrait = false;
                if ($this$hasTrait$iv.hasTrait(AwsQueryCompatibleTrait.class)) {
                    $this$hasTrait$iv = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getAwsQueryCompatibleErrorDetails()};
                    this.$writer.write((Object)"var queryErrorDetails: #T? = null", $this$hasTrait$iv);
                    $this$hasTrait$iv = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getXAmznQueryErrorHeader()};
                    AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)((AbstractCodeWriter)this.$writer), (String)"call.response.headers[#T]?.let {", (String)"}", (Object[])$this$hasTrait$iv, (Function1)((Function1)new Function1<KotlinWriter, Unit>(exceptionBaseSymbol){
                        final /* synthetic */ Symbol $exceptionBaseSymbol;
                        {
                            this.$exceptionBaseSymbol = $exceptionBaseSymbol;
                            super(1);
                        }

                        public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                            Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
                            $this$withBlock.openBlock("queryErrorDetails = try {", new Object[0]);
                            Object[] objectArray = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getAwsQueryCompatibleErrorDetails()};
                            $this$withBlock.write((Object)"#T.parse(it)", objectArray);
                            AbstractCodeWriterExtKt.closeAndOpenBlock((AbstractCodeWriter)((AbstractCodeWriter)$this$withBlock), (String)"} catch (ex: Exception) {", (Object[])new Object[0]);
                            objectArray = new Object[]{this.$exceptionBaseSymbol};
                            AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)((AbstractCodeWriter)$this$withBlock), (String)"throw #T(\"Failed to parse awsQuery-compatible error\", ex).also {", (String)"}", (Object[])objectArray, (Function1)renderThrowOperationError.1.INSTANCE);
                            $this$withBlock.closeBlock("}", new Object[0]);
                        }
                    }));
                    this.$writer.write((Object)"", new Object[0]);
                }
                AbstractCodeWriterExtKt.withBlock((AbstractCodeWriter)((AbstractCodeWriter)this.$writer), (String)"val ex = when(errorDetails.code) {", (String)"}", (Object[])new Object[0], (Function1)((Function1)new Function1<KotlinWriter, Unit>(this.$op, exceptionBaseSymbol, this.$ctx, this.$writer, this.this$0){
                    final /* synthetic */ OperationShape $op;
                    final /* synthetic */ Symbol $exceptionBaseSymbol;
                    final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
                    final /* synthetic */ KotlinWriter $writer;
                    final /* synthetic */ AwsHttpBindingProtocolGenerator this$0;
                    {
                        this.$op = $op;
                        this.$exceptionBaseSymbol = $exceptionBaseSymbol;
                        this.$ctx = $ctx;
                        this.$writer = $writer;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull KotlinWriter $this$withBlock) {
                        void $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"$this$withBlock");
                        List list = this.$op.getErrors();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getErrors(...)");
                        Object[] objectArray = (Object[])list;
                        ProtocolGenerator.GenerationContext generationContext = this.$ctx;
                        KotlinWriter kotlinWriter = this.$writer;
                        AwsHttpBindingProtocolGenerator awsHttpBindingProtocolGenerator = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            ShapeId err = (ShapeId)element$iv;
                            boolean bl = false;
                            Symbol errSymbol = generationContext.getSymbolProvider().toSymbol(generationContext.getModel().expectShape(err));
                            Symbol errDeserializerSymbol2 = SymbolBuilderKt.buildSymbol((Function1)((Function1)new Function1<SymbolBuilder, Unit>(errSymbol, generationContext){
                                final /* synthetic */ Symbol $errSymbol;
                                final /* synthetic */ ProtocolGenerator.GenerationContext $ctx;
                                {
                                    this.$errSymbol = $errSymbol;
                                    this.$ctx = $ctx;
                                    super(1);
                                }

                                public final void invoke(@NotNull SymbolBuilder $this$buildSymbol) {
                                    Intrinsics.checkNotNullParameter((Object)$this$buildSymbol, (String)"$this$buildSymbol");
                                    $this$buildSymbol.setName(this.$errSymbol.getName() + "Deserializer");
                                    $this$buildSymbol.setNamespace(this.$ctx.getSettings().getPkg().getSerde());
                                }
                            }));
                            Object[] objectArray2 = new Object[2];
                            Intrinsics.checkNotNull((Object)err);
                            objectArray2[0] = awsHttpBindingProtocolGenerator.getErrorCode(generationContext, err);
                            objectArray2[1] = errDeserializerSymbol2;
                            kotlinWriter.write((Object)"#S -> #T().deserialize(context, wrappedCall, payload)", objectArray2);
                        }
                        objectArray = new Object[]{this.$exceptionBaseSymbol};
                        $this$withBlock.write((Object)"else -> #T(errorDetails.message)", objectArray);
                    }
                }));
                this.$writer.write((Object)"", new Object[0]);
                $this$hasTrait$iv = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getSetAseErrorMetadata()};
                this.$writer.write((Object)"#T(ex, wrappedResponse, errorDetails)", $this$hasTrait$iv);
                $this$hasTrait$iv = (Object[])this.$ctx.getService();
                $i$f$hasTrait = false;
                if ($this$hasTrait$iv.hasTrait(AwsQueryCompatibleTrait.class)) {
                    objectArray2 = new Object[]{RuntimeTypes.AwsProtocolCore.INSTANCE.getSetAwsQueryCompatibleErrorMetadata()};
                    this.$writer.write((Object)"queryErrorDetails?.let { #T(ex, it) }", objectArray2);
                }
                this.$writer.write((Object)"throw ex", new Object[0]);
            }

            private static final void invoke$lambda$0(AwsHttpBindingProtocolGenerator this$0, ProtocolGenerator.GenerationContext $ctx, OperationShape $op, KotlinWriter $writer) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
                Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
                Intrinsics.checkNotNullParameter((Object)$writer, (String)"$writer");
                this$0.renderDeserializeErrorDetails($ctx, $op, $writer);
            }
        }));
    }

    public static final /* synthetic */ void access$renderThrowOperationError(AwsHttpBindingProtocolGenerator $this, ProtocolGenerator.GenerationContext ctx, OperationShape op, KotlinWriter writer) {
        $this.renderThrowOperationError(ctx, op, writer);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/AwsHttpBindingProtocolGenerator$Sections;", "", "()V", "ProtocolErrorDeserialization", "RenderThrowOperationError", "smithy-aws-kotlin-codegen"})
    public static final class Sections {
        @NotNull
        public static final Sections INSTANCE = new Sections();

        private Sections() {
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/AwsHttpBindingProtocolGenerator$Sections$ProtocolErrorDeserialization;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "()V", "Operation", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "getOperation", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "smithy-aws-kotlin-codegen"})
        public static final class ProtocolErrorDeserialization
        implements SectionId {
            @NotNull
            public static final ProtocolErrorDeserialization INSTANCE = new ProtocolErrorDeserialization();
            @NotNull
            private static final SectionKey<OperationShape> Operation = new SectionKey("Operation");

            private ProtocolErrorDeserialization() {
            }

            @NotNull
            public final SectionKey<OperationShape> getOperation() {
                return Operation;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/AwsHttpBindingProtocolGenerator$Sections$RenderThrowOperationError;", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionId;", "()V", "Context", "Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "getContext", "()Lsoftware/amazon/smithy/kotlin/codegen/integration/SectionKey;", "Operation", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "getOperation", "smithy-aws-kotlin-codegen"})
        public static final class RenderThrowOperationError
        implements SectionId {
            @NotNull
            public static final RenderThrowOperationError INSTANCE = new RenderThrowOperationError();
            @NotNull
            private static final SectionKey<ProtocolGenerator.GenerationContext> Context = new SectionKey("Context");
            @NotNull
            private static final SectionKey<OperationShape> Operation = new SectionKey("Operation");

            private RenderThrowOperationError() {
            }

            @NotNull
            public final SectionKey<ProtocolGenerator.GenerationContext> getContext() {
                return Context;
            }

            @NotNull
            public final SectionKey<OperationShape> getOperation() {
                return Operation;
            }
        }
    }
}

