/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.kotlin.codegen.aws.protocols.core;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import software.amazon.smithy.kotlin.codegen.aws.protocols.core.AwsHttpBindingProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.aws.protocols.core.QueryBindingResolver;
import software.amazon.smithy.kotlin.codegen.core.KotlinWriter;
import software.amazon.smithy.kotlin.codegen.core.RuntimeTypes;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.HttpBindingResolver;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.MutateHeadersMiddleware;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolGenerator;
import software.amazon.smithy.kotlin.codegen.rendering.protocol.ProtocolMiddleware;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.TimestampFormatTrait;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/QueryHttpBindingProtocolGenerator;", "Lsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/AwsHttpBindingProtocolGenerator;", "()V", "defaultTimestampFormat", "Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "getDefaultTimestampFormat", "()Lsoftware/amazon/smithy/model/traits/TimestampFormatTrait$Format;", "getDefaultHttpMiddleware", "", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolMiddleware;", "ctx", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/ProtocolGenerator$GenerationContext;", "getProtocolHttpBindingResolver", "Lsoftware/amazon/smithy/kotlin/codegen/rendering/protocol/HttpBindingResolver;", "model", "Lsoftware/amazon/smithy/model/Model;", "serviceShape", "Lsoftware/amazon/smithy/model/shapes/ServiceShape;", "renderSerializeHttpBody", "", "op", "Lsoftware/amazon/smithy/model/shapes/OperationShape;", "writer", "Lsoftware/amazon/smithy/kotlin/codegen/core/KotlinWriter;", "smithy-aws-kotlin-codegen"})
@SourceDebugExtension(value={"SMAP\nQueryHttpBindingProtocolGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryHttpBindingProtocolGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/QueryHttpBindingProtocolGenerator\n+ 2 ShapeExt.kt\nsoftware/amazon/smithy/kotlin/codegen/model/ShapeExtKt\n*L\n1#1,189:1\n42#2:190\n42#2:191\n*S KotlinDebug\n*F\n+ 1 QueryHttpBindingProtocolGenerator.kt\nsoftware/amazon/smithy/kotlin/codegen/aws/protocols/core/QueryHttpBindingProtocolGenerator\n*L\n50#1:190\n56#1:191\n*E\n"})
public abstract class QueryHttpBindingProtocolGenerator
extends AwsHttpBindingProtocolGenerator {
    @NotNull
    private final TimestampFormatTrait.Format defaultTimestampFormat = TimestampFormatTrait.Format.DATE_TIME;

    @NotNull
    public TimestampFormatTrait.Format getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    @NotNull
    protected List<ProtocolMiddleware> getDefaultHttpMiddleware(@NotNull ProtocolGenerator.GenerationContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        List middleware = super.getDefaultHttpMiddleware(ctx);
        List queryMiddleware = CollectionsKt.listOf((Object)new MutateHeadersMiddleware(null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/x-www-form-urlencoded")), 3, null));
        return CollectionsKt.plus((Collection)middleware, (Iterable)queryMiddleware);
    }

    @NotNull
    public HttpBindingResolver getProtocolHttpBindingResolver(@NotNull Model model, @NotNull ServiceShape serviceShape) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)serviceShape, (String)"serviceShape");
        return new QueryBindingResolver(model, serviceShape);
    }

    /*
     * WARNING - void declaration
     */
    protected void renderSerializeHttpBody(@NotNull ProtocolGenerator.GenerationContext ctx, @NotNull OperationShape op, @NotNull KotlinWriter writer) {
        void $this$expectShape$iv;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Model model = ctx.getModel();
        Object t = op.getInput().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        ShapeId shapeId$iv = (ShapeId)t;
        boolean $i$f$expectShape2 = false;
        Shape shape = $this$expectShape$iv.expectShape(shapeId$iv, StructureShape.class);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"expectShape(...)");
        StructureShape input = (StructureShape)shape;
        if (input.members().isEmpty()) {
            void $this$expectShape$iv2;
            String action = op.getId().getName();
            Model $i$f$expectShape2 = ctx.getModel();
            ShapeId shapeId$iv2 = ctx.getSettings().getService();
            boolean $i$f$expectShape3 = false;
            Shape shape2 = $this$expectShape$iv2.expectShape(shapeId$iv2, ServiceShape.class);
            Intrinsics.checkNotNullExpressionValue((Object)shape2, (String)"expectShape(...)");
            ServiceShape service = (ServiceShape)shape2;
            String version = service.getVersion();
            writer.write((Object)("val content = \"Action=" + action + "&Version=" + version + "\""), new Object[0]);
            Object[] objectArray = new Object[]{RuntimeTypes.Http.INSTANCE.getHttpBody()};
            writer.write((Object)"builder.body = #T.fromBytes(content.encodeToByteArray())", objectArray);
        } else {
            super.renderSerializeHttpBody(ctx, op, writer);
        }
    }
}

