/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.s3accessgrants.plugin.internal;

import java.util.List;
import java.util.regex.Pattern;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.identity.spi.IdentityProperty;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3control.model.Privilege;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

public class S3AccessGrantsUtils {
    public static Logger logger = Logger.loggerFor((String)"software.amazon.awssdk.s3accessgrants");
    public static final IdentityProperty PREFIX_PROPERTY = IdentityProperty.create(String.class, (String)"S3Prefix");
    public static final IdentityProperty OPERATION_PROPERTY = IdentityProperty.create(String.class, (String)"Operation");
    public static final IdentityProperty BUCKET_LOCATION_PROPERTY = IdentityProperty.create(Region.class, (String)"BucketLocation");
    public static final IdentityProperty AUTH_EXCEPTIONS_PROPERTY = IdentityProperty.create(SdkServiceException.class, (String)"AuthExceptions");
    public static final IdentityProperty PERMISSION_PROPERTY = IdentityProperty.create(String.class, (String)"PermissionProperty");
    public static String CONTACT_TEAM_MESSAGE_TEMPLATE = "An internal exception has occurred. Valid %s was not passed to the %s. Please contact S3 access grants plugin team!";
    public static final Boolean DEFAULT_CACHE_SETTING = true;
    public static final Privilege DEFAULT_PRIVILEGE_FOR_PLUGIN = Privilege.DEFAULT;
    public static final Boolean DEFAULT_FALLBACK_SETTING = false;
    public static final Boolean DEFAULT_CROSS_REGION_ACCESS_SETTING = false;
    public static String USER_AGENT = "aws-s3-accessgrants-java-sdk-v2-plugin";

    public static void argumentNotNull(Object param, String message) {
        try {
            Validate.notNull((Object)param, (String)message, (Object[])new Object[0]);
        }
        catch (NullPointerException e) {
            logger.error(() -> message);
            throw new IllegalArgumentException(message);
        }
    }

    public static String getCommonPrefixFromMultiplePrefixes(List<String> keys) {
        String firstKey;
        if (keys.isEmpty()) {
            return "/";
        }
        String commonAncestor = firstKey = keys.get(0);
        String lastPrefix = "";
        for (String i : keys) {
            while (!commonAncestor.isEmpty() && !i.startsWith(commonAncestor)) {
                int lastIndex = commonAncestor.lastIndexOf("/");
                if (lastIndex == -1) {
                    return "/";
                }
                lastPrefix = commonAncestor.substring(lastIndex + 1);
                commonAncestor = commonAncestor.substring(0, lastIndex);
            }
        }
        String newCommonAncestor = commonAncestor + "/" + lastPrefix;
        for (String i : keys) {
            while (!lastPrefix.isEmpty() && !i.startsWith(newCommonAncestor)) {
                lastPrefix = lastPrefix.substring(0, lastPrefix.length() - 1);
                newCommonAncestor = commonAncestor + "/" + lastPrefix;
            }
        }
        if (newCommonAncestor.equals(firstKey + "/")) {
            return "/" + firstKey;
        }
        return "/" + newCommonAncestor;
    }

    public static void validateUserInput(String userAgent) {
        if (!Pattern.compile("[a-zA-Z0-9.-]*").matcher(userAgent).matches()) {
            throw new IllegalArgumentException("This user agent name is not permitted. The name can only contain characters 'a-z', 'A-Z', '0-9', '.', and '-'.");
        }
    }
}

