/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.s3accessgrants.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.time.Duration;
import java.util.List;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.s3accessgrants.cache.S3AccessGrantsBucketRegionResolver;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.utils.Logger;

public class S3AccessGrantsCachedBucketRegionResolver
implements S3AccessGrantsBucketRegionResolver {
    private int maxCacheSize = 1000;
    private int expireCacheAfterWriteSeconds = 300;
    private Cache<String, Region> cache;
    private S3Client s3Client;
    private static final Logger logger = Logger.loggerFor(S3AccessGrantsCachedBucketRegionResolver.class);

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public int getExpireCacheAfterWriteSeconds() {
        return this.expireCacheAfterWriteSeconds;
    }

    public int expireCacheAfterWriteSeconds() {
        return this.expireCacheAfterWriteSeconds;
    }

    public int maxCacheSize() {
        return this.maxCacheSize;
    }

    protected CacheStats getCacheStats() {
        return this.cache.stats();
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private S3AccessGrantsCachedBucketRegionResolver() {
    }

    @Override
    public Region resolve(String bucket) throws S3Exception {
        Region bucketRegion = (Region)this.cache.getIfPresent((Object)bucket);
        if (bucketRegion == null) {
            logger.debug(() -> "bucket region not available in cache, fetching the region from the service!");
            if (this.s3Client == null) {
                throw new IllegalArgumentException("S3Client is required for the bucket region resolver!");
            }
            bucketRegion = this.resolveFromService(bucket);
            if (bucketRegion != null) {
                this.cache.put((Object)bucket, (Object)bucketRegion);
            }
        } else {
            logger.debug(() -> "bucket region available in cache!");
        }
        return bucketRegion;
    }

    private Region resolveFromService(String bucket) {
        String resolvedRegion = null;
        try {
            logger.info(() -> "making a call to S3 for determining the bucket region! " + bucket);
            HeadBucketRequest bucketLocationRequest = (HeadBucketRequest)HeadBucketRequest.builder().bucket(bucket).build();
            HeadBucketResponse headBucketResponse = this.s3Client.headBucket(bucketLocationRequest);
            resolvedRegion = headBucketResponse.bucketRegion();
        }
        catch (S3Exception e) {
            logger.debug(() -> "an exception occurred while make head bucket request to fetch bucket region. Attempting to extract the region from headers!");
            if (e.awsErrorDetails() != null && e.awsErrorDetails().sdkHttpResponse() != null && e.awsErrorDetails().sdkHttpResponse().headers().get("x-amz-bucket-region") != null) {
                String bucketRegion;
                resolvedRegion = bucketRegion = (String)((List)e.awsErrorDetails().sdkHttpResponse().headers().get("x-amz-bucket-region")).get(0);
            }
            throw SdkServiceException.builder().message(e.getMessage()).cause((Throwable)e).build();
        }
        if (resolvedRegion == null) {
            throw SdkServiceException.builder().message("S3 error! region cannot be determined for the specified bucket!").build();
        }
        return Region.of((String)resolvedRegion);
    }

    static final class BuilderImpl
    implements Builder {
        private int maxCacheSize = 1000;
        private int expireCacheAfterWriteSeconds = 300;
        private S3Client s3Client;

        private BuilderImpl() {
        }

        public BuilderImpl(S3AccessGrantsCachedBucketRegionResolver s3AccessGrantsCachedBucketRegionResolver) {
            this.maxCacheSize(s3AccessGrantsCachedBucketRegionResolver.maxCacheSize);
            this.expireCacheAfterWriteSeconds(s3AccessGrantsCachedBucketRegionResolver.expireCacheAfterWriteSeconds);
            this.s3Client(s3AccessGrantsCachedBucketRegionResolver.s3Client);
        }

        public int maxCacheSize() {
            return this.maxCacheSize;
        }

        public S3Client s3Client() {
            if (this.s3Client == null) {
                throw new IllegalArgumentException("S3 Client is required while configuring the S3 Bucket Region resolver!");
            }
            return this.s3Client;
        }

        public int expireCacheAfterWriteSeconds() {
            return this.expireCacheAfterWriteSeconds;
        }

        @Override
        public Builder maxCacheSize(int maxCacheSize) {
            if (maxCacheSize <= 0 || maxCacheSize > 1000000) {
                throw new IllegalArgumentException(String.format("maxCacheSize needs to be in range (0, %d]", 1000000));
            }
            this.maxCacheSize = maxCacheSize;
            return this;
        }

        @Override
        public Builder s3Client(S3Client s3Client) {
            if (s3Client == null) {
                throw new IllegalArgumentException("S3 Client is required while configuring the S3 Bucket Region resolver!");
            }
            this.s3Client = s3Client;
            return this;
        }

        @Override
        public Builder expireCacheAfterWriteSeconds(int expireCacheAfterWriteSeconds) {
            if (expireCacheAfterWriteSeconds <= 0 || expireCacheAfterWriteSeconds > 600) {
                throw new IllegalArgumentException(String.format("expireCacheAfterWriteSeconds needs to be in range (0, %d]", 600));
            }
            this.expireCacheAfterWriteSeconds = expireCacheAfterWriteSeconds;
            return this;
        }

        @Override
        public S3AccessGrantsCachedBucketRegionResolver build() {
            S3AccessGrantsCachedBucketRegionResolver resolver = new S3AccessGrantsCachedBucketRegionResolver();
            resolver.maxCacheSize = this.maxCacheSize();
            resolver.expireCacheAfterWriteSeconds = this.expireCacheAfterWriteSeconds();
            resolver.s3Client = this.s3Client();
            resolver.cache = Caffeine.newBuilder().maximumSize((long)this.maxCacheSize).expireAfterWrite(Duration.ofSeconds(this.expireCacheAfterWriteSeconds)).build();
            return resolver;
        }
    }

    public static interface Builder {
        public S3AccessGrantsCachedBucketRegionResolver build();

        public Builder maxCacheSize(int var1);

        public Builder s3Client(S3Client var1);

        public Builder expireCacheAfterWriteSeconds(int var1);
    }
}

