/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.amazon.rdsdata.client.MappingException;
import com.amazon.rdsdata.client.PropertyWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class SetterPropertyWriter
implements PropertyWriter {
    private Object instance;
    private Method setter;
    private String fieldName;

    static Optional<PropertyWriter> setterPropertyWriterFor(Object instance, String fieldName) {
        Class<?> instanceType = instance.getClass();
        String setterName = SetterPropertyWriter.buildSetterName(fieldName);
        List<Method> possibleSetterMethods = Stream.of(instanceType.getMethods()).filter(method -> method.getName().equals(setterName)).filter(SetterPropertyWriter::isNotStatic).filter(SetterPropertyWriter::hasOneParameter).filter(SetterPropertyWriter::isPublic).collect(Collectors.toList());
        if (possibleSetterMethods.size() > 1) {
            throw MappingException.ambiguousSetter(fieldName, possibleSetterMethods);
        }
        if (possibleSetterMethods.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(new SetterPropertyWriter(instance, possibleSetterMethods.get(0), fieldName));
    }

    private static boolean isNotStatic(Method method) {
        return !Modifier.isStatic(method.getModifiers());
    }

    private static boolean hasOneParameter(Method method) {
        return method.getParameterCount() == 1;
    }

    private static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    private static String buildSetterName(String fieldName) {
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    @Override
    public void write(Object value) {
        try {
            this.setter.invoke(this.instance, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw MappingException.cannotSetValue(this.fieldName, e);
        }
    }

    @Override
    public Class<?> getType() {
        return this.setter.getParameterTypes()[0];
    }

    private SetterPropertyWriter(Object instance, Method setter, String fieldName) {
        this.instance = instance;
        this.setter = setter;
        this.fieldName = fieldName;
    }
}

