/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.amazon.rdsdata.client.FieldMapper;
import com.amazon.rdsdata.client.MappingException;
import com.amazonaws.services.rdsdata.model.Field;
import com.amazonaws.services.rdsdata.model.TypeHint;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.UUID;

class TypeConverter {
    static String ERROR_PARAMETER_OF_UNKNOWN_TYPE = "Unknown parameter type: ";
    static DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSS]");
    static DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss[.SSS]");
    static DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    TypeConverter() {
    }

    static Field toField(Object o) {
        if (o == null || o == FieldMapper.NULL) {
            return new Field().withIsNull(Boolean.valueOf(true));
        }
        if (o instanceof Byte || o instanceof Integer || o instanceof Long) {
            return new Field().withLongValue(Long.valueOf(((Number)o).longValue()));
        }
        if (o instanceof Double || o instanceof Float) {
            return new Field().withDoubleValue(Double.valueOf(((Number)o).doubleValue()));
        }
        if (o instanceof Character) {
            return new Field().withLongValue(Long.valueOf(((Character)o).charValue()));
        }
        if (o instanceof String) {
            return new Field().withStringValue(o.toString());
        }
        if (o instanceof Boolean) {
            return new Field().withBooleanValue((Boolean)o);
        }
        if (o instanceof byte[]) {
            return new Field().withBlobValue(ByteBuffer.wrap((byte[])o));
        }
        if (o instanceof BigDecimal || o instanceof BigInteger) {
            return new Field().withStringValue(o.toString());
        }
        if (o instanceof LocalDateTime) {
            return new Field().withStringValue(DATE_TIME_FORMATTER.format((LocalDateTime)o));
        }
        if (o instanceof LocalDate) {
            return new Field().withStringValue(DATE_FORMATTER.format((LocalDate)o));
        }
        if (o instanceof LocalTime) {
            return new Field().withStringValue(TIME_FORMATTER.format((LocalTime)o));
        }
        if (o instanceof Enum) {
            return new Field().withStringValue(((Enum)o).name());
        }
        if (o instanceof UUID) {
            return new Field().withStringValue(o.toString());
        }
        throw new IllegalArgumentException(ERROR_PARAMETER_OF_UNKNOWN_TYPE + o.getClass().getName());
    }

    static Optional<TypeHint> getTypeHint(Object o) {
        if (o instanceof BigDecimal || o instanceof BigInteger) {
            return Optional.of(TypeHint.DECIMAL);
        }
        if (o instanceof LocalDateTime) {
            return Optional.of(TypeHint.TIMESTAMP);
        }
        if (o instanceof LocalDate) {
            return Optional.of(TypeHint.DATE);
        }
        if (o instanceof LocalTime) {
            return Optional.of(TypeHint.TIME);
        }
        if (o instanceof UUID) {
            return Optional.of(TypeHint.UUID);
        }
        return Optional.empty();
    }

    static Object fromField(Field field, Class<?> type) {
        if (field.isNull() != null && field.isNull().booleanValue()) {
            return null;
        }
        if (type == String.class) {
            return field.getStringValue();
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return field.getLongValue().byteValue();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return field.getLongValue().intValue();
        }
        if (type == Long.class || type == Long.TYPE) {
            return field.getLongValue();
        }
        if (type == Character.class || type == Character.TYPE) {
            return Character.valueOf((char)field.getLongValue().longValue());
        }
        if (type == Double.class || type == Double.TYPE) {
            return field.getDoubleValue();
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(field.getDoubleValue().floatValue());
        }
        if (type == byte[].class) {
            return field.getBlobValue().array();
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return field.getBooleanValue();
        }
        if (type == BigDecimal.class) {
            return TypeConverter.toBigDecimal(field);
        }
        if (type == BigInteger.class) {
            return TypeConverter.toBigInteger(field);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return Enum.valueOf(type, field.getStringValue());
        }
        if (type == UUID.class) {
            return UUID.fromString(field.getStringValue());
        }
        return null;
    }

    private static BigDecimal toBigDecimal(Field field) {
        if (field.getStringValue() != null) {
            return new BigDecimal(field.getStringValue());
        }
        if (field.getLongValue() != null) {
            return BigDecimal.valueOf(field.getLongValue());
        }
        if (field.getDoubleValue() != null) {
            return BigDecimal.valueOf(field.getDoubleValue());
        }
        throw MappingException.cannotConvertToType(field, BigDecimal.class);
    }

    private static BigInteger toBigInteger(Field field) {
        if (field.getStringValue() != null) {
            return new BigInteger(field.getStringValue());
        }
        if (field.getLongValue() != null) {
            return BigInteger.valueOf(field.getLongValue());
        }
        throw MappingException.cannotConvertToType(field, BigInteger.class);
    }
}

