/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.amazon.rdsdata.client.ExecutionResult;
import com.amazon.rdsdata.client.ObjectMapper;
import com.amazon.rdsdata.client.RdsDataClient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Executor {
    private final String sql;
    private final RdsDataClient client;
    private List<Object> paramSets = Collections.emptyList();
    private String transactionId = "";

    public Executor withParameter(Object param) {
        this.paramSets = Collections.singletonList(param);
        return this;
    }

    public Executor withParamSets(List<Object> params) {
        this.paramSets = params;
        return this;
    }

    public Executor withParamSets(Object ... params) {
        return this.withParamSets(Arrays.asList(params));
    }

    public Executor withParameter(String parameterName, Object value) {
        Object firstParamSet;
        if (this.paramSets.isEmpty()) {
            this.paramSets = Collections.singletonList(new HashMap());
        }
        if (!((firstParamSet = this.paramSets.get(0)) instanceof Map)) {
            throw new IllegalArgumentException("Parameters are already supplied");
        }
        ((Map)this.paramSets.get(0)).put(parameterName, value);
        return this;
    }

    public ExecutionResult execute() {
        return this.paramSets.size() > 1 ? this.executeAsBatch() : this.executeAsSingle();
    }

    private ExecutionResult executeAsBatch() {
        List<Map<String, Object>> paramSetsAsMaps = this.paramSets.stream().map(paramSet -> this.toMap(this.sql, paramSet)).collect(Collectors.toList());
        return this.client.batchExecuteStatement(this.transactionId, this.sql, paramSetsAsMaps);
    }

    private ExecutionResult executeAsSingle() {
        Map<String, Object> firstParamSetAsMap = this.paramSets.stream().findFirst().map(paramSet -> this.toMap(this.sql, paramSet)).orElse(Collections.emptyMap());
        return this.client.executeStatement(this.transactionId, this.sql, firstParamSetAsMap);
    }

    private Map<String, Object> toMap(String sql, Object paramSet) {
        if (paramSet instanceof Map) {
            return (Map)paramSet;
        }
        ObjectMapper mapper = new ObjectMapper(sql);
        return mapper.map(paramSet);
    }

    public Executor withTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public Executor(String sql, RdsDataClient client) {
        this.sql = sql;
        this.client = client;
    }
}

