/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.amazon.rdsdata.client.ExecutionResult;
import com.amazon.rdsdata.client.MappingException;
import com.amazon.rdsdata.client.ObjectWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

class ConstructorObjectWriter<T>
extends ObjectWriter<T> {
    private final Constructor<T> constructor;
    private final Map<String, Integer> indexByName;

    ConstructorObjectWriter(Constructor<T> constructor, List<String> fieldNames) {
        this.constructor = constructor;
        this.indexByName = ConstructorObjectWriter.buildIndexByNameMap(fieldNames);
    }

    private static Map<String, Integer> buildIndexByNameMap(List<String> fieldNames) {
        return IntStream.range(0, fieldNames.size()).boxed().collect(Collectors.toMap(fieldNames::get, i -> i));
    }

    public static <T> Optional<ObjectWriter<T>> create(Class<T> mapperClass, List<String> fieldNames) {
        if (fieldNames.size() == 0) {
            return Optional.empty();
        }
        return Stream.of(mapperClass.getDeclaredConstructors()).filter(c -> ConstructorObjectWriter.containsAllFields(c, fieldNames)).findFirst().map(c -> new ConstructorObjectWriter(c, fieldNames));
    }

    private static boolean containsAllFields(Constructor<?> constructor, List<String> fieldNames) {
        Set<String> parameterNames = ConstructorObjectWriter.getParameterNames(constructor);
        return parameterNames.equals(new HashSet<String>(fieldNames));
    }

    private static Set<String> getParameterNames(Constructor<?> constructor) {
        return Arrays.stream(constructor.getParameters()).map(Parameter::getName).collect(Collectors.toSet());
    }

    @Override
    public T write(ExecutionResult.Row row) {
        try {
            return this.constructor.newInstance(this.buildArgumentsList(row));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw MappingException.cannotCreateInstance(this.constructor.getDeclaringClass(), e);
        }
    }

    private Object[] buildArgumentsList(ExecutionResult.Row row) {
        Parameter[] parameters = this.constructor.getParameters();
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String name = parameters[i].getName();
            Integer indexInFieldsList = this.indexByName.get(name);
            Object value = row.getValue(indexInFieldsList, parameters[i].getType());
            args[i] = value;
        }
        return args;
    }
}

