/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.amazon.rdsdata.client.ConstructorObjectWriter;
import com.amazon.rdsdata.client.FieldObjectWriter;
import com.amazon.rdsdata.client.MappingException;
import com.amazon.rdsdata.client.ObjectWriter;
import com.amazon.rdsdata.client.TypeConverter;
import com.amazonaws.services.rdsdata.model.ColumnMetadata;
import com.amazonaws.services.rdsdata.model.Field;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ExecutionResult {
    private List<String> fieldNames;
    private List<Row> rows;
    private Long numberOfRecordsUpdated;

    ExecutionResult(List<ColumnMetadata> metadata, List<List<Field>> fields, Long numberOfRecordsUpdated) {
        this.fieldNames = this.extractFieldNames(metadata);
        this.rows = this.convertToRows(fields);
        this.numberOfRecordsUpdated = numberOfRecordsUpdated;
    }

    private List<String> extractFieldNames(List<ColumnMetadata> metadata) {
        if (metadata == null) {
            return Collections.emptyList();
        }
        return metadata.stream().map(ColumnMetadata::getName).collect(Collectors.toList());
    }

    private List<Row> convertToRows(List<List<Field>> records) {
        if (records == null) {
            return Collections.emptyList();
        }
        return records.stream().map(Row::new).collect(Collectors.toList());
    }

    public Long getNumberOfRecordsUpdated() {
        return this.numberOfRecordsUpdated;
    }

    public <T> T mapToSingle(Class<T> mapperClass) {
        if (this.rows.isEmpty()) {
            throw MappingException.emptyResultSet();
        }
        return this.mapToSingle(mapperClass, this.fieldNames, this.rows.get(0));
    }

    private <T> T mapToSingle(Class<T> mapperClass, List<String> fieldNames, Row row) {
        ObjectWriter writer = ConstructorObjectWriter.create(mapperClass, fieldNames).orElseGet(() -> FieldObjectWriter.create(mapperClass, fieldNames));
        return writer.write(row);
    }

    public <T> List<T> mapToList(Class<T> mapperClass) {
        return this.rows.stream().map(row -> this.mapToSingle(mapperClass, this.fieldNames, (Row)row)).collect(Collectors.toList());
    }

    static class Row {
        private List<Field> fields;

        public <T> T getValue(int index, Class<T> type) {
            return (T)TypeConverter.fromField(this.fields.get(index), type);
        }

        public Row(List<Field> fields) {
            this.fields = fields;
        }
    }
}

