/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.rdsdata.client;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;

class FieldMapper {
    static String ERROR_FIELD_NOT_FOUND = "Cannot find field or getter corresponding to placeholder '%s' in object '%s'";
    static String ERROR_VOID_RETURN_TYPE_NOT_SUPPORTED = "Void return type is not supported";
    private final Object object;

    public Object read(String fieldName) {
        return this.getValueFromGetter(fieldName).orElseGet(() -> this.getValueFromField(fieldName).orElseThrow(() -> this.buildCannotFindException(fieldName)));
    }

    private RuntimeException buildCannotFindException(String fieldName) {
        String errorMessage = String.format(ERROR_FIELD_NOT_FOUND, fieldName, this.object);
        return new IllegalArgumentException(errorMessage);
    }

    private Optional<Object> getValueFromField(String fieldName) {
        try {
            Field field = this.object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object result = field.get(this.object);
            return Optional.of(result);
        }
        catch (NoSuchFieldException e) {
            return Optional.empty();
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access field " + fieldName + " from object " + this.object);
        }
    }

    private Optional<Object> getValueFromGetter(String fieldName) {
        String methodName = this.buildGetterName(fieldName);
        try {
            Method method = this.object.getClass().getDeclaredMethod(methodName, new Class[0]);
            Preconditions.checkArgument((method.getReturnType() != Void.TYPE ? 1 : 0) != 0, (Object)ERROR_VOID_RETURN_TYPE_NOT_SUPPORTED);
            method.setAccessible(true);
            Object result = method.invoke(this.object, new Object[0]);
            return Optional.of(result);
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Cannot access method " + methodName + " from object " + this.object);
        }
    }

    private String buildGetterName(String fieldName) {
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public FieldMapper(Object object) {
        this.object = object;
    }
}

