/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import java.time.Duration;
import java.util.Random;
import software.amazon.awssdk.utils.Validate;
import software.amazon.qldb.BackoffStrategy;
import software.amazon.qldb.RetryPolicyContext;

public class DefaultQldbTransactionBackoffStrategy
implements BackoffStrategy {
    static final Duration BASE_DELAY_CEILING = Duration.ofMillis(10L);
    private static final Duration MAX_BACKOFF_CEILING = Duration.ofMillis(5000L);
    private static final int RETRIES_ATTEMPTED_CEILING = (int)Math.floor(Math.log(2.147483647E9) / Math.log(2.0));
    private final Duration baseDelay;
    private final Duration maxBackoffTime;
    private final Random random;

    DefaultQldbTransactionBackoffStrategy() {
        this(BASE_DELAY_CEILING, MAX_BACKOFF_CEILING, new Random());
    }

    DefaultQldbTransactionBackoffStrategy(Duration baseDelay, Duration maxBackoffTime, Random random) {
        this.baseDelay = Validate.isNotNegative((Duration)baseDelay, (String)"baseDelay");
        this.maxBackoffTime = Validate.isNotNegative((Duration)maxBackoffTime, (String)"maxBackoffTime");
        if (baseDelay.compareTo(maxBackoffTime) > 0) {
            throw new IllegalArgumentException(String.format("%s cannot be greater than %s", "baseDelay", "maxBackoffTime"));
        }
        this.random = random;
    }

    public DefaultQldbTransactionBackoffStrategy(Duration baseDelay, Duration maxBackoffTime) {
        this(baseDelay, maxBackoffTime, new Random());
    }

    @Override
    public Duration calculateDelay(RetryPolicyContext retryPolicyContext) {
        int cappedRetries = Math.min(retryPolicyContext.retriesAttempted(), RETRIES_ATTEMPTED_CEILING);
        int delay = (int)Math.min(this.baseDelay.multipliedBy(1L << cappedRetries).toMillis(), this.maxBackoffTime.toMillis());
        return Duration.ofMillis(delay / 2 + this.random.nextInt(delay / 2 + 1));
    }
}

