/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import com.amazon.ion.system.IonSystemBuilder;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.internal.http.loader.DefaultSdkHttpClientBuilder;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.services.qldbsession.QldbSessionClient;
import software.amazon.awssdk.services.qldbsession.QldbSessionClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.qldb.QldbDriver;
import software.amazon.qldb.QldbDriverBuilder;
import software.amazon.qldb.QldbDriverImpl;
import software.amazon.qldb.RetryPolicy;
import software.amazon.qldb.Validate;

class QldbDriverImplBuilder
implements QldbDriverBuilder {
    private static final String VERSION = "QLDB Driver for Java v";
    private static final String VERSION_KEY = "project.version";
    private static final IonSystem DEFAULT_ION_SYSTEM = IonSystemBuilder.standard().build();
    private static final int DEFAULT_READAHEAD = 0;
    private int maxConcurrentTransactions = (Integer)SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS);
    private int readAhead = 0;
    private ExecutorService executorService;
    private QldbSessionClientBuilder clientBuilder;
    private String ledgerName;
    private RetryPolicy retryPolicy = RetryPolicy.builder().build();
    private IonSystem ionSystem = DEFAULT_ION_SYSTEM;

    QldbDriverImplBuilder() {
    }

    @Override
    public QldbDriver build() {
        software.amazon.awssdk.utils.Validate.paramNotBlank((CharSequence)this.ledgerName, (String)"ledgerName");
        software.amazon.awssdk.utils.Validate.paramNotNull((Object)this.clientBuilder, (String)"client");
        return this.createDriver();
    }

    @Override
    public QldbDriverBuilder ionSystem(IonSystem ionSystem) {
        software.amazon.awssdk.utils.Validate.paramNotNull((Object)ionSystem, (String)"ionSystem");
        this.ionSystem = ionSystem;
        return this;
    }

    @Override
    public QldbDriverBuilder ledger(String ledgerName) {
        software.amazon.awssdk.utils.Validate.paramNotBlank((CharSequence)ledgerName, (String)"ledgerName");
        this.ledgerName = ledgerName;
        return this;
    }

    @Override
    public QldbDriverBuilder transactionRetryPolicy(RetryPolicy retryPolicy) {
        software.amazon.awssdk.utils.Validate.notNull((Object)retryPolicy, (String)"retryPolicy", (Object[])new Object[0]);
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Override
    public QldbDriverBuilder sessionClientBuilder(QldbSessionClientBuilder clientBuilder) {
        software.amazon.awssdk.utils.Validate.paramNotNull((Object)clientBuilder, (String)"clientBuilder");
        this.clientBuilder = clientBuilder;
        return this;
    }

    @Override
    public QldbDriverBuilder maxConcurrentTransactions(int maxConcurrentTransactions) {
        software.amazon.awssdk.utils.Validate.isPositive((int)maxConcurrentTransactions, (String)"maxConcurrentTransactions");
        this.maxConcurrentTransactions = maxConcurrentTransactions;
        return this;
    }

    @Override
    public QldbDriverBuilder readAhead(int readAhead) {
        Validate.assertIsAtLeastTwo(readAhead, "readAhead");
        this.readAhead = readAhead;
        this.executorService = null;
        return this;
    }

    @Override
    public QldbDriverBuilder readAhead(int readAhead, ExecutorService executorService) {
        software.amazon.awssdk.utils.Validate.isNotNegative((int)readAhead, (String)"readAhead");
        software.amazon.awssdk.utils.Validate.notNull((Object)executorService, (String)"executorService", (Object[])new Object[0]);
        this.readAhead = readAhead;
        this.executorService = executorService;
        return this;
    }

    private QldbDriver createDriver() {
        this.clientBuilder.applyMutation(client -> client.overrideConfiguration(oc -> {
            oc.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)this.getVersion());
            oc.retryPolicy(software.amazon.awssdk.core.retry.RetryPolicy.builder().numRetries(Integer.valueOf(0)).build());
        }));
        AttributeMap httpConfig = AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)this.maxConcurrentTransactions).build();
        this.clientBuilder.httpClient(new DefaultSdkHttpClientBuilder().buildWithDefaults(httpConfig));
        return new QldbDriverImpl(this.ledgerName, (QldbSessionClient)this.clientBuilder.build(), this.retryPolicy, this.readAhead, this.maxConcurrentTransactions, this.ionSystem, this.executorService);
    }

    private String getVersion() {
        String version;
        try {
            version = VERSION + ResourceBundle.getBundle("version").getString(VERSION_KEY);
        }
        catch (MissingResourceException e) {
            version = "QLDB Driver for Java vunknown";
        }
        return version;
    }
}

