/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazonaws.AmazonClientException;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.qldbsession.model.ExecuteStatementResult;
import com.amazonaws.services.qldbsession.model.OccConflictException;
import com.amazonaws.util.ValidationUtils;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.qldb.BaseTransaction;
import software.amazon.qldb.Result;
import software.amazon.qldb.Session;
import software.amazon.qldb.StreamResult;
import software.amazon.qldb.Transaction;
import software.amazon.qldb.Validate;
import software.amazon.qldb.exceptions.Errors;

@NotThreadSafe
class TransactionImpl
extends BaseTransaction
implements Transaction {
    private static final Logger logger = LoggerFactory.getLogger(TransactionImpl.class);
    private final int readAheadBufferCount;
    private final ExecutorService executorService;
    private final Deque<Result> results;

    TransactionImpl(Session session, String txnId, int readAheadBufferCount, IonSystem ionSystem, ExecutorService executorService) {
        super(session, txnId, ionSystem);
        Validate.assertIsNotNegative(readAheadBufferCount, "readAheadBufferCount");
        this.readAheadBufferCount = readAheadBufferCount;
        this.executorService = executorService;
        this.results = new ArrayDeque<Result>();
    }

    @Override
    public void abort() {
        if (!this.isClosed.get()) {
            this.internalClose();
            this.session.sendAbort();
        }
    }

    @Override
    public void close() {
        try {
            this.abort();
        }
        catch (AmazonClientException ace) {
            logger.warn("Ignored error aborting transaction when closing.", (Throwable)ace);
        }
    }

    @Override
    public void commit() {
        this.throwIfClosed();
        try {
            ByteBuffer hashByteBuffer = ByteBuffer.wrap(this.getTransactionHash().getQldbHash());
            ByteBuffer commitDigest = this.session.sendCommit(this.txnId, hashByteBuffer).getCommitDigest();
            if (!commitDigest.equals(hashByteBuffer)) {
                logger.error(Errors.TXN_DIGEST_MISMATCH.get());
                throw new IllegalStateException(Errors.TXN_DIGEST_MISMATCH.get());
            }
        }
        catch (OccConflictException oce) {
            throw oce;
        }
        catch (AmazonClientException ace) {
            this.close();
            throw ace;
        }
        finally {
            this.internalClose();
        }
    }

    @Override
    public Result execute(String statement) {
        return this.execute(statement, Collections.emptyList());
    }

    @Override
    public Result execute(String statement, List<IonValue> parameters) {
        this.throwIfClosed();
        ValidationUtils.assertStringNotEmpty((String)statement, (String)"statement");
        ValidationUtils.assertNotNull(parameters, (String)"parameters");
        this.setTransactionHash(TransactionImpl.dot(this.getTransactionHash(), statement, parameters, this.ionSystem));
        ExecuteStatementResult executeStatementResult = this.session.sendExecute(statement, parameters, this.txnId);
        StreamResult result = new StreamResult(this.session, executeStatementResult.getFirstPage(), this.txnId, this.readAheadBufferCount, this.ionSystem, this.executorService);
        this.results.add(result);
        return result;
    }

    @Override
    public Result execute(String statement, IonValue ... parameters) {
        ValidationUtils.assertNotNull((Object)parameters, (String)"parameters");
        return this.execute(statement, Arrays.asList(parameters));
    }

    void internalClose() {
        this.isClosed.set(true);
        while (!this.results.isEmpty()) {
            ((StreamResult)this.results.pop()).close();
        }
    }
}

