/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazonaws.AmazonClientException;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.qldbsession.model.ExecuteStatementResult;
import com.amazonaws.services.qldbsession.model.InvalidSessionException;
import com.amazonaws.services.qldbsession.model.OccConflictException;
import com.amazonaws.util.ValidationUtils;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.qldb.BaseTransaction;
import software.amazon.qldb.QldbSessionImpl;
import software.amazon.qldb.Result;
import software.amazon.qldb.StreamResult;
import software.amazon.qldb.Transaction;
import software.amazon.qldb.Validate;
import software.amazon.qldb.exceptions.Errors;

@NotThreadSafe
class TransactionImpl
extends BaseTransaction
implements Transaction {
    private static final Logger logger = LoggerFactory.getLogger(TransactionImpl.class);
    private final int readAheadBufferCount;
    private final ExecutorService executorService;
    private final Deque<Result> results;

    TransactionImpl(QldbSessionImpl qldbSession, String txnId, int readAheadBufferCount, IonSystem ionSystem, ExecutorService executorService) {
        super(qldbSession, txnId, ionSystem);
        Validate.assertIsNotNegative(readAheadBufferCount, "readAheadBufferCount");
        this.readAheadBufferCount = readAheadBufferCount;
        this.executorService = executorService;
        this.results = new ArrayDeque<Result>();
    }

    @Override
    public void abort() {
        if (!this.isClosed.get()) {
            this.internalClose();
            try {
                this.session.sendAbort();
            }
            catch (InvalidSessionException ise) {
                this.qldbSession.softClose();
                throw ise;
            }
        }
    }

    @Override
    public void commit() {
        if (this.isClosed.get()) {
            logger.error(Errors.TXN_CLOSED.get());
            throw new IllegalStateException(Errors.TXN_CLOSED.get());
        }
        try {
            ByteBuffer hashByteBuffer = ByteBuffer.wrap(this.getTransactionHash().getQldbHash());
            ByteBuffer commitDigest = this.session.sendCommit(this.txnId, hashByteBuffer);
            if (!commitDigest.equals(hashByteBuffer)) {
                logger.error(Errors.TXN_DIGEST_MISMATCH.get());
                throw new IllegalStateException(Errors.TXN_DIGEST_MISMATCH.get());
            }
        }
        catch (InvalidSessionException ise) {
            this.qldbSession.softClose();
            throw ise;
        }
        catch (OccConflictException oce) {
            throw oce;
        }
        catch (AmazonClientException ace) {
            try {
                this.session.sendAbort();
            }
            catch (InvalidSessionException ise) {
                this.qldbSession.softClose();
                throw ise;
            }
            catch (AmazonClientException ace2) {
                logger.warn("Ignored error aborting transaction after a failed commit.", (Throwable)ace2);
            }
            throw ace;
        }
        finally {
            this.internalClose();
        }
    }

    @Override
    public Result execute(String statement) {
        return this.execute(statement, Collections.emptyList());
    }

    @Override
    public Result execute(String statement, List<IonValue> parameters) {
        if (this.isClosed.get()) {
            logger.error(Errors.TXN_CLOSED.get());
            throw new IllegalStateException(Errors.TXN_CLOSED.get());
        }
        ValidationUtils.assertStringNotEmpty((String)statement, (String)"statement");
        ValidationUtils.assertNotNull(parameters, (String)"parameters");
        try {
            this.setTransactionHash(TransactionImpl.dot(this.getTransactionHash(), statement, parameters, this.ionSystem));
            ExecuteStatementResult executeStatementResult = this.session.sendExecute(statement, parameters, this.txnId);
            StreamResult result = new StreamResult(this.session, executeStatementResult.getFirstPage(), this.txnId, this.readAheadBufferCount, this.ionSystem, this.executorService);
            this.results.add(result);
            return result;
        }
        catch (InvalidSessionException ise) {
            this.qldbSession.softClose();
            this.internalClose();
            throw ise;
        }
    }

    @Override
    public void close() {
        this.abort();
    }

    private void internalClose() {
        this.isClosed.set(true);
        while (!this.results.isEmpty()) {
            ((StreamResult)this.results.pop()).close();
        }
    }
}

