/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.qldb;

import com.amazon.ion.IonSystem;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.services.qldbsession.AmazonQLDBSession;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.qldb.BaseSyncQldbDriver;
import software.amazon.qldb.BaseSyncQldbDriverBuilder;
import software.amazon.qldb.PooledQldbSession;
import software.amazon.qldb.QldbSession;
import software.amazon.qldb.QldbSessionImpl;
import software.amazon.qldb.Session;
import software.amazon.qldb.Validate;
import software.amazon.qldb.exceptions.Errors;
import software.amazon.qldb.exceptions.QldbClientException;

@ThreadSafe
public class PooledQldbDriver
extends BaseSyncQldbDriver {
    private static final Logger logger = LoggerFactory.getLogger(PooledQldbDriver.class);
    private static final long DEFAULT_TIMEOUT_MS = 30000L;
    private final long timeout;
    private final Semaphore poolPermits;
    private final BlockingQueue<QldbSessionImpl> pool;

    protected PooledQldbDriver(String ledgerName, AmazonQLDBSession client, int retryLimit, int readAhead, int poolLimit, long timeout, IonSystem ionSystem, ExecutorService executorService) {
        super(ledgerName, client, retryLimit, readAhead, ionSystem, executorService);
        this.timeout = timeout;
        this.poolPermits = new Semaphore(poolLimit, true);
        this.pool = new LinkedBlockingQueue<QldbSessionImpl>();
    }

    public static PooledQldbDriverBuilder builder() {
        return new PooledQldbDriverBuilder();
    }

    @Override
    public void close() {
        if (!this.isClosed.getAndSet(true)) {
            QldbSessionImpl curSession = (QldbSessionImpl)this.pool.poll();
            while (curSession != null) {
                curSession.close();
                curSession = (QldbSessionImpl)this.pool.poll();
            }
        }
    }

    @Override
    public QldbSession getSession() {
        if (this.isClosed.get()) {
            logger.error(Errors.DRIVER_CLOSED.get());
            throw new IllegalStateException(Errors.DRIVER_CLOSED.get());
        }
        logger.debug("Getting session. There are {} free sessions; currently available permits is: {}.", (Object)this.pool.size(), (Object)this.poolPermits.availablePermits());
        try {
            if (this.poolPermits.tryAcquire(this.timeout, TimeUnit.MILLISECONDS)) {
                try {
                    QldbSessionImpl session = (QldbSessionImpl)this.pool.poll();
                    while (session != null) {
                        if (session.abortOrClose()) {
                            logger.debug("Reusing session from pool.");
                            return this.wrapSession(session);
                        }
                        session = (QldbSessionImpl)this.pool.poll();
                    }
                    logger.debug("Creating new pooled session.");
                    return this.wrapSession(this.createNewSession());
                }
                catch (Exception e) {
                    this.poolPermits.release();
                    throw e;
                }
            }
            throw QldbClientException.create(String.format(Errors.SESSION_POOL_EMPTY.get(), this.timeout), logger);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw QldbClientException.create(Errors.GET_SESSION_INTERRUPTED.get(), logger);
        }
    }

    private QldbSessionImpl createNewSession() {
        Session session = Session.startSession(this.ledgerName, this.amazonQldbSession);
        return new QldbSessionImpl(session, this.retryLimit, this.readAhead, this.ionSystem, this.executorService);
    }

    private void releaseSession(QldbSessionImpl session) {
        this.pool.add(session);
        this.poolPermits.release();
        logger.debug("Session returned to pool; size is now: " + this.pool.size());
    }

    private PooledQldbSession wrapSession(QldbSessionImpl session) {
        return new PooledQldbSession(session, this::releaseSession);
    }

    public static class PooledQldbDriverBuilder
    extends BaseSyncQldbDriverBuilder<PooledQldbDriverBuilder, PooledQldbDriver> {
        private int poolLimit = 0;
        private long timeout = 30000L;

        protected PooledQldbDriverBuilder() {
        }

        public PooledQldbDriverBuilder withPoolLimit(int poolLimit) {
            Validate.assertIsNotNegative(poolLimit, "poolLimit");
            this.poolLimit = poolLimit;
            return (PooledQldbDriverBuilder)this.getSubclass();
        }

        public PooledQldbDriverBuilder withPoolTimeout(int timeout) {
            Validate.assertIsNotNegative(timeout, "timeout");
            this.timeout = timeout;
            return (PooledQldbDriverBuilder)this.getSubclass();
        }

        @Override
        protected PooledQldbDriver createDriver() {
            if (0 == this.poolLimit) {
                this.poolLimit = this.clientMaxConnections;
            }
            Validate.assertPoolLimit(this.clientMaxConnections, this.poolLimit, "poolLimit");
            return new PooledQldbDriver(this.ledgerName, this.client, this.retryLimit, this.readAhead, this.poolLimit, this.timeout, this.ionSystem, this.executorService);
        }
    }
}

