/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.payloadoffloading;

import java.io.UncheckedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.payloadoffloading.ServerSideEncryptionStrategy;
import software.amazon.payloadoffloading.Util;

public class S3AsyncDao {
    private static final Logger LOG = LoggerFactory.getLogger(S3AsyncDao.class);
    private final S3AsyncClient s3Client;
    private final ServerSideEncryptionStrategy serverSideEncryptionStrategy;
    private final ObjectCannedACL objectCannedACL;

    public S3AsyncDao(S3AsyncClient s3Client) {
        this(s3Client, null, null);
    }

    public S3AsyncDao(S3AsyncClient s3Client, ServerSideEncryptionStrategy serverSideEncryptionStrategy, ObjectCannedACL objectCannedACL) {
        this.s3Client = s3Client;
        this.serverSideEncryptionStrategy = serverSideEncryptionStrategy;
        this.objectCannedACL = objectCannedACL;
    }

    public CompletableFuture<String> getTextFromS3(String s3BucketName, String s3Key) {
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(s3BucketName).key(s3Key).build();
        return ((CompletableFuture)this.s3Client.getObject(getObjectRequest, AsyncResponseTransformer.toBytes()).thenApply(BytesWrapper::asUtf8String)).handle((v, tIn) -> {
            if (tIn != null) {
                Throwable t = Util.unwrapFutureException(tIn);
                if (t instanceof SdkException) {
                    String errorMessage = "Failed to get the S3 object which contains the payload.";
                    LOG.error(errorMessage, t);
                    throw SdkException.create((String)errorMessage, (Throwable)t);
                }
                if (t instanceof UncheckedIOException) {
                    String errorMessage = "Failure when handling the message which was read from S3 object.";
                    LOG.error(errorMessage, t);
                    throw SdkClientException.create((String)errorMessage, (Throwable)t);
                }
                throw new CompletionException(t);
            }
            return v;
        });
    }

    public CompletableFuture<Void> storeTextInS3(String s3BucketName, String s3Key, String payloadContentStr) {
        PutObjectRequest.Builder putObjectRequestBuilder = PutObjectRequest.builder().bucket(s3BucketName).key(s3Key);
        if (this.objectCannedACL != null) {
            putObjectRequestBuilder.acl(this.objectCannedACL);
        }
        if (this.serverSideEncryptionStrategy != null) {
            this.serverSideEncryptionStrategy.decorate(putObjectRequestBuilder);
        }
        return this.s3Client.putObject((PutObjectRequest)putObjectRequestBuilder.build(), AsyncRequestBody.fromString((String)payloadContentStr)).handle((v, tIn) -> {
            if (tIn != null) {
                Throwable t = Util.unwrapFutureException(tIn);
                if (t instanceof SdkException) {
                    String errorMessage = "Failed to store the message content in an S3 object.";
                    LOG.error(errorMessage, t);
                    throw SdkException.create((String)errorMessage, (Throwable)t);
                }
                throw new CompletionException(t);
            }
            return null;
        });
    }

    public CompletableFuture<Void> deletePayloadFromS3(String s3BucketName, String s3Key) {
        DeleteObjectRequest deleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(s3BucketName).key(s3Key).build();
        return this.s3Client.deleteObject(deleteObjectRequest).handle((v, tIn) -> {
            if (tIn != null) {
                Throwable t = Util.unwrapFutureException(tIn);
                if (t instanceof SdkException) {
                    String errorMessage = "Failed to delete the S3 object which contains the payload";
                    LOG.error(errorMessage, t);
                    throw SdkException.create((String)errorMessage, (Throwable)t);
                }
                throw new CompletionException(t);
            }
            LOG.info("S3 object deleted, Bucket name: " + s3BucketName + ", Object key: " + s3Key + ".");
            return null;
        });
    }
}

