/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.payloadoffloading;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.payloadoffloading.PayloadStorageConfigurationBase;
import software.amazon.payloadoffloading.ServerSideEncryptionStrategy;

@NotThreadSafe
public class PayloadStorageAsyncConfiguration
extends PayloadStorageConfigurationBase {
    private static final Logger LOG = LoggerFactory.getLogger(PayloadStorageAsyncConfiguration.class);
    private S3AsyncClient s3Async;

    public PayloadStorageAsyncConfiguration() {
        this.s3Async = null;
    }

    public PayloadStorageAsyncConfiguration(PayloadStorageAsyncConfiguration other) {
        super(other);
        this.s3Async = other.getS3AsyncClient();
    }

    public void setPayloadSupportEnabled(S3AsyncClient s3Async, String s3BucketName) {
        if (s3Async == null || s3BucketName == null) {
            String errorMessage = "S3 client and/or S3 bucket name cannot be null.";
            LOG.error(errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        super.setPayloadSupportEnabled(s3BucketName);
        this.s3Async = s3Async;
    }

    public PayloadStorageAsyncConfiguration withPayloadSupportEnabled(S3AsyncClient s3Async, String s3BucketName) {
        this.setPayloadSupportEnabled(s3Async, s3BucketName);
        return this;
    }

    @Override
    public void setPayloadSupportDisabled() {
        super.setPayloadSupportDisabled();
        this.s3Async = null;
        LOG.info("Payload support disabled.");
    }

    public PayloadStorageAsyncConfiguration withPayloadSupportDisabled() {
        this.setPayloadSupportDisabled();
        return this;
    }

    public S3AsyncClient getS3AsyncClient() {
        return this.s3Async;
    }

    public PayloadStorageAsyncConfiguration withPayloadSizeThreshold(int payloadSizeThreshold) {
        this.setPayloadSizeThreshold(payloadSizeThreshold);
        return this;
    }

    public PayloadStorageAsyncConfiguration withAlwaysThroughS3(boolean alwaysThroughS3) {
        this.setAlwaysThroughS3(alwaysThroughS3);
        return this;
    }

    public PayloadStorageAsyncConfiguration withServerSideEncryption(ServerSideEncryptionStrategy serverSideEncryptionStrategy) {
        this.setServerSideEncryptionStrategy(serverSideEncryptionStrategy);
        return this;
    }

    public PayloadStorageAsyncConfiguration withObjectCannedACL(ObjectCannedACL objectCannedACL) {
        this.setObjectCannedACL(objectCannedACL);
        return this;
    }
}

