/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.payloadoffloading;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.payloadoffloading.ServerSideEncryptionStrategy;

@NotThreadSafe
public class PayloadStorageConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(PayloadStorageConfiguration.class);
    private S3Client s3;
    private String s3BucketName;
    private int payloadSizeThreshold = 0;
    private boolean alwaysThroughS3 = false;
    private boolean payloadSupport = false;
    private ServerSideEncryptionStrategy serverSideEncryptionStrategy;

    public PayloadStorageConfiguration() {
        this.s3 = null;
        this.s3BucketName = null;
        this.serverSideEncryptionStrategy = null;
    }

    public PayloadStorageConfiguration(PayloadStorageConfiguration other) {
        this.s3 = other.getS3Client();
        this.s3BucketName = other.getS3BucketName();
        this.payloadSupport = other.isPayloadSupportEnabled();
        this.alwaysThroughS3 = other.isAlwaysThroughS3();
        this.payloadSizeThreshold = other.getPayloadSizeThreshold();
        this.serverSideEncryptionStrategy = other.getServerSideEncryptionStrategy();
    }

    public void setPayloadSupportEnabled(S3Client s3, String s3BucketName) {
        if (s3 == null || s3BucketName == null) {
            String errorMessage = "S3 client and/or S3 bucket name cannot be null.";
            LOG.error(errorMessage);
            throw SdkClientException.create((String)errorMessage);
        }
        if (this.isPayloadSupportEnabled()) {
            LOG.warn("Payload support is already enabled. Overwriting AmazonS3Client and S3BucketName.");
        }
        this.s3 = s3;
        this.s3BucketName = s3BucketName;
        this.payloadSupport = true;
        LOG.info("Payload support enabled.");
    }

    public PayloadStorageConfiguration withPayloadSupportEnabled(S3Client s3, String s3BucketName) {
        this.setPayloadSupportEnabled(s3, s3BucketName);
        return this;
    }

    public void setPayloadSupportDisabled() {
        this.s3 = null;
        this.s3BucketName = null;
        this.payloadSupport = false;
        LOG.info("Payload support disabled.");
    }

    public PayloadStorageConfiguration withPayloadSupportDisabled() {
        this.setPayloadSupportDisabled();
        return this;
    }

    public boolean isPayloadSupportEnabled() {
        return this.payloadSupport;
    }

    public S3Client getS3Client() {
        return this.s3;
    }

    public String getS3BucketName() {
        return this.s3BucketName;
    }

    public PayloadStorageConfiguration withPayloadSizeThreshold(int payloadSizeThreshold) {
        this.setPayloadSizeThreshold(payloadSizeThreshold);
        return this;
    }

    public int getPayloadSizeThreshold() {
        return this.payloadSizeThreshold;
    }

    public void setPayloadSizeThreshold(int payloadSizeThreshold) {
        this.payloadSizeThreshold = payloadSizeThreshold;
    }

    public PayloadStorageConfiguration withAlwaysThroughS3(boolean alwaysThroughS3) {
        this.setAlwaysThroughS3(alwaysThroughS3);
        return this;
    }

    public boolean isAlwaysThroughS3() {
        return this.alwaysThroughS3;
    }

    public void setAlwaysThroughS3(boolean alwaysThroughS3) {
        this.alwaysThroughS3 = alwaysThroughS3;
    }

    public PayloadStorageConfiguration withServerSideEncryption(ServerSideEncryptionStrategy serverSideEncryptionStrategy) {
        this.setServerSideEncryptionStrategy(serverSideEncryptionStrategy);
        return this;
    }

    public void setServerSideEncryptionStrategy(ServerSideEncryptionStrategy serverSideEncryptionStrategy) {
        this.serverSideEncryptionStrategy = serverSideEncryptionStrategy;
    }

    public ServerSideEncryptionStrategy getServerSideEncryptionStrategy() {
        return this.serverSideEncryptionStrategy;
    }
}

