/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api;

import com.amazon.pay.api.AmazonPayClient;
import com.amazon.pay.api.AmazonPayResponse;
import com.amazon.pay.api.PayConfiguration;
import com.amazon.pay.api.Util;
import com.amazon.pay.api.exceptions.AmazonPayClientException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class WebstoreClient
extends AmazonPayClient {
    public WebstoreClient(PayConfiguration payConfiguration) throws AmazonPayClientException {
        super(payConfiguration);
    }

    public AmazonPayResponse getBuyer(String buyerToken, Map<String, String> header) throws AmazonPayClientException {
        URI buyerURI = Util.getServiceURI(this.payConfiguration, "v2/buyers");
        URI getBuyerURI = buyerURI.resolve(buyerURI.getPath() + "/" + buyerToken);
        return this.callAPI(getBuyerURI, "GET", null, "", header);
    }

    public AmazonPayResponse getBuyer(String buyerToken) throws AmazonPayClientException {
        return this.getBuyer(buyerToken, null);
    }

    public AmazonPayResponse createCheckoutSession(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI createCheckoutSessionURI = Util.getServiceURI(this.payConfiguration, "v2/checkoutSessions");
        Map<String, String> headerMap = Util.updateHeader(header);
        return this.callAPI(createCheckoutSessionURI, "POST", null, payload.toString(), headerMap);
    }

    public AmazonPayResponse createCheckoutSession(JSONObject payload) throws AmazonPayClientException {
        return this.createCheckoutSession(payload, null);
    }

    public AmazonPayResponse getCheckoutSession(String checkoutSessionId, Map<String, String> header) throws AmazonPayClientException {
        URI checkoutSessionURI = Util.getServiceURI(this.payConfiguration, "v2/checkoutSessions");
        URI getCheckoutSessionURI = checkoutSessionURI.resolve(checkoutSessionURI.getPath() + "/" + checkoutSessionId);
        AmazonPayResponse response = this.callAPI(getCheckoutSessionURI, "GET", null, "", header);
        return Util.enhanceResponseWithShippingAddressList(response);
    }

    public AmazonPayResponse getCheckoutSession(String checkoutSessionId) throws AmazonPayClientException {
        return this.getCheckoutSession(checkoutSessionId, null);
    }

    public AmazonPayResponse updateCheckoutSession(String checkoutSessionId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI checkoutSessionURI = Util.getServiceURI(this.payConfiguration, "v2/checkoutSessions");
        URI updateCheckoutSessionURI = checkoutSessionURI.resolve(checkoutSessionURI.getPath() + "/" + checkoutSessionId);
        AmazonPayResponse response = this.callAPI(updateCheckoutSessionURI, "PATCH", null, payload.toString(), header);
        return Util.enhanceResponseWithShippingAddressList(response);
    }

    public AmazonPayResponse updateCheckoutSession(String checkoutSessionId, JSONObject payload) throws AmazonPayClientException {
        return this.updateCheckoutSession(checkoutSessionId, payload, null);
    }

    public AmazonPayResponse completeCheckoutSession(String checkoutSessionId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI checkoutSessionURI = Util.getServiceURI(this.payConfiguration, "v2/checkoutSessions");
        URI completeCheckoutSessionURI = checkoutSessionURI.resolve(checkoutSessionURI.getPath() + "/" + checkoutSessionId + "/complete");
        AmazonPayResponse response = this.callAPI(completeCheckoutSessionURI, "POST", null, payload.toString(), header);
        return Util.enhanceResponseWithShippingAddressList(response);
    }

    public AmazonPayResponse completeCheckoutSession(String checkoutSessionId, JSONObject payload) throws AmazonPayClientException {
        return this.completeCheckoutSession(checkoutSessionId, payload, null);
    }

    public AmazonPayResponse getChargePermission(String chargePermissionId, Map<String, String> header) throws AmazonPayClientException {
        URI chargePermissionURI = Util.getServiceURI(this.payConfiguration, "v2/chargePermissions");
        URI getChargePermissionURI = chargePermissionURI.resolve(chargePermissionURI.getPath() + "/" + chargePermissionId);
        return this.callAPI(getChargePermissionURI, "GET", null, "", header);
    }

    public AmazonPayResponse getChargePermission(String chargePermissionId) throws AmazonPayClientException {
        return this.getChargePermission(chargePermissionId, null);
    }

    public AmazonPayResponse updateChargePermission(String chargePermissionId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI chargePermissionURI = Util.getServiceURI(this.payConfiguration, "v2/chargePermissions");
        URI updateChargePermissionURI = chargePermissionURI.resolve(chargePermissionURI.getPath() + "/" + chargePermissionId);
        return this.callAPI(updateChargePermissionURI, "PATCH", null, payload.toString(), header);
    }

    public AmazonPayResponse updateChargePermission(String chargePermissionId, JSONObject payload) throws AmazonPayClientException {
        return this.updateChargePermission(chargePermissionId, payload, null);
    }

    public AmazonPayResponse closeChargePermission(String chargePermissionId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI chargePermissionURI = Util.getServiceURI(this.payConfiguration, "v2/chargePermissions");
        URI closeChargePermissionURI = chargePermissionURI.resolve(chargePermissionURI.getPath() + "/" + chargePermissionId + "/close");
        return this.callAPI(closeChargePermissionURI, "DELETE", null, payload.toString(), header);
    }

    public AmazonPayResponse closeChargePermission(String chargePermissionId, JSONObject payload) throws AmazonPayClientException {
        return this.closeChargePermission(chargePermissionId, payload, null);
    }

    public AmazonPayResponse createCharge(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI createChargesURI = Util.getServiceURI(this.payConfiguration, "v2/charges");
        Map<String, String> headerMap = Util.updateHeader(header);
        return this.callAPI(createChargesURI, "POST", null, payload.toString(), headerMap);
    }

    public AmazonPayResponse createCharge(JSONObject payload) throws AmazonPayClientException {
        return this.createCharge(payload, null);
    }

    public AmazonPayResponse getCharge(String chargeId, Map<String, String> header) throws AmazonPayClientException {
        URI chargesURI = Util.getServiceURI(this.payConfiguration, "v2/charges");
        URI getChargeURI = chargesURI.resolve(chargesURI.getPath() + "/" + chargeId);
        return this.callAPI(getChargeURI, "GET", null, "", header);
    }

    public AmazonPayResponse getCharge(String chargeId) throws AmazonPayClientException {
        return this.getCharge(chargeId, null);
    }

    public AmazonPayResponse updateCharge(String chargeId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI chargesURI = Util.getServiceURI(this.payConfiguration, "v2/charges");
        URI updateChargeURI = chargesURI.resolve(chargesURI.getPath() + "/" + chargeId);
        Map<String, String> headerMap = Util.updateHeader(header);
        return this.callAPI(updateChargeURI, "PATCH", null, payload.toString(), headerMap);
    }

    public AmazonPayResponse updateCharge(String chargeId, JSONObject payload) throws AmazonPayClientException {
        return this.updateCharge(chargeId, payload, null);
    }

    public AmazonPayResponse captureCharge(String chargeId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI chargesURI = Util.getServiceURI(this.payConfiguration, "v2/charges");
        URI captureChargeURI = chargesURI.resolve(chargesURI.getPath() + "/" + chargeId + "/capture");
        Map<String, String> headerMap = Util.updateHeader(header);
        return this.callAPI(captureChargeURI, "POST", null, payload.toString(), headerMap);
    }

    public AmazonPayResponse captureCharge(String chargeId, JSONObject payload) throws AmazonPayClientException {
        return this.captureCharge(chargeId, payload, null);
    }

    public AmazonPayResponse cancelCharge(String chargeId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI chargesURI = Util.getServiceURI(this.payConfiguration, "v2/charges");
        URI cancelChargeURI = chargesURI.resolve(chargesURI.getPath() + "/" + chargeId + "/cancel");
        return this.callAPI(cancelChargeURI, "DELETE", null, payload.toString(), header);
    }

    public AmazonPayResponse cancelCharge(String chargeId, JSONObject payload) throws AmazonPayClientException {
        return this.cancelCharge(chargeId, payload, null);
    }

    public AmazonPayResponse createRefund(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI createRefundsURI = Util.getServiceURI(this.payConfiguration, "v2/refunds");
        Map<String, String> headerMap = Util.updateHeader(header);
        return this.callAPI(createRefundsURI, "POST", null, payload.toString(), headerMap);
    }

    public AmazonPayResponse createRefund(JSONObject payload) throws AmazonPayClientException {
        return this.createRefund(payload, null);
    }

    public AmazonPayResponse getRefund(String refundId, Map<String, String> header) throws AmazonPayClientException {
        URI refundsURI = Util.getServiceURI(this.payConfiguration, "v2/refunds");
        URI getRefundURI = refundsURI.resolve(refundsURI.getPath() + "/" + refundId + "/");
        return this.callAPI(getRefundURI, "GET", null, "", header);
    }

    public AmazonPayResponse getRefund(String refundId) throws AmazonPayClientException {
        return this.getRefund(refundId, null);
    }

    public AmazonPayResponse getReports(Map<String, List<String>> queryParameters, Map<String, String> header) throws AmazonPayClientException {
        URI getReportsURI = Util.getServiceURI(this.payConfiguration, "v2/reports");
        URI getReportsFinalURI = getReportsURI.resolve(getReportsURI.getPath() + "/?" + this.convertQueryParamters(queryParameters));
        return this.callAPI(getReportsFinalURI, "GET", queryParameters, "", header);
    }

    public AmazonPayResponse getReports(Map<String, List<String>> queryParameters) throws AmazonPayClientException {
        return this.getReports(queryParameters, null);
    }

    public AmazonPayResponse getReports() throws AmazonPayClientException {
        return this.getReports(null, null);
    }

    public AmazonPayResponse getReportById(String reportId, Map<String, String> header) throws AmazonPayClientException {
        URI getReportByIdURI = Util.getServiceURI(this.payConfiguration, "v2/reports");
        URI getReportByIdFinalURI = getReportByIdURI.resolve(getReportByIdURI.getPath() + "/" + reportId);
        return this.callAPI(getReportByIdFinalURI, "GET", null, "", header);
    }

    public AmazonPayResponse getReportById(String reportId) throws AmazonPayClientException {
        return this.getReportById(reportId, null);
    }

    public AmazonPayResponse getReportDocument(String reportDocumentId, Map<String, String> header) throws AmazonPayClientException {
        URI getReportDocumentURI = Util.getServiceURI(this.payConfiguration, "v2/report-documents");
        URI getReportDocumentFinalURI = getReportDocumentURI.resolve(getReportDocumentURI.getPath() + "/" + reportDocumentId);
        return this.callAPI(getReportDocumentFinalURI, "GET", null, "", header);
    }

    public AmazonPayResponse getReportDocument(String reportDocumentId) throws AmazonPayClientException {
        return this.getReportDocument(reportDocumentId, null);
    }

    public AmazonPayResponse getReportSchedules(String reportTypes, Map<String, String> header) throws AmazonPayClientException {
        URI getReportScheduleURI = Util.getServiceURI(this.payConfiguration, "v2/report-schedules");
        HashMap<String, List<String>> queryParameters = new HashMap<String, List<String>>();
        if (!reportTypes.isEmpty()) {
            queryParameters.put("reportTypes", Arrays.asList(reportTypes));
        }
        URI getReportSchedulesFinalURI = getReportScheduleURI.resolve(getReportScheduleURI.getPath() + "/?" + this.convertQueryParamters(queryParameters));
        return this.callAPI(getReportSchedulesFinalURI, "GET", queryParameters, "", header);
    }

    public AmazonPayResponse getReportSchedules(String reportTypes) throws AmazonPayClientException {
        return this.getReportSchedules(reportTypes, null);
    }

    public AmazonPayResponse getReportSchedules() throws AmazonPayClientException {
        return this.getReportSchedules("", null);
    }

    public AmazonPayResponse getReportScheduleById(String reportScheduleId, Map<String, String> header) throws AmazonPayClientException {
        URI getReportScheduleByIdURI = Util.getServiceURI(this.payConfiguration, "v2/report-schedules");
        URI getReportScheduleByIdFinalURI = getReportScheduleByIdURI.resolve(getReportScheduleByIdURI.getPath() + "/" + reportScheduleId);
        return this.callAPI(getReportScheduleByIdFinalURI, "GET", null, "", header);
    }

    public AmazonPayResponse getReportScheduleById(String reportScheduleId) throws AmazonPayClientException {
        return this.getReportScheduleById(reportScheduleId, null);
    }

    public AmazonPayResponse createReport(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI createReportURI = Util.getServiceURI(this.payConfiguration, "v2/reports");
        return this.callAPI(createReportURI, "POST", null, payload.toString(), header);
    }

    public AmazonPayResponse createReportSchedule(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI createReportScheduleURI = Util.getServiceURI(this.payConfiguration, "v2/report-schedules");
        return this.callAPI(createReportScheduleURI, "POST", null, payload.toString(), header);
    }

    public AmazonPayResponse cancelReportSchedule(String reportScheduleId, Map<String, String> header) throws AmazonPayClientException {
        URI cancelReportScheduleURI = Util.getServiceURI(this.payConfiguration, "v2/report-schedules");
        URI cancelReportScheduleFinalURI = cancelReportScheduleURI.resolve(cancelReportScheduleURI.getPath() + "/" + reportScheduleId);
        return this.callAPI(cancelReportScheduleFinalURI, "DELETE", null, "", header);
    }

    public AmazonPayResponse cancelReportSchedule(String reportScheduleId) throws AmazonPayClientException {
        return this.cancelReportSchedule(reportScheduleId, null);
    }

    public AmazonPayResponse getDisbursements(Map<String, List<String>> queryParameters, Map<String, String> header) throws AmazonPayClientException {
        URI getDisbursementsURI = Util.getServiceURI(this.payConfiguration, "v2/disbursements");
        URI getDisbursementsFinalURI = getDisbursementsURI.resolve(getDisbursementsURI.getPath() + "/?" + this.convertQueryParamters(queryParameters));
        return this.callAPI(getDisbursementsFinalURI, "GET", queryParameters, "", header);
    }

    public AmazonPayResponse finalizeCheckoutSession(String checkoutSessionId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI checkoutSessionURI = Util.getServiceURI(this.payConfiguration, "v2/checkoutSessions");
        URI completeCheckoutSessionURI = checkoutSessionURI.resolve(checkoutSessionURI.getPath() + "/" + checkoutSessionId + "/finalize");
        return this.callAPI(completeCheckoutSessionURI, "POST", null, payload.toString(), header);
    }

    public AmazonPayResponse finalizeCheckoutSession(String checkoutSessionId, JSONObject payload) throws AmazonPayClientException {
        return this.finalizeCheckoutSession(checkoutSessionId, payload, null);
    }

    public String convertQueryParamters(Map<String, List<String>> parameters) throws AmazonPayClientException {
        if (parameters == null || parameters.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            for (String value : entry.getValue()) {
                if (result.length() > 0) {
                    result.append("&");
                }
                result.append(entry.getKey()).append("=").append(value);
            }
        }
        return result.toString();
    }

    public AmazonPayResponse createDispute(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI createDisputeURI = Util.getServiceURI(this.payConfiguration, "v2/disputes");
        return this.callAPI(createDisputeURI, "POST", null, payload.toString(), header);
    }

    public AmazonPayResponse updateDispute(String disputeId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI updateDisputeURI = Util.getServiceURI(this.payConfiguration, "v2/disputes");
        URI updateDisputeFinalURI = updateDisputeURI.resolve(updateDisputeURI.getPath() + "/" + disputeId);
        return this.callAPI(updateDisputeFinalURI, "PATCH", null, payload.toString(), header);
    }

    public AmazonPayResponse updateDispute(String disputeId, JSONObject payload) throws AmazonPayClientException {
        return this.updateDispute(disputeId, payload, null);
    }

    public AmazonPayResponse contestDispute(String disputeId, JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI contestDisputeURI = Util.getServiceURI(this.payConfiguration, "v2/disputes");
        URI contestDisputeFinalURI = contestDisputeURI.resolve(contestDisputeURI.getPath() + "/" + disputeId + "/contest");
        return this.callAPI(contestDisputeFinalURI, "POST", null, payload.toString(), header);
    }

    public AmazonPayResponse contestDispute(String disputeId, JSONObject payload) throws AmazonPayClientException {
        return this.contestDispute(disputeId, payload, null);
    }

    public AmazonPayResponse uploadFile(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI uploadFileURI = Util.getServiceURI(this.payConfiguration, "v2/files");
        return this.callAPI(uploadFileURI, "POST", null, payload.toString(), header);
    }

    public AmazonPayResponse uploadFile(JSONObject payload) throws AmazonPayClientException {
        return this.uploadFile(payload, null);
    }
}

