/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api;

import com.amazon.pay.api.PayConfiguration;
import com.amazon.pay.api.SignatureHelper;
import com.amazon.pay.api.Util;
import com.amazon.pay.api.exceptions.AmazonPayClientException;
import com.amazon.pay.api.types.AmazonSignatureAlgorithm;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestSigner {
    private final PayConfiguration payConfiguration;
    private final SignatureHelper signatureHelper;
    private final PrivateKey privateKey;

    public RequestSigner(PayConfiguration payConfiguration) throws AmazonPayClientException {
        this.checkIfConfigParametersAreSet(payConfiguration);
        this.payConfiguration = payConfiguration;
        this.signatureHelper = new SignatureHelper(payConfiguration);
        this.privateKey = payConfiguration.getPrivateKey();
    }

    public Map<String, String> signRequest(URI uri, String httpMethodName, Map<String, List<String>> queryParameters, String requestPayload, Map<String, String> header) throws AmazonPayClientException {
        String publicKeyId = this.payConfiguration.getPublicKeyId();
        AmazonSignatureAlgorithm algorithm = this.payConfiguration.getAlgorithm();
        Map<String, List<String>> preSignedHeaders = this.signatureHelper.createPreSignedHeaders(uri, header);
        String userAgent = this.buildUserAgentHeader();
        String signature = null;
        try {
            String canonicalRequest = this.signatureHelper.createCanonicalRequest(uri, httpMethodName, queryParameters, requestPayload, preSignedHeaders);
            String stringToSign = this.signatureHelper.createStringToSign(canonicalRequest, algorithm.getName());
            signature = this.signatureHelper.generateSignature(stringToSign, this.privateKey, algorithm);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            throw new AmazonPayClientException(e.getMessage(), e);
        }
        String authorizationHeader = this.buildAuthorizationHeader(publicKeyId, preSignedHeaders, signature, algorithm);
        HashMap<String, String> postSignedHeadersMap = new HashMap<String, String>();
        for (String key : preSignedHeaders.keySet()) {
            postSignedHeadersMap.put(key.toLowerCase(), preSignedHeaders.get(key).get(0));
        }
        postSignedHeadersMap.put("authorization", authorizationHeader);
        postSignedHeadersMap.put("user-agent", userAgent);
        return postSignedHeadersMap;
    }

    private String buildUserAgentHeader() {
        String javaVersion = this.payConfiguration.isUserAgentRedaction() ? "Redacted" : Util.JAVA_VERSION;
        String osName = this.payConfiguration.isUserAgentRedaction() ? "Redacted" : Util.OS_NAME;
        String osVersion = this.payConfiguration.isUserAgentRedaction() ? "Redacted" : Util.OS_VERSION;
        StringBuilder userAgentBuilder = new StringBuilder("amazon-pay-api-sdk-java").append("/").append("2.6.5").append(" (").append("Java/").append(javaVersion).append("; ").append(osName).append("/").append(osVersion).append(")");
        return userAgentBuilder.toString();
    }

    private String buildAuthorizationHeader(String publicKeyId, Map<String, List<String>> preSignedHeaders, String signature, AmazonSignatureAlgorithm algorithm) throws AmazonPayClientException {
        if (publicKeyId == null || preSignedHeaders == null || signature == null) {
            throw new AmazonPayClientException("Invalid parameter while constructing authorization header");
        }
        StringBuilder authorizationBuilder = new StringBuilder(algorithm.getName()).append(" PublicKeyId=").append(publicKeyId).append(", ").append("SignedHeaders=").append(this.signatureHelper.getSignedHeadersString(preSignedHeaders)).append(", Signature=").append(signature);
        return authorizationBuilder.toString();
    }

    private void checkIfConfigParametersAreSet(PayConfiguration payConfiguration) {
        if (payConfiguration.getRegion() == null || payConfiguration.getRegion().toString().isEmpty()) {
            this.generateException("Region");
        }
        if (payConfiguration.getPrivateKey() == null) {
            this.generateException("Private Key");
        }
        if (payConfiguration.getPublicKeyId() == null || payConfiguration.getPublicKeyId().isEmpty()) {
            this.generateException("Public key id");
        }
    }

    private void generateException(String parameter) {
        throw new IllegalArgumentException(parameter + " is not set in the PayConfiguration, this is a required parameter");
    }
}

