/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api;

import com.amazon.pay.api.PayConfiguration;
import com.amazon.pay.api.ServiceConstants;
import com.amazon.pay.api.exceptions.AmazonPayClientException;
import com.amazon.pay.api.types.Environment;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class Util {
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    public static String urlEncode(String value, boolean path) throws AmazonPayClientException {
        if (value == null) {
            return "";
        }
        try {
            if (path) {
                value = value.replaceAll("/+", "/");
            }
            String encoded = URLEncoder.encode(value, DEFAULT_ENCODING);
            Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(encoded);
            StringBuffer buffer = new StringBuffer(encoded.length());
            while (matcher.find()) {
                String replacement = matcher.group(0);
                if ("+".equals(replacement)) {
                    replacement = "%20";
                } else if ("*".equals(replacement)) {
                    replacement = "%2A";
                } else if ("%7E".equals(replacement)) {
                    replacement = "~";
                } else if (path && "%2F".equals(replacement)) {
                    replacement = "/";
                }
                matcher.appendReplacement(buffer, replacement);
            }
            matcher.appendTail(buffer);
            return buffer.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new AmazonPayClientException("Encountered UnsupportedEncodingException:", ex);
        }
    }

    public static String lowerCase(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.toLowerCase(Locale.ENGLISH);
    }

    public static String getFormattedTimestamp() {
        Date now = new Date();
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        dateTimeFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        return dateTimeFormat.format(now);
    }

    public static PrivateKey buildPrivateKeyFromString(String privateKeyString) throws AmazonPayClientException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (privateKeyString == null || privateKeyString.isEmpty()) {
            throw new AmazonPayClientException("Private key string cannot be null or empty");
        }
        PemObject pemObject = Util.getPEMObjectFromKey(privateKeyString);
        if (pemObject == null) {
            throw new AmazonPayClientException("Private key string provided is not valid");
        }
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(pemObject.getContent());
        PrivateKey privateKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            privateKey = keyFactory.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new AmazonPayClientException(e.getMessage(), e);
        }
        return privateKey;
    }

    private static PemObject getPEMObjectFromKey(String privateKey) throws AmazonPayClientException {
        PemObject pemObject;
        try {
            PemReader pemReader = new PemReader((Reader)new StringReader(privateKey));
            pemObject = pemReader.readPemObject();
            pemReader.close();
        }
        catch (IOException e) {
            throw new AmazonPayClientException(e.getMessage(), e);
        }
        return pemObject;
    }

    public static URI getServiceURI(PayConfiguration payConfiguration, String action) throws AmazonPayClientException {
        URI uri;
        try {
            String endpoint = payConfiguration.getOverrideServiceURL() != null ? "https://" + payConfiguration.getOverrideServiceURL() : ServiceConstants.endpointMappings.get((Object)payConfiguration.getRegion());
            uri = new URI(endpoint + Util.getServiceVersionName(payConfiguration.getEnvironment(), action));
        }
        catch (URISyntaxException e) {
            throw new AmazonPayClientException(e.getMessage(), e);
        }
        return uri;
    }

    private static String getServiceVersionName(Environment environment, String action) {
        String serviceVersionName = environment == Environment.SANDBOX ? "/sandbox/" + action : "/live/" + action;
        return serviceVersionName;
    }

    public static long getExponentialWaitTime(int retryCount) {
        return (long)Math.pow(2.0, retryCount) * 1000L;
    }

    public static Map<String, String> updateHeader(Map<String, String> header) {
        if (header == null || header.isEmpty()) {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("x-amz-pay-idempotency-key", UUID.randomUUID().toString().replace("-", ""));
            return headerMap;
        }
        boolean isIdempotencyKeyPresent = false;
        for (Map.Entry<String, String> entry : header.entrySet()) {
            if (!entry.getKey().toLowerCase().equals("x-amz-pay-idempotency-key")) continue;
            isIdempotencyKeyPresent = true;
            break;
        }
        if (!isIdempotencyKeyPresent) {
            header.put("x-amz-pay-idempotency-key", UUID.randomUUID().toString().replace("-", ""));
        }
        return header;
    }

    static {
        StringBuilder pattern = new StringBuilder();
        pattern.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|").append(Pattern.quote("%2F"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(pattern.toString());
    }
}

