/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api;

import com.amazon.pay.api.Util;
import com.amazon.pay.api.exceptions.AmazonPayClientException;
import com.amazon.pay.api.types.Environment;
import com.amazon.pay.api.types.Region;
import java.security.PrivateKey;

public class PayConfiguration {
    private Region region;
    private String publicKeyId;
    private PrivateKey privateKey;
    private Environment environment;
    private int maxRetries = 3;
    private boolean userAgentRedaction = false;

    public Region getRegion() {
        return this.region;
    }

    public PayConfiguration setRegion(Region region) {
        this.region = region;
        return this;
    }

    public String getPublicKeyId() {
        return this.publicKeyId;
    }

    public PayConfiguration setPublicKeyId(String publicKeyId) {
        this.publicKeyId = publicKeyId;
        return this;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public PayConfiguration setPrivateKey(String privateKey) throws AmazonPayClientException {
        return this.setPrivateKey(Util.buildPrivateKeyFromString(privateKey));
    }

    public PayConfiguration setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public PayConfiguration setEnvironment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public PayConfiguration setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public boolean isUserAgentRedaction() {
        return this.userAgentRedaction;
    }

    public PayConfiguration setUserAgentRedaction(boolean userAgentRedaction) {
        this.userAgentRedaction = userAgentRedaction;
        return this;
    }
}

