/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.pay.api;

import com.amazon.pay.api.AmazonPayResponse;
import com.amazon.pay.api.PayConfiguration;
import com.amazon.pay.api.RequestSigner;
import com.amazon.pay.api.ServiceConstants;
import com.amazon.pay.api.Util;
import com.amazon.pay.api.exceptions.AmazonPayClientException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;

public class AmazonPayClient {
    protected final PayConfiguration payConfiguration;
    protected final RequestSigner requestSigner;
    protected final Map<String, List<String>> queryParametersMap = new HashMap<String, List<String>>();

    public AmazonPayClient(PayConfiguration payConfiguration) throws AmazonPayClientException {
        this.payConfiguration = payConfiguration;
        this.requestSigner = new RequestSigner(payConfiguration);
        AmazonPayClient.allowPatch();
    }

    public AmazonPayResponse deliveryTracker(JSONObject payload, Map<String, String> header) throws AmazonPayClientException {
        URI deliveryTrackerURI = Util.getServiceURI(this.payConfiguration, "v2/deliveryTrackers");
        return this.callAPI(deliveryTrackerURI, "POST", this.queryParametersMap, payload.toString(), header);
    }

    public AmazonPayResponse getAuthorizationToken(String mwsAuthToken, String merchantId, Map<String, String> header) throws AmazonPayClientException {
        URI authorizationTokenURI = Util.getServiceURI(this.payConfiguration, "v2/authorizationTokens");
        URI getAuthorizationTokenURI = authorizationTokenURI.resolve(authorizationTokenURI.getPath() + "/" + mwsAuthToken + "?merchantId=" + merchantId);
        this.queryParametersMap.clear();
        ArrayList<String> auxList = new ArrayList<String>();
        auxList.add(merchantId);
        this.queryParametersMap.put("merchantId", auxList);
        return this.callAPI(getAuthorizationTokenURI, "GET", this.queryParametersMap, "", header);
    }

    public AmazonPayResponse deliveryTracker(JSONObject payload) throws AmazonPayClientException {
        return this.deliveryTracker(payload, null);
    }

    public AmazonPayResponse callAPI(URI uri, String httpMethodName, Map<String, List<String>> queryParameters, String request, Map<String, String> header) throws AmazonPayClientException {
        Map<String, String> postSignedHeaders = this.requestSigner.signRequest(uri, httpMethodName, queryParameters, request, header);
        return this.processRequest(uri, postSignedHeaders, request, httpMethodName);
    }

    private AmazonPayResponse processRequest(URI uri, Map<String, String> postSignedHeaders, String payload, String httpMethodName) throws AmazonPayClientException {
        List<String> response;
        String rawResponseObject = null;
        JSONObject jsonResponse = null;
        AmazonPayResponse responseObject = new AmazonPayResponse();
        responseObject.setUrl(uri);
        responseObject.setMethod(httpMethodName);
        responseObject.setRawRequest(payload);
        responseObject.setHeaders(postSignedHeaders);
        try {
            long millisBefore = System.currentTimeMillis();
            response = this.sendRequest(uri, postSignedHeaders, payload, httpMethodName);
            int statusCode = Integer.parseInt(response.get(0));
            int retry = 0;
            while (ServiceConstants.serviceErrors.containsValue(statusCode) && retry < this.payConfiguration.getMaxRetries()) {
                long waitTime = Util.getExponentialWaitTime(++retry);
                Thread.sleep(waitTime);
                response = this.sendRequest(uri, postSignedHeaders, payload, httpMethodName);
                statusCode = Integer.parseInt(response.get(0));
            }
            responseObject.setRetries(retry);
            responseObject.setStatus(statusCode);
            responseObject.setDuration(System.currentTimeMillis() - millisBefore);
        }
        catch (InterruptedException e) {
            throw new AmazonPayClientException(e.getMessage(), e);
        }
        if (response.get(1) != null) {
            rawResponseObject = response.get(1);
            jsonResponse = JSONObject.fromObject((Object)response.get(1));
        }
        responseObject.setResponse(jsonResponse);
        responseObject.setRawResponse(rawResponseObject);
        responseObject.setRequestId(response.get(2));
        return responseObject;
    }

    private List<String> sendRequest(URI uri, Map<String, String> headers, String payload, String httpMethodName) throws AmazonPayClientException {
        int responseCode;
        String requestId;
        StringBuffer response;
        ArrayList<String> result;
        block51: {
            result = new ArrayList<String>();
            HttpURLConnection conn = null;
            response = new StringBuffer();
            requestId = null;
            responseCode = 0;
            try {
                String inputLine;
                conn = (HttpURLConnection)uri.toURL().openConnection();
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
                conn.setRequestMethod(httpMethodName);
                conn.setDoInput(true);
                if (payload == null || payload.isEmpty()) {
                    conn.setDoOutput(false);
                } else {
                    conn.setDoOutput(true);
                    try {
                        Throwable throwable = null;
                        try (OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());){
                            out.write(payload);
                            out.flush();
                        }
                        catch (Throwable throwable2) {
                            Throwable throwable3 = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        throw new AmazonPayClientException(e.getMessage(), e);
                    }
                }
                responseCode = conn.getResponseCode();
                requestId = conn.getHeaderField("X-Amz-Pay-Request-Id");
                if (responseCode < 400) {
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));){
                        while ((inputLine = bufferedReader.readLine()) != null) {
                            response.append(inputLine).append(System.lineSeparator());
                        }
                        break block51;
                    }
                    catch (IOException iOException) {
                        throw new AmazonPayClientException(iOException.getMessage(), iOException);
                    }
                }
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(conn.getErrorStream(), "UTF-8"));){
                    while ((inputLine = bufferedReader.readLine()) != null) {
                        response.append(inputLine).append(System.lineSeparator());
                    }
                }
                catch (IOException iOException) {
                    throw new AmazonPayClientException(iOException.getMessage(), iOException);
                }
            }
            catch (IOException e) {
                throw new AmazonPayClientException(e.getMessage(), e);
            }
        }
        result.add(String.valueOf(responseCode));
        result.add(response.toString());
        result.add(requestId);
        return result;
    }

    private static void allowPatch() {
        try {
            Field methodsField = HttpURLConnection.class.getDeclaredField("methods");
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(methodsField, methodsField.getModifiers() & 0xFFFFFFEF);
            methodsField.setAccessible(true);
            String[] oldMethods = (String[])methodsField.get(null);
            LinkedHashSet<String> methodsSet = new LinkedHashSet<String>(Arrays.asList(oldMethods));
            methodsSet.add("PATCH");
            String[] newMethods = methodsSet.toArray(new String[0]);
            methodsField.set(null, newMethods);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }
}

