/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal.shaded.caffeine3.cache;

import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.shaded.caffeine3.cache.DisabledFuture;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.shaded.caffeine3.cache.Scheduler;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

final class ExecutorServiceScheduler
implements Scheduler,
Serializable {
    static final System.Logger logger = System.getLogger(ExecutorServiceScheduler.class.getName());
    static final long serialVersionUID = 1L;
    final ScheduledExecutorService scheduledExecutorService;

    ExecutorServiceScheduler(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = Objects.requireNonNull(scheduledExecutorService);
    }

    @Override
    public Future<?> schedule(Executor executor, Runnable command, long delay, TimeUnit unit) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(command);
        Objects.requireNonNull(unit);
        if (this.scheduledExecutorService.isShutdown()) {
            return DisabledFuture.INSTANCE;
        }
        return this.scheduledExecutorService.schedule(() -> {
            try {
                executor.execute(command);
            }
            catch (Throwable t) {
                logger.log(System.Logger.Level.WARNING, "Exception thrown when submitting scheduled task", t);
                throw t;
            }
        }, delay, unit);
    }
}

