/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.shaded.instrumentation.api.InstrumentationVersion;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.EndTimeExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanLinksBuilderImpl;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanSuppressionStrategy;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.StartTimeExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.UnsafeAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SupportabilityMetrics;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class Instrumenter<REQUEST, RESPONSE> {
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private final String instrumentationName;
    private final Tracer tracer;
    private final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    private final SpanKindExtractor<? super REQUEST> spanKindExtractor;
    private final SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor;
    private final List<? extends SpanLinksExtractor<? super REQUEST>> spanLinksExtractors;
    private final List<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors;
    private final List<? extends ContextCustomizer<? super REQUEST>> contextCustomizers;
    private final List<? extends RequestListener> requestListeners;
    private final ErrorCauseExtractor errorCauseExtractor;
    @Nullable
    private final StartTimeExtractor<REQUEST> startTimeExtractor;
    @Nullable
    private final EndTimeExtractor<REQUEST, RESPONSE> endTimeExtractor;
    private final boolean disabled;
    private final SpanSuppressionStrategy spanSuppressionStrategy;

    public static <REQUEST, RESPONSE> InstrumenterBuilder<REQUEST, RESPONSE> newBuilder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        return new InstrumenterBuilder(openTelemetry, instrumentationName, spanNameExtractor);
    }

    Instrumenter(InstrumenterBuilder<REQUEST, RESPONSE> builder) {
        this.instrumentationName = builder.instrumentationName;
        this.tracer = builder.openTelemetry.getTracer(this.instrumentationName, InstrumentationVersion.VERSION);
        this.spanNameExtractor = builder.spanNameExtractor;
        this.spanKindExtractor = builder.spanKindExtractor;
        this.spanStatusExtractor = builder.spanStatusExtractor;
        this.spanLinksExtractors = new ArrayList(builder.spanLinksExtractors);
        this.attributesExtractors = new ArrayList(builder.attributesExtractors);
        this.contextCustomizers = new ArrayList(builder.contextCustomizers);
        this.requestListeners = new ArrayList<RequestListener>(builder.requestListeners);
        this.errorCauseExtractor = builder.errorCauseExtractor;
        this.startTimeExtractor = builder.startTimeExtractor;
        this.endTimeExtractor = builder.endTimeExtractor;
        this.disabled = builder.disabled;
        this.spanSuppressionStrategy = builder.getSpanSuppressionStrategy();
    }

    public boolean shouldStart(Context parentContext, REQUEST request) {
        if (this.disabled) {
            return false;
        }
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        boolean suppressed = this.spanSuppressionStrategy.shouldSuppress(parentContext, spanKind);
        if (suppressed) {
            supportability.recordSuppressedSpan(spanKind, this.instrumentationName);
        }
        return !suppressed;
    }

    /*
     * WARNING - void declaration
     */
    public Context start(Context parentContext, REQUEST request) {
        void var9_15;
        SpanKind spanKind = this.spanKindExtractor.extract(request);
        SpanBuilder spanBuilder = this.tracer.spanBuilder(this.spanNameExtractor.extract(request)).setSpanKind(spanKind).setParent(parentContext);
        Instant startTime = null;
        if (this.startTimeExtractor != null) {
            startTime = this.startTimeExtractor.extract(request);
            spanBuilder.setStartTimestamp(startTime);
        }
        SpanLinksBuilderImpl spanLinksBuilder = new SpanLinksBuilderImpl(spanBuilder);
        for (SpanLinksExtractor<REQUEST> spanLinksExtractor : this.spanLinksExtractors) {
            spanLinksExtractor.extract(spanLinksBuilder, parentContext, request);
        }
        UnsafeAttributes attributesBuilder = new UnsafeAttributes();
        for (AttributesExtractor<REQUEST, RESPONSE> attributesExtractor : this.attributesExtractors) {
            attributesExtractor.onStart(attributesBuilder, request);
        }
        UnsafeAttributes unsafeAttributes = attributesBuilder;
        Context context = parentContext;
        for (ContextCustomizer<REQUEST> contextCustomizer : this.contextCustomizers) {
            void var9_13;
            Context context2 = contextCustomizer.start((Context)var9_13, request, unsafeAttributes);
        }
        if (!this.requestListeners.isEmpty()) {
            long startNanos = Instrumenter.getNanos(startTime);
            for (RequestListener requestListener : this.requestListeners) {
                Context context3 = requestListener.start((Context)var9_15, unsafeAttributes, startNanos);
            }
        }
        spanBuilder.setAllAttributes(unsafeAttributes);
        Span span = spanBuilder.startSpan();
        Context context4 = var9_15.with(span);
        return this.spanSuppressionStrategy.storeInContext(context4, spanKind, span);
    }

    public void end(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        StatusCode statusCode;
        Span span = Span.fromContext(context);
        if (error != null) {
            error = this.errorCauseExtractor.extractCause(error);
            span.recordException(error);
        }
        UnsafeAttributes attributesBuilder = new UnsafeAttributes();
        for (AttributesExtractor<REQUEST, RESPONSE> extractor : this.attributesExtractors) {
            extractor.onEnd(attributesBuilder, request, response, error);
        }
        UnsafeAttributes attributes = attributesBuilder;
        span.setAllAttributes(attributes);
        Instant endTime = null;
        if (this.endTimeExtractor != null) {
            endTime = this.endTimeExtractor.extract(request, response, error);
        }
        if (!this.requestListeners.isEmpty()) {
            long endNanos = Instrumenter.getNanos(endTime);
            for (RequestListener requestListener : this.requestListeners) {
                requestListener.end(context, attributes, endNanos);
            }
        }
        if ((statusCode = this.spanStatusExtractor.extract(request, response, error)) != StatusCode.UNSET) {
            span.setStatus(statusCode);
        }
        if (endTime != null) {
            span.end(endTime);
        } else {
            span.end();
        }
    }

    private static long getNanos(@Nullable Instant time) {
        if (time == null) {
            return System.nanoTime();
        }
        return TimeUnit.SECONDS.toNanos(time.getEpochSecond()) + (long)time.getNano();
    }
}

