/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;

final class AlternateUrlSchemeProvider<REQUEST>
implements Function<REQUEST, String> {
    private static final boolean PREFER_FORWARDED_URL_SCHEME = ConfigPropertiesUtil.getBoolean("otel.instrumentation.http.prefer-forwarded-url-scheme", false);
    private final HttpServerAttributesGetter<REQUEST, ?> getter;

    AlternateUrlSchemeProvider(HttpServerAttributesGetter<REQUEST, ?> getter) {
        this.getter = getter;
    }

    @Override
    public String apply(REQUEST request) {
        String proto;
        if (!PREFER_FORWARDED_URL_SCHEME) {
            return null;
        }
        for (String forwarded : this.getter.getHttpRequestHeader(request, "forwarded")) {
            proto = AlternateUrlSchemeProvider.extractProtoFromForwardedHeader(forwarded);
            if (proto == null) continue;
            return proto;
        }
        for (String forwardedProto : this.getter.getHttpRequestHeader(request, "x-forwarded-proto")) {
            proto = AlternateUrlSchemeProvider.extractProtoFromForwardedProtoHeader(forwardedProto);
            if (proto == null) continue;
            return proto;
        }
        return null;
    }

    @Nullable
    private static String extractProtoFromForwardedHeader(String forwarded) {
        int start = forwarded.toLowerCase(Locale.ROOT).indexOf("proto=");
        if (start < 0) {
            return null;
        }
        if ((start += 6) >= forwarded.length() - 1) {
            return null;
        }
        return AlternateUrlSchemeProvider.extractProto(forwarded, start);
    }

    @Nullable
    private static String extractProtoFromForwardedProtoHeader(String forwardedProto) {
        return AlternateUrlSchemeProvider.extractProto(forwardedProto, 0);
    }

    @Nullable
    private static String extractProto(String forwarded, int start) {
        if (forwarded.length() == start) {
            return null;
        }
        if (forwarded.charAt(start) == '\"') {
            return AlternateUrlSchemeProvider.extractProto(forwarded, start + 1);
        }
        for (int i = start; i < forwarded.length(); ++i) {
            char c = forwarded.charAt(i);
            if (c != ',' && c != ';' && c != '\"') continue;
            if (i == start) {
                return null;
            }
            return forwarded.substring(start, i);
        }
        return forwarded.substring(start);
    }
}

